# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class TrackingInfo(Model):
    """Tracking courier information.

    :param serial_number: Serial number of the device being tracked.
    :type serial_number: str
    :param carrier_name: Name of the carrier used in the delivery.
    :type carrier_name: str
    :param tracking_id: Tracking ID of the shipment.
    :type tracking_id: str
    :param tracking_url: Tracking URL of the shipment.
    :type tracking_url: str
    """

    _attribute_map = {
        'serial_number': {'key': 'serialNumber', 'type': 'str'},
        'carrier_name': {'key': 'carrierName', 'type': 'str'},
        'tracking_id': {'key': 'trackingId', 'type': 'str'},
        'tracking_url': {'key': 'trackingUrl', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TrackingInfo, self).__init__(**kwargs)
        self.serial_number = kwargs.get('serial_number', None)
        self.carrier_name = kwargs.get('carrier_name', None)
        self.tracking_id = kwargs.get('tracking_id', None)
        self.tracking_url = kwargs.get('tracking_url', None)
