# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class EnvironmentSize(Model):
    """Represents a size category supported by this Lab Account (small, medium or
    large).

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param name: The size category. Possible values include: 'Basic',
     'Standard', 'Performance'
    :type name: str or ~azure.mgmt.labservices.models.ManagedLabVmSize
    :param vm_sizes: Represents a set of compute sizes that can serve this
     given size type
    :type vm_sizes: list[~azure.mgmt.labservices.models.SizeInfo]
    :ivar max_price: The pay-as-you-go dollar price per hour this size will
     cost. It does not include discounts and may not reflect the actual price
     the size will cost. This is the maximum price of all prices within this
     tier.
    :vartype max_price: decimal.Decimal
    :ivar min_number_of_cores: The number of cores a VM of this size has. This
     is the minimum number of cores within this tier.
    :vartype min_number_of_cores: int
    :ivar min_memory: The amount of memory available (in GB). This is the
     minimum amount of memory within this tier.
    :vartype min_memory: float
    """

    _validation = {
        'max_price': {'readonly': True},
        'min_number_of_cores': {'readonly': True},
        'min_memory': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'vm_sizes': {'key': 'vmSizes', 'type': '[SizeInfo]'},
        'max_price': {'key': 'maxPrice', 'type': 'decimal'},
        'min_number_of_cores': {'key': 'minNumberOfCores', 'type': 'int'},
        'min_memory': {'key': 'minMemory', 'type': 'float'},
    }

    def __init__(self, *, name=None, vm_sizes=None, **kwargs) -> None:
        super(EnvironmentSize, self).__init__(**kwargs)
        self.name = name
        self.vm_sizes = vm_sizes
        self.max_price = None
        self.min_number_of_cores = None
        self.min_memory = None
