# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .linked_service import LinkedService


class AzureBatchLinkedService(LinkedService):
    """Azure Batch linked service.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param connect_via: The integration runtime reference.
    :type connect_via:
     ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :param description: Linked service description.
    :type description: str
    :param parameters: Parameters for linked service.
    :type parameters: dict[str,
     ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the
     linked service.
    :type annotations: list[object]
    :param type: Required. Constant filled by server.
    :type type: str
    :param account_name: Required. The Azure Batch account name. Type: string
     (or Expression with resultType string).
    :type account_name: object
    :param access_key: The Azure Batch account access key.
    :type access_key: ~azure.mgmt.datafactory.models.SecretBase
    :param batch_uri: Required. The Azure Batch URI. Type: string (or
     Expression with resultType string).
    :type batch_uri: object
    :param pool_name: Required. The Azure Batch pool name. Type: string (or
     Expression with resultType string).
    :type pool_name: object
    :param linked_service_name: Required. The Azure Storage linked service
     reference.
    :type linked_service_name:
     ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param encrypted_credential: The encrypted credential used for
     authentication. Credentials are encrypted using the integration runtime
     credential manager. Type: string (or Expression with resultType string).
    :type encrypted_credential: object
    """

    _validation = {
        'type': {'required': True},
        'account_name': {'required': True},
        'batch_uri': {'required': True},
        'pool_name': {'required': True},
        'linked_service_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'connect_via': {'key': 'connectVia', 'type': 'IntegrationRuntimeReference'},
        'description': {'key': 'description', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'type': {'key': 'type', 'type': 'str'},
        'account_name': {'key': 'typeProperties.accountName', 'type': 'object'},
        'access_key': {'key': 'typeProperties.accessKey', 'type': 'SecretBase'},
        'batch_uri': {'key': 'typeProperties.batchUri', 'type': 'object'},
        'pool_name': {'key': 'typeProperties.poolName', 'type': 'object'},
        'linked_service_name': {'key': 'typeProperties.linkedServiceName', 'type': 'LinkedServiceReference'},
        'encrypted_credential': {'key': 'typeProperties.encryptedCredential', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(AzureBatchLinkedService, self).__init__(**kwargs)
        self.account_name = kwargs.get('account_name', None)
        self.access_key = kwargs.get('access_key', None)
        self.batch_uri = kwargs.get('batch_uri', None)
        self.pool_name = kwargs.get('pool_name', None)
        self.linked_service_name = kwargs.get('linked_service_name', None)
        self.encrypted_credential = kwargs.get('encrypted_credential', None)
        self.type = 'AzureBatch'
