# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class TopLevelDomain(Resource):
    """A top level domain object.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :param name: Resource Name.
    :type name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Resource Location.
    :type location: str
    :param type: Resource type.
    :type type: str
    :param tags: Resource tags.
    :type tags: dict
    :ivar domain_name: Name of the top level domain.
    :vartype domain_name: str
    :param privacy: If <code>true</code>, then the top level domain supports
     domain privacy; otherwise, <code>false</code>.
    :type privacy: bool
    """

    _validation = {
        'id': {'readonly': True},
        'location': {'required': True},
        'domain_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'domain_name': {'key': 'properties.name', 'type': 'str'},
        'privacy': {'key': 'properties.privacy', 'type': 'bool'},
    }

    def __init__(self, location, name=None, kind=None, type=None, tags=None, privacy=None):
        super(TopLevelDomain, self).__init__(name=name, kind=kind, location=location, type=type, tags=tags)
        self.domain_name = None
        self.privacy = privacy
