# -*- coding: utf-8 -*-

import os.path

class repertoire:
    def __init__(self, chemin):
        self.chemin0=os.path.abspath(chemin)
        if os.path.isfile(self.chemin0):
            self.chemin0=os.path.dirname(self.chemin0)
        
    def chemin(self,choix="defaut"):
        if choix=="defaut":
            return self.chemin0
        if choix=="textures":
            for d in [os.path.join(self.chemin0,"images"), "/usr/share/celestia/textures/medres"]:
                if os.path.exists(d+'/earth.png'):
                    return d
            print "erreur : pas de répertoire des planètes"
            print "=== Il faudrait installer Celestia ==="
            raise(IOError)
        elif os.path.isdir(os.path.join(self.chemin0,choix)):
            return os.path.join(self.chemin0,choix)
        else:
            raise(IOError)
    def fichier(self,*elementsDeChemin):
        f=self.chemin0
        for e in elementsDeChemin:
            f=os.path.join(f,e)
        return f
        
