/* Test of line breaking of UTF-8 strings.
   Copyright (C) 2008-2011 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* Written by Bruno Haible <bruno@clisp.org>, 2008.  */

#include <config.h>

#include "unilbrk.h"

#include <stdlib.h>

#include "macros.h"

int
main ()
{
  /* Test case n = 0.  */
  u8_possible_linebreaks (NULL, 0, "GB18030", NULL);

  {
    static const uint8_t input[91] =
      /* "Grüß Gott. Здравствуйте! x=(-b±sqrt(b²-4ac))/(2a)  日本語,中文,한글" */
      "Gr\303\274\303\237 Gott. \320\227\320\264\321\200\320\260\320\262\321\201\321\202\320\262\321\203\320\271\321\202\320\265! x=(-b\302\261sqrt(b\302\262-4ac))/(2a)  \346\227\245\346\234\254\350\252\236,\344\270\255\346\226\207,\355\225\234\352\270\200\n";

    {
      char *p = (char *) malloc (SIZEOF (input));
      size_t i;

      u8_possible_linebreaks (input, SIZEOF (input), "GB18030", p);
      for (i = 0; i < 91; i++)
        {
          ASSERT (p[i] == (i == 90 ? UC_BREAK_MANDATORY :
                           i == 7
                           || i == 13 || i == 39
                           || i == 43 || i == 44
                           || i == 61 || i == 67
                           || i == 70 || i == 73 || i == 77 || i == 80
                           || i == 84 || i == 87 ? UC_BREAK_POSSIBLE :
                           UC_BREAK_PROHIBITED));
        }
      free (p);
    }

    {
      char *p = (char *) malloc (SIZEOF (input));
      size_t i;

      u8_possible_linebreaks (input, SIZEOF (input), "GB2312", p);
      for (i = 0; i < 91; i++)
        {
          ASSERT (p[i] == (i == 90 ? UC_BREAK_MANDATORY :
                           i == 7
                           || i == 13 || i == 39
                           || i == 43 || i == 44
                           || i == 52 || i == 61 || i == 67
                           || i == 70 || i == 73 || i == 77 || i == 80
                           || i == 84 || i == 87 ? UC_BREAK_POSSIBLE :
                           UC_BREAK_PROHIBITED));
        }
      free (p);
    }
  }

  /* Test that a break is possible after a zero-width space followed by some
     regular spaces (rule LB8 in Unicode TR#14 revision 26).  */
  {
    static const uint8_t input[6] = "x\342\200\213 y";
    char *p = (char *) malloc (SIZEOF (input));
    size_t i;

    u8_possible_linebreaks (input, SIZEOF (input), "UTF-8", p);
    for (i = 0; i < 4; i++)
      {
        ASSERT (p[i] == (i == 5 ? UC_BREAK_POSSIBLE : UC_BREAK_PROHIBITED));
      }
    free (p);
  }

  return 0;
}
