/*-------------------------------------------------------------------------
 *
 * utility.h
 *	  prototypes for utility.c.
 *
 *
 * Portions Copyright (c) 1996-2012, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * src/include/tcop/utility.h
 *
 *-------------------------------------------------------------------------
 */
#ifndef UTILITY_H
#define UTILITY_H

#include "tcop/tcopprot.h"


/* Hook for plugins to get control in ProcessUtility() */
typedef void (*ProcessUtility_hook_type) (Node *parsetree,
			  const char *queryString, ParamListInfo params, bool isTopLevel,
									DestReceiver *dest,
#ifdef PGXC
									bool sentToRemote,
#endif /* PGXC */
									char *completionTag);
extern PGDLLIMPORT ProcessUtility_hook_type ProcessUtility_hook;

extern void ProcessUtility(Node *parsetree, const char *queryString,
			   ParamListInfo params, bool isTopLevel,
			   DestReceiver *dest,
#ifdef PGXC
			   bool sentToRemote,
#endif /* PGXC */
			   char *completionTag);
extern void standard_ProcessUtility(Node *parsetree, const char *queryString,
						ParamListInfo params, bool isTopLevel,
						DestReceiver *dest,
#ifdef PGXC
						bool sentToRemote,
#endif /* PGXC */
						char *completionTag);

extern bool UtilityReturnsTuples(Node *parsetree);

extern TupleDesc UtilityTupleDescriptor(Node *parsetree);

extern Query *UtilityContainsQuery(Node *parsetree);

extern const char *CreateCommandTag(Node *parsetree);

extern LogStmtLevel GetCommandLogLevel(Node *parsetree);

extern bool CommandIsReadOnly(Node *parsetree);

extern void CheckRelationOwnership(RangeVar *rel, bool noCatalogs);

#ifdef PGXC
extern bool pgxc_lock_for_utility_stmt(Node *parsetree);
#endif

#endif   /* UTILITY_H */
