------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--                             T E S T _ J O B                              --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--            Copyright (C) 2003 Free Software Foundation, Inc.             --
--                                                                          --
-- PolyORB is free software; you  can  redistribute  it and/or modify it    --
-- under terms of the  GNU General Public License as published by the  Free --
-- Software Foundation;  either version 2,  or (at your option)  any  later --
-- version. PolyORB is distributed  in the hope that it will be  useful,    --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License distributed with PolyORB; see file COPYING. If    --
-- not, write to the Free Software Foundation, 59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
--                                                                          --
--                PolyORB is maintained by ACT Europe.                      --
--                    (email: sales@act-europe.fr)                          --
--                                                                          --
------------------------------------------------------------------------------

with CORBA;

with PolyORB.Utils.Report;

package body Test_Job is

   procedure Run_Job is
   begin
      PolyORB.Utils.Report.Output
        ("Invocation on servant finished",
         "Hello Ada World !" =
         CORBA.To_Standard_String
         (Echo.echoString (Global_Obj_Ref,
                           CORBA.To_CORBA_String ("Hello Ada World !"))));
   end Run_Job;

   procedure Run_Job_Wait is
   begin
      PolyORB.Utils.Report.Output
        ("Invocation on servant finished",
         "Hello Ada World !" =
         CORBA.To_Standard_String
         (Echo.echoString_wait
          (Global_Obj_Ref,
           CORBA.To_CORBA_String ("Hello Ada World !"))));
   end Run_Job_Wait;

end Test_Job;
