<?php
/**
*
* common [Hungarian]
*
* @package language
* @version $Id: common.php 233 2012-01-05 22:31:27Z marcee $
* @copyright (c) 2007 „Magyar phpBB Közösség fordítók”
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
* Original copyright: (c) 2005 phpBB Group
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

$lang = array_merge($lang, array(
	'TRANSLATION_INFO'	=> 'Magyar fordítás © <a href="http://phpbb.hu/">Magyar phpBB Közösség</a>',
	'DIRECTION'			=> 'ltr',
	'DATE_FORMAT'		=> '|Y.m.d.|',
	'USER_LANG'			=> 'hu',

	'1_DAY'			=> '1 nap',
	'1_MONTH'		=> '1 hónap',
	'1_YEAR'		=> '1 év',
	'2_WEEKS'		=> '2 hét',
	'3_MONTHS'		=> '3 hónap',
	'6_MONTHS'		=> '6 hónap',
	'7_DAYS'		=> '7 nap',

	'ACCOUNT_ALREADY_ACTIVATED'		=> 'Az azonosítód már aktiváltuk.',
	'ACCOUNT_DEACTIVATED'			=> 'Az azonosítód kézzel deaktiválásra került, csak egy adminisztrátor tudja újraaktiválni.',
	'ACCOUNT_NOT_ACTIVATED'			=> 'Az azonosítód még nem aktiváltuk.',
	'ACP'							=> 'Adminisztrátori vezérlőpult',
	'ACTIVE'						=> 'aktív',
	'ACTIVE_ERROR'					=> 'A megadott felhasználónév jelenleg inaktív. Ha problémáid akadnának az azonosítód aktiválásával, lépj kapcsolatba a fórum adminisztrátorával.',
	'ADMINISTRATOR'					=> 'Adminisztrátor',
	'ADMINISTRATORS'				=> 'Adminisztrátorok',
	'AGE'							=> 'Kor',
	'AIM'							=> 'AIM',
	'ALLOWED'						=> 'Engedélyezett',
	'ALL_FILES'						=> 'Összes állomány',
	'ALL_FORUMS'					=> 'Összes fórum',
	'ALL_MESSAGES'					=> 'Összes üzenet',
	'ALL_POSTS'						=> 'Összes hozzászólás',
	'ALL_TIMES'						=> 'Időzóna: %1$s %2$s',
	'ALL_TOPICS'					=> 'Összes téma',
	'AND'							=> 'és',
	'ARE_WATCHING_FORUM'			=> 'Sikeresen feliratkoztál erre a fórumra.',
	'ARE_WATCHING_TOPIC'			=> 'Sikeresen feliratkoztál erre a témára.',
	'ASCENDING'						=> 'Növekvő',
	'ATTACHMENTS'					=> 'Csatolmányok',
	'ATTACHED_IMAGE_NOT_IMAGE'		=> 'A csatolni próbált képállomány hibás.',
	'AUTHOR'						=> 'Szerző',
	'AUTH_NO_PROFILE_CREATED'		=> 'Nem sikerült létrehozni a felhasználói profilt.',
	'AVATAR_DISALLOWED_CONTENT'		=> 'A feltöltés visszautasításra került, mivel a feltöltött állomány egy esetleges támadás hordozója lehet.',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'Az állományt nem lehet megjeleníteni, mivel a <strong>%s</strong> kiterjesztés nem engedélyezett.',
	'AVATAR_EMPTY_REMOTE_DATA'		=> 'Nem sikerült feltölteni az avatart, mivel a külső forrás hibásnak tűnik.',
	'AVATAR_EMPTY_FILEUPLOAD'		=> 'A feltöltött avatar állomány üres.',
	'AVATAR_INVALID_FILENAME'		=> 'Hibás állománynév: %s',
	'AVATAR_NOT_UPLOADED'			=> 'Nem sikerült feltölteni az avatart.',
	'AVATAR_NO_SIZE'				=> 'Nem sikerült meghatározni a belinkelt avatar szélességét és magasságát, kérjük, add meg kézzel.',
	'AVATAR_PARTIAL_UPLOAD'			=> 'Az avatart csak részben sikerült feltölteni.',
	'AVATAR_PHP_SIZE_NA'			=> 'Az avatar állomány mérete túl nagy.<br />Nem sikerült megállapítani a PHP php.ini-jében meghatározott maximális méretet.',
	'AVATAR_PHP_SIZE_OVERRUN'		=> 'Az avatar állomány mérete túl nagy, a maximum feltölthető méret %1$d %2$s.<br />Kérjük, vedd figyelembe, hogy ez a php.ini-ben van meghatározva, ezért nem írható felül.',
	'AVATAR_URL_INVALID'			=> 'A megadott URL hibás.',
	'AVATAR_URL_NOT_FOUND'			=> 'A megadott állomány nem található.',
	'AVATAR_WRONG_FILESIZE'			=> 'Az avatarnak 0 és %1d %2s között kell lennie.',
	'AVATAR_WRONG_SIZE'				=> 'A megadott avatar %5$d pixel széles, és %6$d pixel magas. Az avatarnak legalább %1$d pixel szélesnek és %2$d pixel magasnak kell lennie, valamint legfeljebb %3$d pixel széles és %4$d pixel magas lehet.',

	'BACK_TO_TOP'			=> 'Vissza a tetejére',
	'BACK_TO_PREV'			=> 'Vissza az előző oldalra',
	'BAN_TRIGGERED_BY_EMAIL'=> 'A kitiltás e-mail cím alapján történt.',
	'BAN_TRIGGERED_BY_IP'	=> 'A kitiltás IP-cím alapján történt.',
	'BAN_TRIGGERED_BY_USER'	=> 'A kitiltás felhasználónév alapján történt.',
	'BBCODE_GUIDE'			=> 'BBCode útmutató',
	'BCC'					=> 'Titkos másolat',
	'BIRTHDAYS'				=> 'Születésnaposok',
	'BOARD_BAN_PERM'		=> '<strong>Véglegesen</strong> kitiltottak erről a fórumról.<br /><br />További információért lépj kapcsolatba a %2$sfórum adminisztátorával%3$s.',
	'BOARD_BAN_REASON'		=> 'Kitiltás oka: <strong>%s</strong>',
	'BOARD_BAN_TIME'		=> '<strong>%1$s</strong>-ig kitiltottak erről a fórumról.<br /><br />További információért lépj kapcsolatba a %2$sfórum adminisztátorával%3$s.',
	'BOARD_DISABLE'			=> 'A fórum jelenleg nem elérhető.',
	'BOARD_DISABLED'		=> 'A fórum ideiglenesen szünetel.',
	'BOARD_UNAVAILABLE'		=> 'A fórum ideiglenesen nem elérhető, kérünk, próbálkozz újra pár perc múlva.',
	'BROWSING_FORUM'		=> 'Jelenlévő fórumuzók: %1$s',
	'BROWSING_FORUM_GUEST'	=> 'Jelenlévő fórumozók: %1$s valamint %2$d vendég',
	'BROWSING_FORUM_GUESTS'	=> 'Jelenlévő fórumozók: %1$s valamint %2$d vendég',
	'BYTES'					=> 'bájt',

	'CANCEL'				=> 'Mégsem',
	'CHANGE'				=> 'Változtatás',
	'CHANGE_FONT_SIZE'		=> 'Betűméret megváltoztatása',
	'CHANGING_PREFERENCES'	=> 'Fórum beállítások megváltoztatása',
	'CHANGING_PROFILE'		=> 'Profil megváltoztatása',
	'CLICK_VIEW_PRIVMSG'	=> '%sBejövő mappa megtekintése%s',
	'COLLAPSE_VIEW'			=> 'Összecsukás',
	'CLOSE_WINDOW'			=> 'Ablak bezárása',
	'COLOUR_SWATCH'			=> 'Szín kiválasztása',
	'COMMA_SEPARATOR'		=> ', ', // Used in pagination of ACP & prosilver, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'				=> 'Megerősítés',
	'CONFIRM_CODE'			=> 'Megerősítő kód',
	'CONFIRM_CODE_EXPLAIN'	=> 'Gépeld be a képen látható kódot. A kis- vagy nagybetűk nem számítanak.',
	'CONFIRM_CODE_WRONG'	=> 'A megadott megerősítő kód hibás.',
	'CONFIRM_OPERATION'		=> 'Biztosan végre akarod hajtani ezt a műveletet?',
	'CONGRATULATIONS'		=> 'Gratulálunk',
	'CONNECTION_FAILED'		=> 'Sikertelen kapcsolódási kísérlet',
	'CONNECTION_SUCCESS'	=> 'Sikerült csatlakozni!',
	'COOKIES_DELETED'		=> 'A fórum sütijei törlésre kerültek.',
	'CURRENT_TIME'			=> 'Pontos idő: %s',

	'DAY'					=> 'nap',
	'DAYS'					=> 'nap',
	'DELETE'				=> 'Törlés',
	'DELETE_ALL'			=> 'Összes törlése',
	'DELETE_COOKIES'		=> 'Fórum sütik törlése',
	'DELETE_MARKED'			=> 'Kijelöltek törlése',
	'DELETE_POST'			=> 'Hozzászólás törlése',
	'DELIMITER'				=> 'Határolójel',
	'DESCENDING'			=> 'Csökkenő',
	'DISABLED'				=> 'Kikapcsolva',
	'DISPLAY'				=> 'Megjelenítés',
	'DISPLAY_GUESTS'		=> 'Vendégek megjelenítése',
	'DISPLAY_MESSAGES'		=> 'Üzenetek megtekintése',
	'DISPLAY_POSTS'			=> 'Hozzászólások megjelenítése',
	'DISPLAY_TOPICS'		=> 'Témák megjelenítése',
	'DOWNLOADED'			=> 'Letöltve',
	'DOWNLOADING_FILE'		=> 'Állomány letöltése',
	'DOWNLOAD_COUNT'		=> '%d alkalommal.',
	'DOWNLOAD_COUNTS'		=> '%d alkalommal.',
	'DOWNLOAD_COUNT_NONE'	=> 'Még senki sem töltötte le.',
	'VIEWED_COUNT'			=> 'Megtekintve %d alkalommal.',
	'VIEWED_COUNTS'			=> 'Megtekintve %d alkalommal.',
	'VIEWED_COUNT_NONE'		=> 'Még senki sem tekintette meg.',

	'EDIT_POST'							=> 'Hozzászólás szerkesztése',
	'EMAIL'								=> 'E-mail', // Short form for EMAIL_ADDRESS
	'EMAIL_ADDRESS'						=> 'E-mail cím',
	'EMAIL_SMTP_ERROR_RESPONSE'			=> 'Problémába ütköztünk egy levél elküldése során a <strong>%1$s.</strong> sorban. Válasz: %2$s',
	'EMPTY_SUBJECT'						=> 'Új téma indításához meg kell adnod a téma címét.',
	'EMPTY_MESSAGE_SUBJECT'				=> 'Meg kell adnod az üzenet témáját.',
	'ENABLED'							=> 'Bekapcsolva',
	'ENCLOSURE'							=> 'Körülhatárolójel',
	'ENTER_USERNAME'					=> 'Add meg a felhasználónevet',
	'ERR_CHANGING_DIRECTORY'			=> 'Nem sikerült megváltoztatni a könyvtárat.',
	'ERR_CONNECTING_SERVER'				=> 'Nem sikerült csatlakozni a szerverhez.',
	'ERR_JAB_AUTH'						=> 'Nem sikerült az azonosítás a Jabber szerveren. ',
	'ERR_JAB_CONNECT'					=> 'Nem sikerült csatlakozni a Jabber szerverhez.',
	'ERR_UNABLE_TO_LOGIN'				=> 'A megadott felhasználói név vagy jelszó hibás.',
	'ERR_UNWATCHING'					=> 'Hiba lépett fel a leiratkozás során.',
	'ERR_WATCHING'						=> 'Hiba lépett fel a feliratkozás során.',
	'ERR_WRONG_PATH_TO_PHPBB'			=> 'A megadott phpBB elérési útvonal feltehetőleg hibás.',
	'EXPAND_VIEW'						=> 'Kinyitás',
	'EXTENSION'							=> 'Kiterjesztés',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'A <b>%s</b> kiterjesztés deaktiválva lett, ezért a csatolmány nem kerül megjelenítésre.',

	'FAQ'					=> 'GyIK',
	'FAQ_EXPLAIN'			=> 'Gyakran ismételt kérdések',

	'FILENAME'				=> 'Állomány neve',
	'FILESIZE'				=> 'Állomány mérete',
	'FILEDATE'				=> 'Állomány feltöltve',
	'FILE_COMMENT'			=> 'Magyarázat',
	'FILE_NOT_FOUND'		=> 'A keresett állomány nem található.',
	'FIND_USERNAME'			=> 'Felhasználó keresése',
	'FOLDER'				=> 'Mappa',
	'FORGOT_PASS'			=> 'Elfelejtettem a jelszavam',
	'FORM_INVALID'			=> 'Az elküldött űrlap érvénytelen. Próbáld meg újra elküldeni.',
	'FORUM'					=> 'Fórum',
	'FORUMS'				=> 'Fórumok',
	'FORUMS_MARKED'			=> 'A kiválasztott fórumok megjelölésre kerültek olvasottként.',
	'FORUM_CAT'				=> 'Fórum kategória',
	'FORUM_INDEX'			=> 'Fórum kezdőlap',
	'FORUM_LINK'			=> 'Fórum link',
	'FORUM_LOCATION'		=> 'Tevékenység',
	'FORUM_LOCKED'			=> 'Lezárt fórum',
	'FORUM_RULES'			=> 'Fórum szabályok',
	'FORUM_RULES_LINK'		=> 'Kattints ide a fórum szabályainak megtekintéséhez',
	'FROM'					=> 'Minta:',
	'FSOCK_DISABLED'		=> 'Nem sikerült végrehajtani a műveletet, mivel az <var>fsockopen</var> függvény nincs engedélyezve, vagy az elérni kívánt szerver nem található.',
	'FSOCK_TIMEOUT'			=> 'Időtúllépés történt a hálózati kapcsolat közben.',

	'FTP_FSOCK_HOST'				=> 'FTP hoszt',
	'FTP_FSOCK_HOST_EXPLAIN'		=> 'Az oldalad eléréséhez használt FTP kiszolgáló.',
	'FTP_FSOCK_PASSWORD'			=> 'FTP jelszó',
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'Az FTP felhasználónévhez tartozó jelszó.',
	'FTP_FSOCK_PORT'				=> 'FTP port',
	'FTP_FSOCK_PORT_EXPLAIN'		=> 'AZ FTP szerver portja.',
	'FTP_FSOCK_ROOT_PATH'			=> 'PhpBB elérési út',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'A phpBB elérési útja az FTP gyökérkönyvtárától (ami alapból megnyílik).',
	'FTP_FSOCK_TIMEOUT'				=> 'FTP időtúllépés',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'		=> 'Legfeljebb ennyit fog várni a rendszer a válaszra a szervertől másodpercben megadva.',
	'FTP_FSOCK_USERNAME'			=> 'FTP felhasználónév',
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'A szerverhez való csatlakozáshoz használt felhasználónév.',

	'FTP_HOST'					=> 'FTP hoszt',
	'FTP_HOST_EXPLAIN'			=> 'Az oldalad eléréséhez használt FTP szerver.',
	'FTP_PASSWORD'				=> 'FTP jelszó',
	'FTP_PASSWORD_EXPLAIN'		=> 'Az FTP felhasználónévhez tartozó jelszó.',
	'FTP_PORT'					=> 'FTP port',
	'FTP_PORT_EXPLAIN'			=> 'AZ FTP szerver portja.',
	'FTP_ROOT_PATH'				=> 'PhpBB elérési út',
	'FTP_ROOT_PATH_EXPLAIN'		=> 'A phpBB elérési útja az FTP gyökérkönyvtárától (ami alapból megnyílik).',
	'FTP_TIMEOUT'				=> 'FTP várakozási limit',
	'FTP_TIMEOUT_EXPLAIN'		=> 'Legfeljebb ennyit fog várni a rendszer a válaszra a szervertől másodpercben megadva.',
	'FTP_USERNAME'				=> 'FTP felhasználónév',
	'FTP_USERNAME_EXPLAIN'		=> 'A szerverhez való csatlakozáshoz használt felhasználónév.',

	'GENERAL_ERROR'				=> 'Általános hiba',
	'GB'						=> 'GB',
	'GIB'						=> 'GiB',
	'GO'						=> 'Mehet',
	'GOTO_PAGE'					=> 'Oldal',
	'GROUP'						=> 'Csoport',
	'GROUPS'					=> 'Csoportok',
	'GROUP_ERR_TYPE'			=> 'Helytelen csoporttípust adtál meg.',
	'GROUP_ERR_USERNAME'		=> 'Nem adtad meg a csoport nevét.',
	'GROUP_ERR_USER_LONG'		=> 'Egy csoport neve legfeljebb 60 karakter hosszú lehet. A megadott csoportnév túl hosszú.',
	'GUEST'						=> 'Vendég',
	'GUEST_USERS_ONLINE'		=> '%d vendég van jelen.',
	'GUEST_USERS_TOTAL'			=> '%d vendég.',
	'GUEST_USERS_ZERO_ONLINE'	=> '0 vendég van jelen.',
	'GUEST_USERS_ZERO_TOTAL'	=> '0 vendég.',
	'GUEST_USER_ONLINE'			=> '%d vendég van jelen.',
	'GUEST_USER_TOTAL'			=> '%d vendég.',
	'G_ADMINISTRATORS'			=> 'Adminisztrátorok',
	'G_BOTS'					=> 'Robotok',
	'G_GUESTS'					=> 'Vendégek',
	'G_REGISTERED'				=> 'Regisztrált felhasználók',
	'G_REGISTERED_COPPA'		=> 'Regisztrált COPPA felhasználók',
	'G_GLOBAL_MODERATORS'		=> 'Globális moderátorok',
	'G_NEWLY_REGISTERED'		=> 'Újonnan regisztrált felhasználók',

	'HIDDEN_USERS_ONLINE'			=> '%d rejtett felhasználó van jelen.',
	'HIDDEN_USERS_TOTAL'			=> '%d rejtett',
	'HIDDEN_USERS_TOTAL_AND'		=> '%d rejtett és ',
	'HIDDEN_USERS_ZERO_ONLINE'		=> '0 rejtett felhasználó van jelen.',
	'HIDDEN_USERS_ZERO_TOTAL'		=> '0 rejtett',
	'HIDDEN_USERS_ZERO_TOTAL_AND'	=> '0 rejtett és ',
	'HIDDEN_USER_ONLINE'			=> '%d rejtett felhasználó van jelen.',
	'HIDDEN_USER_TOTAL'				=> '%d rejtett',
	'HIDDEN_USER_TOTAL_AND'			=> '%d rejtett és ',
	'HIDE_GUESTS'					=> 'Vendégek elrejtése',
	'HIDE_ME'						=> 'Bejelentkezés rejtettként',
	'HOURS'							=> 'óra',
	'HOME'							=> 'Főoldal',


	'ICQ'						=> 'ICQ',
	'ICQ_STATUS'				=> 'ICQ állapot',
	'IF'						=> 'Feltétel',
	'IMAGE'						=> 'Kép',
	'IMAGE_FILETYPE_INVALID'	=> 'A %d kiterjesztésű %s MIME típusú kép nem támogatott.',
	'IMAGE_FILETYPE_MISMATCH'	=> 'Nem stimmel a kép kiterjesztése: %1$s helyett %2$s.',
	'IN'						=> 'Fórum:',
	'INDEX'						=> 'Fórum kezdőlap megtekintése',
	'INFORMATION'				=> 'Információ',
	'INTERESTS'					=> 'Érdeklődési kör',
	'INVALID_DIGEST_CHALLENGE'	=> 'Hibás feltárási kérés',
	'INVALID_EMAIL_LOG'			=> 'A <strong>%s</strong> feltehetőleg egy nem létező e-mail cím.',
	'IP'						=> 'IP-cím',
	'IP_BLACKLISTED'			=> 'Az IP-címed tiltólistára került, ezért a hozzáférésed a fórumhoz blokkoltuk. További információ: <a href="%2$s">%2$s</a>.',

	'JABBER'				=> 'Jabber',
	'JOINED'				=> 'Csatlakozott',
	'JUMP_PAGE'				=> 'Add meg annak az oldalnak a számát, ahová menni szeretnél',
	'JUMP_TO'				=> 'Ugrás',
	'JUMP_TO_PAGE'			=> 'Kattints ide egy fel nem sorolt oldalra való ugráshoz',

	'KB'					=> 'KB',
	'KIB'					=> 'KiB',

	'LAST_POST'							=> 'Utolsó hozzászólás',
	'LAST_UPDATED'						=> 'Legutóbb frissített',
	'LAST_VISIT'						=> 'Utolsó látogatás',
	'LDAP_NO_LDAP_EXTENSION'			=> 'Az LDAP kiterjesztés nem elérhető.',
	'LDAP_NO_SERVER_CONNECTION'			=> 'Nem sikerült csatlakozni az LDAP szerverhez.',
	'LDAP_SEARCH_FAILED'				=> 'Hiba történt az LDAP könyvtár keresése közben.',
	'LEGEND'							=> 'Magyarázat',
	'LOCATION'							=> 'Tartózkodási hely',
	'LOCK_POST'							=> 'Hozzászólás lezárása',
	'LOCK_POST_EXPLAIN'					=> 'A felhasználó nem fogja tudni szerkeszteni a hozzászólást.',
	'LOCK_TOPIC'						=> 'Téma lezárása',
	'LOGIN'								=> 'Belépés',
	'LOGIN_CHECK_PM'					=> 'Privát üzeneteid megtekintéséhez lépj be.',
	'LOGIN_CONFIRMATION'				=> 'Belépés megerősítése',
	'LOGIN_CONFIRM_EXPLAIN'				=> 'Az azonosítók feltörésének megakadályozása érdekében egy bizonyos számú sikertelen belépési kísérlet után meg kell adnod egy megerősítő kódot. A kód az alábbi képen található. Ha látási (vagy egyéb) problémák folytán nem tudnád elolvasni a kódot, vedd fel a kapcsolatot a %sfórum adminisztrátorával%s.', // unused
	'LOGIN_ERROR_ATTEMPTS'				=> 'Túllépted az engedélyezett belépési kísérletek számát. Ezért a felhasználóneved és a jelszavad megadása mellett most el kell végezned az alább látható CAPTCHA-t is.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'Az Apache szervernek nem sikerült azonosítania téged.',
	'LOGIN_ERROR_PASSWORD'				=> 'Rossz jelszót adtál meg. Ellenőrizd le a jelszavad, majd próbálkozz újra. Ha továbbra is gondjaid lennének, lépj kapcsolatba a %sfórum adminisztrátorával%s.',
	'LOGIN_ERROR_PASSWORD_CONVERT'		=> 'Nem sikerült átkonvertálni a jelszavad a fórum szoftverének frissítése során. Kérünk, %sigényelj egy új jelszót%s. Ha továbbra is problémáid lennének, lépj kapcsolatba a %sfórum adminisztrátorával%s.',
	'LOGIN_ERROR_USERNAME'				=> 'Rossz felhasználónevet adtál meg. Ellenőrizd le a felhasználónevet, majd próbálkozz újra. Ha továbbra is gondjaid lennének, lépj kapcsolatba a %sfórum adminisztrátorával%s.',
	'LOGIN_FORUM'						=> 'A fórum megtekintéséhez vagy a hozzászóláshoz meg kell adnod a fórum jelszavát.',
	'LOGIN_INFO'						=> 'A belépéshez regisztrált felhasználónak kell lenned. A regisztráció csupán néhány másodpercet vesz igénybe, de számos előnnyel jár, az adminisztrátor például így tud külön jogosultságokat adni. A regisztráció előtt győződj meg róla, hogy elfogadod a felhasználási feltételeinket, valamint egyetértesz az adatvédelmi nyilatkozatunkkal. Kérjük, olvasd el a fórumok szabályait is!',
	'LOGIN_VIEWFORUM'					=> 'Csak regisztrált felhasználók tekinthetik meg ezt a fórumot.',
	'LOGIN_EXPLAIN_EDIT'				=> 'Csak regisztrált felhasználók szerkeszthetik a hozzászólásaikat ebben a fórumban.',
 	'LOGIN_EXPLAIN_VIEWONLINE'			=> 'Csak regisztrált felhasználók tekinthetik meg a jelenlévők listáját.',
	'LOGOUT'							=> 'Kilépés',
	'LOGOUT_USER'						=> 'Kilépés [ %s ]',
	'LOG_ME_IN'							=> 'Automatikus bejelentkezés',

	'MARK'					=> 'Kijelölés',
	'MARK_ALL'				=> 'Összes kijelölése',
	'MARK_FORUMS_READ'		=> 'Fórumok megjelölése olvasottként',
	'MARK_SUBFORUMS_READ'	=> 'Alfórumok megjelölése olvasottként',
	'MB'					=> 'MB',
	'MIB'					=> 'MiB',
	'MCP'					=> 'Moderátori vezérlőpult',
	'MEMBERLIST'			=> 'Taglista',
	'MEMBERLIST_EXPLAIN'	=> 'Felhasználók listájának megtekintése',
	'MERGE'					=> 'Összevonás',
	'MERGE_POSTS'			=> 'Hozzászólások áthelyezése',
	'MERGE_TOPIC'			=> 'Téma összevonása',
	'MESSAGE'				=> 'Üzenet',
	'MESSAGES'				=> 'üzenet',
	'MESSAGE_BODY'			=> 'Üzenet tartalma',
	'MINUTES'				=> 'perc',
	'MODERATE'				=> 'Moderálás',
	'MODERATOR'				=> 'Moderátor',
	'MODERATORS'			=> 'Moderátorok',
	'MONTH'					=> 'hónap',
	'MOVE'					=> 'Áthelyezés',
	'MSNM'					=> 'MSNM/WLM',

	'NA'						=> 'N/A',
	'NEWEST_USER'				=> 'Legújabb regisztrált tagunk: <strong>%s</strong>',
	'NEW_MESSAGE'				=> 'Új üzenet',
	'NEW_MESSAGES'				=> 'Új üzenetek',
	'NEW_PM'					=> '<strong>%d</strong> új üzenet',
	'NEW_PMS'					=> '<strong>%d</strong> új üzenet',
	'NEW_POST'					=> 'Új hozzászólás',	// Not used anymore
	'NEW_POSTS'					=> 'Új hozzászólások',	// Not used anymore
	'NEXT'						=> 'Következő',		// Used in pagination
	'NEXT_STEP'					=> 'Tovább',
	'NEVER'						=> 'Soha',
	'NO'						=> 'Nem',
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'Nincs jogosultságod a csoport kezeléséhez.',
	'NOT_AUTHORISED'			=> 'Nincs jogosultságod hozzáférni ehhez a részhez.',
	'NOT_WATCHING_FORUM'		=> 'Sikeresen leiratkoztál a fórumról.',
	'NOT_WATCHING_TOPIC'		=> 'Sikeresen leiratkoztál a témáról.',
	'NOTIFY_ADMIN'				=> 'Kérjük, értesítsd a fórum adminisztrátorát vagy a webmestert.',
	'NOTIFY_ADMIN_EMAIL'		=> 'Kérjük, értesítsd a fórum adminisztrátorát vagy a webmestert: <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'		=> 'Nincs jogosultságod hozzáférni ehhez az állományhoz.',
	'NO_ACTION'					=> 'Nincs semmilyen teendő.',
	'NO_ADMINISTRATORS'			=> 'Nincs adminisztrátor.',
	'NO_AUTH_ADMIN'				=> 'Nem férhetsz hozzá az adminisztrátori vezérlőpulthoz, mivel nincs adminisztrátori jogosultságod.',
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'Nem azonosíthatod magad egy másik felhasználóként.',
	'NO_AUTH_OPERATION'			=> 'Nincs meg a megfelelő jogosultságod ezen művelet elvégzéséhez.',
	'NO_CONNECT_TO_SMTP_HOST'	=> 'Nem sikerült csatlakozni az SMTP szerverhez: %1$s : %2$s',
	'NO_BIRTHDAYS'				=> 'Ma senkinek sincs születésnapja.',
	'NO_EMAIL_MESSAGE'			=> 'Az e-mail üzenet üres.',
	'NO_EMAIL_RESPONSE_CODE'	=> 'Nem jött válasz az e-mail szervertől.',
	'NO_EMAIL_SUBJECT'			=> 'Nem adtad meg az e-mail témáját.',
	'NO_FORUM'					=> 'A kiválasztott fórum nem létezik.',
	'NO_FORUMS'					=> 'Nincs fórum.',
	'NO_GROUP'					=> 'A keresett csoport nem létezik.',
	'NO_GROUP_MEMBERS'			=> 'A csoportnak jelenleg nincs tagja.',
	'NO_IPS_DEFINED'			=> 'Nincs ilyen IP-cím vagy hoszt.',
	'NO_MEMBERS'				=> 'Nincs a keresési feltételeknek megfelelő felhasználó.',
	'NO_MESSAGES'				=> 'Nincs üzenet.',
	'NO_MODE'					=> 'Nem adtál meg módot.',
	'NO_MODERATORS'				=> 'Nincs moderátor.',
	'NO_NEW_MESSAGES'			=> 'Nincs új üzenet.',
	'NO_NEW_PM'					=> '<strong>0</strong> új üzenet',
	'NO_NEW_POSTS'				=> 'Nincs új hozzászólás',	// Not used anymore
	'NO_ONLINE_USERS'			=> 'nincs regisztrált felhasználó',
	'NO_POSTS'					=> 'Nincs hozzászólás',
	'NO_POSTS_TIME_FRAME'		=> 'Nincs a kiválasztott időtartamon belüli hozzászólás a témában.',
	'NO_FEED_ENABLED'			=> 'Nincs elérhető csatorna ezen a fórumon.',
	'NO_FEED'					=> 'A kívánt csatorna nem elérhető.',
	'NO_SUBJECT'				=> 'Nincs téma',								// Used for posts having no subject defined but displayed within management pages.
	'NO_SUCH_SEARCH_MODULE'		=> 'A megadott keresési mechanizmus nem létezik.',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'Nincsen támogatott azonosítási eljárás.',
	'NO_TOPIC'					=> 'A keresett téma nem létezik.',
	'NO_TOPIC_FORUM'			=> 'A téma vagy fórum már nem létezik.',
	'NO_TOPICS'					=> 'A fórum nem tartalmaz témákat, illetve hozzászólásokat.',
	'NO_TOPICS_TIME_FRAME'		=> 'A fórum nem tartalmaz témákat a megadott időtartamon belül.',
	'NO_UNREAD_PM'				=> '<strong>0</strong> olvasatlan üzenet',
	'NO_UNREAD_POSTS'			=> 'Nincs olvasatlan hozzászólás',
	'NO_UPLOAD_FORM_FOUND'		=> 'Kezdeményeztél egy feltöltést, azonban erre most nincs lehetőség.',
	'NO_USER'					=> 'A keresett felhasználó nem létezik.',
	'NO_USERS'					=> 'A keresett felhasználók nem léteznek.',
	'NO_USER_SPECIFIED'			=> 'Nem adtál meg felhasználónevet.',

	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_POSTS_IN_QUEUE'		=> array(
		0			=> 'Nincs moderálandó hozzászólás.',		// 0
		1			=> '%d moderálandó hozzászólás van.',	// 1+
	),

	'OCCUPATION'				=> 'Foglalkozás',
	'OFFLINE'					=> 'Offline',
	'ONLINE'					=> 'Online',
	'ONLINE_BUDDIES'			=> 'Jelenlévő barátok',
	'ONLINE_USERS_TOTAL'		=> 'Jelenleg <strong>%d</strong> felhasználó van jelen: ',
	'ONLINE_USERS_ZERO_TOTAL'	=> 'Jelenleg <strong>0</strong> felhasználó van jelen: ',
	'ONLINE_USER_TOTAL'			=> 'Jelenleg <strong>%d</strong> felhasználó van jelen: ',
	'OPTIONS'					=> 'Opciók',

	'PAGE_OF'				=> 'Oldal: <strong>%1$d</strong> / <strong>%2$d</strong>',
	'PASSWORD'				=> 'Jelszó',
	'PIXEL'					=> 'px',
	'PLAY_QUICKTIME_FILE'	=> 'Quicktime állomány lejátszása',
	'PM'					=> 'PÜ',
	'PM_REPORTED'			=> 'Kattints ide a jelentés megtekintéséhez',
	'POSTING_MESSAGE'		=> 'Üzenet küldése a %s fórumban',
	'POSTING_PRIVATE_MESSAGE'	=> 'Privát üzenet küldése',
	'POST'					=> 'Hozzászólás',
	'POST_ANNOUNCEMENT'		=> 'Közlemény',
	'POST_STICKY'			=> 'Kiemelt',
	'POSTED'				=> 'Elküldve',
	'POSTED_IN_FORUM'		=> 'Fórum:',
	'POSTED_ON_DATE'		=> 'Dátum:',
	'POSTS'					=> 'Hozzászólások',
	'POSTS_UNAPPROVED'		=> 'Jóvá nem hagyott hozzászólás(ok)',
	'POST_BY_AUTHOR'		=> 'Szerző:',
	'POST_BY_FOE'			=> 'Ezt a hozzászólást <strong>%1$s</strong> küldte, aki jelenleg a tiltólistádon van. %2$sHozzászólás megjelenítése%3$s',
	'POST_DAY'				=> 'Naponta %.2f hozzászólás',
	'POST_DETAILS'			=> 'Hozzászólás adatai',
	'POST_NEW_TOPIC'		=> 'Új téma nyitása',
	'POST_PCT'				=> 'Az összes hozzászólás %.2f%%-a',
	'POST_PCT_ACTIVE'		=> 'A felhasználó hozzászólásainak %.2f%%-a',
	'POST_PCT_ACTIVE_OWN'	=> 'A hozzászólásaid %.2f%%-a',
	'POST_REPLY'			=> 'Hozzászólás küldése',
	'POST_REPORTED'			=> 'Kattints ide a jelentés megtekintéséhez',
	'POST_SUBJECT'			=> 'Hozzászólás témája',
	'POST_TIME'				=> 'Elküldés ideje',
	'POST_TOPIC'			=> 'Új téma nyitása',
	'POST_UNAPPROVED'		=> 'A hozzászólás jóváhagyásra vár',
	'PREVIEW'				=> 'Előnézet',
	'PREVIOUS'				=> 'Előző',		// Used in pagination
 	'PREVIOUS_STEP'			=> 'Vissza',
	'PRIVACY'				=> 'Adatvédelmi nyilatkozat',
	'PRIVATE_MESSAGE'		=> 'Privát üzenet',
	'PRIVATE_MESSAGES'		=> 'Privát üzenetek',
	'PRIVATE_MESSAGING'		=> 'privát üzenet',
	'PROFILE'				=> 'Felhasználói vezérlőpult',

	'READING_FORUM'				=> '%s fórum megtekintése',
	'READING_GLOBAL_ANNOUNCE'	=> 'Általános közlemény megtekintése',
	'READING_LINK'				=> 'Link megtekintése: %s',
	'READING_TOPIC'				=> 'Téma megtekintése a %s fórumban',
	'READ_PROFILE'				=> 'Profil',
	'REASON'					=> 'Ok',
	'RECORD_ONLINE_USERS'		=> 'A legtöbb felhasználó (<strong>%1$s</strong> fő) %2$s-kor tartózkodott itt.',
	'REDIRECT'					=> 'Átirányítás',
	'REDIRECTS'					=> 'Átirányítások száma',
	'REGISTER'					=> 'Regisztráció',
	'REGISTERED_USERS'			=> 'Regisztrált felhasználók:',
	'REG_USERS_ONLINE'			=> '%d regisztrált és ',
	'REG_USERS_TOTAL'			=> '%d regisztrált, ',
	'REG_USERS_TOTAL_AND'		=> '%d regisztrált és ',
	'REG_USERS_ZERO_ONLINE'		=> '0 regisztrált és ',
	'REG_USERS_ZERO_TOTAL'		=> '0 regisztrált, ',
	'REG_USERS_ZERO_TOTAL_AND'	=> '0 regisztrált és ',
	'REG_USER_ONLINE'			=> '%d regisztrált és ',
	'REG_USER_TOTAL'			=> '%d regisztrált, ',
	'REG_USER_TOTAL_AND'		=> '%d regisztrált és ',
	'REMOVE'					=> 'Törlés',
	'REMOVE_INSTALL'			=> 'Kérjük, töröld, helyezd át, vagy nevezd át az install könyvtárat a fórum használatba vétele előtt. Amíg ez a könyvtár létezik, csak az adminisztrátori vezérlőpult lesz elérhető.',
	'REPLIES'					=> 'Válaszok',
	'REPLY_WITH_QUOTE'			=> 'Hozzászólás az előzmény idézésével',
	'REPLYING_GLOBAL_ANNOUNCE'	=> 'Válasz írása egy általános közleményre',
	'REPLYING_MESSAGE'			=> 'Válasz írása a %s fórumban',
	'REPORT_BY'					=> 'Felhasználó',
	'REPORT_POST'				=> 'Hozzászólás jelentése',
	'REPORTING_POST'			=> 'Hozzászólás jelentése',
	'RESEND_ACTIVATION'			=> 'Aktivációs e-mail újraküldése',
	'RESET'						=> 'Töröl',
	'RESTORE_PERMISSIONS'		=> 'Jogosultságok visszaállítása',
	'RETURN_INDEX'				=> '%sVissza a fórum kezdőlapra%s',
	'RETURN_FORUM'				=> '%sVissza a legutóbb látogatott fórumhoz %s',
	'RETURN_PAGE'				=> '%sVissza az előző oldalra%s',
	'RETURN_TOPIC'				=> '%sVissza a legutóbb látogatott témához%s',
	'RETURN_TO'					=> 'Vissza:',
	'FEED'						=> 'Csatorna',
	'FEED_NEWS'					=> 'Hírek',
	'FEED_TOPICS_ACTIVE'		=> 'Aktív témák',
	'FEED_TOPICS_NEW'			=> 'Új témák',
	'RULES_ATTACH_CAN'			=> '<strong>Küldhetsz</strong> csatolmányokat ebben a fórumban.',
	'RULES_ATTACH_CANNOT'		=> '<strong>Nem</strong> küldhetsz csatolmányokat ebben a fórumban.',
	'RULES_DELETE_CAN'			=> '<strong>Törölheted</strong> a hozzászólásaidat ebben a fórumban.',
	'RULES_DELETE_CANNOT'		=> '<strong>Nem</strong> törölheted a hozzászólásaidat ebben a fórumban.',
	'RULES_DOWNLOAD_CAN'		=> '<strong>Letöltheted</strong> a csatolmányokat ebben a fórumban.',
	'RULES_DOWNLOAD_CANNOT'		=> '<strong>Nem</strong> töltheted le a csatolmányokat ebben a fórumban.',
	'RULES_EDIT_CAN'			=> '<strong>Szerkesztheted</strong> a hozzászólásaidat ebben a fórumban.',
	'RULES_EDIT_CANNOT'			=> '<strong>Nem</strong> szerkesztheted a hozzászólásaidat ebben a fórumban.',
	'RULES_LOCK_CAN'			=> '<strong>Lezárhatod</strong> a témáidat ebben a fórumban.',
	'RULES_LOCK_CANNOT'			=> '<strong>Nem</strong> zárhatod le a témáidat ebben a fórumban.',
	'RULES_POST_CAN'			=> '<strong>Nyithatsz</strong> új témákat ebben a fórumban.',
	'RULES_POST_CANNOT'			=> '<strong>Nem</strong> nyithatsz témákat ebben a fórumban.',
	'RULES_REPLY_CAN'			=> '<strong>Válaszolhatsz</strong> egy témára ebben a fórumban.',
	'RULES_REPLY_CANNOT'		=> '<strong>Nem</strong> válaszolhatsz egy témára ebben a fórumban.',
	'RULES_VOTE_CAN'			=> '<strong>Szavazhatsz</strong> ebben a fórumban.',
	'RULES_VOTE_CANNOT'			=> '<strong>Nem</strong> szavazhatsz ebben a fórumban.',

	'SEARCH'					=> 'Keresés',
	'SEARCH_MINI'				=> 'Keresés…',
	'SEARCH_ADV'				=> 'Részletes keresés',
	'SEARCH_ADV_EXPLAIN'		=> 'Részletes keresés beállításainak megtekintése',
	'SEARCH_KEYWORDS'			=> 'Kulcsszavak',
	'SEARCHING_FORUMS'			=> 'Fórumok keresése',
	'SEARCH_ACTIVE_TOPICS'		=> 'Aktív témák',
	'SEARCH_FOR'				=> 'Keresés',
	'SEARCH_FORUM'				=> 'Keresés a fórumban…',
	'SEARCH_NEW'				=> 'Új hozzászólások',
	'SEARCH_POSTS_BY'			=> 'Hozzászólások keresése:',
	'SEARCH_SELF'				=> 'Saját hozzászólásaim',
	'SEARCH_TOPIC'				=> 'Keresés a témában…',
	'SEARCH_UNANSWERED'			=> 'Megválaszolatlan hozzászólások',
	'SEARCH_UNREAD'				=> 'Olvasatlan hozzászólások megtekintése',
	'SEARCH_USER_POSTS'			=> 'Felhasználó hozzászólásainak megtekintése',
	'SECONDS'					=> 'másodperc',
	'SELECT'					=> 'Kiválasztás',
	'SELECT_ALL'				=> 'Összes kiválasztása',
	'SELECT_ALL_CODE'			=> 'Egész kijelölése',
	'SELECT_DESTINATION_FORUM'	=> 'Célfórum kiválasztása',
	'SELECT_FORUM'				=> 'Fórum kiválasztása',
	'SEND_EMAIL'				=> 'E-mail küldése',				// Used for submit buttons
 	'SEND_EMAIL_USER'			=> 'E-mail küldése:',				// Used as: {L_SEND_EMAIL_USER} {USERNAME} -> E-mail UserX
	'SEND_PRIVATE_MESSAGE'		=> 'Privát üzenet küldése',
	'SETTINGS'					=> 'Beállítások',
	'SIGNATURE'					=> 'Aláírás',
	'SKIP'						=> 'Ugrás a tartalomhoz',
	'SMTP_NO_AUTH_SUPPORT'		=> 'Az SMTP szerver nem támogatja az azonosítás funkciót.',
	'SORRY_AUTH_READ'			=> 'Nincs jogosultságod a fórum megtekintéséhez.',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'Nincs jogosultságod a csatolmány letöltéséhez.',
	'SORT_BY'					=> 'Rendezés',
	'SORT_JOINED'				=> 'Csatlakozás dátuma',
	'SORT_LOCATION'				=> 'Tartózkodási hely',
	'SORT_RANK'					=> 'Rang',
	'SORT_POSTS'				=> 'Hozzászólások',
	'SORT_TOPIC_TITLE'			=> 'Téma címe',
	'SORT_USERNAME'				=> 'Felhasználónév',
	'SPLIT_TOPIC'				=> 'Téma szétválasztása',
	'SQL_ERROR_OCCURRED'		=> 'SQL hiba lépett fel az oldal generálása közben. Ha a probléma továbbra is fennállna, lépj kapcsolatba a %sfórum adminisztrátorával%s.',
	'STATISTICS'				=> 'Statisztika',
	'START_WATCHING_FORUM'		=> 'Feliratkozás a fórumra',
	'START_WATCHING_TOPIC'		=> 'Feliratkozás a témára',
	'STOP_WATCHING_FORUM'		=> 'Leiratkozás a fórumról',
	'STOP_WATCHING_TOPIC'		=> 'Leiratkozás a témáról',
	'SUBFORUM'					=> 'Alfórum',
	'SUBFORUMS'					=> 'Alfórumok',
	'SUBJECT'					=> 'Téma',
	'SUBMIT'					=> 'Elküld',

	'TERMS_USE'			=> 'Használati feltételek',
	'TEST_CONNECTION'	=> 'Kapcsolat tesztelése',
	'THE_TEAM'			=> 'A csapat',
	'TIME'				=> 'Idő',

	'TOO_LARGE'						=> 'A megadott érték túl nagy.',
	'TOO_LARGE_MAX_RECIPIENTS'		=> 'Az <strong>Engedélyezett címzettek maximum száma</strong> beállításnak megadott érték túl nagy.',

	'TOO_LONG'						=> 'A megadott érték túl hosszú.',

	'TOO_LONG_AIM'					=> 'A megadott AIM azonosító túl hosszú.',
	'TOO_LONG_CONFIRM_CODE'			=> 'A megadott megerősítő kód túl hosszú.',
	'TOO_LONG_DATEFORMAT'			=> 'A megadott dátum formátum túl hosszú.',
	'TOO_LONG_ICQ'					=> 'A megadott ICQ azonosító túl hosszú.',
	'TOO_LONG_INTERESTS'			=> 'A megadott érdeklődési kör túl hosszú.',
	'TOO_LONG_JABBER'				=> 'A megadott Jabber azonosító túl hosszú.',
	'TOO_LONG_LOCATION'				=> 'A megadott tartózkodási hely túl hosszú.',
	'TOO_LONG_MSN'					=> 'A megadott MSNM/WLM azonosító túl hosszú.',
	'TOO_LONG_NEW_PASSWORD'			=> 'A megadott jelszó túl hosszú.',
	'TOO_LONG_OCCUPATION'			=> 'A megadott foglalkozás túl hosszú.',
	'TOO_LONG_PASSWORD_CONFIRM'		=> 'A megadott jelszó megerősítés túl hosszú.',
	'TOO_LONG_USER_PASSWORD'		=> 'A megadott jelszó túl hosszú.',
	'TOO_LONG_USERNAME'				=> 'A megadott felhasználónév túl hosszú.',
	'TOO_LONG_EMAIL'				=> 'A megadott e-mail cím túl hosszú.',
	'TOO_LONG_EMAIL_CONFIRM'		=> 'A megadott e-mail cím megerősítés túl hosszú.',
	'TOO_LONG_WEBSITE'				=> 'A megadott honlap cím túl hosszú.',
	'TOO_LONG_YIM'					=> 'A megadott Yahoo! Messenger azonosító túl hosszú.',

	'TOO_MANY_VOTE_OPTIONS'			=> 'Túl sok lehetőségre próbáltál meg szavazni.',

	'TOO_SHORT'						=> 'A megadott érték túl rövid.',

	'TOO_SHORT_AIM'					=> 'A megadott AIM azonosító túl rövid.',
	'TOO_SHORT_CONFIRM_CODE'		=> 'A megadott megerősítő kód túl rövid.',
	'TOO_SHORT_DATEFORMAT'			=> 'A megadott dátum formátum túl rövid.',
	'TOO_SHORT_ICQ'					=> 'A megadott ICQ azonosító túl rövid.',
	'TOO_SHORT_INTERESTS'			=> 'A megadott érdeklődési kör túl rövid.',
	'TOO_SHORT_JABBER'				=> 'A megadott Jabber azonosító túl rövid.',
	'TOO_SHORT_LOCATION'			=> 'A megadott tartózkodási hely túl rövid.',
	'TOO_SHORT_MSN'					=> 'A megadott MSNM/WLM azonosító túl rövid.',
	'TOO_SHORT_NEW_PASSWORD'		=> 'A megadott jelszó túl rövid.',
	'TOO_SHORT_OCCUPATION'			=> 'A megadott foglalkozás túl rövid.',
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'A megadott jelszó megerősítés túl rövid.',
	'TOO_SHORT_USER_PASSWORD'		=> 'A megadott jelszó túl rövid.',
	'TOO_SHORT_USERNAME'			=> 'A megadott felhasználónév túl rövid.',
	'TOO_SHORT_EMAIL'				=> 'A megadott e-mail cím túl rövid.',
	'TOO_SHORT_EMAIL_CONFIRM'		=> 'A megadott e-mail cím megerősítés túl rövid.',
	'TOO_SHORT_WEBSITE'				=> 'A megadott honlap cím túl rövid.',
	'TOO_SHORT_YIM'					=> 'A megadott Yahoo! Messenger azonosító túl rövid.',

	'TOO_SMALL'						=> 'A megadott érték túl kicsi.',
	'TOO_SMALL_MAX_RECIPIENTS'		=> 'Az <strong>Engedélyezett címzettek maximum száma</strong> beállításnak megadott érték túl kicsi.',

	'TOPIC'				=> 'Téma',
	'TOPICS'			=> 'Témák',
	'TOPICS_UNAPPROVED'	=> 'A fórumban van legalább egy téma, amely még nem került jóváhagyásra.',
	'TOPIC_ICON'		=> 'Téma ikon',
	'TOPIC_LOCKED'		=> 'A témát lezárták, nem szerkesztheted a hozzászólásaid, és nem küldhetsz új hozzászólást.',
	'TOPIC_LOCKED_SHORT'=> 'Téma lezárva',
	'TOPIC_MOVED'		=> 'Áthelyezett téma',
	'TOPIC_REVIEW'		=> 'Téma áttekintése',
	'TOPIC_TITLE'		=> 'Téma címe',
	'TOPIC_UNAPPROVED'	=> 'Jóvá nem hagyott téma',
	'TOTAL_ATTACHMENTS'	=> 'Csatolmány(ok)',
	'TOTAL_LOG'			=> '1 bejegyzés',
	'TOTAL_LOGS'		=> '%d bejegyzés',
	'TOTAL_NO_PM'		=> 'Összesen 0 privát üzenet',
	'TOTAL_PM'			=> 'Összesen 1 privát üzenet',
	'TOTAL_PMS'			=> 'Összesen %d privát üzenet',
	'TOTAL_POSTS'		=> 'Hozzászólások száma',
	'TOTAL_POSTS_OTHER'	=> 'Hozzászólások száma: <strong>%d</strong>',
	'TOTAL_POSTS_ZERO'	=> 'Hozzászólások száma: <strong>0</strong>',
	'TOPIC_REPORTED'	=> 'Jelentett téma',
	'TOTAL_TOPICS_OTHER'=> 'Témák száma: <strong>%d</strong>',
	'TOTAL_TOPICS_ZERO'	=> 'Témák száma: <strong>0</strong>',
	'TOTAL_USERS_OTHER'	=> 'Felhasználók száma: <strong>%d</strong>',
	'TOTAL_USERS_ZERO'	=> 'Felhasználók száma: <strong>0</strong>',
	'TRACKED_PHP_ERROR'	=> 'PHP hibák: %s',

	'UNABLE_GET_IMAGE_SIZE'	=> 'Nem sikerült meghatározni a kép méretét.',
	'UNABLE_TO_DELIVER_FILE'=> 'Nem sikerült elküldeni az állományt.',
	'UNKNOWN_BROWSER'		=> 'Ismeretlen böngésző',
	'UNMARK_ALL'			=> 'Összes kijelölésének megszüntetése',
	'UNREAD_MESSAGES'		=> 'Olvasatlan üzenetek',
	'UNREAD_PM'				=> '<strong>%d</strong> olvasatlan üzenet',
	'UNREAD_PMS'			=> '<strong>%d</strong> olvasatlan üzenet',
	'UNREAD_POST'			=> 'Olvasatlan hozzászólás',
	'UNREAD_POSTS'			=> 'Olvasatlan hozzászólások',
	'UNWATCH_FORUM_CONFIRM'		=> 'Valóban le szeretnél iratkozni erről a fórumról?',
	'UNWATCH_FORUM_DETAILED'	=> 'Valóban le szeretnél iratkozni a(z) “%s” fórumról?',
	'UNWATCH_TOPIC_CONFIRM'		=> 'Valóban le szeretnél iratkozni erről a témáról?',
	'UNWATCH_TOPIC_DETAILED'	=> 'Valóban le szeretnél iratkozni a(z) “%s” témáról?',
	'UNWATCHED_FORUMS'			=> 'Sikeresen leiratkoztál a kiválasztott fórumokról.',
	'UNWATCHED_TOPICS'			=> 'Sikeresen leiratkoztál a kiválasztott témákról.',
	'UNWATCHED_FORUMS_TOPICS'	=> 'Sikeresen leiratkoztál a kiválasztott elemekről.',
	'UPDATE'				=> 'Frissítés',
	'UPLOAD_IN_PROGRESS'	=> 'Feltöltés folyamatban...',
	'URL_REDIRECT'			=> 'Ha a böngésződ nem támogatja a meta átirányítást, kattints %side%s.',
	'USERGROUPS'			=> 'Csoportok',
	'USERNAME'				=> 'Felhasználónév',
	'USERNAMES'				=> 'Felhasználónevek',
	'USER_AVATAR'			=> 'Avatar',
	'USER_CANNOT_READ'		=> 'Nincs jogosultságod a hozzászólások megtekintéséhez ebben a fórumban.',
	'USER_POST'				=> '%d hozzászólás',
	'USER_POSTS'			=> '%d hozzászólás',
	'USERS'					=> 'Felhasználók',
	'USE_PERMISSIONS'		=> 'Felhasználó jogosultságainak kipróbálása',
	'USER_NEW_PERMISSION_DISALLOWED'	=> 'Sajnáljuk, de nincs jogosultságod ezen funkció használatához. Még csak most regisztrálhattál, lehet hogy több aktivitást kell felmutatnod, hogy használhasd ezt a funkciót.',

	'VARIANT_DATE_SEPARATOR'	=> ' / ',	// Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
	'VIEWED'					=> 'Megtekintve',
	'VIEWING_FAQ'				=> 'GyIK megtekintése',
	'VIEWING_MEMBERS'			=> 'Taglista megtekintése',
	'VIEWING_ONLINE'			=> 'Jelenlévők listájának megtekintése',
	'VIEWING_MCP'				=> 'Moderátori vezérlőpult megtekintése',
	'VIEWING_PRIVATE_MESSAGES'	=> 'Privát üzenetek megtekintése',
	'VIEWING_REGISTER'			=> 'Regisztrálás a fórumra',
	'VIEWING_MEMBER_PROFILE'	=> 'Felhasználó profiljának megtekintése',
	'VIEWING_UCP'				=> 'Felhasználói vezérlőpult megtekintése',
	'VIEWS'						=> 'Megtekintve',
	'VIEW_BOOKMARKS'			=> 'Kedvencek megtekintése',
	'VIEW_FORUM_LOGS'			=> 'Napló megtekintése',
	'VIEW_LATEST_POST'			=> 'Utolsó hozzászólás megtekintése',
	'VIEW_NEWEST_POST'			=> 'Első olvasatlan hozzászólás megtekintése',
	'VIEW_NOTES'				=> 'Feljegyzések megtekintése',
	'VIEW_ONLINE_TIME'			=> 'Az elmúlt %d percben aktív felhasználók alapján.',
	'VIEW_ONLINE_TIMES'			=> 'Az elmúlt %d percben aktív felhasználók alapján.',
	'VIEW_TOPIC'				=> 'Téma megtekintése',
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'Közlemény: ',
	'VIEW_TOPIC_GLOBAL'			=> 'Általános közlemény: ',
	'VIEW_TOPIC_LOCKED'			=> 'Lezárva: ',
	'VIEW_TOPIC_LOGS'			=> 'Napló megtekintése',
	'VIEW_TOPIC_MOVED'			=> 'Áthelyezve: ',
	'VIEW_TOPIC_POLL'			=> 'Szavazás: ',
	'VIEW_TOPIC_STICKY'			=> 'Kiemelt: ',
	'VISIT_WEBSITE'				=> 'Honlap meglátogatása',

	'WARNINGS'			=> 'Figyelmeztetések',
	'WARN_USER'			=> 'Felhasználó figyelmeztetése',
	'WATCH_FORUM_CONFIRM'	=> 'Valóban fel szeretnél iratkozni erre a fórumra?',
	'WATCH_FORUM_DETAILED'	=> 'Valóban fel szeretnél iratkozni a(z) “%s” fórumra?',
	'WATCH_TOPIC_CONFIRM'	=> 'Valóban fel szeretnél iratkozni erre a témára?',
	'WATCH_TOPIC_DETAILED'	=> 'Valóban fel szeretnél iratkozni a(z) “%s” témára?',
	'WELCOME_SUBJECT'	=> 'Üdvözlünk a %s fórumán!',
	'WEBSITE'			=> 'Honlap',
	'WHOIS'				=> 'IP adatok',
	'WHO_IS_ONLINE'		=> 'Ki van itt',
	'WRONG_PASSWORD'	=> 'Hibás jelszót adtál meg.',

	'WRONG_DATA_ICQ'			=> 'A megadott ICQ azonosító hibás.',
	'WRONG_DATA_JABBER'			=> 'A megadott Jabber azonosító hibás.',
	'WRONG_DATA_LANG'			=> 'A megadott nyelv hibás.',
	'WRONG_DATA_WEBSITE'		=> 'A honlap címének egy rendes URL-nek kell lennie (a protokollal együtt). Például: http://www.pelda.hu/.',
 	'WROTE'						=> 'írta',

	'YEAR'				=> 'év',
	'YEAR_MONTH_DAY'	=> '(ÉÉÉÉ-HH-NN)',
	'YES'				=> 'Igen',
	'YIM'				=> 'YIM',
	'YOU_LAST_VISIT'	=> 'Utolsó látogatás: %s',
	'YOU_NEW_PM'		=> 'Új privát üzeneted érkezett.',
	'YOU_NEW_PMS'		=> 'Új privát üzeneteid érkeztek.',
	'YOU_NO_NEW_PM'		=> 'Nincs új privát üzeneted.',

	'datetime'			=> array(
		'TODAY'		=> 'Ma, ',
		'TOMORROW'	=> 'Holnap, ',
		'YESTERDAY'	=> 'Tegnap, ',
		'AGO'		=> array(
			0		=> 'kevesebb mint egy perce',
			1		=> '%d perccel ezelőtt',
			60		=> '1 órával ezelőt',
		),

		'Sunday'	=> 'vasárnap',
		'Monday'	=> 'hétfő',
		'Tuesday'	=> 'kedd',
		'Wednesday'	=> 'szerda',
		'Thursday'	=> 'csütörtök',
		'Friday'	=> 'péntek',
		'Saturday'	=> 'szombat',

		'Sun'		=> 'vas.',
		'Mon'		=> 'hétf.',
		'Tue'		=> 'kedd',
		'Wed'		=> 'szer.',
		'Thu'		=> 'csüt.',
		'Fri'		=> 'pén.',
		'Sat'		=> 'szomb.',

		'January'	=> 'január',
		'February'	=> 'február',
		'March'		=> 'március',
		'April'		=> 'április',
		'May'		=> 'május',
		'June'		=> 'június',
		'July'		=> 'július',
		'August'	=> 'augusztus',
		'September' => 'szeptember',
		'October'	=> 'október',
		'November'	=> 'november',
		'December'	=> 'december',

		'Jan'		=> 'jan.',
		'Feb'		=> 'feb.',
		'Mar'		=> 'márc.',
		'Apr'		=> 'ápr.',
		'May_short'	=> 'máj.',	// Short representation of "May". May_short used because in English the short and long date are the same for May.
		'Jun'		=> 'jún.',
		'Jul'		=> 'júl.',
		'Aug'		=> 'aug.',
		'Sep'		=> 'szept.',
		'Oct'		=> 'okt.',
		'Nov'		=> 'nov.',
		'Dec'		=> 'dec.',
	),

	'tz'				=> array(
		'-12'	=> 'UTC − 12 óra',
		'-11'	=> 'UTC − 11 óra',
		'-10'	=> 'UTC − 10 óra',
		'-9.5'	=> 'UTC − 9,5 óra',
		'-9'	=> 'UTC − 9 óra',
		'-8'	=> 'UTC − 8 óra',
		'-7'	=> 'UTC − 7 óra',
		'-6'	=> 'UTC − 6 óra',
		'-5'	=> 'UTC − 5 óra',
		'-4.5'	=> 'UTC − 4,5 óra',
		'-4'	=> 'UTC − 4 óra',
		'-3.5'	=> 'UTC − 3,5 óra',
		'-3'	=> 'UTC − 3 óra',
		'-2'	=> 'UTC − 2 óra',
		'-1'	=> 'UTC − 1 óra',
		'0'		=> 'UTC',
		'1'		=> 'UTC + 1 óra',
		'2'		=> 'UTC + 2 óra',
		'3'		=> 'UTC + 3 óra',
		'3.5'	=> 'UTC + 3,5 óra',
		'4'		=> 'UTC + 4 óra',
		'4.5'	=> 'UTC + 4,5 óra',
		'5'		=> 'UTC + 5 óra',
		'5.5'	=> 'UTC + 5,5 óra',
		'5.75'	=> 'UTC + 5,75 óra',
		'6'		=> 'UTC + 6 óra',
		'6.5'	=> 'UTC + 6,5 óra',
		'7'		=> 'UTC + 7 óra',
		'8'		=> 'UTC + 8 óra',
		'8.75'	=> 'UTC + 8,75 óra',
		'9'		=> 'UTC + 9 óra',
		'9.5'	=> 'UTC + 9,5 óra',
		'10'	=> 'UTC + 10 óra',
		'10.5'	=> 'UTC + 10:30 óra',
		'11'	=> 'UTC + 11 óra',
		'11.5'	=> 'UTC + 11:30 óra',
		'12'	=> 'UTC + 12 óra',
		'12.75'	=> 'UTC + 12,75 óra',
		'13'	=> 'UTC + 13 óra',
		'14'	=> 'UTC + 14 óra',
		'dst'	=> '[ <abbr title="nyári időszámítás">nyi</abbr> ]',
	),

	'tz_zones'	=> array(
		'-12'	=> '[UTC − 12] Baker-szigeti idő',
		'-11'	=> '[UTC − 11] niue-i idő, szamoai zónaidő',
		'-10'	=> '[UTC − 10] hawaii-aleuti zónaidő, Cook-szigeteki idő',
		'-9.5'	=> '[UTC − 9,5] Marquise-szigeteki idő',
		'-9'	=> '[UTC − 9] alaszkai zónaidő, Gambier-szigeteki idő',
		'-8'	=> '[UTC − 8] csendes-óceáni zónaidő',
		'-7'	=> '[UTC − 7] sziklás-hegységi zónaidő',
		'-6'	=> '[UTC − 6] közép zónaidő',
		'-5'	=> '[UTC − 5] keleti zónaidő',
		'-4.5'	=> '[UTC − 4,5] venezuelai zónaidő',
		'-4'	=> '[UTC − 4] atlanti zónaidő',
		'-3.5'	=> '[UTC − 3,5] újfundlandi zónaidő',
		'-3'	=> '[UTC − 3] amazoni zónaidő, közép-grönlandi idő',
		'-2'	=> '[UTC − 2] Fernando de Noronha-i, dél-georgiai és dél-szendvics-szigeteki idő',
		'-1'	=> '[UTC − 1] azori-szigeteki zónaidő, zöld-foki-szigeteki idő, kelet-grönlandi idő',
		'0'		=> '[UTC] nyugat-európai idő, greenwichi középidő',
		'1'		=> '[UTC + 1] közép-európai idő, nyugat-afrikai idő',
		'2'		=> '[UTC + 2] kelet-európai idő, közép-afrikai idő',
		'3'		=> '[UTC + 3] moszkvai zónaidő, kelet-afrikai idő',
		'3.5'	=> '[UTC + 3,5] iráni zónaidő',
		'4'		=> '[UTC + 4] gulfi zónaidő, szamarai zónaidő',
		'4.5'	=> '[UTC + 4:30] afganisztáni idő',
		'5'		=> '[UTC + 5] pakisztáni zónaidő, yekaterinburgi zónaidő',
		'5.5'	=> '[UTC + 5,5] indiai zónaidő, Sri Lanka-i idő',
		'5.75'	=> '[UTC + 5,75] nepáli idő',
		'6'		=> '[UTC + 6] bangladesi idő, bhutáni idő, novoszibirszki zónaidő',
		'6.5'	=> '[UTC + 6,5] kókusz-szigeteki idő, myanmari idő',
		'7'		=> '[UTC + 7] indokínai idő, krasznojarszki zónaidő',
		'8'		=> '[UTC + 8] kínai zónaidő, nyugat-ausztráliai zónaidő, irkutszki zónaidő',
		'8.75'	=> '[UTC + 8,75] délkelet-nyugat-ausztráliai zónaidő',
		'9'		=> '[UTC + 9] japán zónaidő, koreai zónaidő, csitai zónaidő',
		'9.5'	=> '[UTC + 9,5] közép-ausztráliai zónaidő',
		'10'	=> '[UTC + 10] kelet-ausztráliai zónaidő, vlagyivosztoki zónaidő',
		'10.5'	=> '[UTC + 10,5] Lord Howe-i zónaidő',
		'11'	=> '[UTC + 11] Salamon-szigeteki idő, magadáni zónaidő',
		'11.5'	=> '[UTC + 11,5] Norfolk-szigeti idő',
		'12'	=> '[UTC + 12] új-zélandi idő, Fidzsi-szigeteki idő, kamcsatkai zónaidő',
		'12.75'	=> '[UTC + 12,75] Chatham-szigeteki idő',
		'13'	=> '[UTC + 13] tongai idő, Phoenix-szigeteki idő',
		'14'	=> '[UTC + 14] Line-szigeti idő',
	),

	// The value is only an example and will get replaced by the current time on view
	'dateformats'	=> array(
		'|Y.m.d.| H:i'			=> '2007.01.01. 13:37 [Relatív napok]',
		'Y.m.d. H:i'			=> '2007.01.01. 13:37',
		'|Y.m.d., D| H:i'		=> '2007.01.01. szer., 13:37 [Relatív napok]',
		'|Y. M j.| G:i'			=> '2007. jan. 1. 13:37 [Relatív napok]',
		'|Y. F j.| G:i'			=> '2007. január 1. 13:37 [Relatív napok]',
		'|Y. M j., D| G:i'		=> '2007. jan. 1., szer. 13:37 [Relatív napok]',
		'|Y. F j., l| G:i'		=> '2007. január 1., szerda 13:37 [Relatív napok]',
	),

	// The default dateformat which will be used on new installs in this language
	// Translators should change this if a the usual date format is different
	'default_dateformat'	=> '|Y.m.d.| H:i',

));

?>
