#include "playlist.hh"
#include "song.hh"
#include <algorithm>
#include <random>

void PlayList::addSong(std::shared_ptr<Song> song) {
	std::lock_guard<std::mutex> l(m_mutex);
	m_list.push_back(song);
}

std::shared_ptr<Song> PlayList::getNext() {
	std::lock_guard<std::mutex> l(m_mutex);
	if (isEmpty()) return std::shared_ptr<Song>();
	std::shared_ptr<Song> nextSong;
	nextSong = m_list[0];
	m_list.erase(m_list.begin());
	currentlyActive = nextSong;
	return nextSong;
}

PlayList::SongList& PlayList::getList() {
	return m_list;
}


bool PlayList::isEmpty() {
	return m_list.empty();
}

void PlayList::shuffle() {
	std::lock_guard<std::mutex> l(m_mutex);
	std::shuffle(m_list.begin(), m_list.end(), std::mt19937(std::random_device()()));
}

void PlayList::clear() {
	std::lock_guard<std::mutex> l(m_mutex);
	m_list.clear();
}

void PlayList::removeSong(unsigned index) {
	std::lock_guard<std::mutex> l(m_mutex);
	m_list.erase(m_list.begin() + index);
}
void PlayList::swap(unsigned index1, unsigned index2) {
	std::lock_guard<std::mutex> l(m_mutex);
	std::shared_ptr<Song> song1 = m_list[index1];
	m_list[index1] = m_list[index2];
	m_list[index2] = song1;
}
void PlayList::move(unsigned fromIndex, unsigned toIndex)
{
	std::lock_guard<std::mutex> l(m_mutex);
	if (fromIndex > toIndex)
	{
		std::rotate(m_list.rend() - fromIndex - 1, m_list.rend() - fromIndex, m_list.rend() - toIndex);
	}
	else 
	{
		std::rotate(m_list.begin() + fromIndex, m_list.begin() + fromIndex + 1, m_list.begin() + toIndex + 1);
	}
}

std::shared_ptr<Song> PlayList::getSong(unsigned index) {
	std::lock_guard<std::mutex> l(m_mutex);
	if (isEmpty()) return std::shared_ptr<Song>();
	std::shared_ptr<Song> nextSong;
	nextSong = m_list[index];
	m_list.erase(m_list.begin() + index);
	currentlyActive = nextSong;
	return nextSong;
}
