/*
Copyright (C) 2010 Srivats P.

This file is part of "Ostinato"

This is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

#ifndef _SNAP_H
#define _SNAP_H

#include "abstractprotocol.h"

#include "snap.pb.h"
#include "ui_snap.h"

class SnapConfigForm : public QWidget, public Ui::snap
{
    Q_OBJECT
public:
    SnapConfigForm(QWidget *parent = 0);
};

class SnapProtocol : public AbstractProtocol
{
private:
    OstProto::Snap    data;
    SnapConfigForm    *configForm;
    enum snapfield
    {
        snap_oui = 0,
        snap_type,

        // Meta fields
        snap_is_override_oui,
        snap_is_override_type,

        snap_fieldCount
    };

public:
    SnapProtocol(StreamBase *stream, AbstractProtocol *parent = 0);
    virtual ~SnapProtocol();

    static AbstractProtocol* createInstance(StreamBase *stream,
        AbstractProtocol *parent = 0);
    virtual quint32 protocolNumber() const;

    virtual void protoDataCopyInto(OstProto::Protocol &protocol) const;
    virtual void protoDataCopyFrom(const OstProto::Protocol &protocol);

    virtual QString name() const;
    virtual QString shortName() const;

    virtual ProtocolIdType protocolIdType() const;
    virtual quint32 protocolId(ProtocolIdType type) const;

    virtual int fieldCount() const;

    virtual AbstractProtocol::FieldFlags fieldFlags(int index) const;
    virtual QVariant fieldData(int index, FieldAttrib attrib,
               int streamIndex = 0) const;
    virtual bool setFieldData(int index, const QVariant &value, 
            FieldAttrib attrib = FieldValue);

    virtual QWidget* configWidget();
    virtual void loadConfigWidget();
    virtual void storeConfigWidget();
};

#endif
