# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-5773 (ocsinventory)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64105);
 script_cve_id("CVE-2009-1769");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Fedora Core 10 FEDORA-2009-5773 (ocsinventory)";
 script_name(name);

 desc = "The remote host is missing an update to ocsinventory
announced via advisory FEDORA-2009-5773.

Update Information:

2 Security fixes
- CVE-2009-1769 OCS Inventory NG: Authentication result varies
  for existent and non-existent users
- SQL injection and Unauthenticated Arbitrary File Read
   Some Other minor bug fixes
http://www.ocsinventory-ng.org/index.php?mact=News,cntnt01,detail,0&cntnt01articleid=140&cntnt01returnid=64

ChangeLog:

* Sat May 30 2009 Remi Collet  1.02.1-1
- update to OCS Inventory NG 1.02.1 - Security Fixes (internal version 5003)

References:

[ 1 ] Bug #502250 - CVE-2009-1769 OCS Inventory NG: Authentication result varies for existent and non-existent users
https://bugzilla.redhat.com/show_bug.cgi?id=502250

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update ocsinventory' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-5773

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-5773 (ocsinventory)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"ocsinventory", rpm:"ocsinventory~1.02.1~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ocsinventory-reports", rpm:"ocsinventory-reports~1.02.1~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ocsinventory-server", rpm:"ocsinventory-server~1.02.1~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
