/*
 *  Copyright (c) 2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "ShapeBrush_p.h"

#include <cmath>

#include <GTLCore/AbstractImage.h>
#include <GTLCore/Color.h>
#include <GTLCore/Debug.h>

#include <OpenRijn/DrawingPoint.h>

#include "Canvas.h"
#include "ShapeGenerator_p.h"

using namespace OpenRijn;
using namespace OpenRijn::ImageEngine;

struct ShapeBrush::Private {
  AbstractShapeGenerator* generator;
};

ShapeBrush::ShapeBrush(AbstractShapeGenerator* _generator) : d(new Private)
{
  d->generator = _generator;
}

ShapeBrush::~ShapeBrush()
{
  delete d;
}

float ShapeBrush::drawPoint( AbstractCanvas* _canvas, const DrawingPoint& pt)
{
  // Read the color
  float color[3];
  color[0] = paintColor().red();
  color[1] = paintColor().green();
  color[2] = paintColor().blue();
  float opacity = paintColor().alpha();
  
  // Init the drawing
  Canvas* canvas = static_cast<Canvas*>(_canvas);
  
  int radius = int(floor(d->generator->radius()));
  
  int x_i = pt.x;
  int y_i = pt.y;
  float x_f_r = - pt.x;
  float y_f_r = - pt.y;
  
  // Draw
  for(int x = x_i - radius; x < x_i + radius; ++x)
  {
    for(int y = y_i - radius; y < y_i + radius; ++y)
    {
      float coef = d->generator->valueAt(x + x_f_r, y + y_f_r);
      if(coef != 0.0)
      {
        float* pixel = canvas->image()->data<float>(x, y);
        float colorOpacity = coef * opacity;
        float newAlpha = pixel[3] * (1.0 - colorOpacity) + colorOpacity;
        float blend = colorOpacity / newAlpha;
        for(int k = 0; k < 3; ++k)
        {
          pixel[k] += (color[k] - pixel[k]) * blend;
        }
        pixel[3] = newAlpha;
      }
    }
  }
  
  return 0.1 * d->generator->radius();
}
