/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.turbine.util.Log;

class Main {
    private static final String MAIN_CLASS = "org.apache.avalon.phoenix.frontends.CLIMain";
    private static final String LOADER_JAR = "phoenix-loader.jar";
    private static Object c_frontend;
    static /* synthetic */ Class class$java$util$Map;

    Main() {
    }

    protected static final int startup(String[] args, Map data, boolean blocking) throws Exception {
        int exitCode;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            data.put("common.classloader", classLoader);
            data.put("container.classloader", classLoader);
            data.put("phoenix.home", new File(Main.findPhoenixHome()));
            Class<?> clazz = classLoader.loadClass(MAIN_CLASS);
            Class[] paramTypes = new Class[]{args.getClass(), class$java$util$Map == null ? (class$java$util$Map = Main.class$("java.util.Map")) : class$java$util$Map, Boolean.TYPE};
            Method method = clazz.getMethod("main", paramTypes);
            c_frontend = clazz.newInstance();
            Integer integer = (Integer)method.invoke(c_frontend, args, data, new Boolean(blocking));
            exitCode = integer;
        }
        catch (Exception e) {
            Log.warn("chef", "BasicJamesService.startup()", (Throwable)e);
            exitCode = 1;
        }
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void shutdown() {
        if (null == c_frontend) {
            return;
        }
        try {
            try {
                Class<?> clazz = c_frontend.getClass();
                Method method = clazz.getMethod("shutdown", new Class[0]);
                method.invoke(c_frontend, new Object[0]);
            }
            catch (Exception e) {
                Log.warn("chef", "BasicJamesService.Main.shutdown():", (Throwable)e);
                Object var3_4 = null;
                c_frontend = null;
            }
            Object var3_3 = null;
            c_frontend = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            c_frontend = null;
            throw throwable;
        }
    }

    private static URL[] getEngineClassPath() throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        File dir = Main.findEngineLibDir();
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.getName().endsWith(".jar")) {
                urls.add(file.toURL());
            }
            ++i;
        }
        File dir_p = Main.findPhoenixLibDir();
        File[] files_p = dir_p.listFiles();
        int i2 = 0;
        while (i2 < files_p.length) {
            File file = files_p[i2];
            if (file.getName().endsWith(".jar")) {
                urls.add(file.toURL());
            }
            ++i2;
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static File findEngineLibDir() throws Exception {
        String phoenixHome = Main.findPhoenixHome();
        String engineLibDir = phoenixHome + File.separator + "bin" + File.separator + "lib";
        File dir = new File(engineLibDir).getCanonicalFile();
        if (!dir.exists()) {
            throw new Exception("Unable to locate engine lib directory at " + engineLibDir);
        }
        return dir;
    }

    private static File findPhoenixLibDir() throws Exception {
        String phoenixHome = Main.findPhoenixHome();
        String engineLibDir = phoenixHome + File.separator + "lib";
        File dir = new File(engineLibDir).getCanonicalFile();
        if (!dir.exists()) {
            throw new Exception("Unable to locate engine lib directory at " + engineLibDir);
        }
        return dir;
    }

    private static String findPhoenixHome() throws Exception {
        String phoenixHome = System.getProperty("phoenix.home", null);
        if (null == phoenixHome) {
            File loaderDir = Main.findLoaderDir();
            phoenixHome = loaderDir.getAbsoluteFile().getParentFile() + File.separator;
        }
        phoenixHome = new File(phoenixHome).getCanonicalFile().toString();
        System.setProperty("phoenix.home", phoenixHome);
        return phoenixHome;
    }

    private static final File findLoaderDir() throws Exception {
        String classpath = System.getProperty("java.class.path");
        String pathSeparator = System.getProperty("path.separator");
        StringTokenizer tokenizer = new StringTokenizer(classpath, pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String element = tokenizer.nextToken();
            if (!element.endsWith(LOADER_JAR)) continue;
            File file = new File(element).getCanonicalFile();
            file = file.getParentFile();
            return file;
        }
        throw new Exception("Unable to locate phoenix-loader.jar in classpath");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        MAIN_CLASS = MAIN_CLASS;
        LOADER_JAR = LOADER_JAR;
    }

    private static class FreeNEasyPolicy
    extends Policy {
        private FreeNEasyPolicy() {
        }

        public PermissionCollection getPermissions(CodeSource codeSource) {
            Permissions permissions = new Permissions();
            permissions.add(new AllPermission());
            return permissions;
        }

        public void refresh() {
        }
    }
}

