/*
 *  nextpnr -- Next Generation Place and Route
 *
 *  Copyright (C) 2018  gatecat <gatecat@ds0.me>
 *
 *  Permission to use, copy, modify, and/or distribute this software for any
 *  purpose with or without fee is hereby granted, provided that the above
 *  copyright notice and this permission notice appear in all copies.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 *  WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 *  ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 *  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 *  ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 *  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#ifndef ECP5_GFX_H
#define ECP5_GFX_H

#include "nextpnr.h"

NEXTPNR_NAMESPACE_BEGIN

const float switchbox_x1 = 0.51;
const float switchbox_x2 = 0.90;
const float switchbox_y1 = 0.51;
const float switchbox_y2 = 0.90;

enum GfxTileWireId
{
    TILE_WIRE_NONE,

    TILE_WIRE_FCO_SLICE,
    TILE_WIRE_D7_SLICE,
    TILE_WIRE_C7_SLICE,
    TILE_WIRE_B7_SLICE,
    TILE_WIRE_A7_SLICE,
    TILE_WIRE_D6_SLICE,
    TILE_WIRE_C6_SLICE,
    TILE_WIRE_B6_SLICE,
    TILE_WIRE_A6_SLICE,
    TILE_WIRE_DI7_SLICE,
    TILE_WIRE_DI6_SLICE,
    TILE_WIRE_M7_SLICE,
    TILE_WIRE_M6_SLICE,
    TILE_WIRE_FXBD_SLICE,
    TILE_WIRE_FXAD_SLICE,
    TILE_WIRE_DUMMY_D1,
    TILE_WIRE_FXD_SLICE,
    TILE_WIRE_F7_SLICE,
    TILE_WIRE_Q7_SLICE,
    TILE_WIRE_Q6_SLICE,
    TILE_WIRE_F6_SLICE,
    TILE_WIRE_F5D_SLICE,
    TILE_WIRE_CE3_SLICE,
    TILE_WIRE_FCID_SLICE,

    TILE_WIRE_FCOC_SLICE,
    TILE_WIRE_D5_SLICE,
    TILE_WIRE_C5_SLICE,
    TILE_WIRE_B5_SLICE,
    TILE_WIRE_A5_SLICE,
    TILE_WIRE_D4_SLICE,
    TILE_WIRE_C4_SLICE,
    TILE_WIRE_B4_SLICE,
    TILE_WIRE_A4_SLICE,
    TILE_WIRE_DI5_SLICE,
    TILE_WIRE_DI4_SLICE,
    TILE_WIRE_M5_SLICE,
    TILE_WIRE_M4_SLICE,
    TILE_WIRE_FXBC_SLICE,
    TILE_WIRE_FXAC_SLICE,
    TILE_WIRE_DUMMY_C1,
    TILE_WIRE_FXC_SLICE,
    TILE_WIRE_F5_SLICE,
    TILE_WIRE_Q5_SLICE,
    TILE_WIRE_Q4_SLICE,
    TILE_WIRE_F4_SLICE,
    TILE_WIRE_F5C_SLICE,
    TILE_WIRE_CE2_SLICE,
    TILE_WIRE_FCIC_SLICE,

    TILE_WIRE_FCOB_SLICE,
    TILE_WIRE_D3_SLICE,
    TILE_WIRE_C3_SLICE,
    TILE_WIRE_B3_SLICE,
    TILE_WIRE_A3_SLICE,
    TILE_WIRE_D2_SLICE,
    TILE_WIRE_C2_SLICE,
    TILE_WIRE_B2_SLICE,
    TILE_WIRE_A2_SLICE,
    TILE_WIRE_DI3_SLICE,
    TILE_WIRE_DI2_SLICE,
    TILE_WIRE_M3_SLICE,
    TILE_WIRE_M2_SLICE,
    TILE_WIRE_FXBB_SLICE,
    TILE_WIRE_FXAB_SLICE,
    TILE_WIRE_DUMMY_B1,
    TILE_WIRE_FXB_SLICE,
    TILE_WIRE_F3_SLICE,
    TILE_WIRE_Q3_SLICE,
    TILE_WIRE_Q2_SLICE,
    TILE_WIRE_F2_SLICE,
    TILE_WIRE_F5B_SLICE,
    TILE_WIRE_CE1_SLICE,
    TILE_WIRE_FCIB_SLICE,

    TILE_WIRE_FCOA_SLICE,
    TILE_WIRE_D1_SLICE,
    TILE_WIRE_C1_SLICE,
    TILE_WIRE_B1_SLICE,
    TILE_WIRE_A1_SLICE,
    TILE_WIRE_D0_SLICE,
    TILE_WIRE_C0_SLICE,
    TILE_WIRE_B0_SLICE,
    TILE_WIRE_A0_SLICE,
    TILE_WIRE_DI1_SLICE,
    TILE_WIRE_DI0_SLICE,
    TILE_WIRE_M1_SLICE,
    TILE_WIRE_M0_SLICE,
    TILE_WIRE_FXBA_SLICE,
    TILE_WIRE_FXAA_SLICE,
    TILE_WIRE_DUMMY_A1,
    TILE_WIRE_FXA_SLICE,
    TILE_WIRE_F1_SLICE,
    TILE_WIRE_Q1_SLICE,
    TILE_WIRE_Q0_SLICE,
    TILE_WIRE_F0_SLICE,
    TILE_WIRE_F5A_SLICE,
    TILE_WIRE_CE0_SLICE,
    TILE_WIRE_FCI_SLICE,

    TILE_WIRE_CLK0,
    TILE_WIRE_CLK1,
    TILE_WIRE_LSR0,
    TILE_WIRE_LSR1,

    TILE_WIRE_FCO,
    TILE_WIRE_D7,
    TILE_WIRE_C7,
    TILE_WIRE_B7,
    TILE_WIRE_A7,
    TILE_WIRE_D6,
    TILE_WIRE_C6,
    TILE_WIRE_B6,
    TILE_WIRE_A6,
    TILE_WIRE_DI7,
    TILE_WIRE_DI6,
    TILE_WIRE_M7,
    TILE_WIRE_M6,
    TILE_WIRE_FXBD,
    TILE_WIRE_FXAD,
    TILE_WIRE_DUMMY_SWB1,
    TILE_WIRE_DUMMY_SWB2,
    TILE_WIRE_F7,
    TILE_WIRE_Q7,
    TILE_WIRE_Q6,
    TILE_WIRE_F6,
    TILE_WIRE_DUMMY_SWB3,
    TILE_WIRE_CE3,
    TILE_WIRE_DUMMY_SWB4,

    TILE_WIRE_DUMMY_SWB5,
    TILE_WIRE_D5,
    TILE_WIRE_C5,
    TILE_WIRE_B5,
    TILE_WIRE_A5,
    TILE_WIRE_D4,
    TILE_WIRE_C4,
    TILE_WIRE_B4,
    TILE_WIRE_A4,
    TILE_WIRE_DI5,
    TILE_WIRE_DI4,
    TILE_WIRE_M5,
    TILE_WIRE_M4,
    TILE_WIRE_FXBC,
    TILE_WIRE_FXAC,
    TILE_WIRE_DUMMY_SWB6,
    TILE_WIRE_DUMMY_SWB7,
    TILE_WIRE_F5,
    TILE_WIRE_Q5,
    TILE_WIRE_Q4,
    TILE_WIRE_F4,
    TILE_WIRE_DUMMY_SWB8,
    TILE_WIRE_CE2,
    TILE_WIRE_DUMMY_SWB9,

    TILE_WIRE_DUMMY_SWB10,
    TILE_WIRE_D3,
    TILE_WIRE_C3,
    TILE_WIRE_B3,
    TILE_WIRE_A3,
    TILE_WIRE_D2,
    TILE_WIRE_C2,
    TILE_WIRE_B2,
    TILE_WIRE_A2,
    TILE_WIRE_DI3,
    TILE_WIRE_DI2,
    TILE_WIRE_M3,
    TILE_WIRE_M2,
    TILE_WIRE_FXBB,
    TILE_WIRE_FXAB,
    TILE_WIRE_DUMMY_SWB11,
    TILE_WIRE_DUMMY_SWB12,
    TILE_WIRE_F3,
    TILE_WIRE_Q3,
    TILE_WIRE_Q2,
    TILE_WIRE_F2,
    TILE_WIRE_DUMMY_SWB13,
    TILE_WIRE_CE1,
    TILE_WIRE_DUMMY_SWB14,

    TILE_WIRE_DUMMY_SWB15,
    TILE_WIRE_D1,
    TILE_WIRE_C1,
    TILE_WIRE_B1,
    TILE_WIRE_A1,
    TILE_WIRE_D0,
    TILE_WIRE_C0,
    TILE_WIRE_B0,
    TILE_WIRE_A0,
    TILE_WIRE_DI1,
    TILE_WIRE_DI0,
    TILE_WIRE_M1,
    TILE_WIRE_M0,
    TILE_WIRE_FXBA,
    TILE_WIRE_FXAA,
    TILE_WIRE_DUMMY_SWB16,
    TILE_WIRE_DUMMY_SWB17,
    TILE_WIRE_F1,
    TILE_WIRE_Q1,
    TILE_WIRE_Q0,
    TILE_WIRE_F0,
    TILE_WIRE_DUMMY_SWB18,
    TILE_WIRE_CE0,
    TILE_WIRE_FCI,

    TILE_WIRE_MUXCLK3,
    TILE_WIRE_MUXLSR3,
    TILE_WIRE_MUXCLK2,
    TILE_WIRE_MUXLSR2,
    TILE_WIRE_MUXCLK1,
    TILE_WIRE_MUXLSR1,
    TILE_WIRE_MUXCLK0,
    TILE_WIRE_MUXLSR0,

    TILE_WIRE_WD3,
    TILE_WIRE_WD2,
    TILE_WIRE_WD1,
    TILE_WIRE_WD0,

    TILE_WIRE_WAD3,
    TILE_WIRE_WAD2,
    TILE_WIRE_WAD1,
    TILE_WIRE_WAD0,

    TILE_WIRE_DUMMY_D2,
    TILE_WIRE_DUMMY_D3,
    TILE_WIRE_CLK3_SLICE,
    TILE_WIRE_LSR3_SLICE,
    TILE_WIRE_DUMMY_D4,
    TILE_WIRE_DUMMY_D5,
    TILE_WIRE_DUMMY_D6,
    TILE_WIRE_DUMMY_D7,
    TILE_WIRE_DUMMY_D8,
    TILE_WIRE_DUMMY_D9,
    TILE_WIRE_DUMMY_D10,
    TILE_WIRE_DUMMY_D11,

    TILE_WIRE_DUMMY_C2,
    TILE_WIRE_DUMMY_C3,
    TILE_WIRE_CLK2_SLICE,
    TILE_WIRE_LSR2_SLICE,
    TILE_WIRE_WDO3C_SLICE,
    TILE_WIRE_WDO2C_SLICE,
    TILE_WIRE_WDO1C_SLICE,
    TILE_WIRE_WDO0C_SLICE,
    TILE_WIRE_WADO3C_SLICE,
    TILE_WIRE_WADO2C_SLICE,
    TILE_WIRE_WADO1C_SLICE,
    TILE_WIRE_WADO0C_SLICE,

    TILE_WIRE_WCK1_SLICE,
    TILE_WIRE_WRE1_SLICE,
    TILE_WIRE_CLK1_SLICE,
    TILE_WIRE_LSR1_SLICE,
    TILE_WIRE_DUMMY_B2,
    TILE_WIRE_DUMMY_B3,
    TILE_WIRE_WD1B_SLICE,
    TILE_WIRE_WD0B_SLICE,
    TILE_WIRE_WAD3B_SLICE,
    TILE_WIRE_WAD2B_SLICE,
    TILE_WIRE_WAD1B_SLICE,
    TILE_WIRE_WAD0B_SLICE,

    TILE_WIRE_WCK0_SLICE,
    TILE_WIRE_WRE0_SLICE,
    TILE_WIRE_CLK0_SLICE,
    TILE_WIRE_LSR0_SLICE,
    TILE_WIRE_DUMMY_A2,
    TILE_WIRE_DUMMY_A3,
    TILE_WIRE_WD1A_SLICE,
    TILE_WIRE_WD0A_SLICE,
    TILE_WIRE_WAD3A_SLICE,
    TILE_WIRE_WAD2A_SLICE,
    TILE_WIRE_WAD1A_SLICE,
    TILE_WIRE_WAD0A_SLICE,

    TILE_WIRE_V01N0001,
    TILE_WIRE_V01N0101,
    TILE_WIRE_V01S0000,
    TILE_WIRE_V01S0100,

    TILE_WIRE_H01E0001,
    TILE_WIRE_H01E0101,
    TILE_WIRE_H01W0000,
    TILE_WIRE_H01W0100,
    TILE_WIRE_HFIE0000,
    TILE_WIRE_HL7W0001,

    TILE_WIRE_V00T0000,
    TILE_WIRE_V00T0100,

    TILE_WIRE_V00B0000,
    TILE_WIRE_V00B0100,

    TILE_WIRE_H00L0000,
    TILE_WIRE_H00L0100,

    TILE_WIRE_H00R0000,
    TILE_WIRE_H00R0100,

    TILE_WIRE_NBOUNCE,
    TILE_WIRE_SBOUNCE,
    TILE_WIRE_WBOUNCE,
    TILE_WIRE_EBOUNCE,

    TILE_WIRE_V02N0701,
    TILE_WIRE_V02S0701,
    TILE_WIRE_V02N0601,
    TILE_WIRE_V02S0601,
    TILE_WIRE_V02N0501,
    TILE_WIRE_V02S0501,
    TILE_WIRE_V02N0401,
    TILE_WIRE_V02S0401,
    TILE_WIRE_V02N0301,
    TILE_WIRE_V02S0301,
    TILE_WIRE_V02N0201,
    TILE_WIRE_V02S0201,
    TILE_WIRE_V02N0101,
    TILE_WIRE_V02S0101,
    TILE_WIRE_V02N0001,
    TILE_WIRE_V02S0001,

    TILE_WIRE_V06N0303,
    TILE_WIRE_V06S0303,
    TILE_WIRE_V06N0203,
    TILE_WIRE_V06S0203,
    TILE_WIRE_V06N0103,
    TILE_WIRE_V06S0103,
    TILE_WIRE_V06N0003,
    TILE_WIRE_V06S0003,

    TILE_WIRE_H02W0701,
    TILE_WIRE_H02E0701,
    TILE_WIRE_H02W0601,
    TILE_WIRE_H02E0601,
    TILE_WIRE_H02W0501,
    TILE_WIRE_H02E0501,
    TILE_WIRE_H02W0401,
    TILE_WIRE_H02E0401,
    TILE_WIRE_H02W0301,
    TILE_WIRE_H02E0301,
    TILE_WIRE_H02W0201,
    TILE_WIRE_H02E0201,
    TILE_WIRE_H02W0101,
    TILE_WIRE_H02E0101,
    TILE_WIRE_H02W0001,
    TILE_WIRE_H02E0001,

    TILE_WIRE_H06W0303,
    TILE_WIRE_H06E0303,
    TILE_WIRE_H06W0203,
    TILE_WIRE_H06E0203,
    TILE_WIRE_H06W0103,
    TILE_WIRE_H06E0103,
    TILE_WIRE_H06W0003,
    TILE_WIRE_H06E0003,

    TILE_WIRE_DDRDEL_DQS,
    TILE_WIRE_JRST_DQS,
    TILE_WIRE_ECLK_DQS,
    TILE_WIRE_JDQSR90_DQS,
    TILE_WIRE_JDQSW270_DQS,
    TILE_WIRE_JDQSW_DQS,
    TILE_WIRE_RDPNTR0_DQS,
    TILE_WIRE_RDPNTR1_DQS,
    TILE_WIRE_RDPNTR2_DQS,
    TILE_WIRE_WRPNTR0_DQS,
    TILE_WIRE_WRPNTR1_DQS,
    TILE_WIRE_WRPNTR2_DQS,
    TILE_WIRE_JDQSI_DQS,
    TILE_WIRE_JREAD1_DQS,
    TILE_WIRE_JREAD0_DQS,
    TILE_WIRE_JREADCLKSEL2_DQS,
    TILE_WIRE_JREADCLKSEL1_DQS,
    TILE_WIRE_JREADCLKSEL0_DQS,
    TILE_WIRE_JSCLK_DQS,
    TILE_WIRE_JDYNDELAY0_DQS,
    TILE_WIRE_JDYNDELAY1_DQS,
    TILE_WIRE_JDYNDELAY2_DQS,
    TILE_WIRE_JDYNDELAY3_DQS,
    TILE_WIRE_JDYNDELAY4_DQS,
    TILE_WIRE_JDYNDELAY5_DQS,
    TILE_WIRE_JDYNDELAY6_DQS,
    TILE_WIRE_JDYNDELAY7_DQS,
    TILE_WIRE_JPAUSE_DQS,
    TILE_WIRE_JRDLOADN_DQS,
    TILE_WIRE_JRDMOVE_DQS,
    TILE_WIRE_JRDDIRECTION_DQS,
    TILE_WIRE_JWRLOADN_DQS,
    TILE_WIRE_JWRMOVE_DQS,
    TILE_WIRE_JWRDIRECTION_DQS,
    TILE_WIRE_JDATAVALID_DQS,
    TILE_WIRE_JBURSTDET_DQS,
    TILE_WIRE_JRDCFLAG_DQS,
    TILE_WIRE_JWRCFLAG_DQS,

    TILE_WIRE_JLOADND_IOLOGIC,
    TILE_WIRE_JMOVED_IOLOGIC,
    TILE_WIRE_JDIRECTIOND_IOLOGIC,
    TILE_WIRE_JCFLAGD_IOLOGIC,
    TILE_WIRE_IOLDOD_IOLOGIC,
    TILE_WIRE_IOLTOD_IOLOGIC,
    TILE_WIRE_DID_IOLOGIC,
    TILE_WIRE_IOLDODD_IOLOGIC,
    TILE_WIRE_IOLDOID_IOLOGIC,
    TILE_WIRE_INDDD_IOLOGIC,
    TILE_WIRE_PADDID_IOLOGIC,
    TILE_WIRE_JCLKD_IOLOGIC,
    TILE_WIRE_JCED_IOLOGIC,
    TILE_WIRE_JLSRD_IOLOGIC,
    TILE_WIRE_JTSDATA0D_IOLOGIC,
    TILE_WIRE_JTXDATA0D_IOLOGIC,
    TILE_WIRE_JTXDATA1D_IOLOGIC,
    TILE_WIRE_JRXDATA0D_IOLOGIC,
    TILE_WIRE_JRXDATA1D_IOLOGIC,
    TILE_WIRE_JINFFD_IOLOGIC,
    TILE_WIRE_ECLKD_IOLOGIC,
    TILE_WIRE_JTSDATA1D_IOLOGIC,
    TILE_WIRE_JTXDATA2D_IOLOGIC,
    TILE_WIRE_JTXDATA3D_IOLOGIC,
    TILE_WIRE_JRXDATA2D_IOLOGIC,
    TILE_WIRE_JRXDATA3D_IOLOGIC,
    TILE_WIRE_DQSR90D_IOLOGIC,
    TILE_WIRE_DQSW270D_IOLOGIC,
    TILE_WIRE_DQSWD_IOLOGIC,
    TILE_WIRE_RDPNTR0D_IOLOGIC,
    TILE_WIRE_RDPNTR1D_IOLOGIC,
    TILE_WIRE_RDPNTR2D_IOLOGIC,
    TILE_WIRE_WRPNTR0D_IOLOGIC,
    TILE_WIRE_WRPNTR1D_IOLOGIC,
    TILE_WIRE_WRPNTR2D_IOLOGIC,
    TILE_WIRE_JSLIPD_IOLOGIC,
    TILE_WIRE_DUMMYD2_IOLOGIC,
    TILE_WIRE_DUMMYD3_IOLOGIC,
    TILE_WIRE_DUMMYD4_IOLOGIC,
    TILE_WIRE_DUMMYD5_IOLOGIC,
    TILE_WIRE_DUMMYD6_IOLOGIC,
    TILE_WIRE_DUMMYD7_IOLOGIC,

    TILE_WIRE_JLOADNC_IOLOGIC,
    TILE_WIRE_JMOVEC_IOLOGIC,
    TILE_WIRE_JDIRECTIONC_IOLOGIC,
    TILE_WIRE_JCFLAGC_IOLOGIC,
    TILE_WIRE_IOLDOC_IOLOGIC,
    TILE_WIRE_IOLTOC_IOLOGIC,
    TILE_WIRE_DIC_IOLOGIC,
    TILE_WIRE_IOLDODC_IOLOGIC,
    TILE_WIRE_IOLDOIC_IOLOGIC,
    TILE_WIRE_INDDC_IOLOGIC,
    TILE_WIRE_PADDIC_IOLOGIC,
    TILE_WIRE_JCLKC_IOLOGIC,
    TILE_WIRE_JCEC_IOLOGIC,
    TILE_WIRE_JLSRC_IOLOGIC,
    TILE_WIRE_JTSDATA0C_IOLOGIC,
    TILE_WIRE_JTXDATA0C_IOLOGIC,
    TILE_WIRE_JTXDATA1C_IOLOGIC,
    TILE_WIRE_JRXDATA0C_IOLOGIC,
    TILE_WIRE_JRXDATA1C_IOLOGIC,
    TILE_WIRE_JINFFC_IOLOGIC,
    TILE_WIRE_ECLKC_IOLOGIC,
    TILE_WIRE_JTSDATA1C_IOLOGIC,
    TILE_WIRE_JTXDATA2C_IOLOGIC,
    TILE_WIRE_JTXDATA3C_IOLOGIC,
    TILE_WIRE_JRXDATA2C_IOLOGIC,
    TILE_WIRE_JRXDATA3C_IOLOGIC,
    TILE_WIRE_JTXDATA4C_IOLOGIC,
    TILE_WIRE_JTXDATA5C_IOLOGIC,
    TILE_WIRE_JTXDATA6C_IOLOGIC,
    TILE_WIRE_JSLIPC_IOLOGIC,
    TILE_WIRE_JRXDATA4C_IOLOGIC,
    TILE_WIRE_JRXDATA5C_IOLOGIC,
    TILE_WIRE_JRXDATA6C_IOLOGIC,
    TILE_WIRE_DQSR90C_IOLOGIC,
    TILE_WIRE_DQSW270C_IOLOGIC,
    TILE_WIRE_DQSWC_IOLOGIC,
    TILE_WIRE_RDPNTR0C_IOLOGIC,
    TILE_WIRE_RDPNTR1C_IOLOGIC,
    TILE_WIRE_RDPNTR2C_IOLOGIC,
    TILE_WIRE_WRPNTR0C_IOLOGIC,
    TILE_WIRE_WRPNTR1C_IOLOGIC,
    TILE_WIRE_WRPNTR2C_IOLOGIC,

    TILE_WIRE_JLOADNB_IOLOGIC,
    TILE_WIRE_JMOVEB_IOLOGIC,
    TILE_WIRE_JDIRECTIONB_IOLOGIC,
    TILE_WIRE_JCFLAGB_IOLOGIC,
    TILE_WIRE_IOLDOB_IOLOGIC,
    TILE_WIRE_IOLTOB_IOLOGIC,
    TILE_WIRE_DIB_IOLOGIC,
    TILE_WIRE_IOLDODB_IOLOGIC,
    TILE_WIRE_IOLDOIB_IOLOGIC,
    TILE_WIRE_INDDB_IOLOGIC,
    TILE_WIRE_PADDIB_IOLOGIC,
    TILE_WIRE_JCLKB_IOLOGIC,
    TILE_WIRE_JCEB_IOLOGIC,
    TILE_WIRE_JLSRB_IOLOGIC,
    TILE_WIRE_JTSDATA0B_IOLOGIC,
    TILE_WIRE_JTXDATA0B_IOLOGIC,
    TILE_WIRE_JTXDATA1B_IOLOGIC,
    TILE_WIRE_JRXDATA0B_IOLOGIC,
    TILE_WIRE_JRXDATA1B_IOLOGIC,
    TILE_WIRE_JINFFB_IOLOGIC,
    TILE_WIRE_ECLKB_IOLOGIC,
    TILE_WIRE_JTSDATA1B_IOLOGIC,
    TILE_WIRE_JTXDATA2B_IOLOGIC,
    TILE_WIRE_JTXDATA3B_IOLOGIC,
    TILE_WIRE_JRXDATA2B_IOLOGIC,
    TILE_WIRE_JRXDATA3B_IOLOGIC,
    TILE_WIRE_DQSR90B_IOLOGIC,
    TILE_WIRE_DQSW270B_IOLOGIC,
    TILE_WIRE_DQSWB_IOLOGIC,
    TILE_WIRE_RDPNTR0B_IOLOGIC,
    TILE_WIRE_RDPNTR1B_IOLOGIC,
    TILE_WIRE_RDPNTR2B_IOLOGIC,
    TILE_WIRE_WRPNTR0B_IOLOGIC,
    TILE_WIRE_WRPNTR1B_IOLOGIC,
    TILE_WIRE_WRPNTR2B_IOLOGIC,
    TILE_WIRE_JSLIPB_IOLOGIC,
    TILE_WIRE_DUMMYB2_IOLOGIC,
    TILE_WIRE_DUMMYB3_IOLOGIC,
    TILE_WIRE_DUMMYB4_IOLOGIC,
    TILE_WIRE_DUMMYB5_IOLOGIC,
    TILE_WIRE_DUMMYB6_IOLOGIC,
    TILE_WIRE_DUMMYB7_IOLOGIC,

    TILE_WIRE_JLOADNA_IOLOGIC,
    TILE_WIRE_JMOVEA_IOLOGIC,
    TILE_WIRE_JDIRECTIONA_IOLOGIC,
    TILE_WIRE_JCFLAGA_IOLOGIC,
    TILE_WIRE_IOLDOA_IOLOGIC,
    TILE_WIRE_IOLTOA_IOLOGIC,
    TILE_WIRE_DIA_IOLOGIC,
    TILE_WIRE_IOLDODA_IOLOGIC,
    TILE_WIRE_IOLDOIA_IOLOGIC,
    TILE_WIRE_INDDA_IOLOGIC,
    TILE_WIRE_PADDIA_IOLOGIC,
    TILE_WIRE_JCLKA_IOLOGIC,
    TILE_WIRE_JCEA_IOLOGIC,
    TILE_WIRE_JLSRA_IOLOGIC,
    TILE_WIRE_JTSDATA0A_IOLOGIC,
    TILE_WIRE_JTXDATA0A_IOLOGIC,
    TILE_WIRE_JTXDATA1A_IOLOGIC,
    TILE_WIRE_JRXDATA0A_IOLOGIC,
    TILE_WIRE_JRXDATA1A_IOLOGIC,
    TILE_WIRE_JINFFA_IOLOGIC,
    TILE_WIRE_ECLKA_IOLOGIC,
    TILE_WIRE_JTSDATA1A_IOLOGIC,
    TILE_WIRE_JTXDATA2A_IOLOGIC,
    TILE_WIRE_JTXDATA3A_IOLOGIC,
    TILE_WIRE_JRXDATA2A_IOLOGIC,
    TILE_WIRE_JRXDATA3A_IOLOGIC,
    TILE_WIRE_JTXDATA4A_IOLOGIC,
    TILE_WIRE_JTXDATA5A_IOLOGIC,
    TILE_WIRE_JTXDATA6A_IOLOGIC,
    TILE_WIRE_JSLIPA_IOLOGIC,
    TILE_WIRE_JRXDATA4A_IOLOGIC,
    TILE_WIRE_JRXDATA5A_IOLOGIC,
    TILE_WIRE_JRXDATA6A_IOLOGIC,
    TILE_WIRE_DQSR90A_IOLOGIC,
    TILE_WIRE_DQSW270A_IOLOGIC,
    TILE_WIRE_DQSWA_IOLOGIC,
    TILE_WIRE_RDPNTR0A_IOLOGIC,
    TILE_WIRE_RDPNTR1A_IOLOGIC,
    TILE_WIRE_RDPNTR2A_IOLOGIC,
    TILE_WIRE_WRPNTR0A_IOLOGIC,
    TILE_WIRE_WRPNTR1A_IOLOGIC,
    TILE_WIRE_WRPNTR2A_IOLOGIC,

    TILE_WIRE_JLOADNB_SIOLOGIC,
    TILE_WIRE_JMOVEB_SIOLOGIC,
    TILE_WIRE_JDIRECTIONB_SIOLOGIC,
    TILE_WIRE_JCFLAGB_SIOLOGIC,
    TILE_WIRE_IOLDOB_SIOLOGIC,
    TILE_WIRE_IOLTOB_SIOLOGIC,
    TILE_WIRE_DIB_SIOLOGIC,
    TILE_WIRE_IOLDODB_SIOLOGIC,
    TILE_WIRE_IOLDOIB_SIOLOGIC,
    TILE_WIRE_INDDB_SIOLOGIC,
    TILE_WIRE_PADDIB_SIOLOGIC,
    TILE_WIRE_JCLKB_SIOLOGIC,
    TILE_WIRE_JCEB_SIOLOGIC,
    TILE_WIRE_JLSRB_SIOLOGIC,
    TILE_WIRE_JTSDATA0B_SIOLOGIC,
    TILE_WIRE_JTXDATA0B_SIOLOGIC,
    TILE_WIRE_JTXDATA1B_SIOLOGIC,
    TILE_WIRE_JRXDATA0B_SIOLOGIC,
    TILE_WIRE_JRXDATA1B_SIOLOGIC,
    TILE_WIRE_JINFFB_SIOLOGIC,
    TILE_WIRE_JLOADNA_SIOLOGIC,
    TILE_WIRE_JMOVEA_SIOLOGIC,
    TILE_WIRE_JDIRECTIONA_SIOLOGIC,
    TILE_WIRE_JCFLAGA_SIOLOGIC,
    TILE_WIRE_IOLDOA_SIOLOGIC,
    TILE_WIRE_IOLTOA_SIOLOGIC,
    TILE_WIRE_DIA_SIOLOGIC,
    TILE_WIRE_IOLDODA_SIOLOGIC,
    TILE_WIRE_IOLDOIA_SIOLOGIC,
    TILE_WIRE_INDDA_SIOLOGIC,
    TILE_WIRE_PADDIA_SIOLOGIC,
    TILE_WIRE_JCLKA_SIOLOGIC,
    TILE_WIRE_JCEA_SIOLOGIC,
    TILE_WIRE_JLSRA_SIOLOGIC,
    TILE_WIRE_JTSDATA0A_SIOLOGIC,
    TILE_WIRE_JTXDATA0A_SIOLOGIC,
    TILE_WIRE_JTXDATA1A_SIOLOGIC,
    TILE_WIRE_JRXDATA0A_SIOLOGIC,
    TILE_WIRE_JRXDATA1A_SIOLOGIC,
    TILE_WIRE_JINFFA_SIOLOGIC,

    TILE_WIRE_PADDOD_PIO,
    TILE_WIRE_PADDTD_PIO,
    TILE_WIRE_JPADDID_PIO,
    TILE_WIRE_IOLDOD_PIO,
    TILE_WIRE_IOLTOD_PIO,
    TILE_WIRE_INRDD_PIO,
    TILE_WIRE_LVDSD_PIO,
    TILE_WIRE_PADDOC_PIO,
    TILE_WIRE_PADDTC_PIO,
    TILE_WIRE_JPADDIC_PIO,
    TILE_WIRE_IOLDOC_PIO,
    TILE_WIRE_IOLTOC_PIO,
    TILE_WIRE_INRDC_PIO,
    TILE_WIRE_LVDSC_PIO,
    TILE_WIRE_PADDOB_PIO,
    TILE_WIRE_PADDTB_PIO,
    TILE_WIRE_JPADDIB_PIO,
    TILE_WIRE_IOLDOB_PIO,
    TILE_WIRE_IOLTOB_PIO,
    TILE_WIRE_INRDB_PIO,
    TILE_WIRE_LVDSB_PIO,
    TILE_WIRE_PADDOA_PIO,
    TILE_WIRE_PADDTA_PIO,
    TILE_WIRE_JPADDIA_PIO,
    TILE_WIRE_IOLDOA_PIO,
    TILE_WIRE_IOLTOA_PIO,
    TILE_WIRE_INRDA_PIO,
    TILE_WIRE_LVDSA_PIO,

    TILE_WIRE_JADA0_EBR,
    TILE_WIRE_JADB0_EBR,
    TILE_WIRE_JADA1_EBR,
    TILE_WIRE_JADB1_EBR,
    TILE_WIRE_JADA2_EBR,
    TILE_WIRE_JADB2_EBR,
    TILE_WIRE_JADA3_EBR,
    TILE_WIRE_JADB3_EBR,
    TILE_WIRE_JADA4_EBR,
    TILE_WIRE_JADB4_EBR,
    TILE_WIRE_JADA5_EBR,
    TILE_WIRE_JADB5_EBR,
    TILE_WIRE_JADA6_EBR,
    TILE_WIRE_JADB6_EBR,
    TILE_WIRE_JADA7_EBR,
    TILE_WIRE_JADB7_EBR,
    TILE_WIRE_JADA8_EBR,
    TILE_WIRE_JADB8_EBR,
    TILE_WIRE_JADA9_EBR,
    TILE_WIRE_JADB9_EBR,
    TILE_WIRE_JADA10_EBR,
    TILE_WIRE_JADB10_EBR,
    TILE_WIRE_JADA11_EBR,
    TILE_WIRE_JADB11_EBR,
    TILE_WIRE_JADA12_EBR,
    TILE_WIRE_JADB12_EBR,
    TILE_WIRE_JADA13_EBR,
    TILE_WIRE_JADB13_EBR,
    TILE_WIRE_JCEA_EBR,
    TILE_WIRE_JCEB_EBR,
    TILE_WIRE_JCLKA_EBR,
    TILE_WIRE_JCLKB_EBR,
    TILE_WIRE_JCSA0_EBR,
    TILE_WIRE_JCSA1_EBR,
    TILE_WIRE_JCSA2_EBR,
    TILE_WIRE_JCSB0_EBR,
    TILE_WIRE_JCSB1_EBR,
    TILE_WIRE_JCSB2_EBR,
    TILE_WIRE_JDIA0_EBR,
    TILE_WIRE_JDIB0_EBR,
    TILE_WIRE_JDOA0_EBR,
    TILE_WIRE_JDOB0_EBR,
    TILE_WIRE_JDIA1_EBR,
    TILE_WIRE_JDIB1_EBR,
    TILE_WIRE_JDOA1_EBR,
    TILE_WIRE_JDOB1_EBR,
    TILE_WIRE_JDIA2_EBR,
    TILE_WIRE_JDIB2_EBR,
    TILE_WIRE_JDOA2_EBR,
    TILE_WIRE_JDOB2_EBR,
    TILE_WIRE_JDIA3_EBR,
    TILE_WIRE_JDIB3_EBR,
    TILE_WIRE_JDOA3_EBR,
    TILE_WIRE_JDOB3_EBR,
    TILE_WIRE_JDIA4_EBR,
    TILE_WIRE_JDIB4_EBR,
    TILE_WIRE_JDOA4_EBR,
    TILE_WIRE_JDOB4_EBR,
    TILE_WIRE_JDIA5_EBR,
    TILE_WIRE_JDIB5_EBR,
    TILE_WIRE_JDOA5_EBR,
    TILE_WIRE_JDOB5_EBR,
    TILE_WIRE_JDIA6_EBR,
    TILE_WIRE_JDIB6_EBR,
    TILE_WIRE_JDOA6_EBR,
    TILE_WIRE_JDOB6_EBR,
    TILE_WIRE_JDIA7_EBR,
    TILE_WIRE_JDIB7_EBR,
    TILE_WIRE_JDOA7_EBR,
    TILE_WIRE_JDOB7_EBR,
    TILE_WIRE_JDIA8_EBR,
    TILE_WIRE_JDIB8_EBR,
    TILE_WIRE_JDOA8_EBR,
    TILE_WIRE_JDOB8_EBR,
    TILE_WIRE_JDIA9_EBR,
    TILE_WIRE_JDIB9_EBR,
    TILE_WIRE_JDOA9_EBR,
    TILE_WIRE_JDOB9_EBR,
    TILE_WIRE_JDIA10_EBR,
    TILE_WIRE_JDIB10_EBR,
    TILE_WIRE_JDOA10_EBR,
    TILE_WIRE_JDOB10_EBR,
    TILE_WIRE_JDIA11_EBR,
    TILE_WIRE_JDIB11_EBR,
    TILE_WIRE_JDOA11_EBR,
    TILE_WIRE_JDOB11_EBR,
    TILE_WIRE_JDIA12_EBR,
    TILE_WIRE_JDIB12_EBR,
    TILE_WIRE_JDOA12_EBR,
    TILE_WIRE_JDOB12_EBR,
    TILE_WIRE_JDIA13_EBR,
    TILE_WIRE_JDIB13_EBR,
    TILE_WIRE_JDOA13_EBR,
    TILE_WIRE_JDOB13_EBR,
    TILE_WIRE_JDIA14_EBR,
    TILE_WIRE_JDIB14_EBR,
    TILE_WIRE_JDOA14_EBR,
    TILE_WIRE_JDOB14_EBR,
    TILE_WIRE_JDIA15_EBR,
    TILE_WIRE_JDIB15_EBR,
    TILE_WIRE_JDOA15_EBR,
    TILE_WIRE_JDOB15_EBR,
    TILE_WIRE_JDIA16_EBR,
    TILE_WIRE_JDIB16_EBR,
    TILE_WIRE_JDOA16_EBR,
    TILE_WIRE_JDOB16_EBR,
    TILE_WIRE_JDIA17_EBR,
    TILE_WIRE_JDIB17_EBR,
    TILE_WIRE_JDOA17_EBR,
    TILE_WIRE_JDOB17_EBR,
    TILE_WIRE_JOCEA_EBR,
    TILE_WIRE_JOCEB_EBR,
    TILE_WIRE_JRSTA_EBR,
    TILE_WIRE_JRSTB_EBR,
    TILE_WIRE_JWEA_EBR,
    TILE_WIRE_JWEB_EBR,

    TILE_WIRE_JCLK0_MULT18,
    TILE_WIRE_JCLK1_MULT18,
    TILE_WIRE_JCLK2_MULT18,
    TILE_WIRE_JCLK3_MULT18,
    TILE_WIRE_JCE0_MULT18,
    TILE_WIRE_JCE1_MULT18,
    TILE_WIRE_JCE2_MULT18,
    TILE_WIRE_JCE3_MULT18,
    TILE_WIRE_JRST0_MULT18,
    TILE_WIRE_JRST1_MULT18,
    TILE_WIRE_JRST2_MULT18,
    TILE_WIRE_JRST3_MULT18,
    TILE_WIRE_JA0_MULT18,
    TILE_WIRE_JA1_MULT18,
    TILE_WIRE_JA2_MULT18,
    TILE_WIRE_JA3_MULT18,
    TILE_WIRE_JA4_MULT18,
    TILE_WIRE_JA5_MULT18,
    TILE_WIRE_JA6_MULT18,
    TILE_WIRE_JA7_MULT18,
    TILE_WIRE_JA8_MULT18,
    TILE_WIRE_JA9_MULT18,
    TILE_WIRE_JA10_MULT18,
    TILE_WIRE_JA11_MULT18,
    TILE_WIRE_JA12_MULT18,
    TILE_WIRE_JA13_MULT18,
    TILE_WIRE_JA14_MULT18,
    TILE_WIRE_JA15_MULT18,
    TILE_WIRE_JA16_MULT18,
    TILE_WIRE_JA17_MULT18,
    TILE_WIRE_JB0_MULT18,
    TILE_WIRE_JB1_MULT18,
    TILE_WIRE_JB2_MULT18,
    TILE_WIRE_JB3_MULT18,
    TILE_WIRE_JB4_MULT18,
    TILE_WIRE_JB5_MULT18,
    TILE_WIRE_JB6_MULT18,
    TILE_WIRE_JB7_MULT18,
    TILE_WIRE_JB8_MULT18,
    TILE_WIRE_JB9_MULT18,
    TILE_WIRE_JB10_MULT18,
    TILE_WIRE_JB11_MULT18,
    TILE_WIRE_JB12_MULT18,
    TILE_WIRE_JB13_MULT18,
    TILE_WIRE_JB14_MULT18,
    TILE_WIRE_JB15_MULT18,
    TILE_WIRE_JB16_MULT18,
    TILE_WIRE_JB17_MULT18,
    TILE_WIRE_JC0_MULT18,
    TILE_WIRE_JC1_MULT18,
    TILE_WIRE_JC2_MULT18,
    TILE_WIRE_JC3_MULT18,
    TILE_WIRE_JC4_MULT18,
    TILE_WIRE_JC5_MULT18,
    TILE_WIRE_JC6_MULT18,
    TILE_WIRE_JC7_MULT18,
    TILE_WIRE_JC8_MULT18,
    TILE_WIRE_JC9_MULT18,
    TILE_WIRE_JC10_MULT18,
    TILE_WIRE_JC11_MULT18,
    TILE_WIRE_JC12_MULT18,
    TILE_WIRE_JC13_MULT18,
    TILE_WIRE_JC14_MULT18,
    TILE_WIRE_JC15_MULT18,
    TILE_WIRE_JC16_MULT18,
    TILE_WIRE_JC17_MULT18,
    TILE_WIRE_JSIGNEDA_MULT18,
    TILE_WIRE_JSIGNEDB_MULT18,
    TILE_WIRE_JSOURCEA_MULT18,
    TILE_WIRE_JSOURCEB_MULT18,
    TILE_WIRE_JSRIA0_MULT18,
    TILE_WIRE_JSRIA1_MULT18,
    TILE_WIRE_JSRIA2_MULT18,
    TILE_WIRE_JSRIA3_MULT18,
    TILE_WIRE_JSRIA4_MULT18,
    TILE_WIRE_JSRIA5_MULT18,
    TILE_WIRE_JSRIA6_MULT18,
    TILE_WIRE_JSRIA7_MULT18,
    TILE_WIRE_JSRIA8_MULT18,
    TILE_WIRE_JSRIA9_MULT18,
    TILE_WIRE_JSRIA10_MULT18,
    TILE_WIRE_JSRIA11_MULT18,
    TILE_WIRE_JSRIA12_MULT18,
    TILE_WIRE_JSRIA13_MULT18,
    TILE_WIRE_JSRIA14_MULT18,
    TILE_WIRE_JSRIA15_MULT18,
    TILE_WIRE_JSRIA16_MULT18,
    TILE_WIRE_JSRIA17_MULT18,
    TILE_WIRE_JSRIB0_MULT18,
    TILE_WIRE_JSRIB1_MULT18,
    TILE_WIRE_JSRIB2_MULT18,
    TILE_WIRE_JSRIB3_MULT18,
    TILE_WIRE_JSRIB4_MULT18,
    TILE_WIRE_JSRIB5_MULT18,
    TILE_WIRE_JSRIB6_MULT18,
    TILE_WIRE_JSRIB7_MULT18,
    TILE_WIRE_JSRIB8_MULT18,
    TILE_WIRE_JSRIB9_MULT18,
    TILE_WIRE_JSRIB10_MULT18,
    TILE_WIRE_JSRIB11_MULT18,
    TILE_WIRE_JSRIB12_MULT18,
    TILE_WIRE_JSRIB13_MULT18,
    TILE_WIRE_JSRIB14_MULT18,
    TILE_WIRE_JSRIB15_MULT18,
    TILE_WIRE_JSRIB16_MULT18,
    TILE_WIRE_JSRIB17_MULT18,
    TILE_WIRE_JROA0_MULT18,
    TILE_WIRE_JROA1_MULT18,
    TILE_WIRE_JROA2_MULT18,
    TILE_WIRE_JROA3_MULT18,
    TILE_WIRE_JROA4_MULT18,
    TILE_WIRE_JROA5_MULT18,
    TILE_WIRE_JROA6_MULT18,
    TILE_WIRE_JROA7_MULT18,
    TILE_WIRE_JROA8_MULT18,
    TILE_WIRE_JROA9_MULT18,
    TILE_WIRE_JROA10_MULT18,
    TILE_WIRE_JROA11_MULT18,
    TILE_WIRE_JROA12_MULT18,
    TILE_WIRE_JROA13_MULT18,
    TILE_WIRE_JROA14_MULT18,
    TILE_WIRE_JROA15_MULT18,
    TILE_WIRE_JROA16_MULT18,
    TILE_WIRE_JROA17_MULT18,
    TILE_WIRE_JROB0_MULT18,
    TILE_WIRE_JROB1_MULT18,
    TILE_WIRE_JROB2_MULT18,
    TILE_WIRE_JROB3_MULT18,
    TILE_WIRE_JROB4_MULT18,
    TILE_WIRE_JROB5_MULT18,
    TILE_WIRE_JROB6_MULT18,
    TILE_WIRE_JROB7_MULT18,
    TILE_WIRE_JROB8_MULT18,
    TILE_WIRE_JROB9_MULT18,
    TILE_WIRE_JROB10_MULT18,
    TILE_WIRE_JROB11_MULT18,
    TILE_WIRE_JROB12_MULT18,
    TILE_WIRE_JROB13_MULT18,
    TILE_WIRE_JROB14_MULT18,
    TILE_WIRE_JROB15_MULT18,
    TILE_WIRE_JROB16_MULT18,
    TILE_WIRE_JROB17_MULT18,
    TILE_WIRE_JROC0_MULT18,
    TILE_WIRE_JROC1_MULT18,
    TILE_WIRE_JROC2_MULT18,
    TILE_WIRE_JROC3_MULT18,
    TILE_WIRE_JROC4_MULT18,
    TILE_WIRE_JROC5_MULT18,
    TILE_WIRE_JROC6_MULT18,
    TILE_WIRE_JROC7_MULT18,
    TILE_WIRE_JROC8_MULT18,
    TILE_WIRE_JROC9_MULT18,
    TILE_WIRE_JROC10_MULT18,
    TILE_WIRE_JROC11_MULT18,
    TILE_WIRE_JROC12_MULT18,
    TILE_WIRE_JROC13_MULT18,
    TILE_WIRE_JROC14_MULT18,
    TILE_WIRE_JROC15_MULT18,
    TILE_WIRE_JROC16_MULT18,
    TILE_WIRE_JROC17_MULT18,
    TILE_WIRE_JSROA0_MULT18,
    TILE_WIRE_JSROA1_MULT18,
    TILE_WIRE_JSROA2_MULT18,
    TILE_WIRE_JSROA3_MULT18,
    TILE_WIRE_JSROA4_MULT18,
    TILE_WIRE_JSROA5_MULT18,
    TILE_WIRE_JSROA6_MULT18,
    TILE_WIRE_JSROA7_MULT18,
    TILE_WIRE_JSROA8_MULT18,
    TILE_WIRE_JSROA9_MULT18,
    TILE_WIRE_JSROA10_MULT18,
    TILE_WIRE_JSROA11_MULT18,
    TILE_WIRE_JSROA12_MULT18,
    TILE_WIRE_JSROA13_MULT18,
    TILE_WIRE_JSROA14_MULT18,
    TILE_WIRE_JSROA15_MULT18,
    TILE_WIRE_JSROA16_MULT18,
    TILE_WIRE_JSROA17_MULT18,
    TILE_WIRE_JSROB0_MULT18,
    TILE_WIRE_JSROB1_MULT18,
    TILE_WIRE_JSROB2_MULT18,
    TILE_WIRE_JSROB3_MULT18,
    TILE_WIRE_JSROB4_MULT18,
    TILE_WIRE_JSROB5_MULT18,
    TILE_WIRE_JSROB6_MULT18,
    TILE_WIRE_JSROB7_MULT18,
    TILE_WIRE_JSROB8_MULT18,
    TILE_WIRE_JSROB9_MULT18,
    TILE_WIRE_JSROB10_MULT18,
    TILE_WIRE_JSROB11_MULT18,
    TILE_WIRE_JSROB12_MULT18,
    TILE_WIRE_JSROB13_MULT18,
    TILE_WIRE_JSROB14_MULT18,
    TILE_WIRE_JSROB15_MULT18,
    TILE_WIRE_JSROB16_MULT18,
    TILE_WIRE_JSROB17_MULT18,
    TILE_WIRE_JP0_MULT18,
    TILE_WIRE_JP1_MULT18,
    TILE_WIRE_JP2_MULT18,
    TILE_WIRE_JP3_MULT18,
    TILE_WIRE_JP4_MULT18,
    TILE_WIRE_JP5_MULT18,
    TILE_WIRE_JP6_MULT18,
    TILE_WIRE_JP7_MULT18,
    TILE_WIRE_JP8_MULT18,
    TILE_WIRE_JP9_MULT18,
    TILE_WIRE_JP10_MULT18,
    TILE_WIRE_JP11_MULT18,
    TILE_WIRE_JP12_MULT18,
    TILE_WIRE_JP13_MULT18,
    TILE_WIRE_JP14_MULT18,
    TILE_WIRE_JP15_MULT18,
    TILE_WIRE_JP16_MULT18,
    TILE_WIRE_JP17_MULT18,
    TILE_WIRE_JP18_MULT18,
    TILE_WIRE_JP19_MULT18,
    TILE_WIRE_JP20_MULT18,
    TILE_WIRE_JP21_MULT18,
    TILE_WIRE_JP22_MULT18,
    TILE_WIRE_JP23_MULT18,
    TILE_WIRE_JP24_MULT18,
    TILE_WIRE_JP25_MULT18,
    TILE_WIRE_JP26_MULT18,
    TILE_WIRE_JP27_MULT18,
    TILE_WIRE_JP28_MULT18,
    TILE_WIRE_JP29_MULT18,
    TILE_WIRE_JP30_MULT18,
    TILE_WIRE_JP31_MULT18,
    TILE_WIRE_JP32_MULT18,
    TILE_WIRE_JP33_MULT18,
    TILE_WIRE_JP34_MULT18,
    TILE_WIRE_JP35_MULT18,
    TILE_WIRE_JSIGNEDP_MULT18,

    TILE_WIRE_JCLK0_ALU54,
    TILE_WIRE_JCLK1_ALU54,
    TILE_WIRE_JCLK2_ALU54,
    TILE_WIRE_JCLK3_ALU54,
    TILE_WIRE_JCE0_ALU54,
    TILE_WIRE_JCE1_ALU54,
    TILE_WIRE_JCE2_ALU54,
    TILE_WIRE_JCE3_ALU54,
    TILE_WIRE_JRST0_ALU54,
    TILE_WIRE_JRST1_ALU54,
    TILE_WIRE_JRST2_ALU54,
    TILE_WIRE_JRST3_ALU54,
    TILE_WIRE_JSIGNEDIA_ALU54,
    TILE_WIRE_JSIGNEDIB_ALU54,
    TILE_WIRE_JSIGNEDCIN_ALU54,
    TILE_WIRE_JA0_ALU54,
    TILE_WIRE_JA1_ALU54,
    TILE_WIRE_JA2_ALU54,
    TILE_WIRE_JA3_ALU54,
    TILE_WIRE_JA4_ALU54,
    TILE_WIRE_JA5_ALU54,
    TILE_WIRE_JA6_ALU54,
    TILE_WIRE_JA7_ALU54,
    TILE_WIRE_JA8_ALU54,
    TILE_WIRE_JA9_ALU54,
    TILE_WIRE_JA10_ALU54,
    TILE_WIRE_JA11_ALU54,
    TILE_WIRE_JA12_ALU54,
    TILE_WIRE_JA13_ALU54,
    TILE_WIRE_JA14_ALU54,
    TILE_WIRE_JA15_ALU54,
    TILE_WIRE_JA16_ALU54,
    TILE_WIRE_JA17_ALU54,
    TILE_WIRE_JA18_ALU54,
    TILE_WIRE_JA19_ALU54,
    TILE_WIRE_JA20_ALU54,
    TILE_WIRE_JA21_ALU54,
    TILE_WIRE_JA22_ALU54,
    TILE_WIRE_JA23_ALU54,
    TILE_WIRE_JA24_ALU54,
    TILE_WIRE_JA25_ALU54,
    TILE_WIRE_JA26_ALU54,
    TILE_WIRE_JA27_ALU54,
    TILE_WIRE_JA28_ALU54,
    TILE_WIRE_JA29_ALU54,
    TILE_WIRE_JA30_ALU54,
    TILE_WIRE_JA31_ALU54,
    TILE_WIRE_JA32_ALU54,
    TILE_WIRE_JA33_ALU54,
    TILE_WIRE_JA34_ALU54,
    TILE_WIRE_JA35_ALU54,
    TILE_WIRE_JB0_ALU54,
    TILE_WIRE_JB1_ALU54,
    TILE_WIRE_JB2_ALU54,
    TILE_WIRE_JB3_ALU54,
    TILE_WIRE_JB4_ALU54,
    TILE_WIRE_JB5_ALU54,
    TILE_WIRE_JB6_ALU54,
    TILE_WIRE_JB7_ALU54,
    TILE_WIRE_JB8_ALU54,
    TILE_WIRE_JB9_ALU54,
    TILE_WIRE_JB10_ALU54,
    TILE_WIRE_JB11_ALU54,
    TILE_WIRE_JB12_ALU54,
    TILE_WIRE_JB13_ALU54,
    TILE_WIRE_JB14_ALU54,
    TILE_WIRE_JB15_ALU54,
    TILE_WIRE_JB16_ALU54,
    TILE_WIRE_JB17_ALU54,
    TILE_WIRE_JB18_ALU54,
    TILE_WIRE_JB19_ALU54,
    TILE_WIRE_JB20_ALU54,
    TILE_WIRE_JB21_ALU54,
    TILE_WIRE_JB22_ALU54,
    TILE_WIRE_JB23_ALU54,
    TILE_WIRE_JB24_ALU54,
    TILE_WIRE_JB25_ALU54,
    TILE_WIRE_JB26_ALU54,
    TILE_WIRE_JB27_ALU54,
    TILE_WIRE_JB28_ALU54,
    TILE_WIRE_JB29_ALU54,
    TILE_WIRE_JB30_ALU54,
    TILE_WIRE_JB31_ALU54,
    TILE_WIRE_JB32_ALU54,
    TILE_WIRE_JB33_ALU54,
    TILE_WIRE_JB34_ALU54,
    TILE_WIRE_JB35_ALU54,
    TILE_WIRE_JMA0_ALU54,
    TILE_WIRE_JMA1_ALU54,
    TILE_WIRE_JMA2_ALU54,
    TILE_WIRE_JMA3_ALU54,
    TILE_WIRE_JMA4_ALU54,
    TILE_WIRE_JMA5_ALU54,
    TILE_WIRE_JMA6_ALU54,
    TILE_WIRE_JMA7_ALU54,
    TILE_WIRE_JMA8_ALU54,
    TILE_WIRE_JMA9_ALU54,
    TILE_WIRE_JMA10_ALU54,
    TILE_WIRE_JMA11_ALU54,
    TILE_WIRE_JMA12_ALU54,
    TILE_WIRE_JMA13_ALU54,
    TILE_WIRE_JMA14_ALU54,
    TILE_WIRE_JMA15_ALU54,
    TILE_WIRE_JMA16_ALU54,
    TILE_WIRE_JMA17_ALU54,
    TILE_WIRE_JMA18_ALU54,
    TILE_WIRE_JMA19_ALU54,
    TILE_WIRE_JMA20_ALU54,
    TILE_WIRE_JMA21_ALU54,
    TILE_WIRE_JMA22_ALU54,
    TILE_WIRE_JMA23_ALU54,
    TILE_WIRE_JMA24_ALU54,
    TILE_WIRE_JMA25_ALU54,
    TILE_WIRE_JMA26_ALU54,
    TILE_WIRE_JMA27_ALU54,
    TILE_WIRE_JMA28_ALU54,
    TILE_WIRE_JMA29_ALU54,
    TILE_WIRE_JMA30_ALU54,
    TILE_WIRE_JMA31_ALU54,
    TILE_WIRE_JMA32_ALU54,
    TILE_WIRE_JMA33_ALU54,
    TILE_WIRE_JMA34_ALU54,
    TILE_WIRE_JMA35_ALU54,
    TILE_WIRE_JMB0_ALU54,
    TILE_WIRE_JMB1_ALU54,
    TILE_WIRE_JMB2_ALU54,
    TILE_WIRE_JMB3_ALU54,
    TILE_WIRE_JMB4_ALU54,
    TILE_WIRE_JMB5_ALU54,
    TILE_WIRE_JMB6_ALU54,
    TILE_WIRE_JMB7_ALU54,
    TILE_WIRE_JMB8_ALU54,
    TILE_WIRE_JMB9_ALU54,
    TILE_WIRE_JMB10_ALU54,
    TILE_WIRE_JMB11_ALU54,
    TILE_WIRE_JMB12_ALU54,
    TILE_WIRE_JMB13_ALU54,
    TILE_WIRE_JMB14_ALU54,
    TILE_WIRE_JMB15_ALU54,
    TILE_WIRE_JMB16_ALU54,
    TILE_WIRE_JMB17_ALU54,
    TILE_WIRE_JMB18_ALU54,
    TILE_WIRE_JMB19_ALU54,
    TILE_WIRE_JMB20_ALU54,
    TILE_WIRE_JMB21_ALU54,
    TILE_WIRE_JMB22_ALU54,
    TILE_WIRE_JMB23_ALU54,
    TILE_WIRE_JMB24_ALU54,
    TILE_WIRE_JMB25_ALU54,
    TILE_WIRE_JMB26_ALU54,
    TILE_WIRE_JMB27_ALU54,
    TILE_WIRE_JMB28_ALU54,
    TILE_WIRE_JMB29_ALU54,
    TILE_WIRE_JMB30_ALU54,
    TILE_WIRE_JMB31_ALU54,
    TILE_WIRE_JMB32_ALU54,
    TILE_WIRE_JMB33_ALU54,
    TILE_WIRE_JMB34_ALU54,
    TILE_WIRE_JMB35_ALU54,
    TILE_WIRE_JC0_ALU54,
    TILE_WIRE_JC1_ALU54,
    TILE_WIRE_JC2_ALU54,
    TILE_WIRE_JC3_ALU54,
    TILE_WIRE_JC4_ALU54,
    TILE_WIRE_JC5_ALU54,
    TILE_WIRE_JC6_ALU54,
    TILE_WIRE_JC7_ALU54,
    TILE_WIRE_JC8_ALU54,
    TILE_WIRE_JC9_ALU54,
    TILE_WIRE_JC10_ALU54,
    TILE_WIRE_JC11_ALU54,
    TILE_WIRE_JC12_ALU54,
    TILE_WIRE_JC13_ALU54,
    TILE_WIRE_JC14_ALU54,
    TILE_WIRE_JC15_ALU54,
    TILE_WIRE_JC16_ALU54,
    TILE_WIRE_JC17_ALU54,
    TILE_WIRE_JC18_ALU54,
    TILE_WIRE_JC19_ALU54,
    TILE_WIRE_JC20_ALU54,
    TILE_WIRE_JC21_ALU54,
    TILE_WIRE_JC22_ALU54,
    TILE_WIRE_JC23_ALU54,
    TILE_WIRE_JC24_ALU54,
    TILE_WIRE_JC25_ALU54,
    TILE_WIRE_JC26_ALU54,
    TILE_WIRE_JC27_ALU54,
    TILE_WIRE_JC28_ALU54,
    TILE_WIRE_JC29_ALU54,
    TILE_WIRE_JC30_ALU54,
    TILE_WIRE_JC31_ALU54,
    TILE_WIRE_JC32_ALU54,
    TILE_WIRE_JC33_ALU54,
    TILE_WIRE_JC34_ALU54,
    TILE_WIRE_JC35_ALU54,
    TILE_WIRE_JC36_ALU54,
    TILE_WIRE_JC37_ALU54,
    TILE_WIRE_JC38_ALU54,
    TILE_WIRE_JC39_ALU54,
    TILE_WIRE_JC40_ALU54,
    TILE_WIRE_JC41_ALU54,
    TILE_WIRE_JC42_ALU54,
    TILE_WIRE_JC43_ALU54,
    TILE_WIRE_JC44_ALU54,
    TILE_WIRE_JC45_ALU54,
    TILE_WIRE_JC46_ALU54,
    TILE_WIRE_JC47_ALU54,
    TILE_WIRE_JC48_ALU54,
    TILE_WIRE_JC49_ALU54,
    TILE_WIRE_JC50_ALU54,
    TILE_WIRE_JC51_ALU54,
    TILE_WIRE_JC52_ALU54,
    TILE_WIRE_JC53_ALU54,
    TILE_WIRE_JCFB0_ALU54,
    TILE_WIRE_JCFB1_ALU54,
    TILE_WIRE_JCFB2_ALU54,
    TILE_WIRE_JCFB3_ALU54,
    TILE_WIRE_JCFB4_ALU54,
    TILE_WIRE_JCFB5_ALU54,
    TILE_WIRE_JCFB6_ALU54,
    TILE_WIRE_JCFB7_ALU54,
    TILE_WIRE_JCFB8_ALU54,
    TILE_WIRE_JCFB9_ALU54,
    TILE_WIRE_JCFB10_ALU54,
    TILE_WIRE_JCFB11_ALU54,
    TILE_WIRE_JCFB12_ALU54,
    TILE_WIRE_JCFB13_ALU54,
    TILE_WIRE_JCFB14_ALU54,
    TILE_WIRE_JCFB15_ALU54,
    TILE_WIRE_JCFB16_ALU54,
    TILE_WIRE_JCFB17_ALU54,
    TILE_WIRE_JCFB18_ALU54,
    TILE_WIRE_JCFB19_ALU54,
    TILE_WIRE_JCFB20_ALU54,
    TILE_WIRE_JCFB21_ALU54,
    TILE_WIRE_JCFB22_ALU54,
    TILE_WIRE_JCFB23_ALU54,
    TILE_WIRE_JCFB24_ALU54,
    TILE_WIRE_JCFB25_ALU54,
    TILE_WIRE_JCFB26_ALU54,
    TILE_WIRE_JCFB27_ALU54,
    TILE_WIRE_JCFB28_ALU54,
    TILE_WIRE_JCFB29_ALU54,
    TILE_WIRE_JCFB30_ALU54,
    TILE_WIRE_JCFB31_ALU54,
    TILE_WIRE_JCFB32_ALU54,
    TILE_WIRE_JCFB33_ALU54,
    TILE_WIRE_JCFB34_ALU54,
    TILE_WIRE_JCFB35_ALU54,
    TILE_WIRE_JCFB36_ALU54,
    TILE_WIRE_JCFB37_ALU54,
    TILE_WIRE_JCFB38_ALU54,
    TILE_WIRE_JCFB39_ALU54,
    TILE_WIRE_JCFB40_ALU54,
    TILE_WIRE_JCFB41_ALU54,
    TILE_WIRE_JCFB42_ALU54,
    TILE_WIRE_JCFB43_ALU54,
    TILE_WIRE_JCFB44_ALU54,
    TILE_WIRE_JCFB45_ALU54,
    TILE_WIRE_JCFB46_ALU54,
    TILE_WIRE_JCFB47_ALU54,
    TILE_WIRE_JCFB48_ALU54,
    TILE_WIRE_JCFB49_ALU54,
    TILE_WIRE_JCFB50_ALU54,
    TILE_WIRE_JCFB51_ALU54,
    TILE_WIRE_JCFB52_ALU54,
    TILE_WIRE_JCFB53_ALU54,
    TILE_WIRE_JCIN0_ALU54,
    TILE_WIRE_JCIN1_ALU54,
    TILE_WIRE_JCIN2_ALU54,
    TILE_WIRE_JCIN3_ALU54,
    TILE_WIRE_JCIN4_ALU54,
    TILE_WIRE_JCIN5_ALU54,
    TILE_WIRE_JCIN6_ALU54,
    TILE_WIRE_JCIN7_ALU54,
    TILE_WIRE_JCIN8_ALU54,
    TILE_WIRE_JCIN9_ALU54,
    TILE_WIRE_JCIN10_ALU54,
    TILE_WIRE_JCIN11_ALU54,
    TILE_WIRE_JCIN12_ALU54,
    TILE_WIRE_JCIN13_ALU54,
    TILE_WIRE_JCIN14_ALU54,
    TILE_WIRE_JCIN15_ALU54,
    TILE_WIRE_JCIN16_ALU54,
    TILE_WIRE_JCIN17_ALU54,
    TILE_WIRE_JCIN18_ALU54,
    TILE_WIRE_JCIN19_ALU54,
    TILE_WIRE_JCIN20_ALU54,
    TILE_WIRE_JCIN21_ALU54,
    TILE_WIRE_JCIN22_ALU54,
    TILE_WIRE_JCIN23_ALU54,
    TILE_WIRE_JCIN24_ALU54,
    TILE_WIRE_JCIN25_ALU54,
    TILE_WIRE_JCIN26_ALU54,
    TILE_WIRE_JCIN27_ALU54,
    TILE_WIRE_JCIN28_ALU54,
    TILE_WIRE_JCIN29_ALU54,
    TILE_WIRE_JCIN30_ALU54,
    TILE_WIRE_JCIN31_ALU54,
    TILE_WIRE_JCIN32_ALU54,
    TILE_WIRE_JCIN33_ALU54,
    TILE_WIRE_JCIN34_ALU54,
    TILE_WIRE_JCIN35_ALU54,
    TILE_WIRE_JCIN36_ALU54,
    TILE_WIRE_JCIN37_ALU54,
    TILE_WIRE_JCIN38_ALU54,
    TILE_WIRE_JCIN39_ALU54,
    TILE_WIRE_JCIN40_ALU54,
    TILE_WIRE_JCIN41_ALU54,
    TILE_WIRE_JCIN42_ALU54,
    TILE_WIRE_JCIN43_ALU54,
    TILE_WIRE_JCIN44_ALU54,
    TILE_WIRE_JCIN45_ALU54,
    TILE_WIRE_JCIN46_ALU54,
    TILE_WIRE_JCIN47_ALU54,
    TILE_WIRE_JCIN48_ALU54,
    TILE_WIRE_JCIN49_ALU54,
    TILE_WIRE_JCIN50_ALU54,
    TILE_WIRE_JCIN51_ALU54,
    TILE_WIRE_JCIN52_ALU54,
    TILE_WIRE_JCIN53_ALU54,
    TILE_WIRE_JOP0_ALU54,
    TILE_WIRE_JOP1_ALU54,
    TILE_WIRE_JOP2_ALU54,
    TILE_WIRE_JOP3_ALU54,
    TILE_WIRE_JOP4_ALU54,
    TILE_WIRE_JOP5_ALU54,
    TILE_WIRE_JOP6_ALU54,
    TILE_WIRE_JOP7_ALU54,
    TILE_WIRE_JOP8_ALU54,
    TILE_WIRE_JOP9_ALU54,
    TILE_WIRE_JOP10_ALU54,
    TILE_WIRE_JR0_ALU54,
    TILE_WIRE_JR1_ALU54,
    TILE_WIRE_JR2_ALU54,
    TILE_WIRE_JR3_ALU54,
    TILE_WIRE_JR4_ALU54,
    TILE_WIRE_JR5_ALU54,
    TILE_WIRE_JR6_ALU54,
    TILE_WIRE_JR7_ALU54,
    TILE_WIRE_JR8_ALU54,
    TILE_WIRE_JR9_ALU54,
    TILE_WIRE_JR10_ALU54,
    TILE_WIRE_JR11_ALU54,
    TILE_WIRE_JR12_ALU54,
    TILE_WIRE_JR13_ALU54,
    TILE_WIRE_JR14_ALU54,
    TILE_WIRE_JR15_ALU54,
    TILE_WIRE_JR16_ALU54,
    TILE_WIRE_JR17_ALU54,
    TILE_WIRE_JR18_ALU54,
    TILE_WIRE_JR19_ALU54,
    TILE_WIRE_JR20_ALU54,
    TILE_WIRE_JR21_ALU54,
    TILE_WIRE_JR22_ALU54,
    TILE_WIRE_JR23_ALU54,
    TILE_WIRE_JR24_ALU54,
    TILE_WIRE_JR25_ALU54,
    TILE_WIRE_JR26_ALU54,
    TILE_WIRE_JR27_ALU54,
    TILE_WIRE_JR28_ALU54,
    TILE_WIRE_JR29_ALU54,
    TILE_WIRE_JR30_ALU54,
    TILE_WIRE_JR31_ALU54,
    TILE_WIRE_JR32_ALU54,
    TILE_WIRE_JR33_ALU54,
    TILE_WIRE_JR34_ALU54,
    TILE_WIRE_JR35_ALU54,
    TILE_WIRE_JR36_ALU54,
    TILE_WIRE_JR37_ALU54,
    TILE_WIRE_JR38_ALU54,
    TILE_WIRE_JR39_ALU54,
    TILE_WIRE_JR40_ALU54,
    TILE_WIRE_JR41_ALU54,
    TILE_WIRE_JR42_ALU54,
    TILE_WIRE_JR43_ALU54,
    TILE_WIRE_JR44_ALU54,
    TILE_WIRE_JR45_ALU54,
    TILE_WIRE_JR46_ALU54,
    TILE_WIRE_JR47_ALU54,
    TILE_WIRE_JR48_ALU54,
    TILE_WIRE_JR49_ALU54,
    TILE_WIRE_JR50_ALU54,
    TILE_WIRE_JR51_ALU54,
    TILE_WIRE_JR52_ALU54,
    TILE_WIRE_JR53_ALU54,
    TILE_WIRE_JCO0_ALU54,
    TILE_WIRE_JCO1_ALU54,
    TILE_WIRE_JCO2_ALU54,
    TILE_WIRE_JCO3_ALU54,
    TILE_WIRE_JCO4_ALU54,
    TILE_WIRE_JCO5_ALU54,
    TILE_WIRE_JCO6_ALU54,
    TILE_WIRE_JCO7_ALU54,
    TILE_WIRE_JCO8_ALU54,
    TILE_WIRE_JCO9_ALU54,
    TILE_WIRE_JCO10_ALU54,
    TILE_WIRE_JCO11_ALU54,
    TILE_WIRE_JCO12_ALU54,
    TILE_WIRE_JCO13_ALU54,
    TILE_WIRE_JCO14_ALU54,
    TILE_WIRE_JCO15_ALU54,
    TILE_WIRE_JCO16_ALU54,
    TILE_WIRE_JCO17_ALU54,
    TILE_WIRE_JCO18_ALU54,
    TILE_WIRE_JCO19_ALU54,
    TILE_WIRE_JCO20_ALU54,
    TILE_WIRE_JCO21_ALU54,
    TILE_WIRE_JCO22_ALU54,
    TILE_WIRE_JCO23_ALU54,
    TILE_WIRE_JCO24_ALU54,
    TILE_WIRE_JCO25_ALU54,
    TILE_WIRE_JCO26_ALU54,
    TILE_WIRE_JCO27_ALU54,
    TILE_WIRE_JCO28_ALU54,
    TILE_WIRE_JCO29_ALU54,
    TILE_WIRE_JCO30_ALU54,
    TILE_WIRE_JCO31_ALU54,
    TILE_WIRE_JCO32_ALU54,
    TILE_WIRE_JCO33_ALU54,
    TILE_WIRE_JCO34_ALU54,
    TILE_WIRE_JCO35_ALU54,
    TILE_WIRE_JCO36_ALU54,
    TILE_WIRE_JCO37_ALU54,
    TILE_WIRE_JCO38_ALU54,
    TILE_WIRE_JCO39_ALU54,
    TILE_WIRE_JCO40_ALU54,
    TILE_WIRE_JCO41_ALU54,
    TILE_WIRE_JCO42_ALU54,
    TILE_WIRE_JCO43_ALU54,
    TILE_WIRE_JCO44_ALU54,
    TILE_WIRE_JCO45_ALU54,
    TILE_WIRE_JCO46_ALU54,
    TILE_WIRE_JCO47_ALU54,
    TILE_WIRE_JCO48_ALU54,
    TILE_WIRE_JCO49_ALU54,
    TILE_WIRE_JCO50_ALU54,
    TILE_WIRE_JCO51_ALU54,
    TILE_WIRE_JCO52_ALU54,
    TILE_WIRE_JCO53_ALU54,
    TILE_WIRE_JEQZ_ALU54,
    TILE_WIRE_JEQZM_ALU54,
    TILE_WIRE_JEQOM_ALU54,
    TILE_WIRE_JEQPAT_ALU54,
    TILE_WIRE_JEQPATB_ALU54,
    TILE_WIRE_JOVER_ALU54,
    TILE_WIRE_JUNDER_ALU54,
    TILE_WIRE_JOVERUNDER_ALU54,
    TILE_WIRE_JSIGNEDR_ALU54,

    TILE_WIRE_JCE0,
    TILE_WIRE_JCE1,
    TILE_WIRE_JCE2,
    TILE_WIRE_JCE3,
    TILE_WIRE_JCLK0,
    TILE_WIRE_JCLK1,
    TILE_WIRE_JLSR0,
    TILE_WIRE_JLSR1,

    TILE_WIRE_JA0,
    TILE_WIRE_JA1,
    TILE_WIRE_JA2,
    TILE_WIRE_JA3,
    TILE_WIRE_JA4,
    TILE_WIRE_JA5,
    TILE_WIRE_JA6,
    TILE_WIRE_JA7,
    TILE_WIRE_JB0,
    TILE_WIRE_JB1,
    TILE_WIRE_JB2,
    TILE_WIRE_JB3,
    TILE_WIRE_JB4,
    TILE_WIRE_JB5,
    TILE_WIRE_JB6,
    TILE_WIRE_JB7,
    TILE_WIRE_JC0,
    TILE_WIRE_JC1,
    TILE_WIRE_JC2,
    TILE_WIRE_JC3,
    TILE_WIRE_JC4,
    TILE_WIRE_JC5,
    TILE_WIRE_JC6,
    TILE_WIRE_JC7,
    TILE_WIRE_JD0,
    TILE_WIRE_JD1,
    TILE_WIRE_JD2,
    TILE_WIRE_JD3,
    TILE_WIRE_JD4,
    TILE_WIRE_JD5,
    TILE_WIRE_JD6,
    TILE_WIRE_JD7,
    TILE_WIRE_JM0,
    TILE_WIRE_JM1,
    TILE_WIRE_JM2,
    TILE_WIRE_JM3,
    TILE_WIRE_JM4,
    TILE_WIRE_JM5,
    TILE_WIRE_JM6,
    TILE_WIRE_JM7,
    TILE_WIRE_JF0,
    TILE_WIRE_JF1,
    TILE_WIRE_JF2,
    TILE_WIRE_JF3,
    TILE_WIRE_JF4,
    TILE_WIRE_JF5,
    TILE_WIRE_JF6,
    TILE_WIRE_JF7,
    TILE_WIRE_JQ0,
    TILE_WIRE_JQ1,
    TILE_WIRE_JQ2,
    TILE_WIRE_JQ3,
    TILE_WIRE_JQ4,
    TILE_WIRE_JQ5,
    TILE_WIRE_JQ6,
    TILE_WIRE_JQ7,

    TILE_WIRE_DDRDEL_DDRDLL,
    TILE_WIRE_JRST_DDRDLL,
    TILE_WIRE_JCLK_DDRDLL,
    TILE_WIRE_JUDDCNTLN_DDRDLL,
    TILE_WIRE_JFREEZE_DDRDLL,
    TILE_WIRE_JLOCK_DDRDLL,
    TILE_WIRE_JDIVOSC_DDRDLL,
    TILE_WIRE_JDCNTL0_DDRDLL,
    TILE_WIRE_JDCNTL1_DDRDLL,
    TILE_WIRE_JDCNTL2_DDRDLL,
    TILE_WIRE_JDCNTL3_DDRDLL,
    TILE_WIRE_JDCNTL4_DDRDLL,
    TILE_WIRE_JDCNTL5_DDRDLL,
    TILE_WIRE_JDCNTL6_DDRDLL,
    TILE_WIRE_JDCNTL7_DDRDLL,

    TILE_WIRE_JPADDI_CCLK,
    TILE_WIRE_JPADDO_CCLK,
    TILE_WIRE_JPADDT_CCLK,

    TILE_WIRE_REFCLKP_EXTREF,
    TILE_WIRE_REFCLKN_EXTREF,
    TILE_WIRE_JREFCLKO_EXTREF,

    TILE_WIRE_CH0_RX_REFCLK_DCU,
    TILE_WIRE_CH1_RX_REFCLK_DCU,
    TILE_WIRE_D_REFCLKI_DCU,
    TILE_WIRE_JD_SYNC_PULSE2ND_DCU,
    TILE_WIRE_JD_TXBIT_CLKN_TO_ND_DCU,
    TILE_WIRE_JD_TXBIT_CLKP_TO_ND_DCU,
    TILE_WIRE_JD_TXPLL_LOL_TO_ND_DCU,
    TILE_WIRE_JCH0_FF_RX_PCLK_DCU,
    TILE_WIRE_JCH1_FF_RX_PCLK_DCU,
    TILE_WIRE_JCH0_FF_TX_PCLK_DCU,
    TILE_WIRE_JCH1_FF_TX_PCLK_DCU,
    TILE_WIRE_JCH0_FFC_CDR_EN_BITSLIP_DCU,
    TILE_WIRE_JCH0_FFC_DIV11_MODE_RX_DCU,
    TILE_WIRE_JCH0_FFC_DIV11_MODE_TX_DCU,
    TILE_WIRE_JCH0_FFC_EI_EN_DCU,
    TILE_WIRE_JCH0_FFC_ENABLE_CGALIGN_DCU,
    TILE_WIRE_JCH0_FFC_FB_LOOPBACK_DCU,
    TILE_WIRE_JCH0_FFC_LANE_RX_RST_DCU,
    TILE_WIRE_JCH0_FFC_LANE_TX_RST_DCU,
    TILE_WIRE_JCH0_FFC_LDR_CORE2TX_EN_DCU,
    TILE_WIRE_JCH0_FFC_PCIE_CT_DCU,
    TILE_WIRE_JCH0_FFC_PCIE_DET_EN_DCU,
    TILE_WIRE_JCH0_FFC_PFIFO_CLR_DCU,
    TILE_WIRE_JCH0_FFC_RATE_MODE_RX_DCU,
    TILE_WIRE_JCH0_FFC_RATE_MODE_TX_DCU,
    TILE_WIRE_JCH0_FFC_RRST_DCU,
    TILE_WIRE_JCH0_FFC_RXPWDNB_DCU,
    TILE_WIRE_JCH0_FFC_RX_GEAR_MODE_DCU,
    TILE_WIRE_JCH0_FFC_SB_INV_RX_DCU,
    TILE_WIRE_JCH0_FFC_SB_PFIFO_LP_DCU,
    TILE_WIRE_JCH0_FFC_SIGNAL_DETECT_DCU,
    TILE_WIRE_JCH0_FFC_TXPWDNB_DCU,
    TILE_WIRE_JCH0_FFC_TX_GEAR_MODE_DCU,
    TILE_WIRE_JCH0_FF_EBRD_CLK_DCU,
    TILE_WIRE_JCH0_FF_RXI_CLK_DCU,
    TILE_WIRE_JCH0_FF_TXI_CLK_DCU,
    TILE_WIRE_JCH0_FF_TX_D_0_DCU,
    TILE_WIRE_JCH0_FF_TX_D_10_DCU,
    TILE_WIRE_JCH0_FF_TX_D_11_DCU,
    TILE_WIRE_JCH0_FF_TX_D_12_DCU,
    TILE_WIRE_JCH0_FF_TX_D_13_DCU,
    TILE_WIRE_JCH0_FF_TX_D_14_DCU,
    TILE_WIRE_JCH0_FF_TX_D_15_DCU,
    TILE_WIRE_JCH0_FF_TX_D_16_DCU,
    TILE_WIRE_JCH0_FF_TX_D_17_DCU,
    TILE_WIRE_JCH0_FF_TX_D_18_DCU,
    TILE_WIRE_JCH0_FF_TX_D_19_DCU,
    TILE_WIRE_JCH0_FF_TX_D_1_DCU,
    TILE_WIRE_JCH0_FF_TX_D_20_DCU,
    TILE_WIRE_JCH0_FF_TX_D_21_DCU,
    TILE_WIRE_JCH0_FF_TX_D_22_DCU,
    TILE_WIRE_JCH0_FF_TX_D_23_DCU,
    TILE_WIRE_JCH0_FF_TX_D_2_DCU,
    TILE_WIRE_JCH0_FF_TX_D_3_DCU,
    TILE_WIRE_JCH0_FF_TX_D_4_DCU,
    TILE_WIRE_JCH0_FF_TX_D_5_DCU,
    TILE_WIRE_JCH0_FF_TX_D_6_DCU,
    TILE_WIRE_JCH0_FF_TX_D_7_DCU,
    TILE_WIRE_JCH0_FF_TX_D_8_DCU,
    TILE_WIRE_JCH0_FF_TX_D_9_DCU,
    TILE_WIRE_JCH0_HDINN_DCU,
    TILE_WIRE_JCH0_HDINP_DCU,
    TILE_WIRE_JCH0_LDR_CORE2TX_DCU,
    TILE_WIRE_JCH0_SCIEN_DCU,
    TILE_WIRE_JCH0_SCISEL_DCU,
    TILE_WIRE_JCH1_FFC_CDR_EN_BITSLIP_DCU,
    TILE_WIRE_JCH1_FFC_DIV11_MODE_RX_DCU,
    TILE_WIRE_JCH1_FFC_DIV11_MODE_TX_DCU,
    TILE_WIRE_JCH1_FFC_EI_EN_DCU,
    TILE_WIRE_JCH1_FFC_ENABLE_CGALIGN_DCU,
    TILE_WIRE_JCH1_FFC_FB_LOOPBACK_DCU,
    TILE_WIRE_JCH1_FFC_LANE_RX_RST_DCU,
    TILE_WIRE_JCH1_FFC_LANE_TX_RST_DCU,
    TILE_WIRE_JCH1_FFC_LDR_CORE2TX_EN_DCU,
    TILE_WIRE_JCH1_FFC_PCIE_CT_DCU,
    TILE_WIRE_JCH1_FFC_PCIE_DET_EN_DCU,
    TILE_WIRE_JCH1_FFC_PFIFO_CLR_DCU,
    TILE_WIRE_JCH1_FFC_RATE_MODE_RX_DCU,
    TILE_WIRE_JCH1_FFC_RATE_MODE_TX_DCU,
    TILE_WIRE_JCH1_FFC_RRST_DCU,
    TILE_WIRE_JCH1_FFC_RXPWDNB_DCU,
    TILE_WIRE_JCH1_FFC_RX_GEAR_MODE_DCU,
    TILE_WIRE_JCH1_FFC_SB_INV_RX_DCU,
    TILE_WIRE_JCH1_FFC_SB_PFIFO_LP_DCU,
    TILE_WIRE_JCH1_FFC_SIGNAL_DETECT_DCU,
    TILE_WIRE_JCH1_FFC_TXPWDNB_DCU,
    TILE_WIRE_JCH1_FFC_TX_GEAR_MODE_DCU,
    TILE_WIRE_JCH1_FF_EBRD_CLK_DCU,
    TILE_WIRE_JCH1_FF_RXI_CLK_DCU,
    TILE_WIRE_JCH1_FF_TXI_CLK_DCU,
    TILE_WIRE_JCH1_FF_TX_D_0_DCU,
    TILE_WIRE_JCH1_FF_TX_D_10_DCU,
    TILE_WIRE_JCH1_FF_TX_D_11_DCU,
    TILE_WIRE_JCH1_FF_TX_D_12_DCU,
    TILE_WIRE_JCH1_FF_TX_D_13_DCU,
    TILE_WIRE_JCH1_FF_TX_D_14_DCU,
    TILE_WIRE_JCH1_FF_TX_D_15_DCU,
    TILE_WIRE_JCH1_FF_TX_D_16_DCU,
    TILE_WIRE_JCH1_FF_TX_D_17_DCU,
    TILE_WIRE_JCH1_FF_TX_D_18_DCU,
    TILE_WIRE_JCH1_FF_TX_D_19_DCU,
    TILE_WIRE_JCH1_FF_TX_D_1_DCU,
    TILE_WIRE_JCH1_FF_TX_D_20_DCU,
    TILE_WIRE_JCH1_FF_TX_D_21_DCU,
    TILE_WIRE_JCH1_FF_TX_D_22_DCU,
    TILE_WIRE_JCH1_FF_TX_D_23_DCU,
    TILE_WIRE_JCH1_FF_TX_D_2_DCU,
    TILE_WIRE_JCH1_FF_TX_D_3_DCU,
    TILE_WIRE_JCH1_FF_TX_D_4_DCU,
    TILE_WIRE_JCH1_FF_TX_D_5_DCU,
    TILE_WIRE_JCH1_FF_TX_D_6_DCU,
    TILE_WIRE_JCH1_FF_TX_D_7_DCU,
    TILE_WIRE_JCH1_FF_TX_D_8_DCU,
    TILE_WIRE_JCH1_FF_TX_D_9_DCU,
    TILE_WIRE_JCH1_HDINN_DCU,
    TILE_WIRE_JCH1_HDINP_DCU,
    TILE_WIRE_JCH1_LDR_CORE2TX_DCU,
    TILE_WIRE_JCH1_SCIEN_DCU,
    TILE_WIRE_JCH1_SCISEL_DCU,
    TILE_WIRE_JD_CIN0_DCU,
    TILE_WIRE_JD_CIN10_DCU,
    TILE_WIRE_JD_CIN11_DCU,
    TILE_WIRE_JD_CIN1_DCU,
    TILE_WIRE_JD_CIN2_DCU,
    TILE_WIRE_JD_CIN3_DCU,
    TILE_WIRE_JD_CIN4_DCU,
    TILE_WIRE_JD_CIN5_DCU,
    TILE_WIRE_JD_CIN6_DCU,
    TILE_WIRE_JD_CIN7_DCU,
    TILE_WIRE_JD_CIN8_DCU,
    TILE_WIRE_JD_CIN9_DCU,
    TILE_WIRE_JD_CYAWSTN_DCU,
    TILE_WIRE_JD_FFC_DUAL_RST_DCU,
    TILE_WIRE_JD_FFC_MACROPDB_DCU,
    TILE_WIRE_JD_FFC_MACRO_RST_DCU,
    TILE_WIRE_JD_FFC_SYNC_TOGGLE_DCU,
    TILE_WIRE_JD_FFC_TRST_DCU,
    TILE_WIRE_JD_SCAN_ENABLE_DCU,
    TILE_WIRE_JD_SCAN_IN_0_DCU,
    TILE_WIRE_JD_SCAN_IN_1_DCU,
    TILE_WIRE_JD_SCAN_IN_2_DCU,
    TILE_WIRE_JD_SCAN_IN_3_DCU,
    TILE_WIRE_JD_SCAN_IN_4_DCU,
    TILE_WIRE_JD_SCAN_IN_5_DCU,
    TILE_WIRE_JD_SCAN_IN_6_DCU,
    TILE_WIRE_JD_SCAN_IN_7_DCU,
    TILE_WIRE_JD_SCAN_MODE_DCU,
    TILE_WIRE_JD_SCAN_RESET_DCU,
    TILE_WIRE_JD_SCIADDR0_DCU,
    TILE_WIRE_JD_SCIADDR1_DCU,
    TILE_WIRE_JD_SCIADDR2_DCU,
    TILE_WIRE_JD_SCIADDR3_DCU,
    TILE_WIRE_JD_SCIADDR4_DCU,
    TILE_WIRE_JD_SCIADDR5_DCU,
    TILE_WIRE_JD_SCIENAUX_DCU,
    TILE_WIRE_JD_SCIRD_DCU,
    TILE_WIRE_JD_SCISELAUX_DCU,
    TILE_WIRE_JD_SCIWDATA0_DCU,
    TILE_WIRE_JD_SCIWDATA1_DCU,
    TILE_WIRE_JD_SCIWDATA2_DCU,
    TILE_WIRE_JD_SCIWDATA3_DCU,
    TILE_WIRE_JD_SCIWDATA4_DCU,
    TILE_WIRE_JD_SCIWDATA5_DCU,
    TILE_WIRE_JD_SCIWDATA6_DCU,
    TILE_WIRE_JD_SCIWDATA7_DCU,
    TILE_WIRE_JD_SCIWSTN_DCU,
    TILE_WIRE_JCH0_HDOUTN_DCU,
    TILE_WIRE_JCH1_HDOUTN_DCU,
    TILE_WIRE_JCH0_HDOUTP_DCU,
    TILE_WIRE_JCH1_HDOUTP_DCU,
    TILE_WIRE_JCH1_FF_RX_D_16_DCU,
    TILE_WIRE_JCH1_FF_RX_D_17_DCU,
    TILE_WIRE_JCH1_FF_RX_D_18_DCU,
    TILE_WIRE_JCH1_FF_RX_D_19_DCU,
    TILE_WIRE_JCH1_FF_RX_D_20_DCU,
    TILE_WIRE_JCH1_FF_RX_D_21_DCU,
    TILE_WIRE_JCH1_FF_RX_D_22_DCU,
    TILE_WIRE_JCH1_FF_RX_D_23_DCU,
    TILE_WIRE_JCH1_FFS_SKP_DELETED_DCU,
    TILE_WIRE_JCH1_FFS_SKP_ADDED_DCU,
    TILE_WIRE_JCH1_LDR_RX2CORE_DCU,
    TILE_WIRE_JD_SCAN_OUT_7_DCU,
    TILE_WIRE_JCH1_FFS_TXFBFIFO_ERROR_DCU,
    TILE_WIRE_JCH1_FFS_PCIE_CON_DCU,
    TILE_WIRE_JCH1_FFS_PCIE_DONE_DCU,
    TILE_WIRE_JD_SCAN_OUT_3_DCU,
    TILE_WIRE_JD_COUT1_DCU,
    TILE_WIRE_JD_SCAN_OUT_0_DCU,
    TILE_WIRE_JD_FFS_PLOL_DCU,
    TILE_WIRE_JCH0_FF_RX_D_0_DCU,
    TILE_WIRE_JCH0_FF_RX_D_1_DCU,
    TILE_WIRE_JCH0_FF_RX_D_2_DCU,
    TILE_WIRE_JCH0_FF_RX_D_3_DCU,
    TILE_WIRE_JCH0_FF_RX_D_4_DCU,
    TILE_WIRE_JCH0_FF_RX_D_5_DCU,
    TILE_WIRE_JCH0_FF_RX_D_6_DCU,
    TILE_WIRE_JCH0_FF_RX_D_7_DCU,
    TILE_WIRE_JCH0_FFS_CC_OVERRUN_DCU,
    TILE_WIRE_JCH0_FFS_RLOL_DCU,
    TILE_WIRE_JCH0_FF_RX_D_8_DCU,
    TILE_WIRE_JCH0_FF_RX_D_9_DCU,
    TILE_WIRE_JCH0_FF_RX_D_10_DCU,
    TILE_WIRE_JCH0_FF_RX_D_11_DCU,
    TILE_WIRE_JCH0_FF_RX_D_12_DCU,
    TILE_WIRE_JCH0_FF_RX_D_13_DCU,
    TILE_WIRE_JCH0_FF_RX_D_14_DCU,
    TILE_WIRE_JCH0_FF_RX_D_15_DCU,
    TILE_WIRE_JCH0_FFS_RLOS_DCU,
    TILE_WIRE_JCH0_FFS_LS_SYNC_STATUS_DCU,
    TILE_WIRE_JCH0_FF_RX_D_16_DCU,
    TILE_WIRE_JCH0_FF_RX_D_17_DCU,
    TILE_WIRE_JCH0_FF_RX_D_18_DCU,
    TILE_WIRE_JCH0_FF_RX_D_19_DCU,
    TILE_WIRE_JCH0_FF_RX_D_20_DCU,
    TILE_WIRE_JCH0_FF_RX_D_21_DCU,
    TILE_WIRE_JCH0_FF_RX_D_22_DCU,
    TILE_WIRE_JCH0_FF_RX_D_23_DCU,
    TILE_WIRE_JCH0_FF_RX_F_CLK_DCU,
    TILE_WIRE_JCH0_FF_RX_H_CLK_DCU,
    TILE_WIRE_JD_COUT19_DCU,
    TILE_WIRE_JD_COUT16_DCU,
    TILE_WIRE_JD_COUT6_DCU,
    TILE_WIRE_JD_COUT7_DCU,
    TILE_WIRE_JD_COUT8_DCU,
    TILE_WIRE_JD_COUT9_DCU,
    TILE_WIRE_JD_COUT10_DCU,
    TILE_WIRE_JD_COUT17_DCU,
    TILE_WIRE_JD_COUT18_DCU,
    TILE_WIRE_JCH0_FFS_CC_UNDERRUN_DCU,
    TILE_WIRE_JCH0_FFS_RXFBFIFO_ERROR_DCU,
    TILE_WIRE_JD_COUT11_DCU,
    TILE_WIRE_JD_COUT12_DCU,
    TILE_WIRE_JD_COUT13_DCU,
    TILE_WIRE_JD_COUT14_DCU,
    TILE_WIRE_JD_COUT15_DCU,
    TILE_WIRE_JD_COUT0_DCU,
    TILE_WIRE_JD_COUT2_DCU,
    TILE_WIRE_JD_COUT3_DCU,
    TILE_WIRE_JD_COUT4_DCU,
    TILE_WIRE_JD_COUT5_DCU,
    TILE_WIRE_JD_SCAN_OUT_6_DCU,
    TILE_WIRE_JD_SCIINT_DCU,
    TILE_WIRE_JD_SCIRDATA0_DCU,
    TILE_WIRE_JD_SCIRDATA1_DCU,
    TILE_WIRE_JD_SCIRDATA2_DCU,
    TILE_WIRE_JD_SCIRDATA3_DCU,
    TILE_WIRE_JD_SCIRDATA4_DCU,
    TILE_WIRE_JD_SCIRDATA5_DCU,
    TILE_WIRE_JD_SCIRDATA6_DCU,
    TILE_WIRE_JD_SCIRDATA7_DCU,
    TILE_WIRE_JCH1_FF_RX_F_CLK_DCU,
    TILE_WIRE_JCH1_FF_RX_H_CLK_DCU,
    TILE_WIRE_JCH1_FFS_RXFBFIFO_ERROR_DCU,
    TILE_WIRE_JCH1_FFS_CC_UNDERRUN_DCU,
    TILE_WIRE_JCH1_FFS_LS_SYNC_STATUS_DCU,
    TILE_WIRE_JCH1_FFS_RLOS_DCU,
    TILE_WIRE_JCH1_FFS_RLOL_DCU,
    TILE_WIRE_JCH1_FFS_CC_OVERRUN_DCU,
    TILE_WIRE_JD_SCAN_OUT_4_DCU,
    TILE_WIRE_JCH1_FF_TX_F_CLK_DCU,
    TILE_WIRE_JCH1_FF_TX_H_CLK_DCU,
    TILE_WIRE_JCH1_FF_RX_D_0_DCU,
    TILE_WIRE_JCH1_FF_RX_D_1_DCU,
    TILE_WIRE_JCH1_FF_RX_D_2_DCU,
    TILE_WIRE_JCH1_FF_RX_D_3_DCU,
    TILE_WIRE_JCH1_FF_RX_D_4_DCU,
    TILE_WIRE_JCH1_FF_RX_D_5_DCU,
    TILE_WIRE_JCH1_FF_RX_D_6_DCU,
    TILE_WIRE_JCH1_FF_RX_D_7_DCU,
    TILE_WIRE_JCH1_FF_RX_D_8_DCU,
    TILE_WIRE_JCH1_FF_RX_D_9_DCU,
    TILE_WIRE_JCH1_FF_RX_D_10_DCU,
    TILE_WIRE_JCH1_FF_RX_D_11_DCU,
    TILE_WIRE_JCH1_FF_RX_D_12_DCU,
    TILE_WIRE_JCH1_FF_RX_D_13_DCU,
    TILE_WIRE_JCH1_FF_RX_D_14_DCU,
    TILE_WIRE_JCH1_FF_RX_D_15_DCU,
    TILE_WIRE_JD_SCAN_OUT_1_DCU,
    TILE_WIRE_JCH0_FFS_PCIE_DONE_DCU,
    TILE_WIRE_JCH0_FFS_PCIE_CON_DCU,
    TILE_WIRE_JD_SCAN_OUT_2_DCU,
    TILE_WIRE_JCH0_FFS_TXFBFIFO_ERROR_DCU,
    TILE_WIRE_JD_SCAN_OUT_5_DCU,
    TILE_WIRE_JCH0_LDR_RX2CORE_DCU,
    TILE_WIRE_JCH0_FFS_SKP_ADDED_DCU,
    TILE_WIRE_JCH0_FF_TX_H_CLK_DCU,
    TILE_WIRE_JCH0_FF_TX_F_CLK_DCU,
    TILE_WIRE_JCH0_FFS_SKP_DELETED_DCU,

    TILE_WIRE_G_CLKI_BDCC0,
    TILE_WIRE_G_JCE_BDCC0,
    TILE_WIRE_G_CLKO_BDCC0,
    TILE_WIRE_G_CLKI_BDCC1,
    TILE_WIRE_G_JCE_BDCC1,
    TILE_WIRE_G_CLKO_BDCC1,
    TILE_WIRE_G_CLKI_BDCC2,
    TILE_WIRE_G_JCE_BDCC2,
    TILE_WIRE_G_CLKO_BDCC2,
    TILE_WIRE_G_CLKI_BDCC3,
    TILE_WIRE_G_JCE_BDCC3,
    TILE_WIRE_G_CLKO_BDCC3,
    TILE_WIRE_G_CLKI_BDCC4,
    TILE_WIRE_G_JCE_BDCC4,
    TILE_WIRE_G_CLKO_BDCC4,
    TILE_WIRE_G_CLKI_BDCC5,
    TILE_WIRE_G_JCE_BDCC5,
    TILE_WIRE_G_CLKO_BDCC5,
    TILE_WIRE_G_CLKI_BDCC6,
    TILE_WIRE_G_JCE_BDCC6,
    TILE_WIRE_G_CLKO_BDCC6,
    TILE_WIRE_G_CLKI_BDCC7,
    TILE_WIRE_G_JCE_BDCC7,
    TILE_WIRE_G_CLKO_BDCC7,
    TILE_WIRE_G_CLKI_BDCC8,
    TILE_WIRE_G_JCE_BDCC8,
    TILE_WIRE_G_CLKO_BDCC8,
    TILE_WIRE_G_CLKI_BDCC9,
    TILE_WIRE_G_JCE_BDCC9,
    TILE_WIRE_G_CLKO_BDCC9,
    TILE_WIRE_G_CLKI_BDCC10,
    TILE_WIRE_G_JCE_BDCC10,
    TILE_WIRE_G_CLKO_BDCC10,
    TILE_WIRE_G_CLKI_BDCC11,
    TILE_WIRE_G_JCE_BDCC11,
    TILE_WIRE_G_CLKO_BDCC11,
    TILE_WIRE_G_CLKI_BDCC12,
    TILE_WIRE_G_JCE_BDCC12,
    TILE_WIRE_G_CLKO_BDCC12,
    TILE_WIRE_G_CLKI_BDCC13,
    TILE_WIRE_G_JCE_BDCC13,
    TILE_WIRE_G_CLKO_BDCC13,
    TILE_WIRE_G_CLKI_BDCC14,
    TILE_WIRE_G_JCE_BDCC14,
    TILE_WIRE_G_CLKO_BDCC14,
    TILE_WIRE_G_CLKI_BDCC15,
    TILE_WIRE_G_JCE_BDCC15,
    TILE_WIRE_G_CLKO_BDCC15,

    TILE_WIRE_G_CLKI_TDCC0,
    TILE_WIRE_G_JCE_TDCC0,
    TILE_WIRE_G_CLKO_TDCC0,
    TILE_WIRE_G_CLKI_TDCC1,
    TILE_WIRE_G_JCE_TDCC1,
    TILE_WIRE_G_CLKO_TDCC1,
    TILE_WIRE_G_CLKI_TDCC2,
    TILE_WIRE_G_JCE_TDCC2,
    TILE_WIRE_G_CLKO_TDCC2,
    TILE_WIRE_G_CLKI_TDCC3,
    TILE_WIRE_G_JCE_TDCC3,
    TILE_WIRE_G_CLKO_TDCC3,
    TILE_WIRE_G_CLKI_TDCC4,
    TILE_WIRE_G_JCE_TDCC4,
    TILE_WIRE_G_CLKO_TDCC4,
    TILE_WIRE_G_CLKI_TDCC5,
    TILE_WIRE_G_JCE_TDCC5,
    TILE_WIRE_G_CLKO_TDCC5,
    TILE_WIRE_G_CLKI_TDCC6,
    TILE_WIRE_G_JCE_TDCC6,
    TILE_WIRE_G_CLKO_TDCC6,
    TILE_WIRE_G_CLKI_TDCC7,
    TILE_WIRE_G_JCE_TDCC7,
    TILE_WIRE_G_CLKO_TDCC7,
    TILE_WIRE_G_CLKI_TDCC8,
    TILE_WIRE_G_JCE_TDCC8,
    TILE_WIRE_G_CLKO_TDCC8,
    TILE_WIRE_G_CLKI_TDCC9,
    TILE_WIRE_G_JCE_TDCC9,
    TILE_WIRE_G_CLKO_TDCC9,
    TILE_WIRE_G_CLKI_TDCC10,
    TILE_WIRE_G_JCE_TDCC10,
    TILE_WIRE_G_CLKO_TDCC10,
    TILE_WIRE_G_CLKI_TDCC11,
    TILE_WIRE_G_JCE_TDCC11,
    TILE_WIRE_G_CLKO_TDCC11,

    TILE_WIRE_G_CLKI_RDCC0,
    TILE_WIRE_G_JCE_RDCC0,
    TILE_WIRE_G_CLKO_RDCC0,
    TILE_WIRE_G_CLKI_RDCC1,
    TILE_WIRE_G_JCE_RDCC1,
    TILE_WIRE_G_CLKO_RDCC1,
    TILE_WIRE_G_CLKI_RDCC2,
    TILE_WIRE_G_JCE_RDCC2,
    TILE_WIRE_G_CLKO_RDCC2,
    TILE_WIRE_G_CLKI_RDCC3,
    TILE_WIRE_G_JCE_RDCC3,
    TILE_WIRE_G_CLKO_RDCC3,
    TILE_WIRE_G_CLKI_RDCC4,
    TILE_WIRE_G_JCE_RDCC4,
    TILE_WIRE_G_CLKO_RDCC4,
    TILE_WIRE_G_CLKI_RDCC5,
    TILE_WIRE_G_JCE_RDCC5,
    TILE_WIRE_G_CLKO_RDCC5,
    TILE_WIRE_G_CLKI_RDCC6,
    TILE_WIRE_G_JCE_RDCC6,
    TILE_WIRE_G_CLKO_RDCC6,
    TILE_WIRE_G_CLKI_RDCC7,
    TILE_WIRE_G_JCE_RDCC7,
    TILE_WIRE_G_CLKO_RDCC7,
    TILE_WIRE_G_CLKI_RDCC8,
    TILE_WIRE_G_JCE_RDCC8,
    TILE_WIRE_G_CLKO_RDCC8,
    TILE_WIRE_G_CLKI_RDCC9,
    TILE_WIRE_G_JCE_RDCC9,
    TILE_WIRE_G_CLKO_RDCC9,
    TILE_WIRE_G_CLKI_RDCC10,
    TILE_WIRE_G_JCE_RDCC10,
    TILE_WIRE_G_CLKO_RDCC10,
    TILE_WIRE_G_CLKI_RDCC11,
    TILE_WIRE_G_JCE_RDCC11,
    TILE_WIRE_G_CLKO_RDCC11,
    TILE_WIRE_G_CLKI_RDCC12,
    TILE_WIRE_G_JCE_RDCC12,
    TILE_WIRE_G_CLKO_RDCC12,
    TILE_WIRE_G_CLKI_RDCC13,
    TILE_WIRE_G_JCE_RDCC13,
    TILE_WIRE_G_CLKO_RDCC13,

    TILE_WIRE_G_CLKI_LDCC0,
    TILE_WIRE_G_JCE_LDCC0,
    TILE_WIRE_G_CLKO_LDCC0,
    TILE_WIRE_G_CLKI_LDCC1,
    TILE_WIRE_G_JCE_LDCC1,
    TILE_WIRE_G_CLKO_LDCC1,
    TILE_WIRE_G_CLKI_LDCC2,
    TILE_WIRE_G_JCE_LDCC2,
    TILE_WIRE_G_CLKO_LDCC2,
    TILE_WIRE_G_CLKI_LDCC3,
    TILE_WIRE_G_JCE_LDCC3,
    TILE_WIRE_G_CLKO_LDCC3,
    TILE_WIRE_G_CLKI_LDCC4,
    TILE_WIRE_G_JCE_LDCC4,
    TILE_WIRE_G_CLKO_LDCC4,
    TILE_WIRE_G_CLKI_LDCC5,
    TILE_WIRE_G_JCE_LDCC5,
    TILE_WIRE_G_CLKO_LDCC5,
    TILE_WIRE_G_CLKI_LDCC6,
    TILE_WIRE_G_JCE_LDCC6,
    TILE_WIRE_G_CLKO_LDCC6,
    TILE_WIRE_G_CLKI_LDCC7,
    TILE_WIRE_G_JCE_LDCC7,
    TILE_WIRE_G_CLKO_LDCC7,
    TILE_WIRE_G_CLKI_LDCC8,
    TILE_WIRE_G_JCE_LDCC8,
    TILE_WIRE_G_CLKO_LDCC8,
    TILE_WIRE_G_CLKI_LDCC9,
    TILE_WIRE_G_JCE_LDCC9,
    TILE_WIRE_G_CLKO_LDCC9,
    TILE_WIRE_G_CLKI_LDCC10,
    TILE_WIRE_G_JCE_LDCC10,
    TILE_WIRE_G_CLKO_LDCC10,
    TILE_WIRE_G_CLKI_LDCC11,
    TILE_WIRE_G_JCE_LDCC11,
    TILE_WIRE_G_CLKO_LDCC11,
    TILE_WIRE_G_CLKI_LDCC12,
    TILE_WIRE_G_JCE_LDCC12,
    TILE_WIRE_G_CLKO_LDCC12,
    TILE_WIRE_G_CLKI_LDCC13,
    TILE_WIRE_G_JCE_LDCC13,
    TILE_WIRE_G_CLKO_LDCC13,

    TILE_WIRE_CLKI_PLL,
    TILE_WIRE_JRST_PLL,
    TILE_WIRE_JLOCK_PLL,
    TILE_WIRE_CLKFB_PLL,
    TILE_WIRE_CLKINTFB_PLL,
    TILE_WIRE_JREFCLK_PLL,
    TILE_WIRE_JSTDBY_PLL,
    TILE_WIRE_JPHASEDIR_PLL,
    TILE_WIRE_JPHASELOADREG_PLL,
    TILE_WIRE_JPHASESEL0_PLL,
    TILE_WIRE_JPHASESEL1_PLL,
    TILE_WIRE_JPHASESTEP_PLL,
    TILE_WIRE_JPLLWAKESYNC_PLL,
    TILE_WIRE_JENCLKOP_PLL,
    TILE_WIRE_JENCLKOS2_PLL,
    TILE_WIRE_JENCLKOS3_PLL,
    TILE_WIRE_JENCLKOS_PLL,
    TILE_WIRE_JINTLOCK_PLL,
    TILE_WIRE_JCLKOP_PLL,
    TILE_WIRE_JCLKOS_PLL,
    TILE_WIRE_JCLKOS2_PLL,
    TILE_WIRE_JCLKOS3_PLL,

    TILE_WIRE_SEDSTDBY_SED,
    TILE_WIRE_JSEDENABLE_SED,
    TILE_WIRE_JSEDEXCLK_SED,
    TILE_WIRE_JSEDSTART_SED,
    TILE_WIRE_JSEDFRCERR_SED,
    TILE_WIRE_JSEDDONE_SED,
    TILE_WIRE_JSEDINPROG_SED,
    TILE_WIRE_JAUTODONE_SED,
    TILE_WIRE_JSEDERR_SED,

    TILE_WIRE_SEDSTDBY_OSC,

    TILE_WIRE_JJCE1_JTAG,
    TILE_WIRE_JJCE2_JTAG,
    TILE_WIRE_JTCK_JTAG,
    TILE_WIRE_JTMS_JTAG,
    TILE_WIRE_JTDI_JTAG,
    TILE_WIRE_JJTDO2_JTAG,
    TILE_WIRE_JJTDO1_JTAG,
    TILE_WIRE_JTDO_JTAG,
    TILE_WIRE_JJTDI_JTAG,
    TILE_WIRE_JJTCK_JTAG,
    TILE_WIRE_JJRTI2_JTAG,
    TILE_WIRE_JJRTI1_JTAG,
    TILE_WIRE_JJSHIFT_JTAG,
    TILE_WIRE_JJUPDATE_JTAG,
    TILE_WIRE_JJRSTN_JTAG,

    TILE_WIRE_JCLK_GSR,
    TILE_WIRE_JGSR_GSR,

    TILE_WIRE_JSTARTPULSE_DTR,
    TILE_WIRE_JDTROUT0_DTR,
    TILE_WIRE_JDTROUT1_DTR,
    TILE_WIRE_JDTROUT2_DTR,
    TILE_WIRE_JDTROUT3_DTR,
    TILE_WIRE_JDTROUT4_DTR,
    TILE_WIRE_JDTROUT5_DTR,
    TILE_WIRE_JDTROUT6_DTR,
    TILE_WIRE_JDTROUT7_DTR,

    TILE_WIRE_CLKI_PCSCLKDIV1,
    TILE_WIRE_JRST_PCSCLKDIV1,
    TILE_WIRE_CDIVX_PCSCLKDIV1,
    TILE_WIRE_JSEL0_PCSCLKDIV1,
    TILE_WIRE_JSEL1_PCSCLKDIV1,
    TILE_WIRE_JSEL2_PCSCLKDIV1,
    TILE_WIRE_CDIV1_PCSCLKDIV1,

    TILE_WIRE_CLKI_PCSCLKDIV0,
    TILE_WIRE_JRST_PCSCLKDIV0,
    TILE_WIRE_CDIVX_PCSCLKDIV0,
    TILE_WIRE_JSEL0_PCSCLKDIV0,
    TILE_WIRE_JSEL1_PCSCLKDIV0,
    TILE_WIRE_JSEL2_PCSCLKDIV0,
    TILE_WIRE_CDIV1_PCSCLKDIV0,

    TILE_WIRE_JDIA,
    TILE_WIRE_JDIB,
    TILE_WIRE_JDIC,
    TILE_WIRE_JDID,
    TILE_WIRE_JPADDOA,
    TILE_WIRE_JPADDOB,
    TILE_WIRE_JPADDOC,
    TILE_WIRE_JPADDOD,
    TILE_WIRE_JPADDTA,
    TILE_WIRE_JPADDTB,
    TILE_WIRE_JPADDTC,
    TILE_WIRE_JPADDTD,
    TILE_WIRE_IOLDOA,
    TILE_WIRE_IOLDOB,
    TILE_WIRE_IOLDOC,
    TILE_WIRE_IOLDOD,
    TILE_WIRE_ECLKA,
    TILE_WIRE_ECLKB,
    TILE_WIRE_ECLKC,
    TILE_WIRE_ECLKD,

    TILE_WIRE_G_VPTX0000,
    TILE_WIRE_G_VPTX0100,
    TILE_WIRE_G_VPTX0200,
    TILE_WIRE_G_VPTX0300,
    TILE_WIRE_G_VPTX0400,
    TILE_WIRE_G_VPTX0500,
    TILE_WIRE_G_VPTX0600,
    TILE_WIRE_G_VPTX0700,
    TILE_WIRE_G_VPTX0800,
    TILE_WIRE_G_VPTX0900,
    TILE_WIRE_G_VPTX1000,
    TILE_WIRE_G_VPTX1100,
    TILE_WIRE_G_VPTX1200,
    TILE_WIRE_G_VPTX1300,
    TILE_WIRE_G_VPTX1400,
    TILE_WIRE_G_VPTX1500,

    TILE_WIRE_G_HPBX0000,
    TILE_WIRE_G_HPBX0100,
    TILE_WIRE_G_HPBX0200,
    TILE_WIRE_G_HPBX0300,
    TILE_WIRE_G_HPBX0400,
    TILE_WIRE_G_HPBX0500,
    TILE_WIRE_G_HPBX0600,
    TILE_WIRE_G_HPBX0700,
    TILE_WIRE_G_HPBX0800,
    TILE_WIRE_G_HPBX0900,
    TILE_WIRE_G_HPBX1000,
    TILE_WIRE_G_HPBX1100,
    TILE_WIRE_G_HPBX1200,
    TILE_WIRE_G_HPBX1300,
    TILE_WIRE_G_HPBX1400,
    TILE_WIRE_G_HPBX1500,

    TILE_WIRE_L_HPBX0000,
    TILE_WIRE_L_HPBX0100,
    TILE_WIRE_L_HPBX0200,
    TILE_WIRE_L_HPBX0300,
    TILE_WIRE_L_HPBX0400,
    TILE_WIRE_L_HPBX0500,
    TILE_WIRE_L_HPBX0600,
    TILE_WIRE_L_HPBX0700,
    TILE_WIRE_L_HPBX0800,
    TILE_WIRE_L_HPBX0900,
    TILE_WIRE_L_HPBX1000,
    TILE_WIRE_L_HPBX1100,
    TILE_WIRE_L_HPBX1200,
    TILE_WIRE_L_HPBX1300,
    TILE_WIRE_L_HPBX1400,
    TILE_WIRE_L_HPBX1500,
    TILE_WIRE_R_HPBX0000,
    TILE_WIRE_R_HPBX0100,
    TILE_WIRE_R_HPBX0200,
    TILE_WIRE_R_HPBX0300,
    TILE_WIRE_R_HPBX0400,
    TILE_WIRE_R_HPBX0500,
    TILE_WIRE_R_HPBX0600,
    TILE_WIRE_R_HPBX0700,
    TILE_WIRE_R_HPBX0800,
    TILE_WIRE_R_HPBX0900,
    TILE_WIRE_R_HPBX1000,
    TILE_WIRE_R_HPBX1100,
    TILE_WIRE_R_HPBX1200,
    TILE_WIRE_R_HPBX1300,
    TILE_WIRE_R_HPBX1400,
    TILE_WIRE_R_HPBX1500,

    TILE_WIRE_JA0_CIBTEST,
    TILE_WIRE_JA1_CIBTEST,
    TILE_WIRE_JA2_CIBTEST,
    TILE_WIRE_JA3_CIBTEST,
    TILE_WIRE_JA4_CIBTEST,
    TILE_WIRE_JA5_CIBTEST,
    TILE_WIRE_JA6_CIBTEST,
    TILE_WIRE_JA7_CIBTEST,
    TILE_WIRE_JB0_CIBTEST,
    TILE_WIRE_JB1_CIBTEST,
    TILE_WIRE_JB2_CIBTEST,
    TILE_WIRE_JB3_CIBTEST,
    TILE_WIRE_JB4_CIBTEST,
    TILE_WIRE_JB5_CIBTEST,
    TILE_WIRE_JB6_CIBTEST,
    TILE_WIRE_JB7_CIBTEST,
    TILE_WIRE_JC0_CIBTEST,
    TILE_WIRE_JC1_CIBTEST,
    TILE_WIRE_JC2_CIBTEST,
    TILE_WIRE_JC3_CIBTEST,
    TILE_WIRE_JC4_CIBTEST,
    TILE_WIRE_JC5_CIBTEST,
    TILE_WIRE_JC6_CIBTEST,
    TILE_WIRE_JC7_CIBTEST,
    TILE_WIRE_JCE0_CIBTEST,
    TILE_WIRE_JCE1_CIBTEST,
    TILE_WIRE_JCE2_CIBTEST,
    TILE_WIRE_JCE3_CIBTEST,
    TILE_WIRE_JCLK0_CIBTEST,
    TILE_WIRE_JCLK1_CIBTEST,
    TILE_WIRE_JD0_CIBTEST,
    TILE_WIRE_JD1_CIBTEST,
    TILE_WIRE_JD2_CIBTEST,
    TILE_WIRE_JD3_CIBTEST,
    TILE_WIRE_JD4_CIBTEST,
    TILE_WIRE_JD5_CIBTEST,
    TILE_WIRE_JD6_CIBTEST,
    TILE_WIRE_JD7_CIBTEST,
    TILE_WIRE_JF0_CIBTEST,
    TILE_WIRE_JF1_CIBTEST,
    TILE_WIRE_JF2_CIBTEST,
    TILE_WIRE_JF3_CIBTEST,
    TILE_WIRE_JF4_CIBTEST,
    TILE_WIRE_JF5_CIBTEST,
    TILE_WIRE_JF6_CIBTEST,
    TILE_WIRE_JF7_CIBTEST,
    TILE_WIRE_JLSR0_CIBTEST,
    TILE_WIRE_JLSR1_CIBTEST,
    TILE_WIRE_JM0_CIBTEST,
    TILE_WIRE_JM1_CIBTEST,
    TILE_WIRE_JM2_CIBTEST,
    TILE_WIRE_JM3_CIBTEST,
    TILE_WIRE_JM4_CIBTEST,
    TILE_WIRE_JM5_CIBTEST,
    TILE_WIRE_JM6_CIBTEST,
    TILE_WIRE_JM7_CIBTEST,
    TILE_WIRE_JQ0_CIBTEST,
    TILE_WIRE_JQ1_CIBTEST,
    TILE_WIRE_JQ2_CIBTEST,
    TILE_WIRE_JQ3_CIBTEST,
    TILE_WIRE_JQ4_CIBTEST,
    TILE_WIRE_JQ5_CIBTEST,
    TILE_WIRE_JQ6_CIBTEST,
    TILE_WIRE_JQ7_CIBTEST,

    TILE_WIRE_JA0_MULT9,
    TILE_WIRE_JA1_MULT9,
    TILE_WIRE_JA2_MULT9,
    TILE_WIRE_JA3_MULT9,
    TILE_WIRE_JA4_MULT9,
    TILE_WIRE_JA5_MULT9,
    TILE_WIRE_JA6_MULT9,
    TILE_WIRE_JA7_MULT9,
    TILE_WIRE_JA8_MULT9,
    TILE_WIRE_JB0_MULT9,
    TILE_WIRE_JB1_MULT9,
    TILE_WIRE_JB2_MULT9,
    TILE_WIRE_JB3_MULT9,
    TILE_WIRE_JB4_MULT9,
    TILE_WIRE_JB5_MULT9,
    TILE_WIRE_JB6_MULT9,
    TILE_WIRE_JB7_MULT9,
    TILE_WIRE_JB8_MULT9,
    TILE_WIRE_JC0_MULT9,
    TILE_WIRE_JC1_MULT9,
    TILE_WIRE_JC2_MULT9,
    TILE_WIRE_JC3_MULT9,
    TILE_WIRE_JC4_MULT9,
    TILE_WIRE_JC5_MULT9,
    TILE_WIRE_JC6_MULT9,
    TILE_WIRE_JC7_MULT9,
    TILE_WIRE_JC8_MULT9,
    TILE_WIRE_JCE0_MULT9,
    TILE_WIRE_JCE1_MULT9,
    TILE_WIRE_JCE2_MULT9,
    TILE_WIRE_JCE3_MULT9,
    TILE_WIRE_JCLK0_MULT9,
    TILE_WIRE_JCLK1_MULT9,
    TILE_WIRE_JCLK2_MULT9,
    TILE_WIRE_JCLK3_MULT9,
    TILE_WIRE_JP0_MULT9,
    TILE_WIRE_JP1_MULT9,
    TILE_WIRE_JP2_MULT9,
    TILE_WIRE_JP3_MULT9,
    TILE_WIRE_JP4_MULT9,
    TILE_WIRE_JP5_MULT9,
    TILE_WIRE_JP6_MULT9,
    TILE_WIRE_JP7_MULT9,
    TILE_WIRE_JP8_MULT9,
    TILE_WIRE_JP9_MULT9,
    TILE_WIRE_JP10_MULT9,
    TILE_WIRE_JP11_MULT9,
    TILE_WIRE_JP12_MULT9,
    TILE_WIRE_JP13_MULT9,
    TILE_WIRE_JP14_MULT9,
    TILE_WIRE_JP15_MULT9,
    TILE_WIRE_JP16_MULT9,
    TILE_WIRE_JP17_MULT9,
    TILE_WIRE_JROA0_MULT9,
    TILE_WIRE_JROA1_MULT9,
    TILE_WIRE_JROA2_MULT9,
    TILE_WIRE_JROA3_MULT9,
    TILE_WIRE_JROA4_MULT9,
    TILE_WIRE_JROA5_MULT9,
    TILE_WIRE_JROA6_MULT9,
    TILE_WIRE_JROA7_MULT9,
    TILE_WIRE_JROA8_MULT9,
    TILE_WIRE_JROB0_MULT9,
    TILE_WIRE_JROB1_MULT9,
    TILE_WIRE_JROB2_MULT9,
    TILE_WIRE_JROB3_MULT9,
    TILE_WIRE_JROB4_MULT9,
    TILE_WIRE_JROB5_MULT9,
    TILE_WIRE_JROB6_MULT9,
    TILE_WIRE_JROB7_MULT9,
    TILE_WIRE_JROB8_MULT9,
    TILE_WIRE_JROC0_MULT9,
    TILE_WIRE_JROC1_MULT9,
    TILE_WIRE_JROC2_MULT9,
    TILE_WIRE_JROC3_MULT9,
    TILE_WIRE_JROC4_MULT9,
    TILE_WIRE_JROC5_MULT9,
    TILE_WIRE_JROC6_MULT9,
    TILE_WIRE_JROC7_MULT9,
    TILE_WIRE_JROC8_MULT9,
    TILE_WIRE_JRST0_MULT9,
    TILE_WIRE_JRST1_MULT9,
    TILE_WIRE_JRST2_MULT9,
    TILE_WIRE_JRST3_MULT9,
    TILE_WIRE_JSIGNEDA_MULT9,
    TILE_WIRE_JSIGNEDB_MULT9,
    TILE_WIRE_JSIGNEDP_MULT9,
    TILE_WIRE_JSOURCEA_MULT9,
    TILE_WIRE_JSOURCEB_MULT9,
    TILE_WIRE_JSRIA0_MULT9,
    TILE_WIRE_JSRIA1_MULT9,
    TILE_WIRE_JSRIA2_MULT9,
    TILE_WIRE_JSRIA3_MULT9,
    TILE_WIRE_JSRIA4_MULT9,
    TILE_WIRE_JSRIA5_MULT9,
    TILE_WIRE_JSRIA6_MULT9,
    TILE_WIRE_JSRIA7_MULT9,
    TILE_WIRE_JSRIA8_MULT9,
    TILE_WIRE_JSRIB0_MULT9,
    TILE_WIRE_JSRIB1_MULT9,
    TILE_WIRE_JSRIB2_MULT9,
    TILE_WIRE_JSRIB3_MULT9,
    TILE_WIRE_JSRIB4_MULT9,
    TILE_WIRE_JSRIB5_MULT9,
    TILE_WIRE_JSRIB6_MULT9,
    TILE_WIRE_JSRIB7_MULT9,
    TILE_WIRE_JSRIB8_MULT9,
    TILE_WIRE_JSROA0_MULT9,
    TILE_WIRE_JSROA1_MULT9,
    TILE_WIRE_JSROA2_MULT9,
    TILE_WIRE_JSROA3_MULT9,
    TILE_WIRE_JSROA4_MULT9,
    TILE_WIRE_JSROA5_MULT9,
    TILE_WIRE_JSROA6_MULT9,
    TILE_WIRE_JSROA7_MULT9,
    TILE_WIRE_JSROA8_MULT9,
    TILE_WIRE_JSROB0_MULT9,
    TILE_WIRE_JSROB1_MULT9,
    TILE_WIRE_JSROB2_MULT9,
    TILE_WIRE_JSROB3_MULT9,
    TILE_WIRE_JSROB4_MULT9,
    TILE_WIRE_JSROB5_MULT9,
    TILE_WIRE_JSROB6_MULT9,
    TILE_WIRE_JSROB7_MULT9,
    TILE_WIRE_JSROB8_MULT9,

    TILE_WIRE_JC0_PRADD9,
    TILE_WIRE_JC1_PRADD9,
    TILE_WIRE_JC2_PRADD9,
    TILE_WIRE_JC3_PRADD9,
    TILE_WIRE_JC4_PRADD9,
    TILE_WIRE_JC5_PRADD9,
    TILE_WIRE_JC6_PRADD9,
    TILE_WIRE_JC7_PRADD9,
    TILE_WIRE_JC8_PRADD9,
    TILE_WIRE_JCE0_PRADD9,
    TILE_WIRE_JCE1_PRADD9,
    TILE_WIRE_JCE2_PRADD9,
    TILE_WIRE_JCE3_PRADD9,
    TILE_WIRE_JCLK0_PRADD9,
    TILE_WIRE_JCLK1_PRADD9,
    TILE_WIRE_JCLK2_PRADD9,
    TILE_WIRE_JCLK3_PRADD9,
    TILE_WIRE_JOPPRE_PRADD9,
    TILE_WIRE_JPA0_PRADD9,
    TILE_WIRE_JPA1_PRADD9,
    TILE_WIRE_JPA2_PRADD9,
    TILE_WIRE_JPA3_PRADD9,
    TILE_WIRE_JPA4_PRADD9,
    TILE_WIRE_JPA5_PRADD9,
    TILE_WIRE_JPA6_PRADD9,
    TILE_WIRE_JPA7_PRADD9,
    TILE_WIRE_JPA8_PRADD9,
    TILE_WIRE_JPB0_PRADD9,
    TILE_WIRE_JPB1_PRADD9,
    TILE_WIRE_JPB2_PRADD9,
    TILE_WIRE_JPB3_PRADD9,
    TILE_WIRE_JPB4_PRADD9,
    TILE_WIRE_JPB5_PRADD9,
    TILE_WIRE_JPB6_PRADD9,
    TILE_WIRE_JPB7_PRADD9,
    TILE_WIRE_JPB8_PRADD9,
    TILE_WIRE_JPO0_PRADD9,
    TILE_WIRE_JPO1_PRADD9,
    TILE_WIRE_JPO2_PRADD9,
    TILE_WIRE_JPO3_PRADD9,
    TILE_WIRE_JPO4_PRADD9,
    TILE_WIRE_JPO5_PRADD9,
    TILE_WIRE_JPO6_PRADD9,
    TILE_WIRE_JPO7_PRADD9,
    TILE_WIRE_JPO8_PRADD9,
    TILE_WIRE_JRST0_PRADD9,
    TILE_WIRE_JRST1_PRADD9,
    TILE_WIRE_JRST2_PRADD9,
    TILE_WIRE_JRST3_PRADD9,
    TILE_WIRE_JSOURCEA_PRADD9,
    TILE_WIRE_JSRIA0_PRADD9,
    TILE_WIRE_JSRIA1_PRADD9,
    TILE_WIRE_JSRIA2_PRADD9,
    TILE_WIRE_JSRIA3_PRADD9,
    TILE_WIRE_JSRIA4_PRADD9,
    TILE_WIRE_JSRIA5_PRADD9,
    TILE_WIRE_JSRIA6_PRADD9,
    TILE_WIRE_JSRIA7_PRADD9,
    TILE_WIRE_JSRIA8_PRADD9,
    TILE_WIRE_JSRIB0_PRADD9,
    TILE_WIRE_JSRIB1_PRADD9,
    TILE_WIRE_JSRIB2_PRADD9,
    TILE_WIRE_JSRIB3_PRADD9,
    TILE_WIRE_JSRIB4_PRADD9,
    TILE_WIRE_JSRIB5_PRADD9,
    TILE_WIRE_JSRIB6_PRADD9,
    TILE_WIRE_JSRIB7_PRADD9,
    TILE_WIRE_JSRIB8_PRADD9,
    TILE_WIRE_JSROA0_PRADD9,
    TILE_WIRE_JSROA1_PRADD9,
    TILE_WIRE_JSROA2_PRADD9,
    TILE_WIRE_JSROA3_PRADD9,
    TILE_WIRE_JSROA4_PRADD9,
    TILE_WIRE_JSROA5_PRADD9,
    TILE_WIRE_JSROA6_PRADD9,
    TILE_WIRE_JSROA7_PRADD9,
    TILE_WIRE_JSROA8_PRADD9,
    TILE_WIRE_JSROB0_PRADD9,
    TILE_WIRE_JSROB1_PRADD9,
    TILE_WIRE_JSROB2_PRADD9,
    TILE_WIRE_JSROB3_PRADD9,
    TILE_WIRE_JSROB4_PRADD9,
    TILE_WIRE_JSROB5_PRADD9,
    TILE_WIRE_JSROB6_PRADD9,
    TILE_WIRE_JSROB7_PRADD9,
    TILE_WIRE_JSROB8_PRADD9,

    TILE_WIRE_JC0_PRADD18,
    TILE_WIRE_JC10_PRADD18,
    TILE_WIRE_JC11_PRADD18,
    TILE_WIRE_JC12_PRADD18,
    TILE_WIRE_JC13_PRADD18,
    TILE_WIRE_JC14_PRADD18,
    TILE_WIRE_JC15_PRADD18,
    TILE_WIRE_JC16_PRADD18,
    TILE_WIRE_JC17_PRADD18,
    TILE_WIRE_JC1_PRADD18,
    TILE_WIRE_JC2_PRADD18,
    TILE_WIRE_JC3_PRADD18,
    TILE_WIRE_JC4_PRADD18,
    TILE_WIRE_JC5_PRADD18,
    TILE_WIRE_JC6_PRADD18,
    TILE_WIRE_JC7_PRADD18,
    TILE_WIRE_JC8_PRADD18,
    TILE_WIRE_JC9_PRADD18,
    TILE_WIRE_JCE0_PRADD18,
    TILE_WIRE_JCE1_PRADD18,
    TILE_WIRE_JCE2_PRADD18,
    TILE_WIRE_JCE3_PRADD18,
    TILE_WIRE_JCLK0_PRADD18,
    TILE_WIRE_JCLK1_PRADD18,
    TILE_WIRE_JCLK2_PRADD18,
    TILE_WIRE_JCLK3_PRADD18,
    TILE_WIRE_JOPPRE_PRADD18,
    TILE_WIRE_JPA0_PRADD18,
    TILE_WIRE_JPA10_PRADD18,
    TILE_WIRE_JPA11_PRADD18,
    TILE_WIRE_JPA12_PRADD18,
    TILE_WIRE_JPA13_PRADD18,
    TILE_WIRE_JPA14_PRADD18,
    TILE_WIRE_JPA15_PRADD18,
    TILE_WIRE_JPA16_PRADD18,
    TILE_WIRE_JPA17_PRADD18,
    TILE_WIRE_JPA1_PRADD18,
    TILE_WIRE_JPA2_PRADD18,
    TILE_WIRE_JPA3_PRADD18,
    TILE_WIRE_JPA4_PRADD18,
    TILE_WIRE_JPA5_PRADD18,
    TILE_WIRE_JPA6_PRADD18,
    TILE_WIRE_JPA7_PRADD18,
    TILE_WIRE_JPA8_PRADD18,
    TILE_WIRE_JPA9_PRADD18,
    TILE_WIRE_JPB0_PRADD18,
    TILE_WIRE_JPB10_PRADD18,
    TILE_WIRE_JPB11_PRADD18,
    TILE_WIRE_JPB12_PRADD18,
    TILE_WIRE_JPB13_PRADD18,
    TILE_WIRE_JPB14_PRADD18,
    TILE_WIRE_JPB15_PRADD18,
    TILE_WIRE_JPB16_PRADD18,
    TILE_WIRE_JPB17_PRADD18,
    TILE_WIRE_JPB1_PRADD18,
    TILE_WIRE_JPB2_PRADD18,
    TILE_WIRE_JPB3_PRADD18,
    TILE_WIRE_JPB4_PRADD18,
    TILE_WIRE_JPB5_PRADD18,
    TILE_WIRE_JPB6_PRADD18,
    TILE_WIRE_JPB7_PRADD18,
    TILE_WIRE_JPB8_PRADD18,
    TILE_WIRE_JPB9_PRADD18,
    TILE_WIRE_JPO0_PRADD18,
    TILE_WIRE_JPO10_PRADD18,
    TILE_WIRE_JPO11_PRADD18,
    TILE_WIRE_JPO12_PRADD18,
    TILE_WIRE_JPO13_PRADD18,
    TILE_WIRE_JPO14_PRADD18,
    TILE_WIRE_JPO15_PRADD18,
    TILE_WIRE_JPO16_PRADD18,
    TILE_WIRE_JPO17_PRADD18,
    TILE_WIRE_JPO1_PRADD18,
    TILE_WIRE_JPO2_PRADD18,
    TILE_WIRE_JPO3_PRADD18,
    TILE_WIRE_JPO4_PRADD18,
    TILE_WIRE_JPO5_PRADD18,
    TILE_WIRE_JPO6_PRADD18,
    TILE_WIRE_JPO7_PRADD18,
    TILE_WIRE_JPO8_PRADD18,
    TILE_WIRE_JPO9_PRADD18,
    TILE_WIRE_JRST0_PRADD18,
    TILE_WIRE_JRST1_PRADD18,
    TILE_WIRE_JRST2_PRADD18,
    TILE_WIRE_JRST3_PRADD18,
    TILE_WIRE_JSOURCEA_PRADD18,
    TILE_WIRE_JSRIA0_PRADD18,
    TILE_WIRE_JSRIA10_PRADD18,
    TILE_WIRE_JSRIA11_PRADD18,
    TILE_WIRE_JSRIA12_PRADD18,
    TILE_WIRE_JSRIA13_PRADD18,
    TILE_WIRE_JSRIA14_PRADD18,
    TILE_WIRE_JSRIA15_PRADD18,
    TILE_WIRE_JSRIA16_PRADD18,
    TILE_WIRE_JSRIA17_PRADD18,
    TILE_WIRE_JSRIA1_PRADD18,
    TILE_WIRE_JSRIA2_PRADD18,
    TILE_WIRE_JSRIA3_PRADD18,
    TILE_WIRE_JSRIA4_PRADD18,
    TILE_WIRE_JSRIA5_PRADD18,
    TILE_WIRE_JSRIA6_PRADD18,
    TILE_WIRE_JSRIA7_PRADD18,
    TILE_WIRE_JSRIA8_PRADD18,
    TILE_WIRE_JSRIA9_PRADD18,
    TILE_WIRE_JSRIB0_PRADD18,
    TILE_WIRE_JSRIB10_PRADD18,
    TILE_WIRE_JSRIB11_PRADD18,
    TILE_WIRE_JSRIB12_PRADD18,
    TILE_WIRE_JSRIB13_PRADD18,
    TILE_WIRE_JSRIB14_PRADD18,
    TILE_WIRE_JSRIB15_PRADD18,
    TILE_WIRE_JSRIB16_PRADD18,
    TILE_WIRE_JSRIB17_PRADD18,
    TILE_WIRE_JSRIB1_PRADD18,
    TILE_WIRE_JSRIB2_PRADD18,
    TILE_WIRE_JSRIB3_PRADD18,
    TILE_WIRE_JSRIB4_PRADD18,
    TILE_WIRE_JSRIB5_PRADD18,
    TILE_WIRE_JSRIB6_PRADD18,
    TILE_WIRE_JSRIB7_PRADD18,
    TILE_WIRE_JSRIB8_PRADD18,
    TILE_WIRE_JSRIB9_PRADD18,
    TILE_WIRE_JSROA0_PRADD18,
    TILE_WIRE_JSROA10_PRADD18,
    TILE_WIRE_JSROA11_PRADD18,
    TILE_WIRE_JSROA12_PRADD18,
    TILE_WIRE_JSROA13_PRADD18,
    TILE_WIRE_JSROA14_PRADD18,
    TILE_WIRE_JSROA15_PRADD18,
    TILE_WIRE_JSROA16_PRADD18,
    TILE_WIRE_JSROA17_PRADD18,
    TILE_WIRE_JSROA1_PRADD18,
    TILE_WIRE_JSROA2_PRADD18,
    TILE_WIRE_JSROA3_PRADD18,
    TILE_WIRE_JSROA4_PRADD18,
    TILE_WIRE_JSROA5_PRADD18,
    TILE_WIRE_JSROA6_PRADD18,
    TILE_WIRE_JSROA7_PRADD18,
    TILE_WIRE_JSROA8_PRADD18,
    TILE_WIRE_JSROA9_PRADD18,
    TILE_WIRE_JSROB0_PRADD18,
    TILE_WIRE_JSROB10_PRADD18,
    TILE_WIRE_JSROB11_PRADD18,
    TILE_WIRE_JSROB12_PRADD18,
    TILE_WIRE_JSROB13_PRADD18,
    TILE_WIRE_JSROB14_PRADD18,
    TILE_WIRE_JSROB15_PRADD18,
    TILE_WIRE_JSROB16_PRADD18,
    TILE_WIRE_JSROB17_PRADD18,
    TILE_WIRE_JSROB1_PRADD18,
    TILE_WIRE_JSROB2_PRADD18,
    TILE_WIRE_JSROB3_PRADD18,
    TILE_WIRE_JSROB4_PRADD18,
    TILE_WIRE_JSROB5_PRADD18,
    TILE_WIRE_JSROB6_PRADD18,
    TILE_WIRE_JSROB7_PRADD18,
    TILE_WIRE_JSROB8_PRADD18,
    TILE_WIRE_JSROB9_PRADD18,

    TILE_WIRE_JCE0_ALU24,
    TILE_WIRE_JCE1_ALU24,
    TILE_WIRE_JCE2_ALU24,
    TILE_WIRE_JCE3_ALU24,
    TILE_WIRE_JCFB0_ALU24,
    TILE_WIRE_JCFB10_ALU24,
    TILE_WIRE_JCFB11_ALU24,
    TILE_WIRE_JCFB12_ALU24,
    TILE_WIRE_JCFB13_ALU24,
    TILE_WIRE_JCFB14_ALU24,
    TILE_WIRE_JCFB15_ALU24,
    TILE_WIRE_JCFB16_ALU24,
    TILE_WIRE_JCFB17_ALU24,
    TILE_WIRE_JCFB18_ALU24,
    TILE_WIRE_JCFB19_ALU24,
    TILE_WIRE_JCFB1_ALU24,
    TILE_WIRE_JCFB20_ALU24,
    TILE_WIRE_JCFB21_ALU24,
    TILE_WIRE_JCFB22_ALU24,
    TILE_WIRE_JCFB23_ALU24,
    TILE_WIRE_JCFB2_ALU24,
    TILE_WIRE_JCFB3_ALU24,
    TILE_WIRE_JCFB4_ALU24,
    TILE_WIRE_JCFB5_ALU24,
    TILE_WIRE_JCFB6_ALU24,
    TILE_WIRE_JCFB7_ALU24,
    TILE_WIRE_JCFB8_ALU24,
    TILE_WIRE_JCFB9_ALU24,
    TILE_WIRE_JCIN0_ALU24,
    TILE_WIRE_JCIN10_ALU24,
    TILE_WIRE_JCIN11_ALU24,
    TILE_WIRE_JCIN12_ALU24,
    TILE_WIRE_JCIN13_ALU24,
    TILE_WIRE_JCIN14_ALU24,
    TILE_WIRE_JCIN15_ALU24,
    TILE_WIRE_JCIN16_ALU24,
    TILE_WIRE_JCIN17_ALU24,
    TILE_WIRE_JCIN18_ALU24,
    TILE_WIRE_JCIN19_ALU24,
    TILE_WIRE_JCIN1_ALU24,
    TILE_WIRE_JCIN20_ALU24,
    TILE_WIRE_JCIN21_ALU24,
    TILE_WIRE_JCIN22_ALU24,
    TILE_WIRE_JCIN23_ALU24,
    TILE_WIRE_JCIN2_ALU24,
    TILE_WIRE_JCIN3_ALU24,
    TILE_WIRE_JCIN4_ALU24,
    TILE_WIRE_JCIN5_ALU24,
    TILE_WIRE_JCIN6_ALU24,
    TILE_WIRE_JCIN7_ALU24,
    TILE_WIRE_JCIN8_ALU24,
    TILE_WIRE_JCIN9_ALU24,
    TILE_WIRE_JCLK0_ALU24,
    TILE_WIRE_JCLK1_ALU24,
    TILE_WIRE_JCLK2_ALU24,
    TILE_WIRE_JCLK3_ALU24,
    TILE_WIRE_JCO0_ALU24,
    TILE_WIRE_JCO10_ALU24,
    TILE_WIRE_JCO11_ALU24,
    TILE_WIRE_JCO12_ALU24,
    TILE_WIRE_JCO13_ALU24,
    TILE_WIRE_JCO14_ALU24,
    TILE_WIRE_JCO15_ALU24,
    TILE_WIRE_JCO16_ALU24,
    TILE_WIRE_JCO17_ALU24,
    TILE_WIRE_JCO18_ALU24,
    TILE_WIRE_JCO19_ALU24,
    TILE_WIRE_JCO1_ALU24,
    TILE_WIRE_JCO20_ALU24,
    TILE_WIRE_JCO21_ALU24,
    TILE_WIRE_JCO22_ALU24,
    TILE_WIRE_JCO23_ALU24,
    TILE_WIRE_JCO2_ALU24,
    TILE_WIRE_JCO3_ALU24,
    TILE_WIRE_JCO4_ALU24,
    TILE_WIRE_JCO5_ALU24,
    TILE_WIRE_JCO6_ALU24,
    TILE_WIRE_JCO7_ALU24,
    TILE_WIRE_JCO8_ALU24,
    TILE_WIRE_JCO9_ALU24,
    TILE_WIRE_JMA0_ALU24,
    TILE_WIRE_JMA10_ALU24,
    TILE_WIRE_JMA11_ALU24,
    TILE_WIRE_JMA12_ALU24,
    TILE_WIRE_JMA13_ALU24,
    TILE_WIRE_JMA14_ALU24,
    TILE_WIRE_JMA15_ALU24,
    TILE_WIRE_JMA16_ALU24,
    TILE_WIRE_JMA17_ALU24,
    TILE_WIRE_JMA1_ALU24,
    TILE_WIRE_JMA2_ALU24,
    TILE_WIRE_JMA3_ALU24,
    TILE_WIRE_JMA4_ALU24,
    TILE_WIRE_JMA5_ALU24,
    TILE_WIRE_JMA6_ALU24,
    TILE_WIRE_JMA7_ALU24,
    TILE_WIRE_JMA8_ALU24,
    TILE_WIRE_JMA9_ALU24,
    TILE_WIRE_JMB0_ALU24,
    TILE_WIRE_JMB10_ALU24,
    TILE_WIRE_JMB11_ALU24,
    TILE_WIRE_JMB12_ALU24,
    TILE_WIRE_JMB13_ALU24,
    TILE_WIRE_JMB14_ALU24,
    TILE_WIRE_JMB15_ALU24,
    TILE_WIRE_JMB16_ALU24,
    TILE_WIRE_JMB17_ALU24,
    TILE_WIRE_JMB1_ALU24,
    TILE_WIRE_JMB2_ALU24,
    TILE_WIRE_JMB3_ALU24,
    TILE_WIRE_JMB4_ALU24,
    TILE_WIRE_JMB5_ALU24,
    TILE_WIRE_JMB6_ALU24,
    TILE_WIRE_JMB7_ALU24,
    TILE_WIRE_JMB8_ALU24,
    TILE_WIRE_JMB9_ALU24,
    TILE_WIRE_JOP5_ALU24,
    TILE_WIRE_JOP7_ALU24,
    TILE_WIRE_JR0_ALU24,
    TILE_WIRE_JR10_ALU24,
    TILE_WIRE_JR11_ALU24,
    TILE_WIRE_JR12_ALU24,
    TILE_WIRE_JR13_ALU24,
    TILE_WIRE_JR14_ALU24,
    TILE_WIRE_JR15_ALU24,
    TILE_WIRE_JR16_ALU24,
    TILE_WIRE_JR17_ALU24,
    TILE_WIRE_JR18_ALU24,
    TILE_WIRE_JR19_ALU24,
    TILE_WIRE_JR1_ALU24,
    TILE_WIRE_JR20_ALU24,
    TILE_WIRE_JR21_ALU24,
    TILE_WIRE_JR22_ALU24,
    TILE_WIRE_JR23_ALU24,
    TILE_WIRE_JR2_ALU24,
    TILE_WIRE_JR3_ALU24,
    TILE_WIRE_JR4_ALU24,
    TILE_WIRE_JR5_ALU24,
    TILE_WIRE_JR6_ALU24,
    TILE_WIRE_JR7_ALU24,
    TILE_WIRE_JR8_ALU24,
    TILE_WIRE_JR9_ALU24,
    TILE_WIRE_JRST0_ALU24,
    TILE_WIRE_JRST1_ALU24,
    TILE_WIRE_JRST2_ALU24,
    TILE_WIRE_JRST3_ALU24,
    TILE_WIRE_JSIGNEDIA_ALU24,
    TILE_WIRE_JSIGNEDIB_ALU24,

    TILE_WIRE_G_BANK2ECLK0,
    TILE_WIRE_G_BANK2ECLK1,
    TILE_WIRE_G_BANK3ECLK0,
    TILE_WIRE_G_BANK3ECLK1,
    TILE_WIRE_G_BANK6ECLK0,
    TILE_WIRE_G_BANK6ECLK1,
    TILE_WIRE_G_BANK7ECLK0,
    TILE_WIRE_G_BANK7ECLK1,
    TILE_WIRE_G_BDCC0CLKI,
    TILE_WIRE_G_BDCC10CLKI,
    TILE_WIRE_G_BDCC11CLKI,
    TILE_WIRE_G_BDCC12CLKI,
    TILE_WIRE_G_BDCC13CLKI,
    TILE_WIRE_G_BDCC14CLKI,
    TILE_WIRE_G_BDCC15CLKI,
    TILE_WIRE_G_BDCC1CLKI,
    TILE_WIRE_G_BDCC2CLKI,
    TILE_WIRE_G_BDCC3CLKI,
    TILE_WIRE_G_BDCC4CLKI,
    TILE_WIRE_G_BDCC5CLKI,
    TILE_WIRE_G_BDCC6CLKI,
    TILE_WIRE_G_BDCC7CLKI,
    TILE_WIRE_G_BDCC8CLKI,
    TILE_WIRE_G_BDCC9CLKI,
    TILE_WIRE_G_CLK0_DCS0,
    TILE_WIRE_G_CLK0_DCS1,
    TILE_WIRE_G_CLK1_DCS0,
    TILE_WIRE_G_CLK1_DCS1,
    TILE_WIRE_G_CLKO_DCCBL,
    TILE_WIRE_G_CLKO_DCCBR,
    TILE_WIRE_G_CLKO_DCCTL,
    TILE_WIRE_G_CLKO_DCCTR,
    TILE_WIRE_G_DCS0,
    TILE_WIRE_G_DCS0CLK0,
    TILE_WIRE_G_DCS0CLK1,
    TILE_WIRE_G_DCS1,
    TILE_WIRE_G_DCS1CLK0,
    TILE_WIRE_G_DCS1CLK1,
    TILE_WIRE_G_DCSOUT_DCS0,
    TILE_WIRE_G_DCSOUT_DCS1,
    TILE_WIRE_G_HPFE0000,
    TILE_WIRE_G_HPFE0100,
    TILE_WIRE_G_HPFE0200,
    TILE_WIRE_G_HPFE0300,
    TILE_WIRE_G_HPFE0400,
    TILE_WIRE_G_HPFE0500,
    TILE_WIRE_G_HPFE0600,
    TILE_WIRE_G_HPFE0700,
    TILE_WIRE_G_HPFE0800,
    TILE_WIRE_G_HPFE0900,
    TILE_WIRE_G_HPFE1000,
    TILE_WIRE_G_HPFE1100,
    TILE_WIRE_G_HPFE1200,
    TILE_WIRE_G_HPFE1300,
    TILE_WIRE_G_HPFW0000,
    TILE_WIRE_G_HPFW0100,
    TILE_WIRE_G_HPFW0200,
    TILE_WIRE_G_HPFW0300,
    TILE_WIRE_G_HPFW0400,
    TILE_WIRE_G_HPFW0500,
    TILE_WIRE_G_HPFW0600,
    TILE_WIRE_G_HPFW0700,
    TILE_WIRE_G_HPFW0800,
    TILE_WIRE_G_HPFW0900,
    TILE_WIRE_G_HPFW1000,
    TILE_WIRE_G_HPFW1100,
    TILE_WIRE_G_HPFW1200,
    TILE_WIRE_G_HPFW1300,
    TILE_WIRE_G_HPRX0000,
    TILE_WIRE_G_HPRX0100,
    TILE_WIRE_G_HPRX0200,
    TILE_WIRE_G_HPRX0300,
    TILE_WIRE_G_HPRX0400,
    TILE_WIRE_G_HPRX0500,
    TILE_WIRE_G_HPRX0600,
    TILE_WIRE_G_HPRX0700,
    TILE_WIRE_G_HPRX0800,
    TILE_WIRE_G_HPRX0900,
    TILE_WIRE_G_HPRX1000,
    TILE_WIRE_G_HPRX1100,
    TILE_WIRE_G_HPRX1200,
    TILE_WIRE_G_HPRX1300,
    TILE_WIRE_G_HPRX1400,
    TILE_WIRE_G_HPRX1500,
    TILE_WIRE_G_JBLQPCLKCIB0,
    TILE_WIRE_G_JBLQPCLKCIB1,
    TILE_WIRE_G_JBRGECLK0,
    TILE_WIRE_G_JBRGECLK1,
    TILE_WIRE_G_JBRQPCLKCIB0,
    TILE_WIRE_G_JBRQPCLKCIB1,
    TILE_WIRE_G_JCE_DCCBL,
    TILE_WIRE_G_JCE_DCCBR,
    TILE_WIRE_G_JCE_DCCTL,
    TILE_WIRE_G_JCE_DCCTR,
    TILE_WIRE_G_JCLKI_DCCBL,
    TILE_WIRE_G_JCLKI_DCCBR,
    TILE_WIRE_G_JCLKI_DCCTL,
    TILE_WIRE_G_JCLKI_DCCTR,
    TILE_WIRE_G_JLCDIVX0,
    TILE_WIRE_G_JLCDIVX1,
    TILE_WIRE_G_JLECLK1,
    TILE_WIRE_G_JLLCPLL0CLKOP,
    TILE_WIRE_G_JLLCPLL0CLKOS,
    TILE_WIRE_G_JLLCPLL0CLKOS2,
    TILE_WIRE_G_JLLCPLL0CLKOS3,
    TILE_WIRE_G_JLLMPCLKCIB0,
    TILE_WIRE_G_JLLMPCLKCIB1,
    TILE_WIRE_G_JLLMPCLKCIB2,
    TILE_WIRE_G_JLLMPCLKCIB3,
    TILE_WIRE_G_JLLQECLKCIB0,
    TILE_WIRE_G_JLLQECLKCIB1,
    TILE_WIRE_G_JLLQPCLKCIB0,
    TILE_WIRE_G_JLLQPCLKCIB1,
    TILE_WIRE_G_JLRCPLL0CLKOP,
    TILE_WIRE_G_JLRCPLL0CLKOS,
    TILE_WIRE_G_JLRCPLL0CLKOS2,
    TILE_WIRE_G_JLRCPLL0CLKOS3,
    TILE_WIRE_G_JLRMPCLKCIB0,
    TILE_WIRE_G_JLRMPCLKCIB1,
    TILE_WIRE_G_JLRMPCLKCIB2,
    TILE_WIRE_G_JLRMPCLKCIB3,
    TILE_WIRE_G_JLRQECLKCIB0,
    TILE_WIRE_G_JLRQECLKCIB1,
    TILE_WIRE_G_JLRQPCLKCIB0,
    TILE_WIRE_G_JLRQPCLKCIB1,
    TILE_WIRE_G_JMODESEL_DCS0,
    TILE_WIRE_G_JMODESEL_DCS1,
    TILE_WIRE_G_JOSC,
    TILE_WIRE_G_JOSC_OSC,
    TILE_WIRE_G_JPCLKT00,
    TILE_WIRE_G_JPCLKT01,
    TILE_WIRE_G_JPCLKT10,
    TILE_WIRE_G_JPCLKT11,
    TILE_WIRE_G_JPCLKT20,
    TILE_WIRE_G_JPCLKT21,
    TILE_WIRE_G_JPCLKT30,
    TILE_WIRE_G_JPCLKT31,
    TILE_WIRE_G_JPCLKT60,
    TILE_WIRE_G_JPCLKT61,
    TILE_WIRE_G_JPCLKT70,
    TILE_WIRE_G_JPCLKT71,
    TILE_WIRE_G_JPCSARXCLK0,
    TILE_WIRE_G_JPCSARXCLK1,
    TILE_WIRE_G_JPCSATXCLK0,
    TILE_WIRE_G_JPCSATXCLK1,
    TILE_WIRE_G_JPCSBRXCLK0,
    TILE_WIRE_G_JPCSBRXCLK1,
    TILE_WIRE_G_JPCSBTXCLK0,
    TILE_WIRE_G_JPCSBTXCLK1,
    TILE_WIRE_G_JRECLK0,
    TILE_WIRE_G_JSEDCLKOUT,
    TILE_WIRE_G_JSEL0_DCS0,
    TILE_WIRE_G_JSEL0_DCS1,
    TILE_WIRE_G_JSEL1_DCS0,
    TILE_WIRE_G_JSEL1_DCS1,
    TILE_WIRE_G_JTLQPCLKCIB0,
    TILE_WIRE_G_JTLQPCLKCIB1,
    TILE_WIRE_G_JTRQPCLKCIB0,
    TILE_WIRE_G_JTRQPCLKCIB1,
    TILE_WIRE_G_JULCPLL0CLKOP,
    TILE_WIRE_G_JULCPLL0CLKOS,
    TILE_WIRE_G_JULCPLL0CLKOS2,
    TILE_WIRE_G_JULCPLL0CLKOS3,
    TILE_WIRE_G_JULMPCLKCIB0,
    TILE_WIRE_G_JULMPCLKCIB1,
    TILE_WIRE_G_JULMPCLKCIB2,
    TILE_WIRE_G_JULMPCLKCIB3,
    TILE_WIRE_G_JULQECLKCIB0,
    TILE_WIRE_G_JULQECLKCIB1,
    TILE_WIRE_G_JULQPCLKCIB0,
    TILE_WIRE_G_JULQPCLKCIB1,
    TILE_WIRE_G_JURCPLL0CLKOP,
    TILE_WIRE_G_JURCPLL0CLKOS,
    TILE_WIRE_G_JURCPLL0CLKOS2,
    TILE_WIRE_G_JURCPLL0CLKOS3,
    TILE_WIRE_G_JURMPCLKCIB0,
    TILE_WIRE_G_JURMPCLKCIB1,
    TILE_WIRE_G_JURMPCLKCIB2,
    TILE_WIRE_G_JURMPCLKCIB3,
    TILE_WIRE_G_JURQECLKCIB0,
    TILE_WIRE_G_JURQECLKCIB1,
    TILE_WIRE_G_JURQPCLKCIB0,
    TILE_WIRE_G_JURQPCLKCIB1,
    TILE_WIRE_G_LDCC0CLKI,
    TILE_WIRE_G_LDCC10CLKI,
    TILE_WIRE_G_LDCC11CLKI,
    TILE_WIRE_G_LDCC12CLKI,
    TILE_WIRE_G_LDCC13CLKI,
    TILE_WIRE_G_LDCC1CLKI,
    TILE_WIRE_G_LDCC2CLKI,
    TILE_WIRE_G_LDCC3CLKI,
    TILE_WIRE_G_LDCC4CLKI,
    TILE_WIRE_G_LDCC5CLKI,
    TILE_WIRE_G_LDCC6CLKI,
    TILE_WIRE_G_LDCC7CLKI,
    TILE_WIRE_G_LDCC8CLKI,
    TILE_WIRE_G_LDCC9CLKI,
    TILE_WIRE_G_LLCPCLKCIB0,
    TILE_WIRE_G_LLDDRDEL,
    TILE_WIRE_G_LLPCLK0,
    TILE_WIRE_G_LLPCLK1,
    TILE_WIRE_G_LLPCLK10,
    TILE_WIRE_G_LLPCLK11,
    TILE_WIRE_G_LLPCLK12,
    TILE_WIRE_G_LLPCLK13,
    TILE_WIRE_G_LLPCLK14,
    TILE_WIRE_G_LLPCLK15,
    TILE_WIRE_G_LLPCLK2,
    TILE_WIRE_G_LLPCLK3,
    TILE_WIRE_G_LLPCLK4,
    TILE_WIRE_G_LLPCLK5,
    TILE_WIRE_G_LLPCLK6,
    TILE_WIRE_G_LLPCLK7,
    TILE_WIRE_G_LLPCLK8,
    TILE_WIRE_G_LLPCLK9,
    TILE_WIRE_G_LRCPCLKCIB0,
    TILE_WIRE_G_LRDDRDEL,
    TILE_WIRE_G_LRPCLK0,
    TILE_WIRE_G_LRPCLK1,
    TILE_WIRE_G_LRPCLK10,
    TILE_WIRE_G_LRPCLK11,
    TILE_WIRE_G_LRPCLK12,
    TILE_WIRE_G_LRPCLK13,
    TILE_WIRE_G_LRPCLK14,
    TILE_WIRE_G_LRPCLK15,
    TILE_WIRE_G_LRPCLK2,
    TILE_WIRE_G_LRPCLK3,
    TILE_WIRE_G_LRPCLK4,
    TILE_WIRE_G_LRPCLK5,
    TILE_WIRE_G_LRPCLK6,
    TILE_WIRE_G_LRPCLK7,
    TILE_WIRE_G_LRPCLK8,
    TILE_WIRE_G_LRPCLK9,
    TILE_WIRE_G_RDCC0CLKI,
    TILE_WIRE_G_RDCC10CLKI,
    TILE_WIRE_G_RDCC11CLKI,
    TILE_WIRE_G_RDCC12CLKI,
    TILE_WIRE_G_RDCC13CLKI,
    TILE_WIRE_G_RDCC1CLKI,
    TILE_WIRE_G_RDCC2CLKI,
    TILE_WIRE_G_RDCC3CLKI,
    TILE_WIRE_G_RDCC4CLKI,
    TILE_WIRE_G_RDCC5CLKI,
    TILE_WIRE_G_RDCC6CLKI,
    TILE_WIRE_G_RDCC7CLKI,
    TILE_WIRE_G_RDCC8CLKI,
    TILE_WIRE_G_RDCC9CLKI,
    TILE_WIRE_G_TDCC0CLKI,
    TILE_WIRE_G_TDCC10CLKI,
    TILE_WIRE_G_TDCC11CLKI,
    TILE_WIRE_G_TDCC1CLKI,
    TILE_WIRE_G_TDCC2CLKI,
    TILE_WIRE_G_TDCC3CLKI,
    TILE_WIRE_G_TDCC4CLKI,
    TILE_WIRE_G_TDCC5CLKI,
    TILE_WIRE_G_TDCC6CLKI,
    TILE_WIRE_G_TDCC7CLKI,
    TILE_WIRE_G_TDCC8CLKI,
    TILE_WIRE_G_TDCC9CLKI,
    TILE_WIRE_G_ULCPCLKCIB0,
    TILE_WIRE_G_ULDDRDEL,
    TILE_WIRE_G_ULPCLK0,
    TILE_WIRE_G_ULPCLK1,
    TILE_WIRE_G_ULPCLK10,
    TILE_WIRE_G_ULPCLK11,
    TILE_WIRE_G_ULPCLK12,
    TILE_WIRE_G_ULPCLK13,
    TILE_WIRE_G_ULPCLK14,
    TILE_WIRE_G_ULPCLK15,
    TILE_WIRE_G_ULPCLK2,
    TILE_WIRE_G_ULPCLK3,
    TILE_WIRE_G_ULPCLK4,
    TILE_WIRE_G_ULPCLK5,
    TILE_WIRE_G_ULPCLK6,
    TILE_WIRE_G_ULPCLK7,
    TILE_WIRE_G_ULPCLK8,
    TILE_WIRE_G_ULPCLK9,
    TILE_WIRE_G_URCPCLKCIB0,
    TILE_WIRE_G_URDDRDEL,
    TILE_WIRE_G_URPCLK0,
    TILE_WIRE_G_URPCLK1,
    TILE_WIRE_G_URPCLK10,
    TILE_WIRE_G_URPCLK11,
    TILE_WIRE_G_URPCLK12,
    TILE_WIRE_G_URPCLK13,
    TILE_WIRE_G_URPCLK14,
    TILE_WIRE_G_URPCLK15,
    TILE_WIRE_G_URPCLK2,
    TILE_WIRE_G_URPCLK3,
    TILE_WIRE_G_URPCLK4,
    TILE_WIRE_G_URPCLK5,
    TILE_WIRE_G_URPCLK6,
    TILE_WIRE_G_URPCLK7,
    TILE_WIRE_G_URPCLK8,
    TILE_WIRE_G_URPCLK9,
    TILE_WIRE_G_VPFN0000,
    TILE_WIRE_G_VPFN0100,
    TILE_WIRE_G_VPFN0200,
    TILE_WIRE_G_VPFN0300,
    TILE_WIRE_G_VPFN0400,
    TILE_WIRE_G_VPFN0500,
    TILE_WIRE_G_VPFN0600,
    TILE_WIRE_G_VPFN0700,
    TILE_WIRE_G_VPFN0800,
    TILE_WIRE_G_VPFN0900,
    TILE_WIRE_G_VPFN1000,
    TILE_WIRE_G_VPFN1100,
    TILE_WIRE_G_VPFN1200,
    TILE_WIRE_G_VPFN1300,
    TILE_WIRE_G_VPFN1400,
    TILE_WIRE_G_VPFN1500,
    TILE_WIRE_G_VPFS0000,
    TILE_WIRE_G_VPFS0100,
    TILE_WIRE_G_VPFS0200,
    TILE_WIRE_G_VPFS0300,
    TILE_WIRE_G_VPFS0400,
    TILE_WIRE_G_VPFS0500,
    TILE_WIRE_G_VPFS0600,
    TILE_WIRE_G_VPFS0700,
    TILE_WIRE_G_VPFS0800,
    TILE_WIRE_G_VPFS0900,
    TILE_WIRE_G_VPFS1000,
    TILE_WIRE_G_VPFS1100,

    TILE_WIRE_BNK_ECLK0,
    TILE_WIRE_BNK_ECLK1,
    TILE_WIRE_BNK_INRD,
    TILE_WIRE_BNK_LVDS,
    TILE_WIRE_CH0_RX_REFCLK,
    TILE_WIRE_CH1_RX_REFCLK,
    TILE_WIRE_CLK0_PLLREFCS,
    TILE_WIRE_CLK1_PLLREFCS,
    TILE_WIRE_CLKFB,
    TILE_WIRE_CLKI0,
    TILE_WIRE_CLKI1,
    TILE_WIRE_CLKINTFB,
    TILE_WIRE_CLKI_CLKDIV0,
    TILE_WIRE_CLKI_CLKDIV1,
    TILE_WIRE_DDRDEL,
    TILE_WIRE_DDRDEL_DLLDEL,
    TILE_WIRE_DLLDEL,
    TILE_WIRE_DQSECLK,
    TILE_WIRE_DQSG_DQSR90,
    TILE_WIRE_DQSG_DQSW,
    TILE_WIRE_DQSG_DQSW270,
    TILE_WIRE_DQSG_RDPNTR0,
    TILE_WIRE_DQSG_RDPNTR1,
    TILE_WIRE_DQSG_RDPNTR2,
    TILE_WIRE_DQSG_WRPNTR0,
    TILE_WIRE_DQSG_WRPNTR1,
    TILE_WIRE_DQSG_WRPNTR2,
    TILE_WIRE_D_REFCLKI,
    TILE_WIRE_ECLKI0,
    TILE_WIRE_ECLKI1,
    TILE_WIRE_ECLKI_BRGECLKSYNC0,
    TILE_WIRE_ECLKI_BRGECLKSYNC1,
    TILE_WIRE_ECLKI_ECLKSYNC0,
    TILE_WIRE_ECLKI_ECLKSYNC1,
    TILE_WIRE_ECSOUT_ECLKBRIDGECS0,
    TILE_WIRE_ECSOUT_ECLKBRIDGECS1,
    TILE_WIRE_EXTREFCLK,

    TILE_WIRE_INPUT_REFN_APIO,
    TILE_WIRE_INPUT_REFP_APIO,
    TILE_WIRE_JALIGNWD_CLKDIV0,
    TILE_WIRE_JALIGNWD_CLKDIV1,
    TILE_WIRE_JA_DLLDEL,
    TILE_WIRE_JBRGECLK0,
    TILE_WIRE_JBRGECLK1,
    TILE_WIRE_JCDIVX_CLKDIV0,
    TILE_WIRE_JCDIVX_CLKDIV1,
    TILE_WIRE_JCFB0,
    TILE_WIRE_JCFB1,
    TILE_WIRE_JCFB10,
    TILE_WIRE_JCFB11,
    TILE_WIRE_JCFB12,
    TILE_WIRE_JCFB13,
    TILE_WIRE_JCFB14,
    TILE_WIRE_JCFB15,
    TILE_WIRE_JCFB16,
    TILE_WIRE_JCFB17,
    TILE_WIRE_JCFB18,
    TILE_WIRE_JCFB19,
    TILE_WIRE_JCFB2,
    TILE_WIRE_JCFB20,
    TILE_WIRE_JCFB21,
    TILE_WIRE_JCFB22,
    TILE_WIRE_JCFB23,
    TILE_WIRE_JCFB24,
    TILE_WIRE_JCFB25,
    TILE_WIRE_JCFB26,
    TILE_WIRE_JCFB27,
    TILE_WIRE_JCFB28,
    TILE_WIRE_JCFB29,
    TILE_WIRE_JCFB3,
    TILE_WIRE_JCFB30,
    TILE_WIRE_JCFB31,
    TILE_WIRE_JCFB32,
    TILE_WIRE_JCFB33,
    TILE_WIRE_JCFB34,
    TILE_WIRE_JCFB35,
    TILE_WIRE_JCFB36,
    TILE_WIRE_JCFB37,
    TILE_WIRE_JCFB38,
    TILE_WIRE_JCFB39,
    TILE_WIRE_JCFB4,
    TILE_WIRE_JCFB40,
    TILE_WIRE_JCFB41,
    TILE_WIRE_JCFB42,
    TILE_WIRE_JCFB43,
    TILE_WIRE_JCFB44,
    TILE_WIRE_JCFB45,
    TILE_WIRE_JCFB46,
    TILE_WIRE_JCFB47,
    TILE_WIRE_JCFB48,
    TILE_WIRE_JCFB49,
    TILE_WIRE_JCFB5,
    TILE_WIRE_JCFB50,
    TILE_WIRE_JCFB51,
    TILE_WIRE_JCFB52,
    TILE_WIRE_JCFB53,
    TILE_WIRE_JCFB6,
    TILE_WIRE_JCFB7,
    TILE_WIRE_JCFB8,
    TILE_WIRE_JCFB9,
    TILE_WIRE_JCFLAG_DLLDEL,
    TILE_WIRE_JCH0RXREFCLKCIB,
    TILE_WIRE_JCH1RXREFCLKCIB,
    TILE_WIRE_JCIBCLK0,
    TILE_WIRE_JCLK0_ECLKBRIDGECS0,
    TILE_WIRE_JCLK0_ECLKBRIDGECS1,
    TILE_WIRE_JCLK1_ECLKBRIDGECS0,
    TILE_WIRE_JCLK1_ECLKBRIDGECS1,
    TILE_WIRE_JCLKFB1,
    TILE_WIRE_JCLKFB2,
    TILE_WIRE_JCLKFB3,
    TILE_WIRE_JCO0,
    TILE_WIRE_JCO1,
    TILE_WIRE_JCO10,
    TILE_WIRE_JCO11,
    TILE_WIRE_JCO12,
    TILE_WIRE_JCO13,
    TILE_WIRE_JCO14,
    TILE_WIRE_JCO15,
    TILE_WIRE_JCO16,
    TILE_WIRE_JCO17,
    TILE_WIRE_JCO18,
    TILE_WIRE_JCO19,
    TILE_WIRE_JCO2,
    TILE_WIRE_JCO20,
    TILE_WIRE_JCO21,
    TILE_WIRE_JCO22,
    TILE_WIRE_JCO23,
    TILE_WIRE_JCO24,
    TILE_WIRE_JCO25,
    TILE_WIRE_JCO26,
    TILE_WIRE_JCO27,
    TILE_WIRE_JCO28,
    TILE_WIRE_JCO29,
    TILE_WIRE_JCO3,
    TILE_WIRE_JCO30,
    TILE_WIRE_JCO31,
    TILE_WIRE_JCO32,
    TILE_WIRE_JCO33,
    TILE_WIRE_JCO34,
    TILE_WIRE_JCO35,
    TILE_WIRE_JCO36,
    TILE_WIRE_JCO37,
    TILE_WIRE_JCO38,
    TILE_WIRE_JCO39,
    TILE_WIRE_JCO4,
    TILE_WIRE_JCO40,
    TILE_WIRE_JCO41,
    TILE_WIRE_JCO42,
    TILE_WIRE_JCO43,
    TILE_WIRE_JCO44,
    TILE_WIRE_JCO45,
    TILE_WIRE_JCO46,
    TILE_WIRE_JCO47,
    TILE_WIRE_JCO48,
    TILE_WIRE_JCO49,
    TILE_WIRE_JCO5,
    TILE_WIRE_JCO50,
    TILE_WIRE_JCO51,
    TILE_WIRE_JCO52,
    TILE_WIRE_JCO53,
    TILE_WIRE_JCO6,
    TILE_WIRE_JCO7,
    TILE_WIRE_JCO8,
    TILE_WIRE_JCO9,
    TILE_WIRE_JDDRDLLCLK,
    TILE_WIRE_JDIRECTION_DLLDEL,
    TILE_WIRE_JDSPC0,
    TILE_WIRE_JDSPC1,
    TILE_WIRE_JDSPC10,
    TILE_WIRE_JDSPC11,
    TILE_WIRE_JDSPC12,
    TILE_WIRE_JDSPC13,
    TILE_WIRE_JDSPC14,
    TILE_WIRE_JDSPC15,
    TILE_WIRE_JDSPC16,
    TILE_WIRE_JDSPC17,
    TILE_WIRE_JDSPC18,
    TILE_WIRE_JDSPC19,
    TILE_WIRE_JDSPC2,
    TILE_WIRE_JDSPC20,
    TILE_WIRE_JDSPC21,
    TILE_WIRE_JDSPC22,
    TILE_WIRE_JDSPC23,
    TILE_WIRE_JDSPC24,
    TILE_WIRE_JDSPC25,
    TILE_WIRE_JDSPC26,
    TILE_WIRE_JDSPC3,
    TILE_WIRE_JDSPC4,
    TILE_WIRE_JDSPC5,
    TILE_WIRE_JDSPC6,
    TILE_WIRE_JDSPC7,
    TILE_WIRE_JDSPC8,
    TILE_WIRE_JDSPC9,
    TILE_WIRE_JD_SYNC_ND_DCU,
    TILE_WIRE_JD_TXBIT_CLKN_FROM_ND_DCU,
    TILE_WIRE_JD_TXBIT_CLKP_FROM_ND_DCU,
    TILE_WIRE_JD_TXPLL_LOL_FROM_ND_DCU,
    TILE_WIRE_JECLK0,
    TILE_WIRE_JECLK1,
    TILE_WIRE_JECLKI0,
    TILE_WIRE_JECLKI1,
    TILE_WIRE_JECLKO_BRGECLKSYNC0,
    TILE_WIRE_JECLKO_BRGECLKSYNC1,
    TILE_WIRE_JECLKO_ECLKSYNC0,
    TILE_WIRE_JECLKO_ECLKSYNC1,
    TILE_WIRE_JINCK,
    TILE_WIRE_JINPUT_IN0_APIO,
    TILE_WIRE_JINPUT_IN1_APIO,
    TILE_WIRE_JINPUT_IP0_APIO,
    TILE_WIRE_JINPUT_IP1_APIO,
    TILE_WIRE_JJTCK,
    TILE_WIRE_JLOADN_DLLDEL,
    TILE_WIRE_JMOVE_DLLDEL,
    TILE_WIRE_JMSROA0,
    TILE_WIRE_JMSROA1,
    TILE_WIRE_JMSROA10,
    TILE_WIRE_JMSROA11,
    TILE_WIRE_JMSROA12,
    TILE_WIRE_JMSROA13,
    TILE_WIRE_JMSROA14,
    TILE_WIRE_JMSROA15,
    TILE_WIRE_JMSROA16,
    TILE_WIRE_JMSROA17,
    TILE_WIRE_JMSROA2,
    TILE_WIRE_JMSROA3,
    TILE_WIRE_JMSROA4,
    TILE_WIRE_JMSROA5,
    TILE_WIRE_JMSROA6,
    TILE_WIRE_JMSROA7,
    TILE_WIRE_JMSROA8,
    TILE_WIRE_JMSROA9,
    TILE_WIRE_JMUIA0,
    TILE_WIRE_JMUIA1,
    TILE_WIRE_JMUIA10,
    TILE_WIRE_JMUIA11,
    TILE_WIRE_JMUIA12,
    TILE_WIRE_JMUIA13,
    TILE_WIRE_JMUIA14,
    TILE_WIRE_JMUIA15,
    TILE_WIRE_JMUIA16,
    TILE_WIRE_JMUIA17,
    TILE_WIRE_JMUIA2,
    TILE_WIRE_JMUIA3,
    TILE_WIRE_JMUIA4,
    TILE_WIRE_JMUIA5,
    TILE_WIRE_JMUIA6,
    TILE_WIRE_JMUIA7,
    TILE_WIRE_JMUIA8,
    TILE_WIRE_JMUIA9,
    TILE_WIRE_JMUIC0,
    TILE_WIRE_JMUIC1,
    TILE_WIRE_JMUIC10,
    TILE_WIRE_JMUIC11,
    TILE_WIRE_JMUIC12,
    TILE_WIRE_JMUIC13,
    TILE_WIRE_JMUIC14,
    TILE_WIRE_JMUIC15,
    TILE_WIRE_JMUIC16,
    TILE_WIRE_JMUIC17,
    TILE_WIRE_JMUIC18,
    TILE_WIRE_JMUIC19,
    TILE_WIRE_JMUIC2,
    TILE_WIRE_JMUIC20,
    TILE_WIRE_JMUIC21,
    TILE_WIRE_JMUIC22,
    TILE_WIRE_JMUIC23,
    TILE_WIRE_JMUIC24,
    TILE_WIRE_JMUIC25,
    TILE_WIRE_JMUIC26,
    TILE_WIRE_JMUIC3,
    TILE_WIRE_JMUIC4,
    TILE_WIRE_JMUIC5,
    TILE_WIRE_JMUIC6,
    TILE_WIRE_JMUIC7,
    TILE_WIRE_JMUIC8,
    TILE_WIRE_JMUIC9,
    TILE_WIRE_JMULTA0,
    TILE_WIRE_JMULTA1,
    TILE_WIRE_JMULTA10,
    TILE_WIRE_JMULTA11,
    TILE_WIRE_JMULTA12,
    TILE_WIRE_JMULTA13,
    TILE_WIRE_JMULTA14,
    TILE_WIRE_JMULTA15,
    TILE_WIRE_JMULTA16,
    TILE_WIRE_JMULTA17,
    TILE_WIRE_JMULTA2,
    TILE_WIRE_JMULTA3,
    TILE_WIRE_JMULTA4,
    TILE_WIRE_JMULTA5,
    TILE_WIRE_JMULTA6,
    TILE_WIRE_JMULTA7,
    TILE_WIRE_JMULTA8,
    TILE_WIRE_JMULTA9,
    TILE_WIRE_JNEIGHBORECLK0,
    TILE_WIRE_JNEIGHBORECLK1,
    TILE_WIRE_JNEXTR0,
    TILE_WIRE_JNEXTR1,
    TILE_WIRE_JNEXTR10,
    TILE_WIRE_JNEXTR11,
    TILE_WIRE_JNEXTR12,
    TILE_WIRE_JNEXTR13,
    TILE_WIRE_JNEXTR14,
    TILE_WIRE_JNEXTR15,
    TILE_WIRE_JNEXTR16,
    TILE_WIRE_JNEXTR17,
    TILE_WIRE_JNEXTR18,
    TILE_WIRE_JNEXTR19,
    TILE_WIRE_JNEXTR2,
    TILE_WIRE_JNEXTR20,
    TILE_WIRE_JNEXTR21,
    TILE_WIRE_JNEXTR22,
    TILE_WIRE_JNEXTR23,
    TILE_WIRE_JNEXTR24,
    TILE_WIRE_JNEXTR25,
    TILE_WIRE_JNEXTR26,
    TILE_WIRE_JNEXTR27,
    TILE_WIRE_JNEXTR28,
    TILE_WIRE_JNEXTR29,
    TILE_WIRE_JNEXTR3,
    TILE_WIRE_JNEXTR30,
    TILE_WIRE_JNEXTR31,
    TILE_WIRE_JNEXTR32,
    TILE_WIRE_JNEXTR33,
    TILE_WIRE_JNEXTR34,
    TILE_WIRE_JNEXTR35,
    TILE_WIRE_JNEXTR36,
    TILE_WIRE_JNEXTR37,
    TILE_WIRE_JNEXTR38,
    TILE_WIRE_JNEXTR39,
    TILE_WIRE_JNEXTR4,
    TILE_WIRE_JNEXTR40,
    TILE_WIRE_JNEXTR41,
    TILE_WIRE_JNEXTR42,
    TILE_WIRE_JNEXTR43,
    TILE_WIRE_JNEXTR44,
    TILE_WIRE_JNEXTR45,
    TILE_WIRE_JNEXTR46,
    TILE_WIRE_JNEXTR47,
    TILE_WIRE_JNEXTR48,
    TILE_WIRE_JNEXTR49,
    TILE_WIRE_JNEXTR5,
    TILE_WIRE_JNEXTR50,
    TILE_WIRE_JNEXTR51,
    TILE_WIRE_JNEXTR52,
    TILE_WIRE_JNEXTR53,
    TILE_WIRE_JNEXTR6,
    TILE_WIRE_JNEXTR7,
    TILE_WIRE_JNEXTR8,
    TILE_WIRE_JNEXTR9,
    TILE_WIRE_JOUTPUT_ON0_APIO,
    TILE_WIRE_JOUTPUT_ON1_APIO,
    TILE_WIRE_JOUTPUT_OP0_APIO,
    TILE_WIRE_JOUTPUT_OP1_APIO,
    TILE_WIRE_JP0,
    TILE_WIRE_JP1,
    TILE_WIRE_JP10,
    TILE_WIRE_JP11,
    TILE_WIRE_JP12,
    TILE_WIRE_JP13,
    TILE_WIRE_JP14,
    TILE_WIRE_JP15,
    TILE_WIRE_JP16,
    TILE_WIRE_JP17,
    TILE_WIRE_JP18,
    TILE_WIRE_JP19,
    TILE_WIRE_JP2,
    TILE_WIRE_JP20,
    TILE_WIRE_JP21,
    TILE_WIRE_JP22,
    TILE_WIRE_JP23,
    TILE_WIRE_JP24,
    TILE_WIRE_JP25,
    TILE_WIRE_JP26,
    TILE_WIRE_JP27,
    TILE_WIRE_JP28,
    TILE_WIRE_JP29,
    TILE_WIRE_JP3,
    TILE_WIRE_JP30,
    TILE_WIRE_JP31,
    TILE_WIRE_JP32,
    TILE_WIRE_JP33,
    TILE_WIRE_JP34,
    TILE_WIRE_JP35,
    TILE_WIRE_JP36,
    TILE_WIRE_JP37,
    TILE_WIRE_JP38,
    TILE_WIRE_JP39,
    TILE_WIRE_JP4,
    TILE_WIRE_JP40,
    TILE_WIRE_JP41,
    TILE_WIRE_JP42,
    TILE_WIRE_JP43,
    TILE_WIRE_JP44,
    TILE_WIRE_JP45,
    TILE_WIRE_JP46,
    TILE_WIRE_JP47,
    TILE_WIRE_JP48,
    TILE_WIRE_JP49,
    TILE_WIRE_JP5,
    TILE_WIRE_JP50,
    TILE_WIRE_JP51,
    TILE_WIRE_JP52,
    TILE_WIRE_JP53,
    TILE_WIRE_JP6,
    TILE_WIRE_JP7,
    TILE_WIRE_JP8,
    TILE_WIRE_JP9,
    TILE_WIRE_JPADDI,
    TILE_WIRE_JPCSCDIVCIB0,
    TILE_WIRE_JPCSCDIVCIB1,
    TILE_WIRE_JPO0,
    TILE_WIRE_JPO1,
    TILE_WIRE_JPO10,
    TILE_WIRE_JPO11,
    TILE_WIRE_JPO12,
    TILE_WIRE_JPO13,
    TILE_WIRE_JPO14,
    TILE_WIRE_JPO15,
    TILE_WIRE_JPO16,
    TILE_WIRE_JPO17,
    TILE_WIRE_JPO2,
    TILE_WIRE_JPO3,
    TILE_WIRE_JPO4,
    TILE_WIRE_JPO5,
    TILE_WIRE_JPO6,
    TILE_WIRE_JPO7,
    TILE_WIRE_JPO8,
    TILE_WIRE_JPO9,
    TILE_WIRE_JPSROA0,
    TILE_WIRE_JPSROA1,
    TILE_WIRE_JPSROA10,
    TILE_WIRE_JPSROA11,
    TILE_WIRE_JPSROA12,
    TILE_WIRE_JPSROA13,
    TILE_WIRE_JPSROA14,
    TILE_WIRE_JPSROA15,
    TILE_WIRE_JPSROA16,
    TILE_WIRE_JPSROA17,
    TILE_WIRE_JPSROA2,
    TILE_WIRE_JPSROA3,
    TILE_WIRE_JPSROA4,
    TILE_WIRE_JPSROA5,
    TILE_WIRE_JPSROA6,
    TILE_WIRE_JPSROA7,
    TILE_WIRE_JPSROA8,
    TILE_WIRE_JPSROA9,
    TILE_WIRE_JR0,
    TILE_WIRE_JR1,
    TILE_WIRE_JR10,
    TILE_WIRE_JR11,
    TILE_WIRE_JR12,
    TILE_WIRE_JR13,
    TILE_WIRE_JR14,
    TILE_WIRE_JR15,
    TILE_WIRE_JR16,
    TILE_WIRE_JR17,
    TILE_WIRE_JR18,
    TILE_WIRE_JR19,
    TILE_WIRE_JR2,
    TILE_WIRE_JR20,
    TILE_WIRE_JR21,
    TILE_WIRE_JR22,
    TILE_WIRE_JR23,
    TILE_WIRE_JR24,
    TILE_WIRE_JR25,
    TILE_WIRE_JR26,
    TILE_WIRE_JR27,
    TILE_WIRE_JR28,
    TILE_WIRE_JR29,
    TILE_WIRE_JR3,
    TILE_WIRE_JR30,
    TILE_WIRE_JR31,
    TILE_WIRE_JR32,
    TILE_WIRE_JR33,
    TILE_WIRE_JR34,
    TILE_WIRE_JR35,
    TILE_WIRE_JR36,
    TILE_WIRE_JR37,
    TILE_WIRE_JR38,
    TILE_WIRE_JR39,
    TILE_WIRE_JR4,
    TILE_WIRE_JR40,
    TILE_WIRE_JR41,
    TILE_WIRE_JR42,
    TILE_WIRE_JR43,
    TILE_WIRE_JR44,
    TILE_WIRE_JR45,
    TILE_WIRE_JR46,
    TILE_WIRE_JR47,
    TILE_WIRE_JR48,
    TILE_WIRE_JR49,
    TILE_WIRE_JR5,
    TILE_WIRE_JR50,
    TILE_WIRE_JR51,
    TILE_WIRE_JR52,
    TILE_WIRE_JR53,
    TILE_WIRE_JR6,
    TILE_WIRE_JR7,
    TILE_WIRE_JR8,
    TILE_WIRE_JR9,
    TILE_WIRE_JRCDIVX0,
    TILE_WIRE_JRCDIVX1,
    TILE_WIRE_JREFCLK0_0,
    TILE_WIRE_JREFCLK0_1,
    TILE_WIRE_JREFCLK0_2,
    TILE_WIRE_JREFCLK0_3,
    TILE_WIRE_JREFCLK0_4,
    TILE_WIRE_JREFCLK0_5,
    TILE_WIRE_JREFCLK0_6,
    TILE_WIRE_JREFCLK1_0,
    TILE_WIRE_JREFCLK1_1,
    TILE_WIRE_JREFCLK1_2,
    TILE_WIRE_JREFCLK1_3,
    TILE_WIRE_JREFCLK1_4,
    TILE_WIRE_JREFCLK1_5,
    TILE_WIRE_JREFCLK1_6,
    TILE_WIRE_JREFCLKFROMND,
    TILE_WIRE_JROC27,
    TILE_WIRE_JROC28,
    TILE_WIRE_JROC29,
    TILE_WIRE_JROC30,
    TILE_WIRE_JROC31,
    TILE_WIRE_JROC32,
    TILE_WIRE_JROC33,
    TILE_WIRE_JROC34,
    TILE_WIRE_JROC35,
    TILE_WIRE_JROC36,
    TILE_WIRE_JROC37,
    TILE_WIRE_JROC38,
    TILE_WIRE_JROC39,
    TILE_WIRE_JROC40,
    TILE_WIRE_JROC41,
    TILE_WIRE_JROC42,
    TILE_WIRE_JROC43,
    TILE_WIRE_JROC44,
    TILE_WIRE_JROC45,
    TILE_WIRE_JROC46,
    TILE_WIRE_JROC47,
    TILE_WIRE_JROC48,
    TILE_WIRE_JROC49,
    TILE_WIRE_JROC50,
    TILE_WIRE_JROC51,
    TILE_WIRE_JROC52,
    TILE_WIRE_JROC53,
    TILE_WIRE_JRST_CLKDIV0,
    TILE_WIRE_JRST_CLKDIV1,
    TILE_WIRE_JSEL_ECLKBRIDGECS0,
    TILE_WIRE_JSEL_ECLKBRIDGECS1,
    TILE_WIRE_JSEL_PLLREFCS,
    TILE_WIRE_JSERDESREFCLK0,
    TILE_WIRE_JSERDESREFCLK1,
    TILE_WIRE_JSROA0,
    TILE_WIRE_JSROA1,
    TILE_WIRE_JSROA10,
    TILE_WIRE_JSROA11,
    TILE_WIRE_JSROA12,
    TILE_WIRE_JSROA13,
    TILE_WIRE_JSROA14,
    TILE_WIRE_JSROA15,
    TILE_WIRE_JSROA16,
    TILE_WIRE_JSROA17,
    TILE_WIRE_JSROA2,
    TILE_WIRE_JSROA3,
    TILE_WIRE_JSROA4,
    TILE_WIRE_JSROA5,
    TILE_WIRE_JSROA6,
    TILE_WIRE_JSROA7,
    TILE_WIRE_JSROA8,
    TILE_WIRE_JSROA9,
    TILE_WIRE_JSTOP_BRGECLKSYNC0,
    TILE_WIRE_JSTOP_BRGECLKSYNC1,
    TILE_WIRE_JSTOP_ECLKSYNC0,
    TILE_WIRE_JSTOP_ECLKSYNC1,
    TILE_WIRE_JTCK_TCK,
    TILE_WIRE_JTDI_TDI,
    TILE_WIRE_JTDO_TDO,
    TILE_WIRE_JTMS_TMS,
    TILE_WIRE_JTXREFCLK,
    TILE_WIRE_JTXREFCLKCIB,
    TILE_WIRE_KEEPWIRE,
    TILE_WIRE_PCSCDIV10,
    TILE_WIRE_PCSCDIV11,
    TILE_WIRE_PCSCDIVI0,
    TILE_WIRE_PCSCDIVI1,
    TILE_WIRE_PCSCDIVX0,
    TILE_WIRE_PCSCDIVX1,
    TILE_WIRE_PLLCSOUT_PLLREFCS,
    TILE_WIRE_REFCLK0,
    TILE_WIRE_REFCLK1,
    TILE_WIRE_RXREFCLK0,
    TILE_WIRE_RXREFCLK1,
    TILE_WIRE_SYNCECLK0,
    TILE_WIRE_SYNCECLK1,
    TILE_WIRE_Z_DLLDEL
};

void gfxTileBel(std::vector<GraphicElement> &g, int x, int y, int z, int w, int h, IdString bel_type,
                GraphicElement::style_t style);
void gfxTileWire(std::vector<GraphicElement> &g, int x, int y, int w, int h, IdString wire_type, GfxTileWireId tilewire,
                 GraphicElement::style_t style);
void gfxTilePip(std::vector<GraphicElement> &g, int x, int y, int w, int h, WireId src, IdString src_type,
                GfxTileWireId src_id, WireId dst, IdString dst_type, GfxTileWireId dst_id,
                GraphicElement::style_t style);

NEXTPNR_NAMESPACE_END

#endif
