---
Name: VCFTools
URL: https://vcftools.github.io
Description: VCFTools is a program for working with and reporting on VCF files.
---

### Important General Note

- Depending on the size and density of the variant data (vcf),
  some of the stat files generated by vcftools can be very large.
  If you find that some of your input files are missing, increase
  the [config.log_filesize_limit](http://multiqc.info/docs/#big-log-files)
  so that the large file(s) will not be skipped by MultiQC. Note, however,
  that this might make MultiQC very slow!

This module parses the outputs from VCFTools' various commands:

### Implemented

- `relatedness2`
  - Plots a heatmap of pairwise sample relatedness.
  - Not to be confused with the similarly-named command `relatedness`
- `TsTv-by-count`
  - Plots the transition to transversion ratio as a function of
    alternative allele count (using only bi-allelic SNPs).
- `TsTv-by-qual`
  - Plots the transition to transversion ratio as a function of SNP
    quality threshold (using only bi-allelic SNPs).
- `TsTv-summary`
  - Plots a bargraph of the summary counts of each type of transition and
    transversion SNPs.

### To do

VCFTools has a number of outputs not yet supported in MultiQC which
would be good to add. Please check GitHub if you'd like these added
or (better still), would like to contribute!

- basic stats
- relatedness
- freq
- depth
- [Everything else](https://vcftools.github.io/man_latest.html)
