/* This file is part of libhud-qt
 * Copyright 2013 Canonical Ltd.
 *
 * libhud-qt is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * libhud-qt is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef UBUNTU_HUD_CONTEXT_H
#define UBUNTU_HUD_CONTEXT_H

#include <QObject>
#include <QString>

#include "action.h"

typedef struct _HudActionPublisher HudActionPublisher;

namespace Ubuntu {
namespace HUD {
    class Context;
    class HUD;
}
}

class Ubuntu::HUD::Context : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(Context)

    Q_PROPERTY(QString identifier
               READ identifier
               WRITE setIdentifier
               NOTIFY identifierChanged)

    class Private;

public:
    explicit Context(QObject *parent = 0);
    virtual ~Context();

    QList<Action *> actions();

    QString identifier() const;
    void setIdentifier(const QString &identifier);

    Q_INVOKABLE void injectRecentAction(const QString &id);

    Q_INVOKABLE void addAction(Action *action);

    Q_INVOKABLE void removeAction(Action *action);

    Q_INVOKABLE void invokeAction(const QString &id);

signals:

    void identifierChanged(const QString &identifier);

    void actionsChanged();
    void actionAdded(Action *action);
    void actionRemoved(Action *action);

private:
    Private *d;

    friend Ubuntu::HUD::HUD;
    HudActionPublisher *publisher();
};

#endif // UBUNTU_HUD_CONTEXT_H
