/* vfs-trash.c generated by valac 0.10.4, the Vala compiler
 * generated from vfs-trash.vala, do not modify */

/*
 * Desktop Agnostic Library: Trash interface.
 *
 * Copyright (C) 2008, 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define DESKTOP_AGNOSTIC_VFS_TYPE_TRASH (desktop_agnostic_vfs_trash_get_type ())
#define DESKTOP_AGNOSTIC_VFS_TRASH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH, DesktopAgnosticVFSTrash))
#define DESKTOP_AGNOSTIC_VFS_IS_TRASH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH))
#define DESKTOP_AGNOSTIC_VFS_TRASH_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH, DesktopAgnosticVFSTrashIface))

typedef struct _DesktopAgnosticVFSTrash DesktopAgnosticVFSTrash;
typedef struct _DesktopAgnosticVFSTrashIface DesktopAgnosticVFSTrashIface;

#define DESKTOP_AGNOSTIC_VFS_TYPE_FILE (desktop_agnostic_vfs_file_get_type ())
#define DESKTOP_AGNOSTIC_VFS_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE, DesktopAgnosticVFSFile))
#define DESKTOP_AGNOSTIC_VFS_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE, DesktopAgnosticVFSFileClass))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE))
#define DESKTOP_AGNOSTIC_VFS_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE, DesktopAgnosticVFSFileClass))

typedef struct _DesktopAgnosticVFSFile DesktopAgnosticVFSFile;
typedef struct _DesktopAgnosticVFSFileClass DesktopAgnosticVFSFileClass;

#define DESKTOP_AGNOSTIC_VFS_TYPE_IMPLEMENTATION (desktop_agnostic_vfs_implementation_get_type ())
#define DESKTOP_AGNOSTIC_VFS_IMPLEMENTATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_IMPLEMENTATION, DesktopAgnosticVFSImplementation))
#define DESKTOP_AGNOSTIC_VFS_IS_IMPLEMENTATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_IMPLEMENTATION))
#define DESKTOP_AGNOSTIC_VFS_IMPLEMENTATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_IMPLEMENTATION, DesktopAgnosticVFSImplementationIface))

typedef struct _DesktopAgnosticVFSImplementation DesktopAgnosticVFSImplementation;
typedef struct _DesktopAgnosticVFSImplementationIface DesktopAgnosticVFSImplementationIface;

#define DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR (desktop_agnostic_vfs_volume_monitor_get_type ())
#define DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR, DesktopAgnosticVFSVolumeMonitor))
#define DESKTOP_AGNOSTIC_VFS_IS_VOLUME_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR))
#define DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR, DesktopAgnosticVFSVolumeMonitorIface))

typedef struct _DesktopAgnosticVFSVolumeMonitor DesktopAgnosticVFSVolumeMonitor;
typedef struct _DesktopAgnosticVFSVolumeMonitorIface DesktopAgnosticVFSVolumeMonitorIface;

#define DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME (desktop_agnostic_vfs_volume_get_type ())
#define DESKTOP_AGNOSTIC_VFS_VOLUME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME, DesktopAgnosticVFSVolume))
#define DESKTOP_AGNOSTIC_VFS_IS_VOLUME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME))
#define DESKTOP_AGNOSTIC_VFS_VOLUME_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME, DesktopAgnosticVFSVolumeIface))

typedef struct _DesktopAgnosticVFSVolume DesktopAgnosticVFSVolume;
typedef struct _DesktopAgnosticVFSVolumeIface DesktopAgnosticVFSVolumeIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _DesktopAgnosticVFSTrashIface {
	GTypeInterface parent_iface;
	void (*send_to_trash) (DesktopAgnosticVFSTrash* self, DesktopAgnosticVFSFile* file, GError** error);
	void (*empty) (DesktopAgnosticVFSTrash* self);
	guint (*get_file_count) (DesktopAgnosticVFSTrash* self);
};

typedef void (*DesktopAgnosticVFSVolumeCallback) (void* user_data);
typedef enum  {
	DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR_MOUNT,
	DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR_UNMOUNT,
	DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR_EJECT
} DesktopAgnosticVFSVolumeError;
#define DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR desktop_agnostic_vfs_volume_error_quark ()
struct _DesktopAgnosticVFSVolumeIface {
	GTypeInterface parent_iface;
	gboolean (*is_mounted) (DesktopAgnosticVFSVolume* self);
	void (*mount) (DesktopAgnosticVFSVolume* self, DesktopAgnosticVFSVolumeCallback callback, void* callback_target);
	gboolean (*mount_finish) (DesktopAgnosticVFSVolume* self, GError** error);
	void (*unmount) (DesktopAgnosticVFSVolume* self, DesktopAgnosticVFSVolumeCallback callback, void* callback_target);
	gboolean (*unmount_finish) (DesktopAgnosticVFSVolume* self, GError** error);
	gboolean (*can_eject) (DesktopAgnosticVFSVolume* self);
	void (*eject) (DesktopAgnosticVFSVolume* self, DesktopAgnosticVFSVolumeCallback callback, void* callback_target);
	gboolean (*eject_finish) (DesktopAgnosticVFSVolume* self, GError** error);
	const char* (*get_name) (DesktopAgnosticVFSVolume* self);
	DesktopAgnosticVFSFile* (*get_uri) (DesktopAgnosticVFSVolume* self);
	char* (*get_icon) (DesktopAgnosticVFSVolume* self);
};

struct _DesktopAgnosticVFSVolumeMonitorIface {
	GTypeInterface parent_iface;
	void* (*get_implementation) (DesktopAgnosticVFSVolumeMonitor* self);
	GList* (*get_volumes) (DesktopAgnosticVFSVolumeMonitor* self);
};

struct _DesktopAgnosticVFSImplementationIface {
	GTypeInterface parent_iface;
	void (*init) (DesktopAgnosticVFSImplementation* self);
	GSList* (*files_from_uri_list) (DesktopAgnosticVFSImplementation* self, const char* uri_list, GError** error);
	DesktopAgnosticVFSVolumeMonitor* (*volume_monitor_get_default) (DesktopAgnosticVFSImplementation* self);
	void (*shutdown) (DesktopAgnosticVFSImplementation* self);
	const char* (*get_name) (DesktopAgnosticVFSImplementation* self);
	GType (*get_file_type) (DesktopAgnosticVFSImplementation* self);
	GType (*get_file_monitor_type) (DesktopAgnosticVFSImplementation* self);
	GType (*get_trash_type) (DesktopAgnosticVFSImplementation* self);
	GType (*get_volume_type) (DesktopAgnosticVFSImplementation* self);
};


extern DesktopAgnosticVFSTrash* desktop_agnostic_vfs_trash;
DesktopAgnosticVFSTrash* desktop_agnostic_vfs_trash = NULL;

GType desktop_agnostic_vfs_file_get_type (void) G_GNUC_CONST;
GType desktop_agnostic_vfs_trash_get_type (void) G_GNUC_CONST;
void desktop_agnostic_vfs_trash_send_to_trash (DesktopAgnosticVFSTrash* self, DesktopAgnosticVFSFile* file, GError** error);
void desktop_agnostic_vfs_trash_empty (DesktopAgnosticVFSTrash* self);
guint desktop_agnostic_vfs_trash_get_file_count (DesktopAgnosticVFSTrash* self);
DesktopAgnosticVFSTrash* desktop_agnostic_vfs_trash_get_default (GError** error);
GQuark desktop_agnostic_vfs_volume_error_quark (void);
GType desktop_agnostic_vfs_volume_get_type (void) G_GNUC_CONST;
GType desktop_agnostic_vfs_volume_monitor_get_type (void) G_GNUC_CONST;
GType desktop_agnostic_vfs_implementation_get_type (void) G_GNUC_CONST;
DesktopAgnosticVFSImplementation* desktop_agnostic_vfs_get_default (GError** error);
GType desktop_agnostic_vfs_implementation_get_trash_type (DesktopAgnosticVFSImplementation* self);



void desktop_agnostic_vfs_trash_send_to_trash (DesktopAgnosticVFSTrash* self, DesktopAgnosticVFSFile* file, GError** error) {
	DESKTOP_AGNOSTIC_VFS_TRASH_GET_INTERFACE (self)->send_to_trash (self, file, error);
}


void desktop_agnostic_vfs_trash_empty (DesktopAgnosticVFSTrash* self) {
	DESKTOP_AGNOSTIC_VFS_TRASH_GET_INTERFACE (self)->empty (self);
}


guint desktop_agnostic_vfs_trash_get_file_count (DesktopAgnosticVFSTrash* self) {
	return DESKTOP_AGNOSTIC_VFS_TRASH_GET_INTERFACE (self)->get_file_count (self);
}


static void desktop_agnostic_vfs_trash_base_init (DesktopAgnosticVFSTrashIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_uint ("file-count", "file-count", "file-count", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_signal_new ("file_count_changed", DESKTOP_AGNOSTIC_VFS_TYPE_TRASH, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	}
}


GType desktop_agnostic_vfs_trash_get_type (void) {
	static volatile gsize desktop_agnostic_vfs_trash_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_agnostic_vfs_trash_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticVFSTrashIface), (GBaseInitFunc) desktop_agnostic_vfs_trash_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType desktop_agnostic_vfs_trash_type_id;
		desktop_agnostic_vfs_trash_type_id = g_type_register_static (G_TYPE_INTERFACE, "DesktopAgnosticVFSTrash", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (desktop_agnostic_vfs_trash_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&desktop_agnostic_vfs_trash_type_id__volatile, desktop_agnostic_vfs_trash_type_id);
	}
	return desktop_agnostic_vfs_trash_type_id__volatile;
}


DesktopAgnosticVFSTrash* desktop_agnostic_vfs_trash_get_default (GError** error) {
	DesktopAgnosticVFSTrash* result = NULL;
	GError * _inner_error_ = NULL;
	if (desktop_agnostic_vfs_trash == NULL) {
		DesktopAgnosticVFSImplementation* vfs;
		GObject* _tmp0_;
		DesktopAgnosticVFSTrash* _tmp1_;
		vfs = desktop_agnostic_vfs_get_default (&_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		desktop_agnostic_vfs_trash = (_tmp1_ = DESKTOP_AGNOSTIC_VFS_TRASH ((_tmp0_ = g_object_new (desktop_agnostic_vfs_implementation_get_trash_type (vfs), NULL), G_IS_INITIALLY_UNOWNED (_tmp0_) ? g_object_ref_sink (_tmp0_) : _tmp0_)), _g_object_unref0 (desktop_agnostic_vfs_trash), _tmp1_);
	}
	result = desktop_agnostic_vfs_trash;
	return result;
}




