<?PHP
# Copyright 2006, CRIM, Revolution Linux Inc.
#
# $Id$
#
# Authors : Stephane Bond
#
# This file is part of the MILLE-XTERM project.
#
#       http://www.revolutionlinux.com/mille-xterm/
#       http://www.mille.ca/
#
# This program is covered by the GNU General Public License.
# See the COPYING file in the top-level MILLE-XTERM directory.
#
# -------------------------------------------------------------------------

/**
*
* This script is called by the TeacherTools program to obtain information on a classroom
*
* <code>
* ?action=list/ip=192.168.2.221
* </code>
*/

require_once 'util/functions.php';
require_once "util/Node.php";
require_once "util/ClassroomFinder.php";

# Security : only the expected variable are assigned
# No post
unset($_POST);
# No cookies 
unset($_COOKIES);


# Expected variables
$get["action"]='';
$get["ip"]='';

# Get the allowed variables
foreach ($_GET as $key=>$value) {
    if (isset($get[$key])) {
	    $get[$key]="$value";
    }
}

# Open the current node
$node=new Node(trim($get["ip"]));
if ($node->notFound()) {
	print "ERROR : Node not found ".$get["ip"];
	die();
}


$classroom=new ClassroomFinder($node->getParentID());

print "CLASSROOM=".$classroom->getClassroom()."\n";
$computers=$classroom->getComputers();
if (!empty($computers)) {
    foreach ($computers as $computer) {
        if ($computer['ip'] != $get["ip"] && ($computer['code'] == '3' || $computer['code'] == '2')) {
            print $computer['ip'].','.$computer['mac'].','.$computer['username']."\n";
        }
    }
}
?>
