// NOTE: File has been autogenerated by utils/aarch64_builtins_test_generator.py
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +i8mm -target-feature +sme -target-feature +sve -verify=guard

// REQUIRES: aarch64-registered-target

#include <arm_sve.h>

// Properties: guard="sve,i8mm" streaming_guard="" flags=""

void test(void) {
  svint8_t svint8_t_val;
  svint32_t svint32_t_val;
  svuint8_t svuint8_t_val;
  svuint32_t svuint32_t_val;

  svmmla(svint32_t_val, svint8_t_val, svint8_t_val);
  svmmla(svuint32_t_val, svuint8_t_val, svuint8_t_val);
  svmmla_s32(svint32_t_val, svint8_t_val, svint8_t_val);
  svmmla_u32(svuint32_t_val, svuint8_t_val, svuint8_t_val);
  svusmmla(svint32_t_val, svuint8_t_val, svint8_t_val);
  svusmmla_s32(svint32_t_val, svuint8_t_val, svint8_t_val);
}

void test_streaming(void) __arm_streaming{
  svint8_t svint8_t_val;
  svint32_t svint32_t_val;
  svuint8_t svuint8_t_val;
  svuint32_t svuint32_t_val;

  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmmla(svint32_t_val, svint8_t_val, svint8_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmmla(svuint32_t_val, svuint8_t_val, svuint8_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmmla_s32(svint32_t_val, svint8_t_val, svint8_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmmla_u32(svuint32_t_val, svuint8_t_val, svuint8_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svusmmla(svint32_t_val, svuint8_t_val, svint8_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svusmmla_s32(svint32_t_val, svuint8_t_val, svint8_t_val);
}

void test_streaming_compatible(void) __arm_streaming_compatible{
  svint8_t svint8_t_val;
  svint32_t svint32_t_val;
  svuint8_t svuint8_t_val;
  svuint32_t svuint32_t_val;

  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmmla(svint32_t_val, svint8_t_val, svint8_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmmla(svuint32_t_val, svuint8_t_val, svuint8_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmmla_s32(svint32_t_val, svint8_t_val, svint8_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmmla_u32(svuint32_t_val, svuint8_t_val, svuint8_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svusmmla(svint32_t_val, svuint8_t_val, svint8_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svusmmla_s32(svint32_t_val, svuint8_t_val, svint8_t_val);
}
