/* Copyright (c) 2012, The Linux Foundation. All rights reserved.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License version 2 and
* only version 2 as published by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*/

#include <linux/mfd/wcd9xxx/wcd9306_registers.h>
#include "wcd9306.h"

const u8 tapan_reg_readable[TAPAN_CACHE_SIZE] = {
	[TAPAN_A_CHIP_CTL] = 1,
	[TAPAN_A_CHIP_STATUS] = 1,
	[TAPAN_A_CHIP_ID_BYTE_0] = 1,
	[TAPAN_A_CHIP_ID_BYTE_1] = 1,
	[TAPAN_A_CHIP_ID_BYTE_2] = 1,
	[TAPAN_A_CHIP_ID_BYTE_3] = 1,
	[TAPAN_A_CHIP_VERSION] = 1,
	[TAPAN_A_CHIP_DEBUG_CTL] = 1,
	[TAPAN_A_SLAVE_ID_1] = 1,
	[TAPAN_A_SLAVE_ID_2] = 1,
	[TAPAN_A_SLAVE_ID_3] = 1,
	[TAPAN_A_PIN_CTL_OE0] = 1,
	[TAPAN_A_PIN_CTL_DATA0] = 1,
	[TAPAN_A_HDRIVE_GENERIC] = 1,
	[TAPAN_A_HDRIVE_OVERRIDE] = 1,
	[TAPAN_A_ANA_CSR_WAIT_STATE] = 1,
	[TAPAN_A_PROCESS_MONITOR_CTL0] = 1,
	[TAPAN_A_PROCESS_MONITOR_CTL1] = 1,
	[TAPAN_A_PROCESS_MONITOR_CTL2] = 1,
	[TAPAN_A_PROCESS_MONITOR_CTL3] = 1,
	[TAPAN_A_QFUSE_CTL] = 1,
	[TAPAN_A_QFUSE_STATUS] = 1,
	[TAPAN_A_QFUSE_DATA_OUT0] = 1,
	[TAPAN_A_QFUSE_DATA_OUT1] = 1,
	[TAPAN_A_QFUSE_DATA_OUT2] = 1,
	[TAPAN_A_QFUSE_DATA_OUT3] = 1,
	[TAPAN_A_QFUSE_DATA_OUT4] = 1,
	[TAPAN_A_QFUSE_DATA_OUT5] = 1,
	[TAPAN_A_QFUSE_DATA_OUT6] = 1,
	[TAPAN_A_QFUSE_DATA_OUT7] = 1,
	[TAPAN_A_CDC_CTL] = 1,
	[TAPAN_A_LEAKAGE_CTL] = 1,
	[TAPAN_A_INTR_MODE] = 1,
	[TAPAN_A_INTR_MASK0] = 1,
	[TAPAN_A_INTR_MASK1] = 1,
	[TAPAN_A_INTR_MASK2] = 1,
	[TAPAN_A_INTR_MASK3] = 1,
	[TAPAN_A_INTR_STATUS0] = 1,
	[TAPAN_A_INTR_STATUS1] = 1,
	[TAPAN_A_INTR_STATUS2] = 1,
	[TAPAN_A_INTR_STATUS3] = 1,
	[TAPAN_A_INTR_CLEAR0] = 0,
	[TAPAN_A_INTR_CLEAR1] = 0,
	[TAPAN_A_INTR_CLEAR2] = 0,
	[TAPAN_A_INTR_CLEAR3] = 0,
	[TAPAN_A_INTR_LEVEL0] = 1,
	[TAPAN_A_INTR_LEVEL1] = 1,
	[TAPAN_A_INTR_LEVEL2] = 1,
	[TAPAN_A_INTR_LEVEL3] = 1,
	[TAPAN_A_INTR_TEST0] = 1,
	[TAPAN_A_INTR_TEST1] = 1,
	[TAPAN_A_INTR_TEST2] = 1,
	[TAPAN_A_INTR_TEST3] = 1,
	[TAPAN_A_INTR_SET0] = 1,
	[TAPAN_A_INTR_SET1] = 1,
	[TAPAN_A_INTR_SET2] = 1,
	[TAPAN_A_INTR_SET3] = 1,
	[TAPAN_A_INTR_DESTN0] = 1,
	[TAPAN_A_INTR_DESTN1] = 1,
	[TAPAN_A_INTR_DESTN2] = 1,
	[TAPAN_A_INTR_DESTN3] = 1,
	[TAPAN_A_CDC_DMIC_DATA0_MODE] = 1,
	[TAPAN_A_CDC_DMIC_CLK0_MODE] = 1,
	[TAPAN_A_CDC_DMIC_DATA1_MODE] = 1,
	[TAPAN_A_CDC_DMIC_CLK1_MODE] = 1,
	[TAPAN_A_CDC_INTR_MODE] = 1,
	[TAPAN_A_BIAS_REF_CTL] = 1,
	[TAPAN_A_BIAS_CENTRAL_BG_CTL] = 1,
	[TAPAN_A_BIAS_PRECHRG_CTL] = 1,
	[TAPAN_A_BIAS_CURR_CTL_1] = 1,
	[TAPAN_A_BIAS_CURR_CTL_2] = 1,
	[TAPAN_A_BIAS_OSC_BG_CTL] = 1,
	[TAPAN_A_CLK_BUFF_EN1] = 1,
	[TAPAN_A_CLK_BUFF_EN2] = 1,
	[TAPAN_A_LDO_H_MODE_1] = 1,
	[TAPAN_A_LDO_H_MODE_2] = 1,
	[TAPAN_A_LDO_H_LOOP_CTL] = 1,
	[TAPAN_A_LDO_H_COMP_1] = 1,
	[TAPAN_A_LDO_H_COMP_2] = 1,
	[TAPAN_A_LDO_H_BIAS_1] = 1,
	[TAPAN_A_LDO_H_BIAS_2] = 1,
	[TAPAN_A_LDO_H_BIAS_3] = 1,
	[TAPAN_A_MICB_CFILT_1_CTL] = 1,
	[TAPAN_A_MICB_CFILT_1_VAL] = 1,
	[TAPAN_A_MICB_CFILT_1_PRECHRG] = 1,
	[TAPAN_A_MICB_1_CTL] = 1,
	[TAPAN_A_MICB_1_INT_RBIAS] = 1,
	[TAPAN_A_MICB_1_MBHC] = 1,
	[TAPAN_A_MICB_CFILT_2_CTL] = 1,
	[TAPAN_A_MICB_CFILT_2_VAL] = 1,
	[TAPAN_A_MICB_CFILT_2_PRECHRG] = 1,
	[TAPAN_A_MICB_2_CTL] = 1,
	[TAPAN_A_MICB_2_INT_RBIAS] = 1,
	[TAPAN_A_MICB_2_MBHC] = 1,
	[TAPAN_A_MICB_CFILT_3_CTL] = 1,
	[TAPAN_A_MICB_CFILT_3_VAL] = 1,
	[TAPAN_A_MICB_CFILT_3_PRECHRG] = 1,
	[TAPAN_A_MICB_3_CTL] = 1,
	[TAPAN_A_MICB_3_INT_RBIAS] = 1,
	[TAPAN_A_MICB_3_MBHC] = 1,
	[TAPAN_A_MBHC_INSERT_DETECT] = 1,
	[TAPAN_A_MBHC_INSERT_DET_STATUS] = 1,
	[TAPAN_A_TX_COM_BIAS] = 1,
	[TAPAN_A_MBHC_SCALING_MUX_1] = 1,
	[TAPAN_A_MBHC_SCALING_MUX_2] = 1,
	[TAPAN_A_RESERVED_MAD_ANA_CTRL] = 1,
	[TAPAN_A_TX_SUP_SWITCH_CTRL_1] = 1,
	[TAPAN_A_TX_SUP_SWITCH_CTRL_2] = 1,
	[TAPAN_A_TX_1_EN] = 1,
	[TAPAN_A_TX_2_EN] = 1,
	[TAPAN_A_TX_1_2_ADC_CH1] = 1,
	[TAPAN_A_TX_1_2_ADC_CH2] = 1,
	[TAPAN_A_TX_1_2_ATEST_REFCTRL] = 1,
	[TAPAN_A_TX_1_2_TEST_CTL] = 1,
	[TAPAN_A_TX_1_2_TEST_BLOCK_EN] = 1,
	[TAPAN_A_TX_1_2_TXFE_CLKDIV] = 1,
	[TAPAN_A_TX_1_2_SAR_ERR_CH1] = 1,
	[TAPAN_A_TX_1_2_SAR_ERR_CH2] = 1,
	[TAPAN_A_TX_3_EN] = 1,
	[TAPAN_A_TX_1_2_TEST_EN] = 1,
	[TAPAN_A_TX_4_5_TXFE_SC_CTL] = 1,
	[TAPAN_A_TX_4_5_TEST_EN] = 1,
	[TAPAN_A_TX_4_EN] = 1,
	[TAPAN_A_TX_5_EN] = 1,
	[TAPAN_A_TX_4_5_ADC_CH4] = 1,
	[TAPAN_A_TX_4_5_ADC_CH5] = 1,
	[TAPAN_A_TX_4_5_ATEST_REFCTRL] = 1,
	[TAPAN_A_TX_4_5_TEST_CTL] = 1,
	[TAPAN_A_TX_4_5_TEST_BLOCK_EN] = 1,
	[TAPAN_A_TX_4_5_TXFE_CKDIV] = 1,
	[TAPAN_A_TX_4_5_SAR_ERR_CH4] = 1,
	[TAPAN_A_TX_4_5_SAR_ERR_CH5] = 1,
	[TAPAN_A_TX_7_MBHC_EN] = 1,
	[TAPAN_A_TX_7_MBHC_ATEST_REFCTRL] = 1,
	[TAPAN_A_TX_7_MBHC_ADC] = 1,
	[TAPAN_A_TX_7_MBHC_TEST_CTL] = 1,
	[TAPAN_A_TX_7_MBHC_SAR_ERR] = 1,
	[TAPAN_A_TX_7_TXFE_CLKDIV] = 1,
	[TAPAN_A_BUCK_MODE_1] = 1,
	[TAPAN_A_BUCK_MODE_2] = 1,
	[TAPAN_A_BUCK_MODE_3] = 1,
	[TAPAN_A_BUCK_MODE_4] = 1,
	[TAPAN_A_BUCK_MODE_5] = 1,
	[TAPAN_A_BUCK_CTRL_VCL_1] = 1,
	[TAPAN_A_BUCK_CTRL_VCL_2] = 1,
	[TAPAN_A_BUCK_CTRL_VCL_3] = 1,
	[TAPAN_A_BUCK_CTRL_CCL_1] = 1,
	[TAPAN_A_BUCK_CTRL_CCL_2] = 1,
	[TAPAN_A_BUCK_CTRL_CCL_3] = 1,
	[TAPAN_A_BUCK_CTRL_CCL_4] = 1,
	[TAPAN_A_BUCK_CTRL_PWM_DRVR_1] = 1,
	[TAPAN_A_BUCK_CTRL_PWM_DRVR_2] = 1,
	[TAPAN_A_BUCK_CTRL_PWM_DRVR_3] = 1,
	[TAPAN_A_BUCK_TMUX_A_D] = 1,
	[TAPAN_A_NCP_BUCKREF] = 1,
	[TAPAN_A_NCP_EN] = 1,
	[TAPAN_A_NCP_CLK] = 1,
	[TAPAN_A_NCP_STATIC] = 1,
	[TAPAN_A_NCP_VTH_LOW] = 1,
	[TAPAN_A_NCP_VTH_HIGH] = 1,
	[TAPAN_A_NCP_ATEST] = 1,
	[TAPAN_A_NCP_DTEST] = 1,
	[TAPAN_A_NCP_DLY1] = 1,
	[TAPAN_A_NCP_DLY2] = 1,
	[TAPAN_A_RX_AUX_SW_CTL] = 1,
	[TAPAN_A_RX_PA_AUX_IN_CONN] = 1,
	[TAPAN_A_RX_COM_TIMER_DIV] = 1,
	[TAPAN_A_RX_COM_OCP_CTL] = 1,
	[TAPAN_A_RX_COM_OCP_COUNT] = 1,
	[TAPAN_A_RX_COM_DAC_CTL] = 1,
	[TAPAN_A_RX_COM_BIAS] = 1,
	[TAPAN_A_RX_HPH_AUTO_CHOP] = 1,
	[TAPAN_A_RX_HPH_CHOP_CTL] = 1,
	[TAPAN_A_RX_HPH_BIAS_PA] = 1,
	[TAPAN_A_RX_HPH_BIAS_LDO] = 1,
	[TAPAN_A_RX_HPH_BIAS_CNP] = 1,
	[TAPAN_A_RX_HPH_BIAS_WG_OCP] = 1,
	[TAPAN_A_RX_HPH_OCP_CTL] = 1,
	[TAPAN_A_RX_HPH_CNP_EN] = 1,
	[TAPAN_A_RX_HPH_CNP_WG_CTL] = 1,
	[TAPAN_A_RX_HPH_CNP_WG_TIME] = 1,
	[TAPAN_A_RX_HPH_L_GAIN] = 1,
	[TAPAN_A_RX_HPH_L_TEST] = 1,
	[TAPAN_A_RX_HPH_L_PA_CTL] = 1,
	[TAPAN_A_RX_HPH_L_DAC_CTL] = 1,
	[TAPAN_A_RX_HPH_L_ATEST] = 1,
	[TAPAN_A_RX_HPH_L_STATUS] = 1,
	[TAPAN_A_RX_HPH_R_GAIN] = 1,
	[TAPAN_A_RX_HPH_R_TEST] = 1,
	[TAPAN_A_RX_HPH_R_PA_CTL] = 1,
	[TAPAN_A_RX_HPH_R_DAC_CTL] = 1,
	[TAPAN_A_RX_HPH_R_ATEST] = 1,
	[TAPAN_A_RX_HPH_R_STATUS] = 1,
	[TAPAN_A_RX_EAR_BIAS_PA] = 1,
	[TAPAN_A_RX_EAR_BIAS_CMBUFF] = 1,
	[TAPAN_A_RX_EAR_EN] = 1,
	[TAPAN_A_RX_EAR_GAIN] = 1,
	[TAPAN_A_RX_EAR_CMBUFF] = 1,
	[TAPAN_A_RX_EAR_ICTL] = 1,
	[TAPAN_A_RX_EAR_CCOMP] = 1,
	[TAPAN_A_RX_EAR_VCM] = 1,
	[TAPAN_A_RX_EAR_CNP] = 1,
	[TAPAN_A_RX_EAR_DAC_CTL_ATEST] = 1,
	[TAPAN_A_RX_EAR_STATUS] = 1,
	[TAPAN_A_RX_LINE_BIAS_PA] = 1,
	[TAPAN_A_RX_BUCK_BIAS1] = 1,
	[TAPAN_A_RX_BUCK_BIAS2] = 1,
	[TAPAN_A_RX_LINE_COM] = 1,
	[TAPAN_A_RX_LINE_CNP_EN] = 1,
	[TAPAN_A_RX_LINE_CNP_WG_CTL] = 1,
	[TAPAN_A_RX_LINE_CNP_WG_TIME] = 1,
	[TAPAN_A_RX_LINE_1_GAIN] = 1,
	[TAPAN_A_RX_LINE_1_TEST] = 1,
	[TAPAN_A_RX_LINE_1_DAC_CTL] = 1,
	[TAPAN_A_RX_LINE_1_STATUS] = 1,
	[TAPAN_A_RX_LINE_2_GAIN] = 1,
	[TAPAN_A_RX_LINE_2_TEST] = 1,
	[TAPAN_A_RX_LINE_2_DAC_CTL] = 1,
	[TAPAN_A_RX_LINE_2_STATUS] = 1,
	[TAPAN_A_RX_LINE_CNP_DBG] = 1,
	[TAPAN_A_SPKR_DRV_EN] = 1,
	[TAPAN_A_SPKR_DRV_GAIN] = 1,
	[TAPAN_A_SPKR_DRV_DAC_CTL] = 1,
	[TAPAN_A_SPKR_DRV_OCP_CTL] = 1,
	[TAPAN_A_SPKR_DRV_CLIP_DET] = 1,
	[TAPAN_A_SPKR_DRV_IEC] = 1,
	[TAPAN_A_SPKR_DRV_DBG_DAC] = 1,
	[TAPAN_A_SPKR_DRV_DBG_PA] = 1,
	[TAPAN_A_SPKR_DRV_DBG_PWRSTG] = 1,
	[TAPAN_A_SPKR_DRV_BIAS_LDO] = 1,
	[TAPAN_A_SPKR_DRV_BIAS_INT] = 1,
	[TAPAN_A_SPKR_DRV_BIAS_PA] = 1,
	[TAPAN_A_SPKR_DRV_STATUS_OCP] = 1,
	[TAPAN_A_SPKR_DRV_STATUS_PA] = 1,
	[TAPAN_A_RC_OSC_FREQ] = 1,
	[TAPAN_A_RC_OSC_TEST] = 1,
	[TAPAN_A_RC_OSC_STATUS] = 1,
	[TAPAN_A_RC_OSC_TUNER] = 1,
	[TAPAN_A_MBHC_HPH] = 1,
	[TAPAN_A_CDC_ANC1_B1_CTL] = 1,
	[TAPAN_A_CDC_ANC2_B1_CTL] = 1,
	[TAPAN_A_CDC_ANC1_SHIFT] = 1,
	[TAPAN_A_CDC_ANC2_SHIFT] = 1,
	[TAPAN_A_CDC_ANC1_IIR_B1_CTL] = 1,
	[TAPAN_A_CDC_ANC2_IIR_B1_CTL] = 1,
	[TAPAN_A_CDC_ANC1_IIR_B2_CTL] = 1,
	[TAPAN_A_CDC_ANC2_IIR_B2_CTL] = 1,
	[TAPAN_A_CDC_ANC1_IIR_B3_CTL] = 1,
	[TAPAN_A_CDC_ANC2_IIR_B3_CTL] = 1,
	[TAPAN_A_CDC_ANC1_LPF_B1_CTL] = 1,
	[TAPAN_A_CDC_ANC2_LPF_B1_CTL] = 1,
	[TAPAN_A_CDC_ANC1_LPF_B2_CTL] = 1,
	[TAPAN_A_CDC_ANC2_LPF_B2_CTL] = 1,
	[TAPAN_A_CDC_ANC1_SPARE] = 1,
	[TAPAN_A_CDC_ANC2_SPARE] = 1,
	[TAPAN_A_CDC_ANC1_SMLPF_CTL] = 1,
	[TAPAN_A_CDC_ANC2_SMLPF_CTL] = 1,
	[TAPAN_A_CDC_ANC1_DCFLT_CTL] = 1,
	[TAPAN_A_CDC_ANC2_DCFLT_CTL] = 1,
	[TAPAN_A_CDC_ANC1_GAIN_CTL] = 1,
	[TAPAN_A_CDC_ANC2_GAIN_CTL] = 1,
	[TAPAN_A_CDC_ANC1_B2_CTL] = 1,
	[TAPAN_A_CDC_ANC2_B2_CTL] = 1,
	[TAPAN_A_CDC_TX1_VOL_CTL_TIMER] = 1,
	[TAPAN_A_CDC_TX2_VOL_CTL_TIMER] = 1,
	[TAPAN_A_CDC_TX3_VOL_CTL_TIMER] = 1,
	[TAPAN_A_CDC_TX4_VOL_CTL_TIMER] = 1,
	[TAPAN_A_CDC_TX1_VOL_CTL_GAIN] = 1,
	[TAPAN_A_CDC_TX2_VOL_CTL_GAIN] = 1,
	[TAPAN_A_CDC_TX3_VOL_CTL_GAIN] = 1,
	[TAPAN_A_CDC_TX4_VOL_CTL_GAIN] = 1,
	[TAPAN_A_CDC_TX1_VOL_CTL_CFG] = 1,
	[TAPAN_A_CDC_TX2_VOL_CTL_CFG] = 1,
	[TAPAN_A_CDC_TX3_VOL_CTL_CFG] = 1,
	[TAPAN_A_CDC_TX4_VOL_CTL_CFG] = 1,
	[TAPAN_A_CDC_TX1_MUX_CTL] = 1,
	[TAPAN_A_CDC_TX2_MUX_CTL] = 1,
	[TAPAN_A_CDC_TX3_MUX_CTL] = 1,
	[TAPAN_A_CDC_TX4_MUX_CTL] = 1,
	[TAPAN_A_CDC_TX1_CLK_FS_CTL] = 1,
	[TAPAN_A_CDC_TX2_CLK_FS_CTL] = 1,
	[TAPAN_A_CDC_TX3_CLK_FS_CTL] = 1,
	[TAPAN_A_CDC_TX4_CLK_FS_CTL] = 1,
	[TAPAN_A_CDC_TX1_DMIC_CTL] = 1,
	[TAPAN_A_CDC_TX2_DMIC_CTL] = 1,
	[TAPAN_A_CDC_TX3_DMIC_CTL] = 1,
	[TAPAN_A_CDC_TX4_DMIC_CTL] = 1,
	[TAPAN_A_CDC_DEBUG_B1_CTL] = 1,
	[TAPAN_A_CDC_DEBUG_B2_CTL] = 1,
	[TAPAN_A_CDC_DEBUG_B3_CTL] = 1,
	[TAPAN_A_CDC_DEBUG_B4_CTL] = 1,
	[TAPAN_A_CDC_DEBUG_B5_CTL] = 1,
	[TAPAN_A_CDC_DEBUG_B6_CTL] = 1,
	[TAPAN_A_CDC_DEBUG_B7_CTL] = 1,
	[TAPAN_A_CDC_SRC1_PDA_CFG] = 1,
	[TAPAN_A_CDC_SRC2_PDA_CFG] = 1,
	[TAPAN_A_CDC_SRC1_FS_CTL] = 1,
	[TAPAN_A_CDC_SRC2_FS_CTL] = 1,
	[TAPAN_A_CDC_RX1_B1_CTL] = 1,
	[TAPAN_A_CDC_RX2_B1_CTL] = 1,
	[TAPAN_A_CDC_RX3_B1_CTL] = 1,
	[TAPAN_A_CDC_RX4_B1_CTL] = 1,
	[TAPAN_A_CDC_RX1_B2_CTL] = 1,
	[TAPAN_A_CDC_RX2_B2_CTL] = 1,
	[TAPAN_A_CDC_RX3_B2_CTL] = 1,
	[TAPAN_A_CDC_RX4_B2_CTL] = 1,
	[TAPAN_A_CDC_RX1_B3_CTL] = 1,
	[TAPAN_A_CDC_RX2_B3_CTL] = 1,
	[TAPAN_A_CDC_RX3_B3_CTL] = 1,
	[TAPAN_A_CDC_RX4_B3_CTL] = 1,
	[TAPAN_A_CDC_RX1_B4_CTL] = 1,
	[TAPAN_A_CDC_RX2_B4_CTL] = 1,
	[TAPAN_A_CDC_RX3_B4_CTL] = 1,
	[TAPAN_A_CDC_RX4_B4_CTL] = 1,
	[TAPAN_A_CDC_RX1_B5_CTL] = 1,
	[TAPAN_A_CDC_RX2_B5_CTL] = 1,
	[TAPAN_A_CDC_RX3_B5_CTL] = 1,
	[TAPAN_A_CDC_RX4_B5_CTL] = 1,
	[TAPAN_A_CDC_RX1_B6_CTL] = 1,
	[TAPAN_A_CDC_RX2_B6_CTL] = 1,
	[TAPAN_A_CDC_RX3_B6_CTL] = 1,
	[TAPAN_A_CDC_RX4_B6_CTL] = 1,
	[TAPAN_A_CDC_RX1_VOL_CTL_B1_CTL] = 1,
	[TAPAN_A_CDC_RX2_VOL_CTL_B1_CTL] = 1,
	[TAPAN_A_CDC_RX3_VOL_CTL_B1_CTL] = 1,
	[TAPAN_A_CDC_RX4_VOL_CTL_B1_CTL] = 1,
	[TAPAN_A_CDC_RX1_VOL_CTL_B2_CTL] = 1,
	[TAPAN_A_CDC_RX2_VOL_CTL_B2_CTL] = 1,
	[TAPAN_A_CDC_RX3_VOL_CTL_B2_CTL] = 1,
	[TAPAN_A_CDC_RX4_VOL_CTL_B2_CTL] = 1,
	[TAPAN_A_CDC_CLK_ANC_RESET_CTL] = 1,
	[TAPAN_A_CDC_CLK_RX_RESET_CTL] = 1,
	[TAPAN_A_CDC_CLK_TX_RESET_B1_CTL] = 1,
	[TAPAN_A_CDC_CLK_TX_RESET_B2_CTL] = 1,
	[TAPAN_A_CDC_CLK_DMIC_B1_CTL] = 1,
	[TAPAN_A_CDC_CLK_DMIC_B2_CTL] = 1,
	[TAPAN_A_CDC_CLK_I2S_CTL] = 1,
	[TAPAN_A_CDC_CLK_OTHR_RESET_B1_CTL] = 1,
	[TAPAN_A_CDC_CLK_OTHR_RESET_B2_CTL] = 1,
	[TAPAN_A_CDC_CLK_TX_CLK_EN_B1_CTL] = 1,
	[TAPAN_A_CDC_CLK_TX_CLK_EN_B2_CTL] = 1,
	[TAPAN_A_CDC_CLK_OTHR_CTL] = 1,
	[TAPAN_A_CDC_CLK_RDAC_CLK_EN_CTL] = 1,
	[TAPAN_A_CDC_CLK_ANC_CLK_EN_CTL] = 1,
	[TAPAN_A_CDC_CLK_RX_B1_CTL] = 1,
	[TAPAN_A_CDC_CLK_RX_B2_CTL] = 1,
	[TAPAN_A_CDC_CLK_MCLK_CTL] = 1,
	[TAPAN_A_CDC_CLK_PDM_CTL] = 1,
	[TAPAN_A_CDC_CLK_SD_CTL] = 1,
	[TAPAN_A_CDC_CLK_POWER_CTL] = 1,
	[TAPAN_A_CDC_CLSH_B1_CTL] = 1,
	[TAPAN_A_CDC_CLSH_B2_CTL] = 1,
	[TAPAN_A_CDC_CLSH_B3_CTL] = 1,
	[TAPAN_A_CDC_CLSH_BUCK_NCP_VARS] = 1,
	[TAPAN_A_CDC_CLSH_IDLE_HPH_THSD] = 1,
	[TAPAN_A_CDC_CLSH_IDLE_EAR_THSD] = 1,
	[TAPAN_A_CDC_CLSH_FCLKONLY_HPH_THSD] = 1,
	[TAPAN_A_CDC_CLSH_FCLKONLY_EAR_THSD] = 1,
	[TAPAN_A_CDC_CLSH_K_ADDR] = 1,
	[TAPAN_A_CDC_CLSH_K_DATA] = 1,
	[TAPAN_A_CDC_CLSH_I_PA_FACT_HPH_L] = 1,
	[TAPAN_A_CDC_CLSH_I_PA_FACT_HPH_U] = 1,
	[TAPAN_A_CDC_CLSH_I_PA_FACT_EAR_L] = 1,
	[TAPAN_A_CDC_CLSH_I_PA_FACT_EAR_U] = 1,
	[TAPAN_A_CDC_CLSH_V_PA_HD_EAR] = 1,
	[TAPAN_A_CDC_CLSH_V_PA_HD_HPH] = 1,
	[TAPAN_A_CDC_CLSH_V_PA_MIN_EAR] = 1,
	[TAPAN_A_CDC_CLSH_V_PA_MIN_HPH] = 1,
	[TAPAN_A_CDC_IIR1_GAIN_B1_CTL] = 1,
	[TAPAN_A_CDC_IIR2_GAIN_B1_CTL] = 1,
	[TAPAN_A_CDC_IIR1_GAIN_B2_CTL] = 1,
	[TAPAN_A_CDC_IIR2_GAIN_B2_CTL] = 1,
	[TAPAN_A_CDC_IIR1_GAIN_B3_CTL] = 1,
	[TAPAN_A_CDC_IIR2_GAIN_B3_CTL] = 1,
	[TAPAN_A_CDC_IIR1_GAIN_B4_CTL] = 1,
	[TAPAN_A_CDC_IIR2_GAIN_B4_CTL] = 1,
	[TAPAN_A_CDC_IIR1_GAIN_B5_CTL] = 1,
	[TAPAN_A_CDC_IIR2_GAIN_B5_CTL] = 1,
	[TAPAN_A_CDC_IIR1_GAIN_B6_CTL] = 1,
	[TAPAN_A_CDC_IIR2_GAIN_B6_CTL] = 1,
	[TAPAN_A_CDC_IIR1_GAIN_B7_CTL] = 1,
	[TAPAN_A_CDC_IIR2_GAIN_B7_CTL] = 1,
	[TAPAN_A_CDC_IIR1_GAIN_B8_CTL] = 1,
	[TAPAN_A_CDC_IIR2_GAIN_B8_CTL] = 1,
	[TAPAN_A_CDC_IIR1_CTL] = 1,
	[TAPAN_A_CDC_IIR2_CTL] = 1,
	[TAPAN_A_CDC_IIR1_GAIN_TIMER_CTL] = 1,
	[TAPAN_A_CDC_IIR2_GAIN_TIMER_CTL] = 1,
	[TAPAN_A_CDC_IIR1_COEF_B1_CTL] = 1,
	[TAPAN_A_CDC_IIR2_COEF_B1_CTL] = 1,
	[TAPAN_A_CDC_IIR1_COEF_B2_CTL] = 1,
	[TAPAN_A_CDC_IIR2_COEF_B2_CTL] = 1,
	[TAPAN_A_CDC_TOP_GAIN_UPDATE] = 1,
	[TAPAN_A_CDC_COMP0_B1_CTL] = 1,
	[TAPAN_A_CDC_COMP1_B1_CTL] = 1,
	[TAPAN_A_CDC_COMP2_B1_CTL] = 1,
	[TAPAN_A_CDC_COMP0_B2_CTL] = 1,
	[TAPAN_A_CDC_COMP1_B2_CTL] = 1,
	[TAPAN_A_CDC_COMP2_B2_CTL] = 1,
	[TAPAN_A_CDC_COMP0_B3_CTL] = 1,
	[TAPAN_A_CDC_COMP1_B3_CTL] = 1,
	[TAPAN_A_CDC_COMP2_B3_CTL] = 1,
	[TAPAN_A_CDC_COMP0_B4_CTL] = 1,
	[TAPAN_A_CDC_COMP1_B4_CTL] = 1,
	[TAPAN_A_CDC_COMP2_B4_CTL] = 1,
	[TAPAN_A_CDC_COMP0_B5_CTL] = 1,
	[TAPAN_A_CDC_COMP1_B5_CTL] = 1,
	[TAPAN_A_CDC_COMP2_B5_CTL] = 1,
	[TAPAN_A_CDC_COMP0_B6_CTL] = 1,
	[TAPAN_A_CDC_COMP1_B6_CTL] = 1,
	[TAPAN_A_CDC_COMP2_B6_CTL] = 1,
	[TAPAN_A_CDC_COMP0_SHUT_DOWN_STATUS] = 1,
	[TAPAN_A_CDC_COMP1_SHUT_DOWN_STATUS] = 1,
	[TAPAN_A_CDC_COMP2_SHUT_DOWN_STATUS] = 1,
	[TAPAN_A_CDC_COMP0_FS_CFG] = 1,
	[TAPAN_A_CDC_COMP1_FS_CFG] = 1,
	[TAPAN_A_CDC_COMP2_FS_CFG] = 1,
	[TAPAN_A_CDC_CONN_RX1_B1_CTL] = 1,
	[TAPAN_A_CDC_CONN_RX1_B2_CTL] = 1,
	[TAPAN_A_CDC_CONN_RX1_B3_CTL] = 1,
	[TAPAN_A_CDC_CONN_RX2_B1_CTL] = 1,
	[TAPAN_A_CDC_CONN_RX2_B2_CTL] = 1,
	[TAPAN_A_CDC_CONN_RX2_B3_CTL] = 1,
	[TAPAN_A_CDC_CONN_RX3_B1_CTL] = 1,
	[TAPAN_A_CDC_CONN_RX3_B2_CTL] = 1,
	[TAPAN_A_CDC_CONN_RX4_B1_CTL] = 1,
	[TAPAN_A_CDC_CONN_RX4_B2_CTL] = 1,
	[TAPAN_A_CDC_CONN_RX4_B3_CTL] = 1,
	[TAPAN_A_CDC_CONN_ANC_B1_CTL] = 1,
	[TAPAN_A_CDC_CONN_ANC_B2_CTL] = 1,
	[TAPAN_A_CDC_CONN_TX_B1_CTL] = 1,
	[TAPAN_A_CDC_CONN_TX_B2_CTL] = 1,
	[TAPAN_A_CDC_CONN_TX_B3_CTL] = 1,
	[TAPAN_A_CDC_CONN_TX_B4_CTL] = 1,
	[TAPAN_A_CDC_CONN_EQ1_B1_CTL] = 1,
	[TAPAN_A_CDC_CONN_EQ1_B2_CTL] = 1,
	[TAPAN_A_CDC_CONN_EQ1_B3_CTL] = 1,
	[TAPAN_A_CDC_CONN_EQ1_B4_CTL] = 1,
	[TAPAN_A_CDC_CONN_EQ2_B1_CTL] = 1,
	[TAPAN_A_CDC_CONN_EQ2_B2_CTL] = 1,
	[TAPAN_A_CDC_CONN_EQ2_B3_CTL] = 1,
	[TAPAN_A_CDC_CONN_EQ2_B4_CTL] = 1,
	[TAPAN_A_CDC_CONN_SRC1_B1_CTL] = 1,
	[TAPAN_A_CDC_CONN_SRC1_B2_CTL] = 1,
	[TAPAN_A_CDC_CONN_SRC2_B1_CTL] = 1,
	[TAPAN_A_CDC_CONN_SRC2_B2_CTL] = 1,
	[TAPAN_A_CDC_CONN_TX_SB_B1_CTL] = 1,
	[TAPAN_A_CDC_CONN_TX_SB_B2_CTL] = 1,
	[TAPAN_A_CDC_CONN_TX_SB_B3_CTL] = 1,
	[TAPAN_A_CDC_CONN_TX_SB_B4_CTL] = 1,
	[TAPAN_A_CDC_CONN_TX_SB_B5_CTL] = 1,
	[TAPAN_A_CDC_CONN_TX_SB_B11_CTL] = 1,
	[TAPAN_A_CDC_CONN_RX_SB_B1_CTL] = 1,
	[TAPAN_A_CDC_CONN_RX_SB_B2_CTL] = 1,
	[TAPAN_A_CDC_CONN_CLSH_CTL] = 1,
	[TAPAN_A_CDC_CONN_MISC] = 1,
	[TAPAN_A_CDC_MBHC_EN_CTL] = 1,
	[TAPAN_A_CDC_MBHC_FIR_B1_CFG] = 1,
	[TAPAN_A_CDC_MBHC_FIR_B2_CFG] = 1,
	[TAPAN_A_CDC_MBHC_TIMER_B1_CTL] = 1,
	[TAPAN_A_CDC_MBHC_TIMER_B2_CTL] = 1,
	[TAPAN_A_CDC_MBHC_TIMER_B3_CTL] = 1,
	[TAPAN_A_CDC_MBHC_TIMER_B4_CTL] = 1,
	[TAPAN_A_CDC_MBHC_TIMER_B5_CTL] = 1,
	[TAPAN_A_CDC_MBHC_TIMER_B6_CTL] = 1,
	[TAPAN_A_CDC_MBHC_B1_STATUS] = 1,
	[TAPAN_A_CDC_MBHC_B2_STATUS] = 1,
	[TAPAN_A_CDC_MBHC_B3_STATUS] = 1,
	[TAPAN_A_CDC_MBHC_B4_STATUS] = 1,
	[TAPAN_A_CDC_MBHC_B5_STATUS] = 1,
	[TAPAN_A_CDC_MBHC_B1_CTL] = 1,
	[TAPAN_A_CDC_MBHC_B2_CTL] = 1,
	[TAPAN_A_CDC_MBHC_VOLT_B1_CTL] = 1,
	[TAPAN_A_CDC_MBHC_VOLT_B2_CTL] = 1,
	[TAPAN_A_CDC_MBHC_VOLT_B3_CTL] = 1,
	[TAPAN_A_CDC_MBHC_VOLT_B4_CTL] = 1,
	[TAPAN_A_CDC_MBHC_VOLT_B5_CTL] = 1,
	[TAPAN_A_CDC_MBHC_VOLT_B6_CTL] = 1,
	[TAPAN_A_CDC_MBHC_VOLT_B7_CTL] = 1,
	[TAPAN_A_CDC_MBHC_VOLT_B8_CTL] = 1,
	[TAPAN_A_CDC_MBHC_VOLT_B9_CTL] = 1,
	[TAPAN_A_CDC_MBHC_VOLT_B10_CTL] = 1,
	[TAPAN_A_CDC_MBHC_VOLT_B11_CTL] = 1,
	[TAPAN_A_CDC_MBHC_VOLT_B12_CTL] = 1,
	[TAPAN_A_CDC_MBHC_CLK_CTL] = 1,
	[TAPAN_A_CDC_MBHC_INT_CTL] = 1,
	[TAPAN_A_CDC_MBHC_DEBUG_CTL] = 1,
	[TAPAN_A_CDC_MBHC_SPARE] = 1,
};

const u8 tapan_reset_reg_defaults[TAPAN_CACHE_SIZE] = {
	[TAPAN_A_CHIP_CTL] = TAPAN_A_CHIP_CTL__POR,
	[TAPAN_A_CHIP_STATUS] = TAPAN_A_CHIP_STATUS__POR,
	[TAPAN_A_CHIP_ID_BYTE_0] = TAPAN_A_CHIP_ID_BYTE_0__POR,
	[TAPAN_A_CHIP_ID_BYTE_1] = TAPAN_A_CHIP_ID_BYTE_1__POR,
	[TAPAN_A_CHIP_ID_BYTE_2] = TAPAN_A_CHIP_ID_BYTE_2__POR,
	[TAPAN_A_CHIP_ID_BYTE_3] = TAPAN_A_CHIP_ID_BYTE_3__POR,
	[TAPAN_A_CHIP_VERSION] = TAPAN_A_CHIP_VERSION__POR,
	[TAPAN_A_CHIP_DEBUG_CTL] = TAPAN_A_CHIP_DEBUG_CTL__POR,
	[TAPAN_A_SLAVE_ID_1] = TAPAN_A_SLAVE_ID_1__POR,
	[TAPAN_A_SLAVE_ID_2] = TAPAN_A_SLAVE_ID_2__POR,
	[TAPAN_A_SLAVE_ID_3] = TAPAN_A_SLAVE_ID_3__POR,
	[TAPAN_A_PIN_CTL_OE0] = TAPAN_A_PIN_CTL_OE0__POR,
	[TAPAN_A_PIN_CTL_DATA0] = TAPAN_A_PIN_CTL_DATA0__POR,
	[TAPAN_A_HDRIVE_GENERIC] = TAPAN_A_HDRIVE_GENERIC__POR,
	[TAPAN_A_HDRIVE_OVERRIDE] = TAPAN_A_HDRIVE_OVERRIDE__POR,
	[TAPAN_A_ANA_CSR_WAIT_STATE] = TAPAN_A_ANA_CSR_WAIT_STATE__POR,
	[TAPAN_A_PROCESS_MONITOR_CTL0] = TAPAN_A_PROCESS_MONITOR_CTL0__POR,
	[TAPAN_A_PROCESS_MONITOR_CTL1] = TAPAN_A_PROCESS_MONITOR_CTL1__POR,
	[TAPAN_A_PROCESS_MONITOR_CTL2] = TAPAN_A_PROCESS_MONITOR_CTL2__POR,
	[TAPAN_A_PROCESS_MONITOR_CTL3] = TAPAN_A_PROCESS_MONITOR_CTL3__POR,
	[TAPAN_A_QFUSE_CTL] = TAPAN_A_QFUSE_CTL__POR,
	[TAPAN_A_QFUSE_STATUS] = TAPAN_A_QFUSE_STATUS__POR,
	[TAPAN_A_QFUSE_DATA_OUT0] = TAPAN_A_QFUSE_DATA_OUT0__POR,
	[TAPAN_A_QFUSE_DATA_OUT1] = TAPAN_A_QFUSE_DATA_OUT1__POR,
	[TAPAN_A_QFUSE_DATA_OUT2] = TAPAN_A_QFUSE_DATA_OUT2__POR,
	[TAPAN_A_QFUSE_DATA_OUT3] = TAPAN_A_QFUSE_DATA_OUT3__POR,
	[TAPAN_A_QFUSE_DATA_OUT4] = TAPAN_A_QFUSE_DATA_OUT4__POR,
	[TAPAN_A_QFUSE_DATA_OUT5] = TAPAN_A_QFUSE_DATA_OUT5__POR,
	[TAPAN_A_QFUSE_DATA_OUT6] = TAPAN_A_QFUSE_DATA_OUT6__POR,
	[TAPAN_A_QFUSE_DATA_OUT7] = TAPAN_A_QFUSE_DATA_OUT7__POR,
	[TAPAN_A_CDC_CTL] = TAPAN_A_CDC_CTL__POR,
	[TAPAN_A_LEAKAGE_CTL] = TAPAN_A_LEAKAGE_CTL__POR,
	[TAPAN_A_INTR_MODE] = TAPAN_A_INTR_MODE__POR,
	[TAPAN_A_INTR_MASK0] = TAPAN_A_INTR_MASK0__POR,
	[TAPAN_A_INTR_MASK1] = TAPAN_A_INTR_MASK1__POR,
	[TAPAN_A_INTR_MASK2] = TAPAN_A_INTR_MASK2__POR,
	[TAPAN_A_INTR_MASK3] = TAPAN_A_INTR_MASK3__POR,
	[TAPAN_A_INTR_STATUS0] = TAPAN_A_INTR_STATUS0__POR,
	[TAPAN_A_INTR_STATUS1] = TAPAN_A_INTR_STATUS1__POR,
	[TAPAN_A_INTR_STATUS2] = TAPAN_A_INTR_STATUS2__POR,
	[TAPAN_A_INTR_STATUS3] = TAPAN_A_INTR_STATUS3__POR,
	[TAPAN_A_INTR_CLEAR0] = TAPAN_A_INTR_CLEAR0__POR,
	[TAPAN_A_INTR_CLEAR1] = TAPAN_A_INTR_CLEAR1__POR,
	[TAPAN_A_INTR_CLEAR2] = TAPAN_A_INTR_CLEAR2__POR,
	[TAPAN_A_INTR_CLEAR3] = TAPAN_A_INTR_CLEAR3__POR,
	[TAPAN_A_INTR_LEVEL0] = TAPAN_A_INTR_LEVEL0__POR,
	[TAPAN_A_INTR_LEVEL1] = TAPAN_A_INTR_LEVEL1__POR,
	[TAPAN_A_INTR_LEVEL2] = TAPAN_A_INTR_LEVEL2__POR,
	[TAPAN_A_INTR_LEVEL3] = TAPAN_A_INTR_LEVEL3__POR,
	[TAPAN_A_INTR_TEST0] = TAPAN_A_INTR_TEST0__POR,
	[TAPAN_A_INTR_TEST1] = TAPAN_A_INTR_TEST1__POR,
	[TAPAN_A_INTR_TEST2] = TAPAN_A_INTR_TEST2__POR,
	[TAPAN_A_INTR_TEST3] = TAPAN_A_INTR_TEST3__POR,
	[TAPAN_A_INTR_SET0] = TAPAN_A_INTR_SET0__POR,
	[TAPAN_A_INTR_SET1] = TAPAN_A_INTR_SET1__POR,
	[TAPAN_A_INTR_SET2] = TAPAN_A_INTR_SET2__POR,
	[TAPAN_A_INTR_SET3] = TAPAN_A_INTR_SET3__POR,
	[TAPAN_A_INTR_DESTN0] = TAPAN_A_INTR_DESTN0__POR,
	[TAPAN_A_INTR_DESTN1] = TAPAN_A_INTR_DESTN1__POR,
	[TAPAN_A_INTR_DESTN2] = TAPAN_A_INTR_DESTN2__POR,
	[TAPAN_A_INTR_DESTN3] = TAPAN_A_INTR_DESTN3__POR,
	[TAPAN_A_CDC_DMIC_DATA0_MODE] = TAPAN_A_CDC_DMIC_DATA0_MODE__POR,
	[TAPAN_A_CDC_DMIC_CLK0_MODE] = TAPAN_A_CDC_DMIC_CLK0_MODE__POR,
	[TAPAN_A_CDC_DMIC_DATA1_MODE] = TAPAN_A_CDC_DMIC_DATA1_MODE__POR,
	[TAPAN_A_CDC_DMIC_CLK1_MODE] = TAPAN_A_CDC_DMIC_CLK1_MODE__POR,
	[TAPAN_A_CDC_INTR_MODE] = TAPAN_A_CDC_INTR_MODE__POR,
	[TAPAN_A_BIAS_REF_CTL] = TAPAN_A_BIAS_REF_CTL__POR,
	[TAPAN_A_BIAS_CENTRAL_BG_CTL] = TAPAN_A_BIAS_CENTRAL_BG_CTL__POR,
	[TAPAN_A_BIAS_PRECHRG_CTL] = TAPAN_A_BIAS_PRECHRG_CTL__POR,
	[TAPAN_A_BIAS_CURR_CTL_1] = TAPAN_A_BIAS_CURR_CTL_1__POR,
	[TAPAN_A_BIAS_CURR_CTL_2] = TAPAN_A_BIAS_CURR_CTL_2__POR,
	[TAPAN_A_BIAS_OSC_BG_CTL] = TAPAN_A_BIAS_OSC_BG_CTL__POR,
	[TAPAN_A_CLK_BUFF_EN1] = TAPAN_A_CLK_BUFF_EN1__POR,
	[TAPAN_A_CLK_BUFF_EN2] = TAPAN_A_CLK_BUFF_EN2__POR,
	[TAPAN_A_LDO_H_MODE_1] = TAPAN_A_LDO_H_MODE_1__POR,
	[TAPAN_A_LDO_H_MODE_2] = TAPAN_A_LDO_H_MODE_2__POR,
	[TAPAN_A_LDO_H_LOOP_CTL] = TAPAN_A_LDO_H_LOOP_CTL__POR,
	[TAPAN_A_LDO_H_COMP_1] = TAPAN_A_LDO_H_COMP_1__POR,
	[TAPAN_A_LDO_H_COMP_2] = TAPAN_A_LDO_H_COMP_2__POR,
	[TAPAN_A_LDO_H_BIAS_1] = TAPAN_A_LDO_H_BIAS_1__POR,
	[TAPAN_A_LDO_H_BIAS_2] = TAPAN_A_LDO_H_BIAS_2__POR,
	[TAPAN_A_LDO_H_BIAS_3] = TAPAN_A_LDO_H_BIAS_3__POR,
	[TAPAN_A_MICB_CFILT_1_CTL] = TAPAN_A_MICB_CFILT_1_CTL__POR,
	[TAPAN_A_MICB_CFILT_1_VAL] = TAPAN_A_MICB_CFILT_1_VAL__POR,
	[TAPAN_A_MICB_CFILT_1_PRECHRG] = TAPAN_A_MICB_CFILT_1_PRECHRG__POR,
	[TAPAN_A_MICB_1_CTL] = TAPAN_A_MICB_1_CTL__POR,
	[TAPAN_A_MICB_1_INT_RBIAS] = TAPAN_A_MICB_1_INT_RBIAS__POR,
	[TAPAN_A_MICB_1_MBHC] = TAPAN_A_MICB_1_MBHC__POR,
	[TAPAN_A_MICB_CFILT_2_CTL] = TAPAN_A_MICB_CFILT_2_CTL__POR,
	[TAPAN_A_MICB_CFILT_2_VAL] = TAPAN_A_MICB_CFILT_2_VAL__POR,
	[TAPAN_A_MICB_CFILT_2_PRECHRG] = TAPAN_A_MICB_CFILT_2_PRECHRG__POR,
	[TAPAN_A_MICB_2_CTL] = TAPAN_A_MICB_2_CTL__POR,
	[TAPAN_A_MICB_2_INT_RBIAS] = TAPAN_A_MICB_2_INT_RBIAS__POR,
	[TAPAN_A_MICB_2_MBHC] = TAPAN_A_MICB_2_MBHC__POR,
	[TAPAN_A_MICB_CFILT_3_CTL] = TAPAN_A_MICB_CFILT_3_CTL__POR,
	[TAPAN_A_MICB_CFILT_3_VAL] = TAPAN_A_MICB_CFILT_3_VAL__POR,
	[TAPAN_A_MICB_CFILT_3_PRECHRG] = TAPAN_A_MICB_CFILT_3_PRECHRG__POR,
	[TAPAN_A_MICB_3_CTL] = TAPAN_A_MICB_3_CTL__POR,
	[TAPAN_A_MICB_3_INT_RBIAS] = TAPAN_A_MICB_3_INT_RBIAS__POR,
	[TAPAN_A_MICB_3_MBHC] = TAPAN_A_MICB_3_MBHC__POR,
	[TAPAN_A_MBHC_INSERT_DETECT] = TAPAN_A_MBHC_INSERT_DETECT__POR,
	[TAPAN_A_MBHC_INSERT_DET_STATUS] = TAPAN_A_MBHC_INSERT_DET_STATUS__POR,
	[TAPAN_A_TX_COM_BIAS] = TAPAN_A_TX_COM_BIAS__POR,
	[TAPAN_A_MBHC_SCALING_MUX_1] = TAPAN_A_MBHC_SCALING_MUX_1__POR,
	[TAPAN_A_MBHC_SCALING_MUX_2] = TAPAN_A_MBHC_SCALING_MUX_2__POR,
	[TAPAN_A_RESERVED_MAD_ANA_CTRL] = TAPAN_A_RESERVED_MAD_ANA_CTRL__POR,
	[TAPAN_A_TX_SUP_SWITCH_CTRL_1] = TAPAN_A_TX_SUP_SWITCH_CTRL_1__POR,
	[TAPAN_A_TX_SUP_SWITCH_CTRL_2] = TAPAN_A_TX_SUP_SWITCH_CTRL_2__POR,
	[TAPAN_A_TX_1_EN] = TAPAN_A_TX_1_EN__POR,
	[TAPAN_A_TX_2_EN] = TAPAN_A_TX_2_EN__POR,
	[TAPAN_A_TX_1_2_ADC_CH1] = TAPAN_A_TX_1_2_ADC_CH1__POR,
	[TAPAN_A_TX_1_2_ADC_CH2] = TAPAN_A_TX_1_2_ADC_CH2__POR,
	[TAPAN_A_TX_1_2_ATEST_REFCTRL] = TAPAN_A_TX_1_2_ATEST_REFCTRL__POR,
	[TAPAN_A_TX_1_2_TEST_CTL] = TAPAN_A_TX_1_2_TEST_CTL__POR,
	[TAPAN_A_TX_1_2_TEST_BLOCK_EN] = TAPAN_A_TX_1_2_TEST_BLOCK_EN__POR,
	[TAPAN_A_TX_1_2_TXFE_CLKDIV] = TAPAN_A_TX_1_2_TXFE_CLKDIV__POR,
	[TAPAN_A_TX_1_2_SAR_ERR_CH1] = TAPAN_A_TX_1_2_SAR_ERR_CH1__POR,
	[TAPAN_A_TX_1_2_SAR_ERR_CH2] = TAPAN_A_TX_1_2_SAR_ERR_CH2__POR,
	[TAPAN_A_TX_3_EN] = TAPAN_A_TX_3_EN__POR,
	[TAPAN_A_TX_1_2_TEST_EN] = TAPAN_A_TX_1_2_TEST_EN__POR,
	[TAPAN_A_TX_4_5_TXFE_SC_CTL] = TAPAN_A_TX_4_5_TXFE_SC_CTL__POR,
	[TAPAN_A_TX_4_5_TEST_EN] = TAPAN_A_TX_4_5_TEST_EN__POR,
	[TAPAN_A_TX_4_EN] = TAPAN_A_TX_4_EN__POR,
	[TAPAN_A_TX_5_EN] = TAPAN_A_TX_5_EN__POR,
	[TAPAN_A_TX_4_5_ADC_CH4] = TAPAN_A_TX_4_5_ADC_CH4__POR,
	[TAPAN_A_TX_4_5_ADC_CH5] = TAPAN_A_TX_4_5_ADC_CH5__POR,
	[TAPAN_A_TX_4_5_ATEST_REFCTRL] = TAPAN_A_TX_4_5_ATEST_REFCTRL__POR,
	[TAPAN_A_TX_4_5_TEST_CTL] = TAPAN_A_TX_4_5_TEST_CTL__POR,
	[TAPAN_A_TX_4_5_TEST_BLOCK_EN] = TAPAN_A_TX_4_5_TEST_BLOCK_EN__POR,
	[TAPAN_A_TX_4_5_TXFE_CKDIV] = TAPAN_A_TX_4_5_TXFE_CKDIV__POR,
	[TAPAN_A_TX_4_5_SAR_ERR_CH4] = TAPAN_A_TX_4_5_SAR_ERR_CH4__POR,
	[TAPAN_A_TX_4_5_SAR_ERR_CH5] = TAPAN_A_TX_4_5_SAR_ERR_CH5__POR,
	[TAPAN_A_TX_7_MBHC_EN] = TAPAN_A_TX_7_MBHC_EN__POR,
	[TAPAN_A_TX_7_MBHC_ATEST_REFCTRL] =
			TAPAN_A_TX_7_MBHC_ATEST_REFCTRL__POR,
	[TAPAN_A_TX_7_MBHC_ADC] = TAPAN_A_TX_7_MBHC_ADC__POR,
	[TAPAN_A_TX_7_MBHC_TEST_CTL] = TAPAN_A_TX_7_MBHC_TEST_CTL__POR,
	[TAPAN_A_TX_7_MBHC_SAR_ERR] = TAPAN_A_TX_7_MBHC_SAR_ERR__POR,
	[TAPAN_A_TX_7_TXFE_CLKDIV] = TAPAN_A_TX_7_TXFE_CLKDIV__POR,
	[TAPAN_A_BUCK_MODE_1] = TAPAN_A_BUCK_MODE_1__POR,
	[TAPAN_A_BUCK_MODE_2] = TAPAN_A_BUCK_MODE_2__POR,
	[TAPAN_A_BUCK_MODE_3] = TAPAN_A_BUCK_MODE_3__POR,
	[TAPAN_A_BUCK_MODE_4] = TAPAN_A_BUCK_MODE_4__POR,
	[TAPAN_A_BUCK_MODE_5] = TAPAN_A_BUCK_MODE_5__POR,
	[TAPAN_A_BUCK_CTRL_VCL_1] = TAPAN_A_BUCK_CTRL_VCL_1__POR,
	[TAPAN_A_BUCK_CTRL_VCL_2] = TAPAN_A_BUCK_CTRL_VCL_2__POR,
	[TAPAN_A_BUCK_CTRL_VCL_3] = TAPAN_A_BUCK_CTRL_VCL_3__POR,
	[TAPAN_A_BUCK_CTRL_CCL_1] = TAPAN_A_BUCK_CTRL_CCL_1__POR,
	[TAPAN_A_BUCK_CTRL_CCL_2] = TAPAN_A_BUCK_CTRL_CCL_2__POR,
	[TAPAN_A_BUCK_CTRL_CCL_3] = TAPAN_A_BUCK_CTRL_CCL_3__POR,
	[TAPAN_A_BUCK_CTRL_CCL_4] = TAPAN_A_BUCK_CTRL_CCL_4__POR,
	[TAPAN_A_BUCK_CTRL_PWM_DRVR_1] = TAPAN_A_BUCK_CTRL_PWM_DRVR_1__POR,
	[TAPAN_A_BUCK_CTRL_PWM_DRVR_2] = TAPAN_A_BUCK_CTRL_PWM_DRVR_2__POR,
	[TAPAN_A_BUCK_CTRL_PWM_DRVR_3] = TAPAN_A_BUCK_CTRL_PWM_DRVR_3__POR,
	[TAPAN_A_BUCK_TMUX_A_D] = TAPAN_A_BUCK_TMUX_A_D__POR,
	[TAPAN_A_NCP_BUCKREF] = TAPAN_A_NCP_BUCKREF__POR,
	[TAPAN_A_NCP_EN] = TAPAN_A_NCP_EN__POR,
	[TAPAN_A_NCP_CLK] = TAPAN_A_NCP_CLK__POR,
	[TAPAN_A_NCP_STATIC] = TAPAN_A_NCP_STATIC__POR,
	[TAPAN_A_NCP_VTH_LOW] = TAPAN_A_NCP_VTH_LOW__POR,
	[TAPAN_A_NCP_VTH_HIGH] = TAPAN_A_NCP_VTH_HIGH__POR,
	[TAPAN_A_NCP_ATEST] = TAPAN_A_NCP_ATEST__POR,
	[TAPAN_A_NCP_DTEST] = TAPAN_A_NCP_DTEST__POR,
	[TAPAN_A_NCP_DLY1] = TAPAN_A_NCP_DLY1__POR,
	[TAPAN_A_NCP_DLY2] = TAPAN_A_NCP_DLY2__POR,
	[TAPAN_A_RX_AUX_SW_CTL] = TAPAN_A_RX_AUX_SW_CTL__POR,
	[TAPAN_A_RX_PA_AUX_IN_CONN] = TAPAN_A_RX_PA_AUX_IN_CONN__POR,
	[TAPAN_A_RX_COM_TIMER_DIV] = TAPAN_A_RX_COM_TIMER_DIV__POR,
	[TAPAN_A_RX_COM_OCP_CTL] = TAPAN_A_RX_COM_OCP_CTL__POR,
	[TAPAN_A_RX_COM_OCP_COUNT] = TAPAN_A_RX_COM_OCP_COUNT__POR,
	[TAPAN_A_RX_COM_DAC_CTL] = TAPAN_A_RX_COM_DAC_CTL__POR,
	[TAPAN_A_RX_COM_BIAS] = TAPAN_A_RX_COM_BIAS__POR,
	[TAPAN_A_RX_HPH_AUTO_CHOP] = TAPAN_A_RX_HPH_AUTO_CHOP__POR,
	[TAPAN_A_RX_HPH_CHOP_CTL] = TAPAN_A_RX_HPH_CHOP_CTL__POR,
	[TAPAN_A_RX_HPH_BIAS_PA] = TAPAN_A_RX_HPH_BIAS_PA__POR,
	[TAPAN_A_RX_HPH_BIAS_LDO] = TAPAN_A_RX_HPH_BIAS_LDO__POR,
	[TAPAN_A_RX_HPH_BIAS_CNP] = TAPAN_A_RX_HPH_BIAS_CNP__POR,
	[TAPAN_A_RX_HPH_BIAS_WG_OCP] = TAPAN_A_RX_HPH_BIAS_WG_OCP__POR,
	[TAPAN_A_RX_HPH_OCP_CTL] = TAPAN_A_RX_HPH_OCP_CTL__POR,
	[TAPAN_A_RX_HPH_CNP_EN] = TAPAN_A_RX_HPH_CNP_EN__POR,
	[TAPAN_A_RX_HPH_CNP_WG_CTL] = TAPAN_A_RX_HPH_CNP_WG_CTL__POR,
	[TAPAN_A_RX_HPH_CNP_WG_TIME] = TAPAN_A_RX_HPH_CNP_WG_TIME__POR,
	[TAPAN_A_RX_HPH_L_GAIN] = TAPAN_A_RX_HPH_L_GAIN__POR,
	[TAPAN_A_RX_HPH_L_TEST] = TAPAN_A_RX_HPH_L_TEST__POR,
	[TAPAN_A_RX_HPH_L_PA_CTL] = TAPAN_A_RX_HPH_L_PA_CTL__POR,
	[TAPAN_A_RX_HPH_L_DAC_CTL] = TAPAN_A_RX_HPH_L_DAC_CTL__POR,
	[TAPAN_A_RX_HPH_L_ATEST] = TAPAN_A_RX_HPH_L_ATEST__POR,
	[TAPAN_A_RX_HPH_L_STATUS] = TAPAN_A_RX_HPH_L_STATUS__POR,
	[TAPAN_A_RX_HPH_R_GAIN] = TAPAN_A_RX_HPH_R_GAIN__POR,
	[TAPAN_A_RX_HPH_R_TEST] = TAPAN_A_RX_HPH_R_TEST__POR,
	[TAPAN_A_RX_HPH_R_PA_CTL] = TAPAN_A_RX_HPH_R_PA_CTL__POR,
	[TAPAN_A_RX_HPH_R_DAC_CTL] = TAPAN_A_RX_HPH_R_DAC_CTL__POR,
	[TAPAN_A_RX_HPH_R_ATEST] = TAPAN_A_RX_HPH_R_ATEST__POR,
	[TAPAN_A_RX_HPH_R_STATUS] = TAPAN_A_RX_HPH_R_STATUS__POR,
	[TAPAN_A_RX_EAR_BIAS_PA] = TAPAN_A_RX_EAR_BIAS_PA__POR,
	[TAPAN_A_RX_EAR_BIAS_CMBUFF] = TAPAN_A_RX_EAR_BIAS_CMBUFF__POR,
	[TAPAN_A_RX_EAR_EN] = TAPAN_A_RX_EAR_EN__POR,
	[TAPAN_A_RX_EAR_GAIN] = TAPAN_A_RX_EAR_GAIN__POR,
	[TAPAN_A_RX_EAR_CMBUFF] = TAPAN_A_RX_EAR_CMBUFF__POR,
	[TAPAN_A_RX_EAR_ICTL] = TAPAN_A_RX_EAR_ICTL__POR,
	[TAPAN_A_RX_EAR_CCOMP] = TAPAN_A_RX_EAR_CCOMP__POR,
	[TAPAN_A_RX_EAR_VCM] = TAPAN_A_RX_EAR_VCM__POR,
	[TAPAN_A_RX_EAR_CNP] = TAPAN_A_RX_EAR_CNP__POR,
	[TAPAN_A_RX_EAR_DAC_CTL_ATEST] = TAPAN_A_RX_EAR_DAC_CTL_ATEST__POR,
	[TAPAN_A_RX_EAR_STATUS] = TAPAN_A_RX_EAR_STATUS__POR,
	[TAPAN_A_RX_LINE_BIAS_PA] = TAPAN_A_RX_LINE_BIAS_PA__POR,
	[TAPAN_A_RX_BUCK_BIAS1] = TAPAN_A_RX_BUCK_BIAS1__POR,
	[TAPAN_A_RX_BUCK_BIAS2] = TAPAN_A_RX_BUCK_BIAS2__POR,
	[TAPAN_A_RX_LINE_COM] = TAPAN_A_RX_LINE_COM__POR,
	[TAPAN_A_RX_LINE_CNP_EN] = TAPAN_A_RX_LINE_CNP_EN__POR,
	[TAPAN_A_RX_LINE_CNP_WG_CTL] = TAPAN_A_RX_LINE_CNP_WG_CTL__POR,
	[TAPAN_A_RX_LINE_CNP_WG_TIME] = TAPAN_A_RX_LINE_CNP_WG_TIME__POR,
	[TAPAN_A_RX_LINE_1_GAIN] = TAPAN_A_RX_LINE_1_GAIN__POR,
	[TAPAN_A_RX_LINE_1_TEST] = TAPAN_A_RX_LINE_1_TEST__POR,
	[TAPAN_A_RX_LINE_1_DAC_CTL] = TAPAN_A_RX_LINE_1_DAC_CTL__POR,
	[TAPAN_A_RX_LINE_1_STATUS] = TAPAN_A_RX_LINE_1_STATUS__POR,
	[TAPAN_A_RX_LINE_2_GAIN] = TAPAN_A_RX_LINE_2_GAIN__POR,
	[TAPAN_A_RX_LINE_2_TEST] = TAPAN_A_RX_LINE_2_TEST__POR,
	[TAPAN_A_RX_LINE_2_DAC_CTL] = TAPAN_A_RX_LINE_2_DAC_CTL__POR,
	[TAPAN_A_RX_LINE_2_STATUS] = TAPAN_A_RX_LINE_2_STATUS__POR,
	[TAPAN_A_RX_LINE_CNP_DBG] = TAPAN_A_RX_LINE_CNP_DBG__POR,
	[TAPAN_A_SPKR_DRV_EN] = TAPAN_A_SPKR_DRV_EN__POR,
	[TAPAN_A_SPKR_DRV_GAIN] = TAPAN_A_SPKR_DRV_GAIN__POR,
	[TAPAN_A_SPKR_DRV_DAC_CTL] = TAPAN_A_SPKR_DRV_DAC_CTL__POR,
	[TAPAN_A_SPKR_DRV_OCP_CTL] = TAPAN_A_SPKR_DRV_OCP_CTL__POR,
	[TAPAN_A_SPKR_DRV_CLIP_DET] = TAPAN_A_SPKR_DRV_CLIP_DET__POR,
	[TAPAN_A_SPKR_DRV_IEC] = TAPAN_A_SPKR_DRV_IEC__POR,
	[TAPAN_A_SPKR_DRV_DBG_DAC] = TAPAN_A_SPKR_DRV_DBG_DAC__POR,
	[TAPAN_A_SPKR_DRV_DBG_PA] = TAPAN_A_SPKR_DRV_DBG_PA__POR,
	[TAPAN_A_SPKR_DRV_DBG_PWRSTG] = TAPAN_A_SPKR_DRV_DBG_PWRSTG__POR,
	[TAPAN_A_SPKR_DRV_BIAS_LDO] = TAPAN_A_SPKR_DRV_BIAS_LDO__POR,
	[TAPAN_A_SPKR_DRV_BIAS_INT] = TAPAN_A_SPKR_DRV_BIAS_INT__POR,
	[TAPAN_A_SPKR_DRV_BIAS_PA] = TAPAN_A_SPKR_DRV_BIAS_PA__POR,
	[TAPAN_A_SPKR_DRV_STATUS_OCP] = TAPAN_A_SPKR_DRV_STATUS_OCP__POR,
	[TAPAN_A_SPKR_DRV_STATUS_PA] = TAPAN_A_SPKR_DRV_STATUS_PA__POR,
	[TAPAN_A_RC_OSC_FREQ] = TAPAN_A_RC_OSC_FREQ__POR,
	[TAPAN_A_RC_OSC_TEST] = TAPAN_A_RC_OSC_TEST__POR,
	[TAPAN_A_RC_OSC_STATUS] = TAPAN_A_RC_OSC_STATUS__POR,
	[TAPAN_A_RC_OSC_TUNER] = TAPAN_A_RC_OSC_TUNER__POR,
	[TAPAN_A_MBHC_HPH] = TAPAN_A_MBHC_HPH__POR,
	[TAPAN_A_CDC_ANC1_B1_CTL] = TAPAN_A_CDC_ANC1_B1_CTL__POR,
	[TAPAN_A_CDC_ANC2_B1_CTL] = TAPAN_A_CDC_ANC2_B1_CTL__POR,
	[TAPAN_A_CDC_ANC1_SHIFT] = TAPAN_A_CDC_ANC1_SHIFT__POR,
	[TAPAN_A_CDC_ANC2_SHIFT] = TAPAN_A_CDC_ANC2_SHIFT__POR,
	[TAPAN_A_CDC_ANC1_IIR_B1_CTL] = TAPAN_A_CDC_ANC1_IIR_B1_CTL__POR,
	[TAPAN_A_CDC_ANC2_IIR_B1_CTL] = TAPAN_A_CDC_ANC2_IIR_B1_CTL__POR,
	[TAPAN_A_CDC_ANC1_IIR_B2_CTL] = TAPAN_A_CDC_ANC1_IIR_B2_CTL__POR,
	[TAPAN_A_CDC_ANC2_IIR_B2_CTL] = TAPAN_A_CDC_ANC2_IIR_B2_CTL__POR,
	[TAPAN_A_CDC_ANC1_IIR_B3_CTL] = TAPAN_A_CDC_ANC1_IIR_B3_CTL__POR,
	[TAPAN_A_CDC_ANC2_IIR_B3_CTL] = TAPAN_A_CDC_ANC2_IIR_B3_CTL__POR,
	[TAPAN_A_CDC_ANC1_LPF_B1_CTL] = TAPAN_A_CDC_ANC1_LPF_B1_CTL__POR,
	[TAPAN_A_CDC_ANC2_LPF_B1_CTL] = TAPAN_A_CDC_ANC2_LPF_B1_CTL__POR,
	[TAPAN_A_CDC_ANC1_LPF_B2_CTL] = TAPAN_A_CDC_ANC1_LPF_B2_CTL__POR,
	[TAPAN_A_CDC_ANC2_LPF_B2_CTL] = TAPAN_A_CDC_ANC2_LPF_B2_CTL__POR,
	[TAPAN_A_CDC_ANC1_SPARE] = TAPAN_A_CDC_ANC1_SPARE__POR,
	[TAPAN_A_CDC_ANC2_SPARE] = TAPAN_A_CDC_ANC2_SPARE__POR,
	[TAPAN_A_CDC_ANC1_SMLPF_CTL] = TAPAN_A_CDC_ANC1_SMLPF_CTL__POR,
	[TAPAN_A_CDC_ANC2_SMLPF_CTL] = TAPAN_A_CDC_ANC2_SMLPF_CTL__POR,
	[TAPAN_A_CDC_ANC1_DCFLT_CTL] = TAPAN_A_CDC_ANC1_DCFLT_CTL__POR,
	[TAPAN_A_CDC_ANC2_DCFLT_CTL] = TAPAN_A_CDC_ANC2_DCFLT_CTL__POR,
	[TAPAN_A_CDC_ANC1_GAIN_CTL] = TAPAN_A_CDC_ANC1_GAIN_CTL__POR,
	[TAPAN_A_CDC_ANC2_GAIN_CTL] = TAPAN_A_CDC_ANC2_GAIN_CTL__POR,
	[TAPAN_A_CDC_ANC1_B2_CTL] = TAPAN_A_CDC_ANC1_B2_CTL__POR,
	[TAPAN_A_CDC_ANC2_B2_CTL] = TAPAN_A_CDC_ANC2_B2_CTL__POR,
	[TAPAN_A_CDC_TX1_VOL_CTL_TIMER] = TAPAN_A_CDC_TX1_VOL_CTL_TIMER__POR,
	[TAPAN_A_CDC_TX2_VOL_CTL_TIMER] = TAPAN_A_CDC_TX2_VOL_CTL_TIMER__POR,
	[TAPAN_A_CDC_TX3_VOL_CTL_TIMER] = TAPAN_A_CDC_TX3_VOL_CTL_TIMER__POR,
	[TAPAN_A_CDC_TX4_VOL_CTL_TIMER] = TAPAN_A_CDC_TX4_VOL_CTL_TIMER__POR,
	[TAPAN_A_CDC_TX1_VOL_CTL_GAIN] = TAPAN_A_CDC_TX1_VOL_CTL_GAIN__POR,
	[TAPAN_A_CDC_TX2_VOL_CTL_GAIN] = TAPAN_A_CDC_TX2_VOL_CTL_GAIN__POR,
	[TAPAN_A_CDC_TX3_VOL_CTL_GAIN] = TAPAN_A_CDC_TX3_VOL_CTL_GAIN__POR,
	[TAPAN_A_CDC_TX4_VOL_CTL_GAIN] = TAPAN_A_CDC_TX4_VOL_CTL_GAIN__POR,
	[TAPAN_A_CDC_TX1_VOL_CTL_CFG] = TAPAN_A_CDC_TX1_VOL_CTL_CFG__POR,
	[TAPAN_A_CDC_TX2_VOL_CTL_CFG] = TAPAN_A_CDC_TX2_VOL_CTL_CFG__POR,
	[TAPAN_A_CDC_TX3_VOL_CTL_CFG] = TAPAN_A_CDC_TX3_VOL_CTL_CFG__POR,
	[TAPAN_A_CDC_TX4_VOL_CTL_CFG] = TAPAN_A_CDC_TX4_VOL_CTL_CFG__POR,
	[TAPAN_A_CDC_TX1_MUX_CTL] = TAPAN_A_CDC_TX1_MUX_CTL__POR,
	[TAPAN_A_CDC_TX2_MUX_CTL] = TAPAN_A_CDC_TX2_MUX_CTL__POR,
	[TAPAN_A_CDC_TX3_MUX_CTL] = TAPAN_A_CDC_TX3_MUX_CTL__POR,
	[TAPAN_A_CDC_TX4_MUX_CTL] = TAPAN_A_CDC_TX4_MUX_CTL__POR,
	[TAPAN_A_CDC_TX1_CLK_FS_CTL] = TAPAN_A_CDC_TX1_CLK_FS_CTL__POR,
	[TAPAN_A_CDC_TX2_CLK_FS_CTL] = TAPAN_A_CDC_TX2_CLK_FS_CTL__POR,
	[TAPAN_A_CDC_TX3_CLK_FS_CTL] = TAPAN_A_CDC_TX3_CLK_FS_CTL__POR,
	[TAPAN_A_CDC_TX4_CLK_FS_CTL] = TAPAN_A_CDC_TX4_CLK_FS_CTL__POR,
	[TAPAN_A_CDC_TX1_DMIC_CTL] = TAPAN_A_CDC_TX1_DMIC_CTL__POR,
	[TAPAN_A_CDC_TX2_DMIC_CTL] = TAPAN_A_CDC_TX2_DMIC_CTL__POR,
	[TAPAN_A_CDC_TX3_DMIC_CTL] = TAPAN_A_CDC_TX3_DMIC_CTL__POR,
	[TAPAN_A_CDC_TX4_DMIC_CTL] = TAPAN_A_CDC_TX4_DMIC_CTL__POR,
	[TAPAN_A_CDC_DEBUG_B1_CTL] = TAPAN_A_CDC_DEBUG_B1_CTL__POR,
	[TAPAN_A_CDC_DEBUG_B2_CTL] = TAPAN_A_CDC_DEBUG_B2_CTL__POR,
	[TAPAN_A_CDC_DEBUG_B3_CTL] = TAPAN_A_CDC_DEBUG_B3_CTL__POR,
	[TAPAN_A_CDC_DEBUG_B4_CTL] = TAPAN_A_CDC_DEBUG_B4_CTL__POR,
	[TAPAN_A_CDC_DEBUG_B5_CTL] = TAPAN_A_CDC_DEBUG_B5_CTL__POR,
	[TAPAN_A_CDC_DEBUG_B6_CTL] = TAPAN_A_CDC_DEBUG_B6_CTL__POR,
	[TAPAN_A_CDC_DEBUG_B7_CTL] = TAPAN_A_CDC_DEBUG_B7_CTL__POR,
	[TAPAN_A_CDC_SRC1_PDA_CFG] = TAPAN_A_CDC_SRC1_PDA_CFG__POR,
	[TAPAN_A_CDC_SRC2_PDA_CFG] = TAPAN_A_CDC_SRC2_PDA_CFG__POR,
	[TAPAN_A_CDC_SRC1_FS_CTL] = TAPAN_A_CDC_SRC1_FS_CTL__POR,
	[TAPAN_A_CDC_SRC2_FS_CTL] = TAPAN_A_CDC_SRC2_FS_CTL__POR,
	[TAPAN_A_CDC_RX1_B1_CTL] = TAPAN_A_CDC_RX1_B1_CTL__POR,
	[TAPAN_A_CDC_RX2_B1_CTL] = TAPAN_A_CDC_RX2_B1_CTL__POR,
	[TAPAN_A_CDC_RX3_B1_CTL] = TAPAN_A_CDC_RX3_B1_CTL__POR,
	[TAPAN_A_CDC_RX4_B1_CTL] = TAPAN_A_CDC_RX4_B1_CTL__POR,
	[TAPAN_A_CDC_RX1_B2_CTL] = TAPAN_A_CDC_RX1_B2_CTL__POR,
	[TAPAN_A_CDC_RX2_B2_CTL] = TAPAN_A_CDC_RX2_B2_CTL__POR,
	[TAPAN_A_CDC_RX3_B2_CTL] = TAPAN_A_CDC_RX3_B2_CTL__POR,
	[TAPAN_A_CDC_RX4_B2_CTL] = TAPAN_A_CDC_RX4_B2_CTL__POR,
	[TAPAN_A_CDC_RX1_B3_CTL] = TAPAN_A_CDC_RX1_B3_CTL__POR,
	[TAPAN_A_CDC_RX2_B3_CTL] = TAPAN_A_CDC_RX2_B3_CTL__POR,
	[TAPAN_A_CDC_RX3_B3_CTL] = TAPAN_A_CDC_RX3_B3_CTL__POR,
	[TAPAN_A_CDC_RX4_B3_CTL] = TAPAN_A_CDC_RX4_B3_CTL__POR,
	[TAPAN_A_CDC_RX1_B4_CTL] = TAPAN_A_CDC_RX1_B4_CTL__POR,
	[TAPAN_A_CDC_RX2_B4_CTL] = TAPAN_A_CDC_RX2_B4_CTL__POR,
	[TAPAN_A_CDC_RX3_B4_CTL] = TAPAN_A_CDC_RX3_B4_CTL__POR,
	[TAPAN_A_CDC_RX4_B4_CTL] = TAPAN_A_CDC_RX4_B4_CTL__POR,
	[TAPAN_A_CDC_RX1_B5_CTL] = TAPAN_A_CDC_RX1_B5_CTL__POR,
	[TAPAN_A_CDC_RX2_B5_CTL] = TAPAN_A_CDC_RX2_B5_CTL__POR,
	[TAPAN_A_CDC_RX3_B5_CTL] = TAPAN_A_CDC_RX3_B5_CTL__POR,
	[TAPAN_A_CDC_RX4_B5_CTL] = TAPAN_A_CDC_RX4_B5_CTL__POR,
	[TAPAN_A_CDC_RX1_B6_CTL] = TAPAN_A_CDC_RX1_B6_CTL__POR,
	[TAPAN_A_CDC_RX2_B6_CTL] = TAPAN_A_CDC_RX2_B6_CTL__POR,
	[TAPAN_A_CDC_RX3_B6_CTL] = TAPAN_A_CDC_RX3_B6_CTL__POR,
	[TAPAN_A_CDC_RX4_B6_CTL] = TAPAN_A_CDC_RX4_B6_CTL__POR,
	[TAPAN_A_CDC_RX1_VOL_CTL_B1_CTL] = TAPAN_A_CDC_RX1_VOL_CTL_B1_CTL__POR,
	[TAPAN_A_CDC_RX2_VOL_CTL_B1_CTL] = TAPAN_A_CDC_RX2_VOL_CTL_B1_CTL__POR,
	[TAPAN_A_CDC_RX3_VOL_CTL_B1_CTL] = TAPAN_A_CDC_RX3_VOL_CTL_B1_CTL__POR,
	[TAPAN_A_CDC_RX4_VOL_CTL_B1_CTL] = TAPAN_A_CDC_RX4_VOL_CTL_B1_CTL__POR,
	[TAPAN_A_CDC_RX1_VOL_CTL_B2_CTL] = TAPAN_A_CDC_RX1_VOL_CTL_B2_CTL__POR,
	[TAPAN_A_CDC_RX2_VOL_CTL_B2_CTL] = TAPAN_A_CDC_RX2_VOL_CTL_B2_CTL__POR,
	[TAPAN_A_CDC_RX3_VOL_CTL_B2_CTL] = TAPAN_A_CDC_RX3_VOL_CTL_B2_CTL__POR,
	[TAPAN_A_CDC_RX4_VOL_CTL_B2_CTL] = TAPAN_A_CDC_RX4_VOL_CTL_B2_CTL__POR,
	[TAPAN_A_CDC_CLK_ANC_RESET_CTL] = TAPAN_A_CDC_CLK_ANC_RESET_CTL__POR,
	[TAPAN_A_CDC_CLK_RX_RESET_CTL] = TAPAN_A_CDC_CLK_RX_RESET_CTL__POR,
	[TAPAN_A_CDC_CLK_TX_RESET_B1_CTL] =
			TAPAN_A_CDC_CLK_TX_RESET_B1_CTL__POR,
	[TAPAN_A_CDC_CLK_TX_RESET_B2_CTL] =
			TAPAN_A_CDC_CLK_TX_RESET_B2_CTL__POR,
	[TAPAN_A_CDC_CLK_DMIC_B1_CTL] = TAPAN_A_CDC_CLK_DMIC_B1_CTL__POR,
	[TAPAN_A_CDC_CLK_DMIC_B2_CTL] = TAPAN_A_CDC_CLK_DMIC_B2_CTL__POR,
	[TAPAN_A_CDC_CLK_I2S_CTL] = TAPAN_A_CDC_CLK_I2S_CTL__POR,
	[TAPAN_A_CDC_CLK_OTHR_RESET_B1_CTL] =
			TAPAN_A_CDC_CLK_OTHR_RESET_B1_CTL__POR,
	[TAPAN_A_CDC_CLK_OTHR_RESET_B2_CTL] =
			TAPAN_A_CDC_CLK_OTHR_RESET_B2_CTL__POR,
	[TAPAN_A_CDC_CLK_TX_CLK_EN_B1_CTL] =
			TAPAN_A_CDC_CLK_TX_CLK_EN_B1_CTL__POR,
	[TAPAN_A_CDC_CLK_TX_CLK_EN_B2_CTL] =
			TAPAN_A_CDC_CLK_TX_CLK_EN_B2_CTL__POR,
	[TAPAN_A_CDC_CLK_OTHR_CTL] = TAPAN_A_CDC_CLK_OTHR_CTL__POR,
	[TAPAN_A_CDC_CLK_RDAC_CLK_EN_CTL] =
			TAPAN_A_CDC_CLK_RDAC_CLK_EN_CTL__POR,
	[TAPAN_A_CDC_CLK_ANC_CLK_EN_CTL] = TAPAN_A_CDC_CLK_ANC_CLK_EN_CTL__POR,
	[TAPAN_A_CDC_CLK_RX_B1_CTL] = TAPAN_A_CDC_CLK_RX_B1_CTL__POR,
	[TAPAN_A_CDC_CLK_RX_B2_CTL] = TAPAN_A_CDC_CLK_RX_B2_CTL__POR,
	[TAPAN_A_CDC_CLK_MCLK_CTL] = TAPAN_A_CDC_CLK_MCLK_CTL__POR,
	[TAPAN_A_CDC_CLK_PDM_CTL] = TAPAN_A_CDC_CLK_PDM_CTL__POR,
	[TAPAN_A_CDC_CLK_SD_CTL] = TAPAN_A_CDC_CLK_SD_CTL__POR,
	[TAPAN_A_CDC_CLK_POWER_CTL] = TAPAN_A_CDC_CLK_POWER_CTL__POR,
	[TAPAN_A_CDC_CLSH_B1_CTL] = TAPAN_A_CDC_CLSH_B1_CTL__POR,
	[TAPAN_A_CDC_CLSH_B2_CTL] = TAPAN_A_CDC_CLSH_B2_CTL__POR,
	[TAPAN_A_CDC_CLSH_B3_CTL] = TAPAN_A_CDC_CLSH_B3_CTL__POR,
	[TAPAN_A_CDC_CLSH_BUCK_NCP_VARS] = TAPAN_A_CDC_CLSH_BUCK_NCP_VARS__POR,
	[TAPAN_A_CDC_CLSH_IDLE_HPH_THSD] = TAPAN_A_CDC_CLSH_IDLE_HPH_THSD__POR,
	[TAPAN_A_CDC_CLSH_IDLE_EAR_THSD] = TAPAN_A_CDC_CLSH_IDLE_EAR_THSD__POR,
	[TAPAN_A_CDC_CLSH_FCLKONLY_HPH_THSD] =
			TAPAN_A_CDC_CLSH_FCLKONLY_HPH_THSD__POR,
	[TAPAN_A_CDC_CLSH_FCLKONLY_EAR_THSD] =
			TAPAN_A_CDC_CLSH_FCLKONLY_EAR_THSD__POR,
	[TAPAN_A_CDC_CLSH_K_ADDR] = TAPAN_A_CDC_CLSH_K_ADDR__POR,
	[TAPAN_A_CDC_CLSH_K_DATA] = TAPAN_A_CDC_CLSH_K_DATA__POR,
	[TAPAN_A_CDC_CLSH_I_PA_FACT_HPH_L] =
			TAPAN_A_CDC_CLSH_I_PA_FACT_HPH_L__POR,
	[TAPAN_A_CDC_CLSH_I_PA_FACT_HPH_U] =
			TAPAN_A_CDC_CLSH_I_PA_FACT_HPH_U__POR,
	[TAPAN_A_CDC_CLSH_I_PA_FACT_EAR_L] =
			TAPAN_A_CDC_CLSH_I_PA_FACT_EAR_L__POR,
	[TAPAN_A_CDC_CLSH_I_PA_FACT_EAR_U] =
			TAPAN_A_CDC_CLSH_I_PA_FACT_EAR_U__POR,
	[TAPAN_A_CDC_CLSH_V_PA_HD_EAR] = TAPAN_A_CDC_CLSH_V_PA_HD_EAR__POR,
	[TAPAN_A_CDC_CLSH_V_PA_HD_HPH] = TAPAN_A_CDC_CLSH_V_PA_HD_HPH__POR,
	[TAPAN_A_CDC_CLSH_V_PA_MIN_EAR] = TAPAN_A_CDC_CLSH_V_PA_MIN_EAR__POR,
	[TAPAN_A_CDC_CLSH_V_PA_MIN_HPH] = TAPAN_A_CDC_CLSH_V_PA_MIN_HPH__POR,
	[TAPAN_A_CDC_IIR1_GAIN_B1_CTL] = TAPAN_A_CDC_IIR1_GAIN_B1_CTL__POR,
	[TAPAN_A_CDC_IIR2_GAIN_B1_CTL] = TAPAN_A_CDC_IIR2_GAIN_B1_CTL__POR,
	[TAPAN_A_CDC_IIR1_GAIN_B2_CTL] = TAPAN_A_CDC_IIR1_GAIN_B2_CTL__POR,
	[TAPAN_A_CDC_IIR2_GAIN_B2_CTL] = TAPAN_A_CDC_IIR2_GAIN_B2_CTL__POR,
	[TAPAN_A_CDC_IIR1_GAIN_B3_CTL] = TAPAN_A_CDC_IIR1_GAIN_B3_CTL__POR,
	[TAPAN_A_CDC_IIR2_GAIN_B3_CTL] = TAPAN_A_CDC_IIR2_GAIN_B3_CTL__POR,
	[TAPAN_A_CDC_IIR1_GAIN_B4_CTL] = TAPAN_A_CDC_IIR1_GAIN_B4_CTL__POR,
	[TAPAN_A_CDC_IIR2_GAIN_B4_CTL] = TAPAN_A_CDC_IIR2_GAIN_B4_CTL__POR,
	[TAPAN_A_CDC_IIR1_GAIN_B5_CTL] = TAPAN_A_CDC_IIR1_GAIN_B5_CTL__POR,
	[TAPAN_A_CDC_IIR2_GAIN_B5_CTL] = TAPAN_A_CDC_IIR2_GAIN_B5_CTL__POR,
	[TAPAN_A_CDC_IIR1_GAIN_B6_CTL] = TAPAN_A_CDC_IIR1_GAIN_B6_CTL__POR,
	[TAPAN_A_CDC_IIR2_GAIN_B6_CTL] = TAPAN_A_CDC_IIR2_GAIN_B6_CTL__POR,
	[TAPAN_A_CDC_IIR1_GAIN_B7_CTL] = TAPAN_A_CDC_IIR1_GAIN_B7_CTL__POR,
	[TAPAN_A_CDC_IIR2_GAIN_B7_CTL] = TAPAN_A_CDC_IIR2_GAIN_B7_CTL__POR,
	[TAPAN_A_CDC_IIR1_GAIN_B8_CTL] = TAPAN_A_CDC_IIR1_GAIN_B8_CTL__POR,
	[TAPAN_A_CDC_IIR2_GAIN_B8_CTL] = TAPAN_A_CDC_IIR2_GAIN_B8_CTL__POR,
	[TAPAN_A_CDC_IIR1_CTL] = TAPAN_A_CDC_IIR1_CTL__POR,
	[TAPAN_A_CDC_IIR2_CTL] = TAPAN_A_CDC_IIR2_CTL__POR,
	[TAPAN_A_CDC_IIR1_GAIN_TIMER_CTL] =
			TAPAN_A_CDC_IIR1_GAIN_TIMER_CTL__POR,
	[TAPAN_A_CDC_IIR2_GAIN_TIMER_CTL] =
			TAPAN_A_CDC_IIR2_GAIN_TIMER_CTL__POR,
	[TAPAN_A_CDC_IIR1_COEF_B1_CTL] = TAPAN_A_CDC_IIR1_COEF_B1_CTL__POR,
	[TAPAN_A_CDC_IIR2_COEF_B1_CTL] = TAPAN_A_CDC_IIR2_COEF_B1_CTL__POR,
	[TAPAN_A_CDC_IIR1_COEF_B2_CTL] = TAPAN_A_CDC_IIR1_COEF_B2_CTL__POR,
	[TAPAN_A_CDC_IIR2_COEF_B2_CTL] = TAPAN_A_CDC_IIR2_COEF_B2_CTL__POR,
	[TAPAN_A_CDC_TOP_GAIN_UPDATE] = TAPAN_A_CDC_TOP_GAIN_UPDATE__POR,
	[TAPAN_A_CDC_COMP0_B1_CTL] = TAPAN_A_CDC_COMP0_B1_CTL__POR,
	[TAPAN_A_CDC_COMP1_B1_CTL] = TAPAN_A_CDC_COMP1_B1_CTL__POR,
	[TAPAN_A_CDC_COMP2_B1_CTL] = TAPAN_A_CDC_COMP2_B1_CTL__POR,
	[TAPAN_A_CDC_COMP0_B2_CTL] = TAPAN_A_CDC_COMP0_B2_CTL__POR,
	[TAPAN_A_CDC_COMP1_B2_CTL] = TAPAN_A_CDC_COMP1_B2_CTL__POR,
	[TAPAN_A_CDC_COMP2_B2_CTL] = TAPAN_A_CDC_COMP2_B2_CTL__POR,
	[TAPAN_A_CDC_COMP0_B3_CTL] = TAPAN_A_CDC_COMP0_B3_CTL__POR,
	[TAPAN_A_CDC_COMP1_B3_CTL] = TAPAN_A_CDC_COMP1_B3_CTL__POR,
	[TAPAN_A_CDC_COMP2_B3_CTL] = TAPAN_A_CDC_COMP2_B3_CTL__POR,
	[TAPAN_A_CDC_COMP0_B4_CTL] = TAPAN_A_CDC_COMP0_B4_CTL__POR,
	[TAPAN_A_CDC_COMP1_B4_CTL] = TAPAN_A_CDC_COMP1_B4_CTL__POR,
	[TAPAN_A_CDC_COMP2_B4_CTL] = TAPAN_A_CDC_COMP2_B4_CTL__POR,
	[TAPAN_A_CDC_COMP0_B5_CTL] = TAPAN_A_CDC_COMP0_B5_CTL__POR,
	[TAPAN_A_CDC_COMP1_B5_CTL] = TAPAN_A_CDC_COMP1_B5_CTL__POR,
	[TAPAN_A_CDC_COMP2_B5_CTL] = TAPAN_A_CDC_COMP2_B5_CTL__POR,
	[TAPAN_A_CDC_COMP0_B6_CTL] = TAPAN_A_CDC_COMP0_B6_CTL__POR,
	[TAPAN_A_CDC_COMP1_B6_CTL] = TAPAN_A_CDC_COMP1_B6_CTL__POR,
	[TAPAN_A_CDC_COMP2_B6_CTL] = TAPAN_A_CDC_COMP2_B6_CTL__POR,
	[TAPAN_A_CDC_COMP0_SHUT_DOWN_STATUS] =
			TAPAN_A_CDC_COMP0_SHUT_DOWN_STATUS__POR,
	[TAPAN_A_CDC_COMP1_SHUT_DOWN_STATUS] =
			TAPAN_A_CDC_COMP1_SHUT_DOWN_STATUS__POR,
	[TAPAN_A_CDC_COMP2_SHUT_DOWN_STATUS] =
			TAPAN_A_CDC_COMP2_SHUT_DOWN_STATUS__POR,
	[TAPAN_A_CDC_COMP0_FS_CFG] = TAPAN_A_CDC_COMP0_FS_CFG__POR,
	[TAPAN_A_CDC_COMP1_FS_CFG] = TAPAN_A_CDC_COMP1_FS_CFG__POR,
	[TAPAN_A_CDC_COMP2_FS_CFG] = TAPAN_A_CDC_COMP2_FS_CFG__POR,
	[TAPAN_A_CDC_CONN_RX1_B1_CTL] = TAPAN_A_CDC_CONN_RX1_B1_CTL__POR,
	[TAPAN_A_CDC_CONN_RX1_B2_CTL] = TAPAN_A_CDC_CONN_RX1_B2_CTL__POR,
	[TAPAN_A_CDC_CONN_RX1_B3_CTL] = TAPAN_A_CDC_CONN_RX1_B3_CTL__POR,
	[TAPAN_A_CDC_CONN_RX2_B1_CTL] = TAPAN_A_CDC_CONN_RX2_B1_CTL__POR,
	[TAPAN_A_CDC_CONN_RX2_B2_CTL] = TAPAN_A_CDC_CONN_RX2_B2_CTL__POR,
	[TAPAN_A_CDC_CONN_RX2_B3_CTL] = TAPAN_A_CDC_CONN_RX2_B3_CTL__POR,
	[TAPAN_A_CDC_CONN_RX3_B1_CTL] = TAPAN_A_CDC_CONN_RX3_B1_CTL__POR,
	[TAPAN_A_CDC_CONN_RX3_B2_CTL] = TAPAN_A_CDC_CONN_RX3_B2_CTL__POR,
	[TAPAN_A_CDC_CONN_RX4_B1_CTL] = TAPAN_A_CDC_CONN_RX4_B1_CTL__POR,
	[TAPAN_A_CDC_CONN_RX4_B2_CTL] = TAPAN_A_CDC_CONN_RX4_B2_CTL__POR,
	[TAPAN_A_CDC_CONN_RX4_B3_CTL] = TAPAN_A_CDC_CONN_RX4_B3_CTL__POR,
	[TAPAN_A_CDC_CONN_ANC_B1_CTL] = TAPAN_A_CDC_CONN_ANC_B1_CTL__POR,
	[TAPAN_A_CDC_CONN_ANC_B2_CTL] = TAPAN_A_CDC_CONN_ANC_B2_CTL__POR,
	[TAPAN_A_CDC_CONN_TX_B1_CTL] = TAPAN_A_CDC_CONN_TX_B1_CTL__POR,
	[TAPAN_A_CDC_CONN_TX_B2_CTL] = TAPAN_A_CDC_CONN_TX_B2_CTL__POR,
	[TAPAN_A_CDC_CONN_TX_B3_CTL] = TAPAN_A_CDC_CONN_TX_B3_CTL__POR,
	[TAPAN_A_CDC_CONN_TX_B4_CTL] = TAPAN_A_CDC_CONN_TX_B4_CTL__POR,
	[TAPAN_A_CDC_CONN_EQ1_B1_CTL] = TAPAN_A_CDC_CONN_EQ1_B1_CTL__POR,
	[TAPAN_A_CDC_CONN_EQ1_B2_CTL] = TAPAN_A_CDC_CONN_EQ1_B2_CTL__POR,
	[TAPAN_A_CDC_CONN_EQ1_B3_CTL] = TAPAN_A_CDC_CONN_EQ1_B3_CTL__POR,
	[TAPAN_A_CDC_CONN_EQ1_B4_CTL] = TAPAN_A_CDC_CONN_EQ1_B4_CTL__POR,
	[TAPAN_A_CDC_CONN_EQ2_B1_CTL] = TAPAN_A_CDC_CONN_EQ2_B1_CTL__POR,
	[TAPAN_A_CDC_CONN_EQ2_B2_CTL] = TAPAN_A_CDC_CONN_EQ2_B2_CTL__POR,
	[TAPAN_A_CDC_CONN_EQ2_B3_CTL] = TAPAN_A_CDC_CONN_EQ2_B3_CTL__POR,
	[TAPAN_A_CDC_CONN_EQ2_B4_CTL] = TAPAN_A_CDC_CONN_EQ2_B4_CTL__POR,
	[TAPAN_A_CDC_CONN_SRC1_B1_CTL] = TAPAN_A_CDC_CONN_SRC1_B1_CTL__POR,
	[TAPAN_A_CDC_CONN_SRC1_B2_CTL] = TAPAN_A_CDC_CONN_SRC1_B2_CTL__POR,
	[TAPAN_A_CDC_CONN_SRC2_B1_CTL] = TAPAN_A_CDC_CONN_SRC2_B1_CTL__POR,
	[TAPAN_A_CDC_CONN_SRC2_B2_CTL] = TAPAN_A_CDC_CONN_SRC2_B2_CTL__POR,
	[TAPAN_A_CDC_CONN_TX_SB_B1_CTL] = TAPAN_A_CDC_CONN_TX_SB_B1_CTL__POR,
	[TAPAN_A_CDC_CONN_TX_SB_B2_CTL] = TAPAN_A_CDC_CONN_TX_SB_B2_CTL__POR,
	[TAPAN_A_CDC_CONN_TX_SB_B3_CTL] = TAPAN_A_CDC_CONN_TX_SB_B3_CTL__POR,
	[TAPAN_A_CDC_CONN_TX_SB_B4_CTL] = TAPAN_A_CDC_CONN_TX_SB_B4_CTL__POR,
	[TAPAN_A_CDC_CONN_TX_SB_B5_CTL] = TAPAN_A_CDC_CONN_TX_SB_B5_CTL__POR,
	[TAPAN_A_CDC_CONN_TX_SB_B11_CTL] = TAPAN_A_CDC_CONN_TX_SB_B11_CTL__POR,
	[TAPAN_A_CDC_CONN_RX_SB_B1_CTL] = TAPAN_A_CDC_CONN_RX_SB_B1_CTL__POR,
	[TAPAN_A_CDC_CONN_RX_SB_B2_CTL] = TAPAN_A_CDC_CONN_RX_SB_B2_CTL__POR,
	[TAPAN_A_CDC_CONN_CLSH_CTL] = TAPAN_A_CDC_CONN_CLSH_CTL__POR,
	[TAPAN_A_CDC_CONN_MISC] = TAPAN_A_CDC_CONN_MISC__POR,
	[TAPAN_A_CDC_MBHC_EN_CTL] = TAPAN_A_CDC_MBHC_EN_CTL__POR,
	[TAPAN_A_CDC_MBHC_FIR_B1_CFG] = TAPAN_A_CDC_MBHC_FIR_B1_CFG__POR,
	[TAPAN_A_CDC_MBHC_FIR_B2_CFG] = TAPAN_A_CDC_MBHC_FIR_B2_CFG__POR,
	[TAPAN_A_CDC_MBHC_TIMER_B1_CTL] = TAPAN_A_CDC_MBHC_TIMER_B1_CTL__POR,
	[TAPAN_A_CDC_MBHC_TIMER_B2_CTL] = TAPAN_A_CDC_MBHC_TIMER_B2_CTL__POR,
	[TAPAN_A_CDC_MBHC_TIMER_B3_CTL] = TAPAN_A_CDC_MBHC_TIMER_B3_CTL__POR,
	[TAPAN_A_CDC_MBHC_TIMER_B4_CTL] = TAPAN_A_CDC_MBHC_TIMER_B4_CTL__POR,
	[TAPAN_A_CDC_MBHC_TIMER_B5_CTL] = TAPAN_A_CDC_MBHC_TIMER_B5_CTL__POR,
	[TAPAN_A_CDC_MBHC_TIMER_B6_CTL] = TAPAN_A_CDC_MBHC_TIMER_B6_CTL__POR,
	[TAPAN_A_CDC_MBHC_B1_STATUS] = TAPAN_A_CDC_MBHC_B1_STATUS__POR,
	[TAPAN_A_CDC_MBHC_B2_STATUS] = TAPAN_A_CDC_MBHC_B2_STATUS__POR,
	[TAPAN_A_CDC_MBHC_B3_STATUS] = TAPAN_A_CDC_MBHC_B3_STATUS__POR,
	[TAPAN_A_CDC_MBHC_B4_STATUS] = TAPAN_A_CDC_MBHC_B4_STATUS__POR,
	[TAPAN_A_CDC_MBHC_B5_STATUS] = TAPAN_A_CDC_MBHC_B5_STATUS__POR,
	[TAPAN_A_CDC_MBHC_B1_CTL] = TAPAN_A_CDC_MBHC_B1_CTL__POR,
	[TAPAN_A_CDC_MBHC_B2_CTL] = TAPAN_A_CDC_MBHC_B2_CTL__POR,
	[TAPAN_A_CDC_MBHC_VOLT_B1_CTL] = TAPAN_A_CDC_MBHC_VOLT_B1_CTL__POR,
	[TAPAN_A_CDC_MBHC_VOLT_B2_CTL] = TAPAN_A_CDC_MBHC_VOLT_B2_CTL__POR,
	[TAPAN_A_CDC_MBHC_VOLT_B3_CTL] = TAPAN_A_CDC_MBHC_VOLT_B3_CTL__POR,
	[TAPAN_A_CDC_MBHC_VOLT_B4_CTL] = TAPAN_A_CDC_MBHC_VOLT_B4_CTL__POR,
	[TAPAN_A_CDC_MBHC_VOLT_B5_CTL] = TAPAN_A_CDC_MBHC_VOLT_B5_CTL__POR,
	[TAPAN_A_CDC_MBHC_VOLT_B6_CTL] = TAPAN_A_CDC_MBHC_VOLT_B6_CTL__POR,
	[TAPAN_A_CDC_MBHC_VOLT_B7_CTL] = TAPAN_A_CDC_MBHC_VOLT_B7_CTL__POR,
	[TAPAN_A_CDC_MBHC_VOLT_B8_CTL] = TAPAN_A_CDC_MBHC_VOLT_B8_CTL__POR,
	[TAPAN_A_CDC_MBHC_VOLT_B9_CTL] = TAPAN_A_CDC_MBHC_VOLT_B9_CTL__POR,
	[TAPAN_A_CDC_MBHC_VOLT_B10_CTL] = TAPAN_A_CDC_MBHC_VOLT_B10_CTL__POR,
	[TAPAN_A_CDC_MBHC_VOLT_B11_CTL] = TAPAN_A_CDC_MBHC_VOLT_B11_CTL__POR,
	[TAPAN_A_CDC_MBHC_VOLT_B12_CTL] = TAPAN_A_CDC_MBHC_VOLT_B12_CTL__POR,
	[TAPAN_A_CDC_MBHC_CLK_CTL] = TAPAN_A_CDC_MBHC_CLK_CTL__POR,
	[TAPAN_A_CDC_MBHC_INT_CTL] = TAPAN_A_CDC_MBHC_INT_CTL__POR,
	[TAPAN_A_CDC_MBHC_DEBUG_CTL] = TAPAN_A_CDC_MBHC_DEBUG_CTL__POR,
	[TAPAN_A_CDC_MBHC_SPARE] = TAPAN_A_CDC_MBHC_SPARE__POR,
};
