/*
 * Copyright (C) 2020 Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/&gt;.
 *
 */

#ifndef LOADINGDIV_H
#define LOADINGDIV_H

#include <QWidget>
#include <QPixmap>
#include <QLabel>
#include <QTimer>
#include <QList>
#include <QDebug>
#include <QVariantAnimation>

class LoadingDiv : public QWidget
{
    Q_OBJECT
public:
    explicit LoadingDiv(QWidget *parent = nullptr);

signals:
    void toStopLoading();

public slots:
    void switchAnimStep(const QVariant& value);
    void startLoading();
    void stopLoading();

private:
    QLabel *loadingGif = nullptr;
    QVariantAnimation * m_animation = nullptr;
//    QTimer *switchTimer = nullptr;

//    int currentPage;
//    int countCurrentTime;
};

#endif // LOADINGDIV_H
