--
-- Adjust password length as crypt makes bigger files
ALTER TABLE auth MODIFY passwd varchar(200);
--
-- Add dmii status to host table
--
ALTER TABLE hosts ADD COLUMN dmii_up tinyint(1) NOT NULL DEFAULT '1';
alter table hosts modify ip varchar(39) not null default '';

--
-- Add system object id for hosts
ALTER TABLE hosts ADD COLUMN sysobjectid varchar(255);

ALTER TABLE interface_types ADD COLUMN snmp_oid ;
UPDATE interface_types SET snmp_oid = '.';
ALTER TABLE interface_types ALTER COLUMN snmp_oid SET DEFAULT '.';

UPDATE interface_types SET snmp_oid = '' WHERE id IN (2,14,20,22,23,29,29,30);

-- Cisco specific interface types
UPDATE interface_types SET snmp_oid = 'ent.9' WHERE id IN (3,9,16,17,18,19,38,43,44,53);
-- Alteon
UPDATE interface_types SET snmp_oid = 'ent.1872' WHERE id IN (32,33,34,35);
-- Brocade
UPDATE interface_types SET snmp_oid = 'ent.1588' WHERE id IN (36,37);
ALTER TABLE logfiles DROP COLUMN parse_group;
ALTER TABLE logfiles ADD COLUMN description ;
UPDATE logfiles SET description = '';
ALTER TABLE logfiles ALTER COLUMN description SET DEFAULT '';
DROP TABLE logfiles_match_groups CASCADE;
ALTER TABLE logfiles_match_items ADD COLUMN logfile_id int4;
UPDATE logfiles_match_items SET logfile_id = 0;
ALTER TABLE logfiles_match_items ALTER COLUMN logfile_id SET DEFAULT 0;
ALTER TABLE logfiles_match_items ADD COLUMN pos int4;
UPDATE logfiles_match_items SET pos = 10;
ALTER TABLE logfiles_match_items ALTER COLUMN pos SET DEFAULT 10;
-- 64 bit counter SNMP interfaces
--

-- New poller items for high-speed
INSERT INTO pollers VALUES
( 229, 'input', 'SNMP Input Rate HC', 'snmp_counter', '.1.3.6.1.2.1.31.1.1.1.6.<interfacenumber>'),
( 230, 'output', 'SNMP Output Rate HC', 'snmp_counter', '.1.3.6.1.2.1.31.1.1.1.10.<interfacenumber>'),
( 231, 'inpackets', 'SNMP Input Packets HC', 'snmp_counter', '.1.3.6.1.2.1.31.1.1.1.7.<interfacenumber>'),
( 232, 'outpackets', 'SNMP Output Packets HC', 'snmp_counter', '.1.3.6.1.2.1.31.1.1.1.11.<interfacenumber>');


INSERT INTO pollers_groups VALUES
(59, 'Cisco Interface HC', 4),
(60, 'SNMP Interface', 4),
(61, 'SNMP Interface HC', 4);

INSERT INTO pollers_poller_groups VALUES
(274,59,10,3,14), (275,59,15,5,9), (276,59,16,13,12), (277,59,17,14,29), (278,59,20,229,9), (279,59,25,231,9), (280,59,30,230,9), (281,59,35,232,9), (282,59,40,11,9), (283,59,45,12,9), (284,59,46,26,9), (285,59,47,55,9), (286,59,48,56,9), (287,59,50,6,1), (288,59,55,7,9), (289,59,60,8,9), (290,59,65,9,1), (291,59,80,1,10),
(292,60,10,3,14), (293,60,16,13,12), (294,60,17,14,29), (295,60,20,2,9), (296,60,25,21,9), (297,60,30,10,9), (298,60,35,22,9), (299,60,40,11,9), (300,60,45,12,9), (301,60,46,26,9), (302,60,47,55,9), (303,60,48,56,9), (304,60,80,1,10),
(305,61,10,3,14), (306,61,16,13,12), (307,61,17,14,29), (308,61,20,229,9), (309,61,25,231,9), (310,61,30,230,9), (311,61,35,232,9), (312,61,40,11,9), (313,61,45,12,9), (314,61,46,26,9), (315,61,47,55,9), (316,61,48,56,9), (317,61,80,1,10);

-- Adjust counters to use standard always for old poller
UPDATE pollers SET parameters='.1.3.6.1.2.1.2.2.1.10.<interfacenumber>' WHERE id=2;
UPDATE pollers SET parameters='.1.3.6.1.2.1.2.2.1.16.<interfacenumber>' WHERE id=10;
UPDATE pollers SET parameters='.1.3.6.1.2.1.2.2.1.11.<interfacenumber>' WHERE id=21;
UPDATE pollers SET parameters='.1.3.6.1.2.1.2.2.1.17.<interfacenumber>' WHERE id=22;
SELECT SETVAL('interface_types_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from interface_types));
SELECT SETVAL('interface_types_fields_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from interface_types_fields));
SELECT SETVAL('interface_types_field_types_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from interface_types_field_types));
SELECT SETVAL('graph_types_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from graph_types));
SELECT SETVAL('alarm_states_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from alarm_states));
SELECT SETVAL('severity_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from severity));
SELECT SETVAL('syslog_types_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from syslog_types));
SELECT SETVAL('trap_receivers_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from trap_receivers));
SELECT SETVAL('types_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from types));
SELECT SETVAL('slas_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from slas));
SELECT SETVAL('slas_cond_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from slas_cond));
SELECT SETVAL('slas_sla_cond_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from slas_sla_cond));
SELECT SETVAL('filters_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from filters));
SELECT SETVAL('filters_fields_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from filters_fields));
SELECT SETVAL('filters_cond_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from filters_cond));
SELECT SETVAL('pollers_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from pollers));
SELECT SETVAL('pollers_groups_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from pollers_groups));
SELECT SETVAL('pollers_backend_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from pollers_backend));
SELECT SETVAL('pollers_poller_groups_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from pollers_poller_groups));
SELECT SETVAL('autodiscovery_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from autodiscovery));
SELECT SETVAL('hosts_config_types_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from hosts_config_types));
SELECT SETVAL('tools_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from tools));
SELECT SETVAL('profiles_options_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from profiles_options));
SELECT SETVAL('actions_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from actions));
SELECT SETVAL('profiles_values_id_seq',(select case when max(id)>299 then max(id) else 299 end from profiles_values));
