/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet;

/**
 * Die Klasse Identifier realisiert einen Identifikator. Der Zweck dieser Klasse
 * ist es Variablen, die einen Identifikator repräsentieren auch als solche
 * kenntlich zu machen und von Zeichenketten abzugrenzen. Dies führt .z.B. zur
 * mehr Klarheit bei den Methiodenaufrufen.
 * 
 * @author michael
 */
public class Identifier {

	private final String value;

	public Identifier(String value) {

		if (value == null) {
			throw new IllegalArgumentException(
					"Argument value must not be null!");
		}

		this.value = value;
	}

	@Override
	public boolean equals(Object obj) {

		if (this == obj) {
			return true;
		}

		if (obj == null) {
			return false;
		}

		if (getClass() != obj.getClass()) {
			return false;
		}

		Identifier other = (Identifier) obj;

		if (value == null && other.value != null) {
			return false;
		}

		if (value != null && other.value == null) {
			return false;
		}

		if (value.equals(other.value) == false) {
			return false;
		}

		return true;
	}

	/**
	 * Liefert den aktuellen Wert des Identifikators.
	 * 
	 * @return String
	 */
	public String getValue() {
		return value;
	}

	@Override
	public int hashCode() {
		return value.hashCode();
	}

	/**
	 * Liefert die Länge des Identifikators.
	 * 
	 * @return int
	 */
	public int length() {
		return value.length();
	}

	@Override
	public String toString() {
		return value;
	}
}
