# $Id: Makefile.PL,v 1.3 2002/06/04 03:09:45 roderick Exp $

use ExtUtils::MakeMaker;

WriteMakefile(
    EXE_FILES		=> [qw(bones-info hearse)],
    NAME		=> 'hearse',
    PREREQ_PM		=> {
	    'Digest::MD5'	=> 0,
	    'Errno'		=> 0,
	    'HTTP::Request'	=> 0,
	    'LWP::UserAgent'	=> 0,
	},
    VERSION_FROM	=> 'hearse',
);

package MY;

# You can specify the MAN1EXT as an argument to WriteMakefile(), but you
# get a warning.  Doing it this way lets me be a little smarter about
# overriding your value (which perhaps should be left as-is if it's 1n,
# eg).

sub constants {
    my ($self, @arg) = @_;

    $self->{MAN1EXT} =~ s/^1p\z/1/;
    return $self->SUPER::constants(@arg);
}

sub dist_core {
    return q(dist:; @echo "use dpkg-buildpackge, not make dist" >&2; false);
}
