#ifndef _BIGCHUMPPOWER_NEG_H_
#define _BIGCHUMPPOWER_NEG_H_

// bigchumppower_neg_table generated by DK/circ_table_gen.py -- do not modify manually

 // variables used
 // --sig_max  -5.000000
 // --table_div  9.127496
 // --table_op  0.002000

struct tablebigchumppower_neg { // 1-dimensional function table
    float low;
    float high;
    float istep;
    int size;
    float data[];
};

template <int tab_size>
struct tablebigchumppower_neg_imp {
    float low;
    float high;
    float istep;
    int size;
    float data[tab_size];
    operator tablebigchumppower_neg&() const { return *(tablebigchumppower_neg*)this; }
};

 static tablebigchumppower_neg_imp<2048> bigchumppower_neg_table __rt_data = {
	0,0.163303,0.8188,2048, {
	0.000000000000,-0.026879808459,-0.053348238319,-0.079398030312,-0.105023297469,
	-0.130219460064,-0.154983175678,-0.179312265571,-0.203205638689,-0.226663214495,
	-0.249685845489,-0.272275240412,-0.294433888873,-0.316164988049,-0.337472371859,
	-0.358360443252,-0.378834109668,-0.398898722007,-0.418560017330,-0.437824065155,
	-0.456697217570,-0.475186063127,-0.493297384096,-0.511038117531,-0.528415319555,
	-0.545436132977,-0.562107757842,-0.578437425076,-0.594432372719,-0.610099824720,
	-0.625446972169,-0.640480956626,-0.655208855583,-0.669637669658,-0.683774311585,
	-0.697625596744,-0.711198235053,-0.724498824259,-0.737533844225,-0.750309652420,
	-0.762832480234,-0.775108430206,-0.787143474005,-0.798943451002,-0.810514067548,
	-0.821860896663,-0.832989378289,-0.843904819865,-0.854612397315,-0.865117156348,
	-0.875424013865,-0.885537759888,-0.895463059377,-0.905204454378,-0.914766366270,
	-0.924153098099,-0.933368837047,-0.942417656870,-0.951303520483,-0.960030282552,
	-0.968601692073,-0.977021394991,-0.985292936829,-0.993419765265,-1.001405232710,
	-1.009252598933,-1.016965033449,-1.024545618192,-1.031997349791,-1.039323142141,
	-1.046525828617,-1.053608164513,-1.060572829230,-1.067422428555,-1.074159496739,
	-1.080786498692,-1.087305832009,-1.093719828951,-1.100030758420,-1.106240827875,
	-1.112352185104,-1.118366920134,-1.124287066827,-1.130114604721,-1.135851460514,
	-1.141499509831,-1.147060578571,-1.152536444584,-1.157928839010,-1.163239447714,
	-1.168469912684,-1.173621833260,-1.178696767507,-1.183696233393,-1.188621710059,
	-1.193474638862,-1.198256424596,-1.202968436551,-1.207612009567,-1.212188445030,
	-1.216699011862,-1.221144947538,-1.225527458930,-1.229847723204,-1.234106888792,
	-1.238306076048,-1.242446378266,-1.246528862276,-1.250554569324,-1.254524515761,
	-1.258439693748,-1.262301071989,-1.266109596315,-1.269866190449,-1.273571756518,
	-1.277227175697,-1.280833308825,-1.284390996938,-1.287901061814,-1.291364306516,
	-1.294781515937,-1.298153457248,-1.301480880414,-1.304764518642,-1.308005088849,
	-1.311203292090,-1.314359814017,-1.317475325240,-1.320550481759,-1.323585925358,
	-1.326582283945,-1.329540171973,-1.332460190735,-1.335342928778,-1.338188962106,
	-1.340998854673,-1.343773158554,-1.346512414342,-1.349217151361,-1.351887888071,
	-1.354525132197,-1.357129381091,-1.359701121974,-1.362240832210,-1.364748979503,
	-1.367226022169,-1.369672409396,-1.372088581383,-1.374474969640,-1.376831997180,
	-1.379160078692,-1.381459620800,-1.383731022213,-1.385974673911,-1.388190959386,
	-1.390380254725,-1.392542928898,-1.394679343823,-1.396789854604,-1.398874809635,
	-1.400934550818,-1.402969413689,-1.404979727499,-1.406965815463,-1.408927994835,
	-1.410866577064,-1.412781867924,-1.414674167643,-1.416543771018,-1.418390967531,
	-1.420216041497,-1.422019272184,-1.423800933841,-1.425561295911,-1.427300623143,
	-1.429019175546,-1.430717208690,-1.432394973646,-1.434052717167,-1.435690681756,
	-1.437309105742,-1.438908223441,-1.440488265126,-1.442049457201,-1.443592022251,
	-1.445116179135,-1.446622143035,-1.448110125579,-1.449580334866,-1.451032975577,
	-1.452468249037,-1.453886353261,-1.455287483025,-1.456671829988,-1.458039582693,
	-1.459390926613,-1.460726044321,-1.462045115419,-1.463349358619,-1.464636833454,
	-1.465908784261,-1.467165379724,-1.468406785552,-1.469633165209,-1.470844679820,
	-1.472041487748,-1.473223743739,-1.474391602184,-1.475545213854,-1.476684727508,
	-1.477810290158,-1.478922045625,-1.480020136708,-1.481104702776,-1.482175882586,
	-1.483233811081,-1.484278622656,-1.485310449406,-1.486329421563,-1.487335666718,
	-1.488329311123,-1.489310479468,-1.490279294407,-1.491235876132,-1.492180344338,
	-1.493112816562,-1.494033408237,-1.494942233793,-1.495839404846,-1.496725033203,
	-1.497599227935,-1.498462097016,-1.499313746349,-1.500154280786,-1.500983804512,
	-1.501802418717,-1.502610224410,-1.503407320149,-1.504193804215,-1.504969773456,
	-1.505735323033,-1.506490546099,-1.507235536154,-1.507970384535,-1.508695180890,
	-1.509410015105,-1.510114974285,-1.510810145520,-1.511495614446,-1.512171465175,
	-1.512837781439,-1.513494644912,-1.514142137369,-1.514780338743,-1.515409328110,
	-1.516029183880,-1.516639982727,-1.517241801016,-1.517834713841,-1.518418795454,
	-1.518994119078,-1.519560757354,-1.520118781518,-1.520668261886,-1.521209268738,
	-1.521741870423,-1.522266135193,-1.522782130475,-1.523289921965,-1.523789575692,
	-1.524281156251,-1.524764727468,-1.525240352837,-1.525708094362,-1.526168014182,
	-1.526620172937,-1.527064630697,-1.527501447593,-1.527930681795,-1.528352391456,
	-1.528766634589,-1.529173467399,-1.529572945934,-1.529965126248,-1.530350062388,
	-1.530727809227,-1.531098419864,-1.531461947436,-1.531818443970,-1.532167961635,
	-1.532510551447,-1.532846263896,-1.533175149011,-1.533497256173,-1.533812634660,
	-1.534121332269,-1.534423397217,-1.534718876680,-1.535007817266,-1.535290265477,
	-1.535566266860,-1.535835866990,-1.536099110104,-1.536356040786,-1.536606702887,
	-1.536851139588,-1.537089393816,-1.537321507967,-1.537547523870,-1.537767483152,
	-1.537981426887,-1.538189395530,-1.538391429592,-1.538587568505,-1.538777851827,
	-1.538962318558,-1.539141007050,-1.539313955703,-1.539481202016,-1.539642783648,
	-1.539798737357,-1.539949099850,-1.540093907328,-1.540233195784,-1.540367000519,
	-1.540495356857,-1.540618299553,-1.540735863136,-1.540848081592,-1.540954988707,
	-1.541056617981,-1.541153002483,-1.541244175120,-1.541330168112,-1.541411013828,
	-1.541486744067,-1.541557390230,-1.541622983636,-1.541683555182,-1.541739135570,
	-1.541789754978,-1.541835443591,-1.541876231176,-1.541912147070,-1.541943220583,
	-1.541969480650,-1.541990955948,-1.542007674663,-1.542019665156,-1.542026955142,
	-1.542029572291,-1.542027543941,-1.542020897301,-1.542009659041,-1.541993855924,
	-1.541973514214,-1.541948660053,-1.541919319397,-1.541885517920,-1.541847280963,
	-1.541804633821,-1.541757601404,-1.541706208469,-1.541650479620,-1.541590439201,
	-1.541526111369,-1.541457519855,-1.541384688436,-1.541307640643,-1.541226399752,
	-1.541140988871,-1.541051430880,-1.540957748508,-1.540859964079,-1.540758100067,
	-1.540652178564,-1.540542221601,-1.540428250709,-1.540310287705,-1.540188353783,
	-1.540062470222,-1.539932658144,-1.539798938314,-1.539661331503,-1.539519858215,
	-1.539374538763,-1.539225393329,-1.539072442037,-1.538915704598,-1.538755200998,
	-1.538590950552,-1.538422972816,-1.538251286846,-1.538075911809,-1.537896866818,
	-1.537714170373,-1.537527841297,-1.537337898185,-1.537144359097,-1.536947242519,
	-1.536746566316,-1.536542348711,-1.536334607192,-1.536123359727,-1.535908623516,
	-1.535690416146,-1.535468755012,-1.535243657006,-1.535015139110,-1.534783218566,
	-1.534547911816,-1.534309235528,-1.534067206292,-1.533821840562,-1.533573154513,
	-1.533321164233,-1.533065885845,-1.532807335437,-1.532545528587,-1.532280480953,
	-1.532012208320,-1.531740726059,-1.531466049439,-1.531188193947,-1.530907174574,
	-1.530623006410,-1.530335704346,-1.530045283386,-1.529751757948,-1.529455142946,
	-1.529155452822,-1.528852702143,-1.528546904932,-1.528238075680,-1.527926228541,
	-1.527611377399,-1.527293536295,-1.526972719162,-1.526648939614,-1.526322211467,
	-1.525992548437,-1.525659963609,-1.525324470855,-1.524986083187,-1.524644814119,
	-1.524300676591,-1.523953683753,-1.523603848553,-1.523251183908,-1.522895702798,
	-1.522537417759,-1.522176341524,-1.521812486815,-1.521445866072,-1.521076491511,
	-1.520704375782,-1.520329530984,-1.519951969500,-1.519571703244,-1.519188744498,
	-1.518803105043,-1.518414796931,-1.518023832098,-1.517630221978,-1.517233978563,
	-1.516835113519,-1.516433638169,-1.516029564182,-1.515622903016,-1.515213665959,
	-1.514801864266,-1.514387509256,-1.513970612235,-1.513551184137,-1.513129235974,
	-1.512704778833,-1.512277823509,-1.511848381084,-1.511416462037,-1.510982077724,
	-1.510545238129,-1.510105954134,-1.509664236337,-1.509220095381,-1.508773541486,
	-1.508324585159,-1.507873236795,-1.507419506630,-1.506963404932,-1.506504941701,
	-1.506044127151,-1.505580971504,-1.505115484616,-1.504647676714,-1.504177557112,
	-1.503705136382,-1.503230423957,-1.502753429585,-1.502274163273,-1.501792634238,
	-1.501308852418,-1.500822827323,-1.500334568521,-1.499844085415,-1.499351387456,
	-1.498856483874,-1.498359384136,-1.497860097621,-1.497358633463,-1.496855000910,
	-1.496349209230,-1.495841267149,-1.495331184225,-1.494818969114,-1.494304630970,
	-1.493788178884,-1.493269621194,-1.492748967555,-1.492226226067,-1.491701405971,
	-1.491174515783,-1.490645564319,-1.490114560139,-1.489581511806,-1.489046428200,
	-1.488509317220,-1.487970188352,-1.487429049373,-1.486885908783,-1.486340775004,
	-1.485793656473,-1.485244561527,-1.484693498414,-1.484140475204,-1.483585500382,
	-1.483028581900,-1.482469728047,-1.481908946822,-1.481346246452,-1.480781634915,
	-1.480215120027,-1.479646709963,-1.479076412476,-1.478504235933,-1.477930187715,
	-1.477354275748,-1.476776507907,-1.476196892022,-1.475615435702,-1.475032146851,
	-1.474447032853,-1.473860101723,-1.473271360774,-1.472680817860,-1.472088480341,
	-1.471494355864,-1.470898451770,-1.470300775616,-1.469701335038,-1.469100137113,
	-1.468497189472,-1.467892499438,-1.467286074049,-1.466677920964,-1.466068047433,
	-1.465456460638,-1.464843167738,-1.464228175790,-1.463611492308,-1.462993123901,
	-1.462373078305,-1.461751362260,-1.461127982743,-1.460502947201,-1.459876262284,
	-1.459247934821,-1.458617972127,-1.457986380805,-1.457353168059,-1.456718340977,
	-1.456081905889,-1.455443869649,-1.454804239346,-1.454163021811,-1.453520223416,
	-1.452875851371,-1.452229912087,-1.451582412245,-1.450933358703,-1.450282757711,
	-1.449630616133,-1.448976941057,-1.448321738119,-1.447665014572,-1.447006776534,
	-1.446347030697,-1.445685783690,-1.445023041450,-1.444358811002,-1.443693098453,
	-1.443025910369,-1.442357253097,-1.441687132566,-1.441015555946,-1.440342528759,
	-1.439668057559,-1.438992148626,-1.438314808393,-1.437636042862,-1.436955858254,
	-1.436274260672,-1.435591256549,-1.434906851980,-1.434221052875,-1.433533865378,
	-1.432845295597,-1.432155349966,-1.431464033956,-1.430771353751,-1.430077315574,
	-1.429381925507,-1.428685189136,-1.427987112665,-1.427287701937,-1.426586962375,
	-1.425884900882,-1.425181522614,-1.424476833630,-1.423770839863,-1.423063546951,
	-1.422354960631,-1.421645086832,-1.420933931389,-1.420221499896,-1.419507798007,
	-1.418792831488,-1.418076606307,-1.417359127676,-1.416640401760,-1.415920433783,
	-1.415199229549,-1.414476794757,-1.413753134584,-1.413028254979,-1.412302161290,
	-1.411574858990,-1.410846353770,-1.410116651152,-1.409385756678,-1.408653675440,
	-1.407920413177,-1.407185975236,-1.406450367148,-1.405713594027,-1.404975661562,
	-1.404236574915,-1.403496339074,-1.402754960582,-1.402012443408,-1.401268793577,
	-1.400524016176,-1.399778116263,-1.399031099206,-1.398282970631,-1.397533735073,
	-1.396783398416,-1.396031965107,-1.395279440961,-1.394525831048,-1.393771139954,
	-1.393015373088,-1.392258535954,-1.391500633267,-1.390741669925,-1.389981651307,
	-1.389220581936,-1.388458467754,-1.387695313192,-1.386931122643,-1.386165902062,
	-1.385399655923,-1.384632389269,-1.383864107508,-1.383094814649,-1.382324516125,
	-1.381553216302,-1.380780921004,-1.380007634248,-1.379233361034,-1.378458106373,
	-1.377681875291,-1.376904671962,-1.376126501372,-1.375347368709,-1.374567277794,
	-1.373786233943,-1.373004242371,-1.372221306790,-1.371437432582,-1.370652624091,
	-1.369866885857,-1.369080222642,-1.368292639202,-1.367504140205,-1.366714729857,
	-1.365924412990,-1.365133194201,-1.364341077934,-1.363548068518,-1.362754170518,
	-1.361959389096,-1.361163727988,-1.360367192107,-1.359569785314,-1.358771512371,
	-1.357972377947,-1.357172386467,-1.356371541858,-1.355569848652,-1.354767311398,
	-1.353963934777,-1.353159722258,-1.352354678970,-1.351548808303,-1.350742115574,
	-1.349934604294,-1.349126279249,-1.348317144192,-1.347507203831,-1.346696461893,
	-1.345884923032,-1.345072591058,-1.344259470632,-1.343445565421,-1.342630879902,
	-1.341815417672,-1.340999183444,-1.340182181087,-1.339364414897,-1.338545888407,
	-1.337726605819,-1.336906571793,-1.336085789663,-1.335264263670,-1.334441997997,
	-1.333618996276,-1.332795262524,-1.331970800799,-1.331145615043,-1.330319709632,
	-1.329493087544,-1.328665753471,-1.327837710535,-1.327008962877,-1.326179514838,
	-1.325349369798,-1.324518532051,-1.323687004702,-1.322854791609,-1.322021897021,
	-1.321188324440,-1.320354077629,-1.319519160320,-1.318683576377,-1.317847329143,
	-1.317010422579,-1.316172860502,-1.315334645940,-1.314495783221,-1.313656275734,
	-1.312816127070,-1.311975340622,-1.311133920191,-1.310291869492,-1.309449191966,
	-1.308605890941,-1.307761969997,-1.306917432935,-1.306072282894,-1.305226523648,
	-1.304380158424,-1.303533190630,-1.302685624201,-1.301837462086,-1.300988707612,
	-1.300139364860,-1.299289436164,-1.298438925775,-1.297587836220,-1.296736171954,
	-1.295883935440,-1.295031129834,-1.294177759184,-1.293323826552,-1.292469334473,
	-1.291614287102,-1.290758687182,-1.289902538108,-1.289045842947,-1.288188604933,
	-1.287330827242,-1.286472513313,-1.285613665649,-1.284754288003,-1.283894383074,
	-1.283033954159,-1.282173004274,-1.281311536637,-1.280449554074,-1.279587059981,
	-1.278724056765,-1.277860548153,-1.276996536550,-1.276132025089,-1.275267016906,
	-1.274401514911,-1.273535522149,-1.272669041058,-1.271802074957,-1.270934626668,
	-1.270066699152,-1.269198295208,-1.268329417665,-1.267460069227,-1.266590252340,
	-1.265719970825,-1.264849227003,-1.263978023722,-1.263106362992,-1.262234248287,
	-1.261361682640,-1.260488667778,-1.259615207364,-1.258741303243,-1.257866959185,
	-1.256992176646,-1.256116959100,-1.255241308347,-1.254365227931,-1.253488720164,
	-1.252611786975,-1.251734431952,-1.250856656931,-1.249978464602,-1.249099857772,
	-1.248220838575,-1.247341409779,-1.246461573903,-1.245581333031,-1.244700689803,
	-1.243819646846,-1.242938205977,-1.242056371062,-1.241174142321,-1.240291523883,
	-1.239408517588,-1.238525125403,-1.237641349738,-1.236757193866,-1.235872658799,
	-1.234987747420,-1.234102462003,-1.233216805215,-1.232330778356,-1.231444384091,
	-1.230557624815,-1.229670503065,-1.228783020158,-1.227895178617,-1.227006980762,
	-1.226118428899,-1.225229524446,-1.224340269910,-1.223450667778,-1.222560719819,
	-1.221670428272,-1.220779794440,-1.219888821270,-1.218997510151,-1.218105863636,
	-1.217213883409,-1.216321571722,-1.215428929972,-1.214535960546,-1.213642665162,
	-1.212749046237,-1.211855105531,-1.210960844191,-1.210066264919,-1.209171369274,
	-1.208276159139,-1.207380636282,-1.206484802802,-1.205588659983,-1.204692210244,
	-1.203795454968,-1.202898395861,-1.202001034895,-1.201103374045,-1.200205414536,
	-1.199307158035,-1.198408606599,-1.197509762117,-1.196610625683,-1.195711199209,
	-1.194811484158,-1.193911482228,-1.193011195630,-1.192110624966,-1.191209772239,
	-1.190308639368,-1.189407227066,-1.188505537983,-1.187603572665,-1.186701333281,
	-1.185798821234,-1.184896037643,-1.183992983759,-1.183089662082,-1.182186072957,
	-1.181282218436,-1.180378099450,-1.179473718148,-1.178569075305,-1.177664172141,
	-1.176759010810,-1.175853591861,-1.174947917030,-1.174041987866,-1.173135804508,
	-1.172229369894,-1.171322683723,-1.170415748532,-1.169508565103,-1.168601134160,
	-1.167693457738,-1.166785536525,-1.165877371687,-1.164968964933,-1.164060316688,
	-1.163151428624,-1.162242301584,-1.161332936697,-1.160423335191,-1.159513498586,
	-1.158603427156,-1.157693122374,-1.156782585465,-1.155871817384,-1.154960818454,
	-1.154049590893,-1.153138134706,-1.152226451322,-1.151314541791,-1.150402406877,
	-1.149490047372,-1.148577464803,-1.147664659021,-1.146751632095,-1.145838384623,
	-1.144924917356,-1.144011230784,-1.143097326047,-1.142183203805,-1.141268865601,
	-1.140354311312,-1.139439542342,-1.138524559813,-1.137609363344,-1.136693954270,
	-1.135778333429,-1.134862501947,-1.133946460202,-1.133030208171,-1.132113748039,
	-1.131197078893,-1.130280202665,-1.129363119092,-1.128445829792,-1.127528334556,
	-1.126610634466,-1.125692729559,-1.124774621310,-1.123856309622,-1.122937795405,
	-1.122019078772,-1.121100160961,-1.120181041912,-1.119261722369,-1.118342202656,
	-1.117422483545,-1.116502565396,-1.115582448836,-1.114662133890,-1.113741621296,
	-1.112820911679,-1.111900005106,-1.110978902117,-1.110057602751,-1.109136107843,
	-1.108214418388,-1.107292533454,-1.106370454028,-1.105448180003,-1.104525712639,
	-1.103603051450,-1.102680196697,-1.101757149415,-1.100833909132,-1.099910475981,
	-1.098986850682,-1.098063033978,-1.097139024886,-1.096214824476,-1.095290432491,
	-1.094365849309,-1.093441075339,-1.092516110240,-1.091590954373,-1.090665608159,
	-1.089740071528,-1.088814344708,-1.087888427416,-1.086962320096,-1.086036022482,
	-1.085109535433,-1.084182858200,-1.083255991253,-1.082328934447,-1.081401687993,
	-1.080474251164,-1.079546624898,-1.078618809172,-1.077690803350,-1.076762607888,
	-1.075834222347,-1.074905646839,-1.073976881561,-1.073047926036,-1.072118779978,
	-1.071189444335,-1.070259917930,-1.069330201259,-1.068400293849,-1.067470195727,
	-1.066539906783,-1.065609426693,-1.064678754979,-1.063747892472,-1.062816837936,
	-1.061885591377,-1.060954152895,-1.060022522215,-1.059090699191,-1.058158682941,
	-1.057226474098,-1.056294071450,-1.055361475595,-1.054429110068,-1.053496122558,
	-1.052562940550,-1.051629563716,-1.050695991709,-1.049762224197,-1.048828260799,
	-1.047894101194,-1.046959744952,-1.046025191709,-1.045090441063,-1.044155492611,
	-1.043220345929,-1.042285000589,-1.041349456133,-1.040413712137,-1.039477768141,
	-1.038541623662,-1.037605278199,-1.036668731311,-1.035731982452,-1.034795031160,
	-1.033857876870,-1.032920519075,-1.031982957219,-1.031045190762,-1.030107219179,
	-1.029169041830,-1.028230658186,-1.027292067651,-1.026353269608,-1.025414263472,
	-1.024475048596,-1.023535624369,-1.022595990188,-1.021656145342,-1.020716089218,
	-1.019775821135,-1.018835340408,-1.017894646382,-1.016953738354,-1.016012615585,
	-1.015071277402,-1.014129723084,-1.013187951866,-1.012245963040,-1.011303755826,
	-1.010361329489,-1.009418683253,-1.008475816336,-1.007532727948,-1.006589417324,
	-1.005645883622,-1.004702126036,-1.003758143739,-1.002813935919,-1.001869501732,
	-1.000924840301,-0.999979950787,-0.999034832335,-0.998089484041,-0.997143905036,
	-0.996198094433,-0.995252051314,-0.994305774765,-0.993359263878,-0.992412517721,
	-0.991465535341,-0.990518315811,-0.989570858178,-0.988623161460,-0.987675224695,
	-0.986727046901,-0.985778627107,-0.984829964287,-0.983881057437,-0.982931905578,
	-0.981982507648,-0.981032862624,-0.980082969472,-0.979132827170,-0.978182434606,
	-0.977231790763,-0.976280894534,-0.975329744878,-0.974378340693,-0.973426680857,
	-0.972474764274,-0.971522589870,-0.970570156468,-0.969617462984,-0.968664508255,
	-0.967711291144,-0.966757810480,-0.965804065147,-0.964850053935,-0.963895775679,
	-0.962941229199,-0.961986413305,-0.961031326789,-0.960075968451,-0.959120337071,
	-0.958164431425,-0.957208250284,-0.956251792416,-0.955295056555,-0.954338041478,
	-0.953380745905,-0.952423168558,-0.951465308171,-0.950507163465,-0.949548733149,
	-0.948590015914,-0.947631010473,-0.946671715496,-0.945712129649,-0.944752251637,
	-0.943792080097,-0.942831613722,-0.941870851113,-0.940909790958,-0.939948431857,
	-0.938986772465,-0.938024811380,-0.937062547222,-0.936099978627,-0.935137104165,
	-0.934173922429,-0.933210432004,-0.932246631491,-0.931282519435,-0.930318094432,
	-0.929353355017,-0.928388299737,-0.927422927144,-0.926457235783,-0.925491224158,
	-0.924524890834,-0.923558234309,-0.922591253076,-0.921623945660,-0.920656310548,
	-0.919688346234,-0.918720051196,-0.917751423919,-0.916782462861,-0.915813166478,
	-0.914843533240,-0.913873561636,-0.912903250055,-0.911932596938,-0.910961600735,
	-0.909990259863,-0.909018572755,-0.908046537795,-0.907074153405,-0.906101417979,
	-0.905128329920,-0.904154887602,-0.903181089399,-0.902206933698,-0.901232418861,
	-0.900257543267,-0.899282305226,-0.898306703132,-0.897330735317,-0.896354400094,
	-0.895377695820,-0.894400620805,-0.893423173365,-0.892445351828,-0.891467154480,
	-0.890488579637,-0.889509625597,-0.888530290625,-0.887550573023,-0.886570471066,
	-0.885589983011,-0.884609107149,-0.883627841700,-0.882646184958,-0.881664135145,
	-0.880681690499,-0.879698849277,-0.878715609702,-0.877731969962,-0.876747928336,
	-0.875763483002,-0.874778632177,-0.873793374051,-0.872807706824,-0.871821628702,
	-0.870835137871,-0.869848232485,-0.868860910723,-0.867873170769,-0.866885010781,
	-0.865896428920,-0.864907423316,-0.863917992154,-0.862928133546,-0.861937845630,
	-0.860947126563,-0.859955974426,-0.858964387372,-0.857972363521,-0.856979900968,
	-0.855986997801,-0.854993652153,-0.853999862111,-0.853005625739,-0.852010941148,
	-0.851015806412,-0.850020219597,-0.849024178763,-0.848027682004,-0.847030727353,
	-0.846033312873,-0.845035436604,-0.844037096603,-0.843038290913,-0.842039017551,
	-0.841039274550,-0.840039059944,-0.839038371738,-0.838037207966,-0.837035566621,
	-0.836033445708,-0.835030843236,-0.834027757207,-0.833024185602,-0.832020126403,
	-0.831015577603,-0.830010537160,-0.829005003081,-0.827998973290,-0.826992445795,
	-0.825985418518,-0.824977889446,-0.823969856486,-0.822961317623,-0.821952270781,
	-0.820942713900,-0.819932644904,-0.818922061741,-0.817910962314,-0.816899344561,
	-0.815887206364,-0.814874545653,-0.813861360361,-0.812847648360,-0.811833407545,
	-0.810818635809,-0.809803331061,-0.808787491172,-0.807771114039,-0.806754197509,
	-0.805736739491,-0.804718737827,-0.803700190378,-0.802681095035,-0.801661449634,
	-0.800641252030,-0.799620500080,-0.798599191628,-0.797577324515,-0.796554896555,
	-0.795531905611,-0.794508349507,-0.793484226077,-0.792459533119,-0.791434268481,
	-0.790408429961,-0.789382015373,-0.788355022509,-0.787327449207,-0.786299293252,
	-0.785270552428,-0.784241224541,-0.783211307398,-0.782180798749,-0.781149696404,
	-0.780117998131,-0.779085701723,-0.778052804918,-0.777019305534,-0.775985201297,
	-0.774950489991,-0.773915169374,-0.772879237196,-0.771842691205,-0.770805529161,
	-0.769767748822,-0.768729347903,-0.767690324168,-0.766650675359,-0.765610399208,
	-0.764569493413,-0.763527955738,-0.762485783900,-0.761442975633,-0.760399528629,
	-0.759355440639,-0.758310709357,-0.757265332491,-0.756219307757,-0.755172632878,
	-0.754125305522,-0.753077323423,-0.752028684270,-0.750979385742,-0.749929425550,
	-0.748878801368,-0.747827510901,-0.746775551843,-0.745722921850,-0.744669618606,
	-0.743615639809,-0.742560983140,-0.741505646227,-0.740449626791,-0.739392922471,
	-0.738335530947,-0.737277449879,-0.736218676941,-0.735159209777,-0.734099046049,
	-0.733038183417,-0.731976619542,-0.730914352062,-0.729851378639,-0.728787696913,
	-0.727723304539,-0.726658199159,-0.725592378417,-0.724525839933,-0.723458581383,
	-0.722390600392,-0.721321894590,-0.720252461605,-0.719182299073,-0.718111404639,
	-0.717039775949,-0.715967410579,-0.714894306198,-0.713820460425,-0.712745870875,
	-0.711670535163,-0.710594450940,-0.709517615796,-0.708440027388,-0.707361683287,
	-0.706282581148,-0.705202718572,-0.704122093189,-0.703040702592,-0.701958544421,
	-0.700875616251,-0.699791915727,-0.698707440458,-0.697622188025,-0.696536156066,
	-0.695449342199,-0.694361743992,-0.693273359105,-0.692184185108,-0.691094219602,
	-0.690003460231,-0.688911904577,-0.687819550236,-0.686726394842,-0.685632435977,
	-0.684537671254,-0.683442098286,-0.682345714663,-0.681248518014,-0.680150505913,
	-0.679051675999,-0.677952025839,-0.676851553083,-0.675750255302,-0.674648130121,
	-0.673545175137,-0.672441387939,-0.671336766170,-0.670231307430,-0.669125009315,
	-0.668017869440,-0.666909885406,-0.665801054842,-0.664691375339,-0.663580844519,
	-0.662469460003,-0.661357219389,-0.660244120302,-0.659130160343,-0.658015337157,
	-0.656899648352,-0.655783091521,-0.654665664324,-0.653547364349,-0.652428189250,
	-0.651308136639,-0.650187204125,-0.649065389360,-0.647942689961,-0.646819103562,
	-0.645694627807,-0.644569260333,-0.643442998756,-0.642315840725,-0.641187783882,
	-0.640058825897,-0.638928964361,-0.637798196951,-0.636666521332,-0.635533935144,
	-0.634400436040,-0.633266021661,-0.632130689679,-0.630994437765,-0.629857263612,
	-0.628719164830,-0.627580139112,-0.626440184153,-0.625299297599,-0.624157477148,
	-0.623014720500,-0.621871025304,-0.620726389270,-0.619580810102,-0.618434285471,
	-0.617286813094,-0.616138390669,-0.614989015917,-0.613838686545,-0.612687400261,
	-0.611535154770,-0.610381947831,-0.609227777144,-0.608072640441,-0.606916535495,
	-0.605759459993,-0.604601411712,-0.603442388376,-0.602282387785,-0.601121407649,
	-0.599959445754,-0.598796499880,-0.597632567761,-0.596467647230,-0.595301736016,
	-0.594134831938,-0.592966932785,-0.591798036352,-0.590628140435,-0.589457242883,
	-0.588285341456,-0.587112434002,-0.585938518378,-0.584763592357,-0.583587653813,
	-0.582410700601,-0.581232730564,-0.580053741532,-0.578873731419,-0.577692698068,
	-0.576510639343,-0.575327553155,-0.574143437391,-0.572958289928,-0.571772108694,
	-0.570584891585,-0.569396636536,-0.568207341452,-0.567017004279,-0.565825622977,
	-0.564633195459,-0.563439719712,-0.562245193689,-0.561049615353,-0.559852982700,
	-0.558655293715,-0.557456546386,-0.556256738733,-0.555055868757,-0.553853934479,
	-0.552650933951,-0.551446865188,-0.550241726247,-0.549035515207,-0.547828230098,
	-0.546619869033,-0.545410430072,-0.544199911319,-0.542988310873,-0.541775626866,
	-0.540561857403,-0.539347000636,-0.538131054699,-0.536914017746,-0.535695887941,
	-0.534476663451,-0.533256342496,-0.532034923261,-0.530812403927,-0.529588782738,
	-0.528364057913,-0.527138227695,-0.525911290325,-0.524683244111,-0.523454087278,
	-0.522223818143,-0.520992434990,-0.519759936155,-0.518526319924,-0.517291584643,
	-0.516055728675,-0.514818750391,-0.513580648127,-0.512341420296,-0.511101065283,
	-0.509859581520,-0.508616967416,-0.507373221404,-0.506128341948,-0.504882327523,
	-0.503635176588,-0.502386887640,-0.501137459198,-0.499886889783,-0.498635177908,
	-0.497382322158,-0.496128321064,-0.494873173250,-0.493616877260,-0.492359431731,
	-0.491100835292,-0.489841086567,-0.488580184234,-0.487318126938,-0.486054913401,
	-0.484790542304,-0.483525012365,-0.482258322330,-0.480990470937,-0.479721456961,
	-0.478451279205,-0.477179936458,-0.475907427546,-0.474633751286,-0.473358906551,
	-0.472082892211,-0.470805707158,-0.469527350299,-0.468247820549,-0.466967116854,
	-0.465685238202,-0.464402183535,-0.463117951889,-0.461832542255,-0.460545953673,
	-0.459258185217,-0.457969235956,-0.456679104988,-0.455387791401,-0.454095294369,
	-0.452801613022,-0.451506746551,-0.450210694126,-0.448913454997,-0.447615028375,
	-0.446315413539,-0.445014609753,-0.443712616305,-0.442409432559,-0.441105057810,
	-0.439799491449,-0.438492732866,-0.437184781453,-0.435875636663,-0.434565297921,
	-0.433253764751,-0.431941036595,-0.430627113030,-0.429311993545,-0.427995677749,
	-0.426678165213,-0.425359455582,-0.424039548473,-0.422718443564,-0.421396140509,
	-0.420072639085,-0.418747938979,-0.417422039956,-0.416094941828,-0.414766644392,
	-0.413437147504,-0.412106451012,-0.410774554813,-0.409441458823,-0.408107162959,
	-0.406771667224,-0.405434971607,-0.404097076132,-0.402757980833,-0.401417685790,
	-0.400076191114,-0.398733496943,-0.397389603421,-0.396044510744,-0.394698219127,
	-0.393350728807,-0.392002040063,-0.390652153177,-0.389301068504,-0.387948786393,
	-0.386595307220,-0.385240631430,-0.383884759443,-0.382527691759,-0.381169428863,
	-0.379809971325,-0.378449319661,-0.377087474520,-0.375724436510,-0.374360206290,
	-0.372994784554,-0.371628172043,-0.370260369485,-0.368891377683,-0.367521197442,
	-0.366149829640,-0.364777275133,-0.363403534857,-0.362028609752,-0.360652500798,
	-0.359275209045,-0.357896735489,-0.356517081250,-0.355136247444,-0.353754235201,
	-0.352371045717,-0.350986680222,-0.349601139963,-0.348214426229,-0.346826540350,
	-0.345437483665,-0.344047257615,-0.342655863594,-0.341263303074,-0.339869577580,
	-0.338474688630,-0.337078637810,-0.335681426741,-0.334283057049,-0.332883530445,
	-0.331482848640,-0.330081013402,-0.328678026535,-0.327273889872,-0.325868605298,
	-0.324462174694,-0.323054600053,-0.321645883365,-0.320236026619,-0.318825031935,
	-0.317412901382,-0.315999637144,-0.314585241381,-0.313169716342,-0.311753064274,
	-0.310335287500,-0.308916388372,-0.307496369263,-0.306075232613,-0.304652980903,
	-0.303229616636,-0.301805142355,-0.300379560665,-0.298952874221,-0.297525085683,
	-0.296096197768,-0.294666213262,-0.293235134953,-0.291802965708,-0.290369708384,
	-0.288935365969,-0.287499941401,-0.286063437703,-0.284625857975,-0.283187205281,
	-0.281747482812,-0.280306693752,-0.278864841340,-0.277421928866,-0.275977959671,
	-0.274532937111,-0.273086864623,-0.271639745658,-0.270191583756,-0.268742382446,
	-0.267292145351,-0.265840876116,-0.264388578416,-0.262935256017,-0.261480912719,
	-0.260025552296,-0.258569178709,-0.257111795827,-0.255653407636,-0.254194018180,
	-0.252733631509,-0.251272251758,-0.249809883070,-0.248346529664,-0.246882195824,
	-0.245416885811,-0.243950604027,-0.242483354869,-0.241015142745,-0.239545972203,
	-0.238075847799,-0.236604774098,-0.235132755777,-0.233659797534,-0.232185904088,
	-0.230711080260,-0.229235330900,-0.227758660868,-0.226281075152,-0.224802578732,
	-0.223323176647,-0.221842874001,-0.220361675938,-0.218879587660,-0.217396614390,
	-0.215912761446,-0.214428034177,-0.212942437968,-0.211455978289,-0.209968660622,
	-0.208480490520,-0.206991473587,-0.205501615486,-0.204010921935,-0.202519398653,
	-0.201027051472,-0.199533886241,-0.198039908895,-0.196545125365,-0.195049541696,
	-0.193553163953,-0.192055998216,-0.190558050702,-0.189059327606,-0.187559835208,
	-0.186059579856,-0.184558567895,-0.183056805789,-0.181554300005,-0.180051057081,
	-0.178547083615,-0.177042386236,-0.175536971651,-0.174030846587,-0.172524017867,
	-0.171016492337,-0.169508276882,-0.167999378479,-0.166489804133,-0.164979560892,
	-0.163468655885,-0.161957096295,-0.160444889312,-0.158932042226,-0.157418562358,
	-0.155904457088,-0.154389733857,-0.152874400109,-0.151358463441,-0.149841931393,
	-0.148324811628,-0.146807111839,-0.145288839774,-0.143770003220,-0.142250610030,
	-0.140730668134,-0.139210185442,-0.137689170025,-0.136167629882,-0.134645573167,
	-0.133123008019,-0.131599942680,-0.130076385409,-0.128552344526,-0.127027828391,
	-0.125502845461,-0.123977404207,-0.122451513137,-0.120925180824,-0.119398415941,
	-0.117871227143,-0.116343623162,-0.114815612787,-0.113287204872,-0.111758408293,
	-0.110229231988,-0.108699684937,-0.107169776210,-0.105639514843,-0.104108910031,
	-0.102577970937,-0.101046706824,-0.099515126955,-0.097983240695,-0.096451057417,
	-0.094918586564,-0.093385837639,-0.091852820181,-0.090319543746,-0.088786017995,
	-0.087252252615,-0.085718257339,-0.084184041933,-0.082649616238,-0.081114990121,
	-0.079580173521,-0.078045176407,-0.076510008804,-0.074974680758,-0.073439202399,
	-0.071903583892,-0.070367835429,-0.068831967272,-0.067295989718,-0.065759913106,
	-0.064223747838,-0.062687504347,-0.061151193083,-0.059614824618,-0.058078409487,
	-0.056541958315,-0.055005481760,-0.053468990518,-0.051932495344,-0.050396007021,
	-0.048859536371,-0.047323094264,-0.045786691623,-0.044250339403,-0.042714048619,
	-0.041177830295,-0.039641695487,-0.038105655366,-0.036569721061,-0.035033903771,
	-0.033498214752,-0.031962665285,-0.030427266688,-0.028892030319,-0.027356967551,
	-0.025822089871,-0.024287408702,-0.022752935572,-0.021218682046,-0.019684659686,
	-0.018150880118,-0.016617354988,-0.015084095997,-0.013551114869,-0.012018423377,
	-0.010486033295,-0.008953956460,-0.007422204735,-0.005890790024,-0.004359724241,
	-0.002829019354,-0.001298687357,0.000231259716,0.001760809842,0.003289950897,
	0.004818670800,0.006346957353,0.007874798442,0.009402181834,0.010929095297,
	0.012455526558,0.013981463357,0.015506893363,0.017031804235,0.018556183600,
	0.020080019073,0.021603298238,0.023126008632,0.024648137806,0.026169673267,
	0.027690602476,0.029210912918,0.030730592046,0.032249627222,0.033768005914,
	0.035285715439,0.036802743191,0.038319076478,0.039834702631,0.041349608928,
	0.042863782667,0.044377211102,0.045889881475,0.047401781011,0.048912896922,
	0.050423216397,0.051932726617,0.053441414766,0.054949267963,0.056456273365,
	0.057962418069,0.059467689224,0.060972073896,0.062475559182,0.063978132170,
	0.065479779922,0.066980489476,0.068480247898,0.069979042221,0.071476859477,
	0.072973686681,0.074469510854,0.075964319024,0.077458098150,0.078950835279,
	0.080442517351,0.081933131394,0.083422664385,0.084911103303,0.086398435126,
	0.087884646845,0.089369725414,0.090853657828,0.092336431065,0.093818032077,
	0.095298447860,0.096777665398,0.098255671674,0.099732453653,0.101207998333,
	0.102682292714,0.104155323792,0.105627078551,0.107097544007,0.108566707185,
	0.110034555086,0.111501074757,0.112966253209,0.114430077526,0.115892534732,
	0.117353611900,0.118813296103,0.120271574434,0.121728433988,0.123183861865,
	0.124637845222,0.126090371158,0.127541426825,0.128990999413,0.130439076098,
	0.131885644062,0.133330690529,0.134774202725,0.136216167911,0.137656573339,
	0.139095406297,0.140532654102,0.141968304059,0.143402343540,0.144834759893,
	0.146265540507,0.147694672808,0.149122144213,0.150547942201,0.151972054233,
	0.153394467825,0.154815170513,0.156234149864,0.157651393458,0.159066888892,
	0.160480623823,0.161892585911,0.163302762850
	}
};

double always_inline bigchumppower_negclip(double x) {
    double f = fabs(x);
    f = f * bigchumppower_neg_table.istep;
    int i = static_cast<int>(f);
    if (i < 0) {
        f = bigchumppower_neg_table.data[0];
    } else if (i >= bigchumppower_neg_table.size-1) {
        f = bigchumppower_neg_table.data[bigchumppower_neg_table.size-1];
    } else {
    f -= i;
    f = bigchumppower_neg_table.data[i]*(1-f) + bigchumppower_neg_table.data[i+1]*f;
    }
    return copysign(f, x);
}

#endif //_BIGCHUMPPOWER_NEG_H_
