// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/datalabeling/v1beta1/evaluation_job.proto

package datalabeling

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// State of the job.
type EvaluationJob_State int32

const (
	EvaluationJob_STATE_UNSPECIFIED EvaluationJob_State = 0
	// The job is scheduled to run at the [configured interval][google.cloud.datalabeling.v1beta1.EvaluationJob.schedule]. You
	// can [pause][google.cloud.datalabeling.v1beta1.DataLabelingService.PauseEvaluationJob] or
	// [delete][google.cloud.datalabeling.v1beta1.DataLabelingService.DeleteEvaluationJob] the job.
	//
	// When the job is in this state, it samples prediction input and output
	// from your model version into your BigQuery table as predictions occur.
	EvaluationJob_SCHEDULED EvaluationJob_State = 1
	// The job is currently running. When the job runs, Data Labeling Service
	// does several things:
	//
	// 1. If you have configured your job to use Data Labeling Service for
	//    ground truth labeling, the service creates a
	//    [Dataset][google.cloud.datalabeling.v1beta1.Dataset] and a labeling task for all data sampled
	//    since the last time the job ran. Human labelers provide ground truth
	//    labels for your data. Human labeling may take hours, or even days,
	//    depending on how much data has been sampled. The job remains in the
	//    `RUNNING` state during this time, and it can even be running multiple
	//    times in parallel if it gets triggered again (for example 24 hours
	//    later) before the earlier run has completed. When human labelers have
	//    finished labeling the data, the next step occurs.
	//    <br><br>
	//    If you have configured your job to provide your own ground truth
	//    labels, Data Labeling Service still creates a [Dataset][google.cloud.datalabeling.v1beta1.Dataset] for newly
	//    sampled data, but it expects that you have already added ground truth
	//    labels to the BigQuery table by this time. The next step occurs
	//    immediately.
	//
	// 2. Data Labeling Service creates an [Evaluation][google.cloud.datalabeling.v1beta1.Evaluation] by comparing your
	//    model version's predictions with the ground truth labels.
	//
	// If the job remains in this state for a long time, it continues to sample
	// prediction data into your BigQuery table and will run again at the next
	// interval, even if it causes the job to run multiple times in parallel.
	EvaluationJob_RUNNING EvaluationJob_State = 2
	// The job is not sampling prediction input and output into your BigQuery
	// table and it will not run according to its schedule. You can
	// [resume][google.cloud.datalabeling.v1beta1.DataLabelingService.ResumeEvaluationJob] the job.
	EvaluationJob_PAUSED EvaluationJob_State = 3
	// The job has this state right before it is deleted.
	EvaluationJob_STOPPED EvaluationJob_State = 4
)

var EvaluationJob_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "SCHEDULED",
	2: "RUNNING",
	3: "PAUSED",
	4: "STOPPED",
}

var EvaluationJob_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"SCHEDULED":         1,
	"RUNNING":           2,
	"PAUSED":            3,
	"STOPPED":           4,
}

func (x EvaluationJob_State) String() string {
	return proto.EnumName(EvaluationJob_State_name, int32(x))
}

func (EvaluationJob_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_052df044fb4ef883, []int{0, 0}
}

// Defines an evaluation job that runs periodically to generate
// [Evaluations][google.cloud.datalabeling.v1beta1.Evaluation]. [Creating an evaluation
// job](/ml-engine/docs/continuous-evaluation/create-job) is the starting point
// for using continuous evaluation.
type EvaluationJob struct {
	// Output only. After you create a job, Data Labeling Service assigns a name
	// to the job with the following format:
	//
	// "projects/<var>{project_id}</var>/evaluationJobs/<var>{evaluation_job_id}</var>"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Description of the job. The description can be up to 25,000
	// characters long.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Describes the current state of the job.
	State EvaluationJob_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.datalabeling.v1beta1.EvaluationJob_State" json:"state,omitempty"`
	// Required. Describes the interval at which the job runs. This interval must
	// be at least 1 day, and it is rounded to the nearest day. For example, if
	// you specify a 50-hour interval, the job runs every 2 days.
	//
	// You can provide the schedule in
	// [crontab format](/scheduler/docs/configuring/cron-job-schedules) or in an
	// [English-like
	// format](/appengine/docs/standard/python/config/cronref#schedule_format).
	//
	// Regardless of what you specify, the job will run at 10:00 AM UTC. Only the
	// interval from this schedule is used, not the specific time of day.
	Schedule string `protobuf:"bytes,4,opt,name=schedule,proto3" json:"schedule,omitempty"`
	// Required. The [AI Platform Prediction model
	// version](/ml-engine/docs/prediction-overview) to be evaluated. Prediction
	// input and output is sampled from this model version. When creating an
	// evaluation job, specify the model version in the following format:
	//
	// "projects/<var>{project_id}</var>/models/<var>{model_name}</var>/versions/<var>{version_name}</var>"
	//
	// There can only be one evaluation job per model version.
	ModelVersion string `protobuf:"bytes,5,opt,name=model_version,json=modelVersion,proto3" json:"model_version,omitempty"`
	// Required. Configuration details for the evaluation job.
	EvaluationJobConfig *EvaluationJobConfig `protobuf:"bytes,6,opt,name=evaluation_job_config,json=evaluationJobConfig,proto3" json:"evaluation_job_config,omitempty"`
	// Required. Name of the [AnnotationSpecSet][google.cloud.datalabeling.v1beta1.AnnotationSpecSet] describing all the
	// labels that your machine learning model outputs. You must create this
	// resource before you create an evaluation job and provide its name in the
	// following format:
	//
	// "projects/<var>{project_id}</var>/annotationSpecSets/<var>{annotation_spec_set_id}</var>"
	AnnotationSpecSet string `protobuf:"bytes,7,opt,name=annotation_spec_set,json=annotationSpecSet,proto3" json:"annotation_spec_set,omitempty"`
	// Required. Whether you want Data Labeling Service to provide ground truth
	// labels for prediction input. If you want the service to assign human
	// labelers to annotate your data, set this to `true`. If you want to provide
	// your own ground truth labels in the evaluation job's BigQuery table, set
	// this to `false`.
	LabelMissingGroundTruth bool `protobuf:"varint,8,opt,name=label_missing_ground_truth,json=labelMissingGroundTruth,proto3" json:"label_missing_ground_truth,omitempty"`
	// Output only. Every time the evaluation job runs and an error occurs, the
	// failed attempt is appended to this array.
	Attempts []*Attempt `protobuf:"bytes,9,rep,name=attempts,proto3" json:"attempts,omitempty"`
	// Output only. Timestamp of when this evaluation job was created.
	CreateTime           *timestamp.Timestamp `protobuf:"bytes,10,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *EvaluationJob) Reset()         { *m = EvaluationJob{} }
func (m *EvaluationJob) String() string { return proto.CompactTextString(m) }
func (*EvaluationJob) ProtoMessage()    {}
func (*EvaluationJob) Descriptor() ([]byte, []int) {
	return fileDescriptor_052df044fb4ef883, []int{0}
}

func (m *EvaluationJob) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EvaluationJob.Unmarshal(m, b)
}
func (m *EvaluationJob) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EvaluationJob.Marshal(b, m, deterministic)
}
func (m *EvaluationJob) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EvaluationJob.Merge(m, src)
}
func (m *EvaluationJob) XXX_Size() int {
	return xxx_messageInfo_EvaluationJob.Size(m)
}
func (m *EvaluationJob) XXX_DiscardUnknown() {
	xxx_messageInfo_EvaluationJob.DiscardUnknown(m)
}

var xxx_messageInfo_EvaluationJob proto.InternalMessageInfo

func (m *EvaluationJob) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EvaluationJob) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *EvaluationJob) GetState() EvaluationJob_State {
	if m != nil {
		return m.State
	}
	return EvaluationJob_STATE_UNSPECIFIED
}

func (m *EvaluationJob) GetSchedule() string {
	if m != nil {
		return m.Schedule
	}
	return ""
}

func (m *EvaluationJob) GetModelVersion() string {
	if m != nil {
		return m.ModelVersion
	}
	return ""
}

func (m *EvaluationJob) GetEvaluationJobConfig() *EvaluationJobConfig {
	if m != nil {
		return m.EvaluationJobConfig
	}
	return nil
}

func (m *EvaluationJob) GetAnnotationSpecSet() string {
	if m != nil {
		return m.AnnotationSpecSet
	}
	return ""
}

func (m *EvaluationJob) GetLabelMissingGroundTruth() bool {
	if m != nil {
		return m.LabelMissingGroundTruth
	}
	return false
}

func (m *EvaluationJob) GetAttempts() []*Attempt {
	if m != nil {
		return m.Attempts
	}
	return nil
}

func (m *EvaluationJob) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

// Configures specific details of how a continuous evaluation job works. Provide
// this configuration when you create an EvaluationJob.
type EvaluationJobConfig struct {
	// Required. Details for how you want human reviewers to provide ground truth
	// labels.
	//
	// Types that are valid to be assigned to HumanAnnotationRequestConfig:
	//	*EvaluationJobConfig_ImageClassificationConfig
	//	*EvaluationJobConfig_BoundingPolyConfig
	//	*EvaluationJobConfig_TextClassificationConfig
	HumanAnnotationRequestConfig isEvaluationJobConfig_HumanAnnotationRequestConfig `protobuf_oneof:"human_annotation_request_config"`
	// Rquired. Details for the sampled prediction input. Within this
	// configuration, there are requirements for several fields:
	//
	// * `dataType` must be one of `IMAGE`, `TEXT`, or `GENERAL_DATA`.
	// * `annotationType` must be one of `IMAGE_CLASSIFICATION_ANNOTATION`,
	//   `TEXT_CLASSIFICATION_ANNOTATION`, `GENERAL_CLASSIFICATION_ANNOTATION`,
	//   or `IMAGE_BOUNDING_BOX_ANNOTATION` (image object detection).
	// * If your machine learning model performs classification, you must specify
	//   `classificationMetadata.isMultiLabel`.
	// * You must specify `bigquerySource` (not `gcsSource`).
	InputConfig *InputConfig `protobuf:"bytes,1,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	// Required. Details for calculating evaluation metrics and creating
	// [Evaulations][google.cloud.datalabeling.v1beta1.Evaluation]. If your model version performs image object
	// detection, you must specify the `boundingBoxEvaluationOptions` field within
	// this configuration. Otherwise, provide an empty object for this
	// configuration.
	EvaluationConfig *EvaluationConfig `protobuf:"bytes,2,opt,name=evaluation_config,json=evaluationConfig,proto3" json:"evaluation_config,omitempty"`
	// Optional. Details for human annotation of your data. If you set
	// [labelMissingGroundTruth][google.cloud.datalabeling.v1beta1.EvaluationJob.label_missing_ground_truth] to
	// `true` for this evaluation job, then you must specify this field. If you
	// plan to provide your own ground truth labels, then omit this field.
	//
	// Note that you must create an [Instruction][google.cloud.datalabeling.v1beta1.Instruction] resource before you can
	// specify this field. Provide the name of the instruction resource in the
	// `instruction` field within this configuration.
	HumanAnnotationConfig *HumanAnnotationConfig `protobuf:"bytes,3,opt,name=human_annotation_config,json=humanAnnotationConfig,proto3" json:"human_annotation_config,omitempty"`
	// Required. Prediction keys that tell Data Labeling Service where to find the
	// data for evaluation in your BigQuery table. When the service samples
	// prediction input and output from your model version and saves it to
	// BigQuery, the data gets stored as JSON strings in the BigQuery table. These
	// keys tell Data Labeling Service how to parse the JSON.
	//
	// You can provide the following entries in this field:
	//
	// * `data_json_key`: the data key for prediction input. You must provide
	//   either this key or `reference_json_key`.
	// * `reference_json_key`: the data reference key for prediction input. You
	//   must provide either this key or `data_json_key`.
	// * `label_json_key`: the label key for prediction output. Required.
	// * `label_score_json_key`: the score key for prediction output. Required.
	// * `bounding_box_json_key`: the bounding box key for prediction output.
	//   Required if your model version perform image object detection.
	//
	// Learn [how to configure prediction
	// keys](/ml-engine/docs/continuous-evaluation/create-job#prediction-keys).
	BigqueryImportKeys map[string]string `protobuf:"bytes,9,rep,name=bigquery_import_keys,json=bigqueryImportKeys,proto3" json:"bigquery_import_keys,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. The maximum number of predictions to sample and save to BigQuery
	// during each [evaluation interval][google.cloud.datalabeling.v1beta1.EvaluationJob.schedule]. This limit
	// overrides `example_sample_percentage`: even if the service has not sampled
	// enough predictions to fulfill `example_sample_perecentage` during an
	// interval, it stops sampling predictions when it meets this limit.
	ExampleCount int32 `protobuf:"varint,10,opt,name=example_count,json=exampleCount,proto3" json:"example_count,omitempty"`
	// Required. Fraction of predictions to sample and save to BigQuery during
	// each [evaluation interval][google.cloud.datalabeling.v1beta1.EvaluationJob.schedule]. For example, 0.1 means
	// 10% of predictions served by your model version get saved to BigQuery.
	ExampleSamplePercentage float64 `protobuf:"fixed64,11,opt,name=example_sample_percentage,json=exampleSamplePercentage,proto3" json:"example_sample_percentage,omitempty"`
	// Optional. Configuration details for evaluation job alerts. Specify this
	// field if you want to receive email alerts if the evaluation job finds that
	// your predictions have low mean average precision during a run.
	EvaluationJobAlertConfig *EvaluationJobAlertConfig `protobuf:"bytes,13,opt,name=evaluation_job_alert_config,json=evaluationJobAlertConfig,proto3" json:"evaluation_job_alert_config,omitempty"`
	XXX_NoUnkeyedLiteral     struct{}                  `json:"-"`
	XXX_unrecognized         []byte                    `json:"-"`
	XXX_sizecache            int32                     `json:"-"`
}

func (m *EvaluationJobConfig) Reset()         { *m = EvaluationJobConfig{} }
func (m *EvaluationJobConfig) String() string { return proto.CompactTextString(m) }
func (*EvaluationJobConfig) ProtoMessage()    {}
func (*EvaluationJobConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_052df044fb4ef883, []int{1}
}

func (m *EvaluationJobConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EvaluationJobConfig.Unmarshal(m, b)
}
func (m *EvaluationJobConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EvaluationJobConfig.Marshal(b, m, deterministic)
}
func (m *EvaluationJobConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EvaluationJobConfig.Merge(m, src)
}
func (m *EvaluationJobConfig) XXX_Size() int {
	return xxx_messageInfo_EvaluationJobConfig.Size(m)
}
func (m *EvaluationJobConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_EvaluationJobConfig.DiscardUnknown(m)
}

var xxx_messageInfo_EvaluationJobConfig proto.InternalMessageInfo

type isEvaluationJobConfig_HumanAnnotationRequestConfig interface {
	isEvaluationJobConfig_HumanAnnotationRequestConfig()
}

type EvaluationJobConfig_ImageClassificationConfig struct {
	ImageClassificationConfig *ImageClassificationConfig `protobuf:"bytes,4,opt,name=image_classification_config,json=imageClassificationConfig,proto3,oneof"`
}

type EvaluationJobConfig_BoundingPolyConfig struct {
	BoundingPolyConfig *BoundingPolyConfig `protobuf:"bytes,5,opt,name=bounding_poly_config,json=boundingPolyConfig,proto3,oneof"`
}

type EvaluationJobConfig_TextClassificationConfig struct {
	TextClassificationConfig *TextClassificationConfig `protobuf:"bytes,8,opt,name=text_classification_config,json=textClassificationConfig,proto3,oneof"`
}

func (*EvaluationJobConfig_ImageClassificationConfig) isEvaluationJobConfig_HumanAnnotationRequestConfig() {
}

func (*EvaluationJobConfig_BoundingPolyConfig) isEvaluationJobConfig_HumanAnnotationRequestConfig() {}

func (*EvaluationJobConfig_TextClassificationConfig) isEvaluationJobConfig_HumanAnnotationRequestConfig() {
}

func (m *EvaluationJobConfig) GetHumanAnnotationRequestConfig() isEvaluationJobConfig_HumanAnnotationRequestConfig {
	if m != nil {
		return m.HumanAnnotationRequestConfig
	}
	return nil
}

func (m *EvaluationJobConfig) GetImageClassificationConfig() *ImageClassificationConfig {
	if x, ok := m.GetHumanAnnotationRequestConfig().(*EvaluationJobConfig_ImageClassificationConfig); ok {
		return x.ImageClassificationConfig
	}
	return nil
}

func (m *EvaluationJobConfig) GetBoundingPolyConfig() *BoundingPolyConfig {
	if x, ok := m.GetHumanAnnotationRequestConfig().(*EvaluationJobConfig_BoundingPolyConfig); ok {
		return x.BoundingPolyConfig
	}
	return nil
}

func (m *EvaluationJobConfig) GetTextClassificationConfig() *TextClassificationConfig {
	if x, ok := m.GetHumanAnnotationRequestConfig().(*EvaluationJobConfig_TextClassificationConfig); ok {
		return x.TextClassificationConfig
	}
	return nil
}

func (m *EvaluationJobConfig) GetInputConfig() *InputConfig {
	if m != nil {
		return m.InputConfig
	}
	return nil
}

func (m *EvaluationJobConfig) GetEvaluationConfig() *EvaluationConfig {
	if m != nil {
		return m.EvaluationConfig
	}
	return nil
}

func (m *EvaluationJobConfig) GetHumanAnnotationConfig() *HumanAnnotationConfig {
	if m != nil {
		return m.HumanAnnotationConfig
	}
	return nil
}

func (m *EvaluationJobConfig) GetBigqueryImportKeys() map[string]string {
	if m != nil {
		return m.BigqueryImportKeys
	}
	return nil
}

func (m *EvaluationJobConfig) GetExampleCount() int32 {
	if m != nil {
		return m.ExampleCount
	}
	return 0
}

func (m *EvaluationJobConfig) GetExampleSamplePercentage() float64 {
	if m != nil {
		return m.ExampleSamplePercentage
	}
	return 0
}

func (m *EvaluationJobConfig) GetEvaluationJobAlertConfig() *EvaluationJobAlertConfig {
	if m != nil {
		return m.EvaluationJobAlertConfig
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*EvaluationJobConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*EvaluationJobConfig_ImageClassificationConfig)(nil),
		(*EvaluationJobConfig_BoundingPolyConfig)(nil),
		(*EvaluationJobConfig_TextClassificationConfig)(nil),
	}
}

// Provides details for how an evaluation job sends email alerts based on the
// results of a run.
type EvaluationJobAlertConfig struct {
	// Required. An email address to send alerts to.
	Email string `protobuf:"bytes,1,opt,name=email,proto3" json:"email,omitempty"`
	// Required. A number between 0 and 1 that describes a minimum mean average
	// precision threshold. When the evaluation job runs, if it calculates that
	// your model version's predictions from the recent interval have
	// [meanAveragePrecision][google.cloud.datalabeling.v1beta1.PrCurve.mean_average_precision] below this
	// threshold, then it sends an alert to your specified email.
	MinAcceptableMeanAveragePrecision float64  `protobuf:"fixed64,2,opt,name=min_acceptable_mean_average_precision,json=minAcceptableMeanAveragePrecision,proto3" json:"min_acceptable_mean_average_precision,omitempty"`
	XXX_NoUnkeyedLiteral              struct{} `json:"-"`
	XXX_unrecognized                  []byte   `json:"-"`
	XXX_sizecache                     int32    `json:"-"`
}

func (m *EvaluationJobAlertConfig) Reset()         { *m = EvaluationJobAlertConfig{} }
func (m *EvaluationJobAlertConfig) String() string { return proto.CompactTextString(m) }
func (*EvaluationJobAlertConfig) ProtoMessage()    {}
func (*EvaluationJobAlertConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_052df044fb4ef883, []int{2}
}

func (m *EvaluationJobAlertConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EvaluationJobAlertConfig.Unmarshal(m, b)
}
func (m *EvaluationJobAlertConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EvaluationJobAlertConfig.Marshal(b, m, deterministic)
}
func (m *EvaluationJobAlertConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EvaluationJobAlertConfig.Merge(m, src)
}
func (m *EvaluationJobAlertConfig) XXX_Size() int {
	return xxx_messageInfo_EvaluationJobAlertConfig.Size(m)
}
func (m *EvaluationJobAlertConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_EvaluationJobAlertConfig.DiscardUnknown(m)
}

var xxx_messageInfo_EvaluationJobAlertConfig proto.InternalMessageInfo

func (m *EvaluationJobAlertConfig) GetEmail() string {
	if m != nil {
		return m.Email
	}
	return ""
}

func (m *EvaluationJobAlertConfig) GetMinAcceptableMeanAveragePrecision() float64 {
	if m != nil {
		return m.MinAcceptableMeanAveragePrecision
	}
	return 0
}

// Records a failed evaluation job run.
type Attempt struct {
	AttemptTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=attempt_time,json=attemptTime,proto3" json:"attempt_time,omitempty"`
	// Details of errors that occurred.
	PartialFailures      []*status.Status `protobuf:"bytes,2,rep,name=partial_failures,json=partialFailures,proto3" json:"partial_failures,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Attempt) Reset()         { *m = Attempt{} }
func (m *Attempt) String() string { return proto.CompactTextString(m) }
func (*Attempt) ProtoMessage()    {}
func (*Attempt) Descriptor() ([]byte, []int) {
	return fileDescriptor_052df044fb4ef883, []int{3}
}

func (m *Attempt) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Attempt.Unmarshal(m, b)
}
func (m *Attempt) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Attempt.Marshal(b, m, deterministic)
}
func (m *Attempt) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Attempt.Merge(m, src)
}
func (m *Attempt) XXX_Size() int {
	return xxx_messageInfo_Attempt.Size(m)
}
func (m *Attempt) XXX_DiscardUnknown() {
	xxx_messageInfo_Attempt.DiscardUnknown(m)
}

var xxx_messageInfo_Attempt proto.InternalMessageInfo

func (m *Attempt) GetAttemptTime() *timestamp.Timestamp {
	if m != nil {
		return m.AttemptTime
	}
	return nil
}

func (m *Attempt) GetPartialFailures() []*status.Status {
	if m != nil {
		return m.PartialFailures
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.datalabeling.v1beta1.EvaluationJob_State", EvaluationJob_State_name, EvaluationJob_State_value)
	proto.RegisterType((*EvaluationJob)(nil), "google.cloud.datalabeling.v1beta1.EvaluationJob")
	proto.RegisterType((*EvaluationJobConfig)(nil), "google.cloud.datalabeling.v1beta1.EvaluationJobConfig")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.datalabeling.v1beta1.EvaluationJobConfig.BigqueryImportKeysEntry")
	proto.RegisterType((*EvaluationJobAlertConfig)(nil), "google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig")
	proto.RegisterType((*Attempt)(nil), "google.cloud.datalabeling.v1beta1.Attempt")
}

func init() {
	proto.RegisterFile("google/cloud/datalabeling/v1beta1/evaluation_job.proto", fileDescriptor_052df044fb4ef883)
}

var fileDescriptor_052df044fb4ef883 = []byte{
	// 1047 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x56, 0xdf, 0x4f, 0x1b, 0x47,
	0x10, 0xce, 0x01, 0x06, 0xb3, 0x86, 0xd6, 0x2c, 0x20, 0x0e, 0xa7, 0x52, 0x0c, 0x55, 0x24, 0xb7,
	0x0f, 0x77, 0x8a, 0xa3, 0x46, 0x11, 0x34, 0xaa, 0x0c, 0x98, 0x40, 0x1b, 0xa8, 0x7b, 0x36, 0x7d,
	0xe8, 0xcb, 0x75, 0xef, 0x3c, 0x1c, 0x4b, 0xee, 0x57, 0x76, 0xf7, 0x10, 0x2e, 0x4a, 0x55, 0xf5,
	0xa5, 0xff, 0x6b, 0x2b, 0xf5, 0x6f, 0xa8, 0x76, 0x6f, 0xcf, 0xd8, 0x21, 0x2e, 0x26, 0x2f, 0x70,
	0x3b, 0xf3, 0xcd, 0xf7, 0xcd, 0xee, 0xcc, 0xce, 0x1a, 0xbd, 0x08, 0x92, 0x24, 0x08, 0xc1, 0xf6,
	0xc3, 0x24, 0xeb, 0xdb, 0x7d, 0x22, 0x48, 0x48, 0x3c, 0x08, 0x69, 0x1c, 0xd8, 0x57, 0xcf, 0x3c,
	0x10, 0xe4, 0x99, 0x0d, 0x57, 0x24, 0xcc, 0x88, 0xa0, 0x49, 0xec, 0x5e, 0x26, 0x9e, 0x95, 0xb2,
	0x44, 0x24, 0x78, 0x2b, 0x8f, 0xb3, 0x54, 0x9c, 0x35, 0x1a, 0x67, 0xe9, 0xb8, 0xda, 0x17, 0x9a,
	0x9a, 0xa4, 0xd4, 0x26, 0x71, 0x9c, 0x08, 0xc5, 0xc1, 0x73, 0x82, 0xda, 0xe6, 0x88, 0x97, 0x01,
	0x4f, 0x32, 0xe6, 0x83, 0x76, 0xd9, 0xf7, 0xe7, 0x24, 0x8d, 0x1c, 0x84, 0x0e, 0x68, 0x3e, 0x64,
	0x13, 0x3a, 0xe6, 0xbb, 0xfb, 0x63, 0x2e, 0xb2, 0x88, 0xc4, 0xee, 0x6d, 0xea, 0xae, 0x9f, 0xc4,
	0xe7, 0x34, 0xd0, 0x04, 0x4f, 0x34, 0x81, 0x5a, 0x79, 0xd9, 0xb9, 0x2d, 0x68, 0x04, 0x5c, 0x90,
	0x28, 0xd5, 0x80, 0x0d, 0x0d, 0x60, 0xa9, 0x6f, 0x73, 0x41, 0x44, 0xa6, 0xb7, 0xbe, 0xfd, 0x4f,
	0x09, 0x2d, 0xb7, 0x87, 0xf9, 0x7c, 0x9f, 0x78, 0x18, 0xa3, 0xb9, 0x98, 0x44, 0x60, 0x1a, 0x75,
	0xa3, 0xb1, 0xe8, 0xa8, 0x6f, 0x5c, 0x47, 0x95, 0x3e, 0x70, 0x9f, 0xd1, 0x54, 0xa2, 0xcc, 0x19,
	0xe5, 0x1a, 0x35, 0xe1, 0x37, 0xa8, 0x24, 0x79, 0xc1, 0x9c, 0xad, 0x1b, 0x8d, 0xcf, 0x9a, 0x2f,
	0xac, 0x7b, 0x6b, 0x62, 0x8d, 0xc9, 0x5a, 0x5d, 0x19, 0xed, 0xe4, 0x24, 0xb8, 0x86, 0xca, 0xdc,
	0xbf, 0x80, 0x7e, 0x16, 0x82, 0x39, 0xa7, 0xc4, 0x86, 0x6b, 0xfc, 0x25, 0x5a, 0x8e, 0x92, 0x3e,
	0x84, 0xee, 0x15, 0x30, 0x2e, 0xb3, 0x29, 0x29, 0xc0, 0x92, 0x32, 0xfe, 0x9c, 0xdb, 0xf0, 0x25,
	0x5a, 0x1f, 0x6f, 0x15, 0x7d, 0x5e, 0xe6, 0x7c, 0xdd, 0x68, 0x54, 0x1e, 0x9e, 0xde, 0xbe, 0x8a,
	0x76, 0x56, 0xe1, 0xae, 0x11, 0x5b, 0x68, 0x75, 0xa4, 0x2e, 0x3c, 0x05, 0xdf, 0xe5, 0x20, 0xcc,
	0x05, 0x95, 0xd6, 0xca, 0xad, 0xab, 0x9b, 0x82, 0xdf, 0x05, 0x81, 0x77, 0x51, 0x4d, 0x89, 0xb9,
	0x11, 0xe5, 0x9c, 0xc6, 0x81, 0x1b, 0xb0, 0x24, 0x8b, 0xfb, 0xae, 0x60, 0x99, 0xb8, 0x30, 0xcb,
	0x75, 0xa3, 0x51, 0x76, 0x36, 0x14, 0xe2, 0x24, 0x07, 0xbc, 0x56, 0xfe, 0x9e, 0x74, 0xe3, 0x43,
	0x54, 0x26, 0x42, 0x40, 0x94, 0x0a, 0x6e, 0x2e, 0xd6, 0x67, 0x1b, 0x95, 0xe6, 0xd7, 0x53, 0xec,
	0xa5, 0x95, 0x87, 0x38, 0xc3, 0x58, 0xbc, 0x8b, 0x2a, 0x3e, 0x03, 0x22, 0xc0, 0x95, 0xad, 0x62,
	0x22, 0x75, 0x2c, 0xb5, 0x82, 0xaa, 0xe8, 0x23, 0xab, 0x57, 0xf4, 0x91, 0x83, 0x72, 0xb8, 0x34,
	0x6c, 0x77, 0x51, 0x49, 0x95, 0x0b, 0xaf, 0xa3, 0x95, 0x6e, 0xaf, 0xd5, 0x6b, 0xbb, 0x67, 0xa7,
	0xdd, 0x4e, 0x7b, 0xff, 0xf8, 0xf0, 0xb8, 0x7d, 0x50, 0x7d, 0x84, 0x97, 0xd1, 0x62, 0x77, 0xff,
	0xa8, 0x7d, 0x70, 0xf6, 0xa6, 0x7d, 0x50, 0x35, 0x70, 0x05, 0x2d, 0x38, 0x67, 0xa7, 0xa7, 0xc7,
	0xa7, 0xaf, 0xab, 0x33, 0x18, 0xa1, 0xf9, 0x4e, 0xeb, 0xac, 0xdb, 0x3e, 0xa8, 0xce, 0x4a, 0x47,
	0xb7, 0xf7, 0x63, 0xa7, 0xd3, 0x3e, 0xa8, 0xce, 0xed, 0x78, 0x7f, 0xb7, 0x5c, 0xf4, 0xd5, 0x58,
	0xfa, 0x79, 0x36, 0x24, 0xa5, 0xdc, 0xf2, 0x93, 0xc8, 0x1e, 0xef, 0xd3, 0x66, 0xca, 0x92, 0x4b,
	0xf0, 0x05, 0xb7, 0x6f, 0xf4, 0xd7, 0x7b, 0x7b, 0xac, 0x3c, 0xdc, 0xbe, 0x19, 0xef, 0x81, 0xf7,
	0xdb, 0xff, 0x96, 0xd1, 0xea, 0x47, 0xea, 0x8a, 0x7f, 0x47, 0x8f, 0x69, 0x44, 0x02, 0x70, 0xfd,
	0x90, 0x70, 0x4e, 0xcf, 0xa9, 0x3f, 0x7a, 0xc9, 0x54, 0x0b, 0x56, 0x9a, 0xdf, 0x4e, 0x71, 0xd0,
	0xc7, 0x92, 0x65, 0x7f, 0x8c, 0x24, 0x97, 0x38, 0x7a, 0xe4, 0x6c, 0xd2, 0x49, 0x4e, 0x4c, 0xd1,
	0x9a, 0x27, 0x6b, 0x2c, 0xbb, 0x21, 0x4d, 0xc2, 0x41, 0x21, 0x5c, 0x52, 0xc2, 0xdf, 0x4c, 0x21,
	0xbc, 0xa7, 0xc3, 0x3b, 0x49, 0x38, 0x18, 0x2a, 0x62, 0xef, 0x8e, 0x15, 0xdf, 0xa0, 0x9a, 0x80,
	0x6b, 0x31, 0x61, 0xa7, 0x65, 0x25, 0xb8, 0x3b, 0x85, 0x60, 0x0f, 0xae, 0xc5, 0x84, 0x8d, 0x9a,
	0x62, 0x82, 0x0f, 0xff, 0x84, 0x96, 0x68, 0x9c, 0x66, 0xa2, 0x90, 0x33, 0x94, 0x9c, 0x35, 0xcd,
	0xc1, 0xca, 0x30, 0x7d, 0x0b, 0x2b, 0xf4, 0x76, 0x81, 0x7f, 0x45, 0x2b, 0x23, 0x55, 0xd6, 0xbc,
	0x33, 0x8a, 0xf7, 0xf9, 0x83, 0x6e, 0xb9, 0x26, 0xaf, 0xc2, 0x07, 0x16, 0x9c, 0xa2, 0x8d, 0x09,
	0xd3, 0x57, 0x0d, 0xbb, 0x4a, 0xf3, 0xe5, 0x14, 0x3a, 0x47, 0x92, 0xa1, 0x35, 0x24, 0xd0, 0x62,
	0xeb, 0x17, 0x1f, 0x33, 0xe3, 0x3f, 0x0c, 0xb4, 0xe6, 0xd1, 0xe0, 0x5d, 0x06, 0x6c, 0xe0, 0xd2,
	0x28, 0x4d, 0x98, 0x70, 0xdf, 0xc2, 0xa0, 0xb8, 0xf1, 0xa7, 0x9f, 0x36, 0xbd, 0xac, 0x3d, 0x4d,
	0x79, 0xac, 0x18, 0x7f, 0x80, 0x01, 0x6f, 0xc7, 0x82, 0x0d, 0x1c, 0xec, 0xdd, 0x71, 0xc8, 0x29,
	0x0b, 0xd7, 0x24, 0x4a, 0x43, 0x70, 0xfd, 0x24, 0x8b, 0x85, 0x9a, 0x10, 0x25, 0x67, 0x49, 0x1b,
	0xf7, 0xa5, 0x0d, 0xef, 0xa0, 0xcd, 0x02, 0xc4, 0xf3, 0x7f, 0x29, 0x30, 0x1f, 0x62, 0x41, 0x02,
	0x30, 0x2b, 0x75, 0xa3, 0x61, 0x38, 0x1b, 0x1a, 0xd0, 0x55, 0x7f, 0x3b, 0x43, 0x37, 0xfe, 0x0d,
	0x3d, 0xfe, 0x60, 0x42, 0x93, 0x10, 0xd8, 0xb0, 0x33, 0x96, 0xa7, 0x6e, 0xc4, 0xb1, 0x9d, 0xb6,
	0x24, 0x87, 0x3e, 0x5c, 0x13, 0x26, 0x78, 0x6a, 0x6d, 0xb4, 0x31, 0xe1, 0x2c, 0x70, 0x15, 0xcd,
	0xbe, 0x85, 0x81, 0x7e, 0xfc, 0xe4, 0x27, 0x5e, 0x43, 0x25, 0xc9, 0x03, 0xfa, 0xd5, 0xcb, 0x17,
	0x3b, 0x33, 0x2f, 0x8d, 0xbd, 0x2d, 0xf4, 0xe4, 0x4e, 0x63, 0x30, 0x78, 0x97, 0x01, 0x2f, 0xb6,
	0xb1, 0xfd, 0xa7, 0x81, 0xcc, 0x49, 0x09, 0x4a, 0x66, 0x88, 0x08, 0x0d, 0xb5, 0x5a, 0xbe, 0xc0,
	0x1d, 0xf4, 0x34, 0xa2, 0xb1, 0x4b, 0x7c, 0x1f, 0x52, 0x41, 0xbc, 0x10, 0xdc, 0x08, 0xa4, 0xc6,
	0x15, 0x30, 0x39, 0xa1, 0x52, 0x06, 0x3e, 0xe5, 0xc5, 0x2b, 0x6c, 0x38, 0x5b, 0x11, 0x8d, 0x5b,
	0x43, 0xec, 0x09, 0x90, 0xb8, 0x95, 0x23, 0x3b, 0x05, 0x70, 0xfb, 0x2f, 0x03, 0x2d, 0xe8, 0x17,
	0x00, 0xbf, 0x42, 0x4b, 0xfa, 0x0d, 0xc8, 0x07, 0xbf, 0x71, 0xef, 0xe0, 0xaf, 0x68, 0xbc, 0xb4,
	0xe0, 0x57, 0xa8, 0x9a, 0x12, 0x26, 0x28, 0x09, 0xdd, 0x73, 0x42, 0xc3, 0x8c, 0x01, 0x37, 0x67,
	0x54, 0x53, 0xe2, 0x82, 0x82, 0xa5, 0xbe, 0x7a, 0xcc, 0x33, 0xee, 0x7c, 0xae, 0xb1, 0x87, 0x1a,
	0xba, 0x77, 0x8d, 0x9e, 0xfa, 0x49, 0x74, 0x7f, 0x51, 0x3b, 0xc6, 0x2f, 0x27, 0x1a, 0x14, 0x24,
	0x21, 0x89, 0x03, 0x2b, 0x61, 0x81, 0x1d, 0x40, 0xac, 0xf2, 0xb3, 0x6f, 0xdf, 0x85, 0xff, 0xf9,
	0xc9, 0xb4, 0x3b, 0x6a, 0xf4, 0xe6, 0x55, 0xe4, 0xf3, 0xff, 0x02, 0x00, 0x00, 0xff, 0xff, 0x95,
	0x57, 0x84, 0xa5, 0x64, 0x0a, 0x00, 0x00,
}
