package containerregistryapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/containerregistry/runtime/2019-07/containerregistry"
	"github.com/Azure/go-autorest/autorest"
)

// BaseClientAPI contains the set of methods on the BaseClient type.
type BaseClientAPI interface {
	CreateManifest(ctx context.Context, name string, reference string, payload containerregistry.Manifest) (result containerregistry.SetObject, err error)
	DeleteAcrRepository(ctx context.Context, name string) (result containerregistry.DeletedRepository, err error)
	DeleteAcrTag(ctx context.Context, name string, reference string) (result autorest.Response, err error)
	DeleteManifest(ctx context.Context, name string, reference string) (result autorest.Response, err error)
	GetAcrAccessToken(ctx context.Context, service string, scope string, refreshToken string) (result containerregistry.AccessToken, err error)
	GetAcrAccessTokenFromLogin(ctx context.Context, service string, scope string) (result containerregistry.AccessToken, err error)
	GetAcrManifestAttributes(ctx context.Context, name string, reference string) (result containerregistry.AcrManifestAttributes, err error)
	GetAcrManifests(ctx context.Context, name string, last string, n *int32, orderby string) (result containerregistry.AcrManifests, err error)
	GetAcrRefreshTokenFromExchange(ctx context.Context, grantType string, service string, tenant string, refreshToken string, accessToken string) (result containerregistry.RefreshToken, err error)
	GetAcrRepositories(ctx context.Context, last string, n *int32) (result containerregistry.Repositories, err error)
	GetAcrRepositoryAttributes(ctx context.Context, name string) (result containerregistry.RepositoryAttributes, err error)
	GetAcrTagAttributes(ctx context.Context, name string, reference string) (result containerregistry.AcrTagAttributes, err error)
	GetAcrTags(ctx context.Context, name string, last string, n *int32, orderby string, digest string) (result containerregistry.AcrRepositoryTags, err error)
	GetDockerRegistryV2Support(ctx context.Context) (result autorest.Response, err error)
	GetManifest(ctx context.Context, name string, reference string, accept string) (result containerregistry.Manifest, err error)
	GetRepositories(ctx context.Context, last string, n *int32) (result containerregistry.Repositories, err error)
	GetTagList(ctx context.Context, name string) (result containerregistry.RepositoryTags, err error)
	UpdateAcrManifestAttributes(ctx context.Context, name string, reference string, value *containerregistry.ChangeableAttributes) (result autorest.Response, err error)
	UpdateAcrRepositoryAttributes(ctx context.Context, name string, value *containerregistry.ChangeableAttributes) (result autorest.Response, err error)
	UpdateAcrTagAttributes(ctx context.Context, name string, reference string, value *containerregistry.ChangeableAttributes) (result autorest.Response, err error)
}

var _ BaseClientAPI = (*containerregistry.BaseClient)(nil)
