package mapsapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/maps/mgmt/2018-05-01/maps"
	"github.com/Azure/go-autorest/autorest"
)

// AccountsClientAPI contains the set of methods on the AccountsClient type.
type AccountsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, accountName string, mapsAccountCreateParameters maps.AccountCreateParameters) (result maps.Account, err error)
	Delete(ctx context.Context, resourceGroupName string, accountName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, accountName string) (result maps.Account, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result maps.Accounts, err error)
	ListBySubscription(ctx context.Context) (result maps.Accounts, err error)
	ListKeys(ctx context.Context, resourceGroupName string, accountName string) (result maps.AccountKeys, err error)
	ListOperations(ctx context.Context) (result maps.Operations, err error)
	Move(ctx context.Context, resourceGroupName string, moveRequest maps.AccountsMoveRequest) (result autorest.Response, err error)
	RegenerateKeys(ctx context.Context, resourceGroupName string, accountName string, keySpecification maps.KeySpecification) (result maps.AccountKeys, err error)
	Update(ctx context.Context, resourceGroupName string, accountName string, mapsAccountUpdateParameters maps.AccountUpdateParameters) (result maps.Account, err error)
}

var _ AccountsClientAPI = (*maps.AccountsClient)(nil)
