/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * gnome-scan
 * Copyright (C) Étienne Bersac 2007 <bersace03@laposte.net>
 * 
 * gnome-scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */

/**
 * SECTION: gnome-scan-preview-sink
 * @short_description: #GnomeScanPreviewSink class
 * 
 **/
#include <gegl.h>
#include "gnome-scan-preview-sink.h"

typedef struct _GnomeScanPreviewSinkPrivate GnomeScanPreviewSinkPrivate;
struct _GnomeScanPreviewSinkPrivate
{
	GdkPixbuf*		pixbuf;
	GeglNode*		save;
};

#define GET_PRIVATE(o)  (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_TYPE_SCAN_PREVIEW_SINK, GnomeScanPreviewSinkPrivate))



G_DEFINE_TYPE (GnomeScanPreviewSink, gnome_scan_preview_sink, GNOME_TYPE_SCAN_SINK);

static void
gnome_scan_preview_sink_init (GnomeScanPreviewSink *object)
{
	/* TODO: Add initialization code here */
}

static void
gnome_scan_preview_sink_finalize (GObject *object)
{
	/* TODO: Add deinitalization code here */

	G_OBJECT_CLASS (gnome_scan_preview_sink_parent_class)->finalize (object);
}

GnomeScanSink*
gnome_scan_preview_sink_new (void)
{
	GObject* object = g_object_new (GNOME_TYPE_SCAN_PREVIEW_SINK,
									NULL);
	return GNOME_SCAN_SINK (object);
}

GdkPixbuf*
gnome_scan_preview_sink_get_pixbuf (GnomeScanPreviewSink *sink)
{
	return GET_PRIVATE (sink)->pixbuf;
}

static void
gnome_scan_preview_sink_configure (GnomeScanPlugin *plugin,
								   GnomeScanSettings *settings)
{
}

static GList*
gnome_scan_preview_sink_get_child_nodes (GnomeScanPlugin *plugin,
										 GeglNode *root)
{
	GnomeScanPreviewSinkPrivate *priv = GET_PRIVATE (plugin);
	GList *list = NULL;

	priv->save = gegl_node_new_child (root,
									  "operation", "gegl:save-pixbuf",
									  "pixbuf", &priv->pixbuf,
									  NULL);
	list = g_list_append (list,
						  priv->save);
	return list;
}

static gboolean
gnome_scan_preview_sink_start_frame (GnomeScanPlugin *plugin)
{
	return TRUE;
}

static gboolean
gnome_scan_preview_sink_work (GnomeScanPlugin *plugin, gdouble *progress)
{
	GnomeScanPreviewSinkPrivate *priv = GET_PRIVATE (plugin);
	*progress = 1.;
	return FALSE;
}

static void
gnome_scan_preview_sink_end_frame (GnomeScanPlugin *plugin)
{
	GnomeScanPreviewSinkPrivate *priv = GET_PRIVATE (plugin);
	g_object_unref (priv->save);
}

static void
gnome_scan_preview_sink_class_init (GnomeScanPreviewSinkClass *klass)
{
	GObjectClass* object_class = G_OBJECT_CLASS (klass);
	GnomeScanPluginClass* parent_class = GNOME_SCAN_PLUGIN_CLASS (klass);

	g_type_class_add_private (klass, sizeof (GnomeScanPreviewSinkPrivate));

	parent_class->configure			= gnome_scan_preview_sink_configure;
	parent_class->get_child_nodes	= gnome_scan_preview_sink_get_child_nodes;
	parent_class->start_frame		= gnome_scan_preview_sink_start_frame;
	parent_class->work				= gnome_scan_preview_sink_work;
	parent_class->end_frame			= gnome_scan_preview_sink_end_frame;
	
	object_class->finalize = gnome_scan_preview_sink_finalize;
}
