// CLASSIFICATION: UNCLASSIFIED

/*
 * testFrame.java
 *
 * Created on April 2, 2001, 4:28 PM
 */

package geotrans3.gui;



import geotrans3.enumerations.*;
import geotrans3.exception.CoordinateConversionException;
import geotrans3.jni.JNIFiomeths;
import geotrans3.jni.JNICoordinateConversionService;
import geotrans3.misc.FormatOptions;
import geotrans3.misc.StringHandler;
import geotrans3.utility.DATFileFilter;
import geotrans3.utility.Directory;
import geotrans3.utility.Utility;

/**
 *
 * @author  amyc
 * @version 
 */
public class FileDlg extends javax.swing.JDialog 
{
    private Directory currentDir;
    private MasterPanel lowerFilePanel;
    private StringHandler stringHandler;
    private JNIFiomeths jniFiomeths;
    private javax.swing.JFrame parentFrame;
    private FormatOptions options;
 
    /** Creates new form FileDlg */
  public FileDlg(JNICoordinateConversionService _jniCoordinateConversionService, javax.swing.JFrame parent, boolean modal, Directory dir, FormatOptions joptions, JNIFiomeths _jniFiomeths, StringHandler _stringHandler) throws CoordinateConversionException
  {
    super(parent, modal);

 //   try
  //  {
      parentFrame = parent;
      currentDir = dir;
      jniFiomeths = _jniFiomeths;
      options = joptions;
      stringHandler = _stringHandler;

      initComponents();

      MasterPanel upperFilePanel = new MasterPanel(_jniCoordinateConversionService, _jniFiomeths.getDatumCode(), _jniFiomeths.getCoordinateSystemParameters(), ConversionState.FILE, SourceOrTarget.SOURCE, joptions, _stringHandler);
      lowerFilePanel = new MasterPanel(_jniCoordinateConversionService, SourceOrTarget.TARGET, joptions, _stringHandler, upperFilePanel.getProjectionType());

      inputFilePanel.add(upperFilePanel, java.awt.BorderLayout.CENTER);
      outputFilePanel.add(lowerFilePanel, java.awt.BorderLayout.CENTER);
            
      getRootPane().setDefaultButton(okButton);
      
      pack();
      Utility.center(parent, this);
/*    }
    catch(Exception e)
    {
      _stringHandler.displayErrorMsg(parent, e.getMessage());
      setVisible(false);
      dispose();
    }*/
  }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {
    java.awt.GridBagConstraints gridBagConstraints;

    inputFilePanel = new javax.swing.JPanel();
    inputLabel = new javax.swing.JLabel();
    outputFilePanel = new javax.swing.JPanel();
    outputLabel = new javax.swing.JLabel();
    buttonsPanel = new javax.swing.JPanel();
    okButton = new javax.swing.JButton();
    helpButton = new javax.swing.JButton();
    cancelButton = new javax.swing.JButton();

    setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
    setTitle("File Processing");
    setResizable(false);
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        closeDialog(evt);
      }
    });
    getContentPane().setLayout(new java.awt.GridBagLayout());

    inputFilePanel.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
    inputFilePanel.setMinimumSize(new java.awt.Dimension(467, 197));
    inputFilePanel.setPreferredSize(new java.awt.Dimension(467, 197));
    inputFilePanel.setLayout(new java.awt.BorderLayout(1, 1));

    inputLabel.setText("INPUT");
    inputFilePanel.add(inputLabel, java.awt.BorderLayout.NORTH);

    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 1;
    gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
    gridBagConstraints.weightx = 0.5;
    gridBagConstraints.weighty = 0.5;
    gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
    getContentPane().add(inputFilePanel, gridBagConstraints);

    outputFilePanel.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
    outputFilePanel.setAlignmentY(1.5F);
    outputFilePanel.setMinimumSize(new java.awt.Dimension(467, 197));
    outputFilePanel.setPreferredSize(new java.awt.Dimension(467, 197));
    outputFilePanel.setLayout(new java.awt.BorderLayout(1, 1));

    outputLabel.setText("OUTPUT");
    outputFilePanel.add(outputLabel, java.awt.BorderLayout.NORTH);

    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 3;
    gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
    gridBagConstraints.ipady = 8;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
    gridBagConstraints.weightx = 0.5;
    gridBagConstraints.weighty = 0.5;
    gridBagConstraints.insets = new java.awt.Insets(3, 2, 2, 2);
    getContentPane().add(outputFilePanel, gridBagConstraints);

    buttonsPanel.setMinimumSize(new java.awt.Dimension(330, 50));
    buttonsPanel.setPreferredSize(new java.awt.Dimension(330, 50));
    buttonsPanel.setLayout(new java.awt.GridBagLayout());

    okButton.setMnemonic(java.awt.event.KeyEvent.VK_O);
    okButton.setText("OK");
    okButton.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED));
    okButton.setMaximumSize(new java.awt.Dimension(80, 21));
    okButton.setMinimumSize(new java.awt.Dimension(80, 21));
    okButton.setPreferredSize(new java.awt.Dimension(80, 21));
    okButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        okActionPerformed(evt);
      }
    });
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
    gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 45);
    buttonsPanel.add(okButton, gridBagConstraints);

    helpButton.setMnemonic(java.awt.event.KeyEvent.VK_H);
    helpButton.setText("Help");
    helpButton.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED));
    helpButton.setMaximumSize(new java.awt.Dimension(80, 21));
    helpButton.setMinimumSize(new java.awt.Dimension(80, 21));
    helpButton.setPreferredSize(new java.awt.Dimension(80, 21));
    helpButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        helpActionPerformed(evt);
      }
    });
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
    gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 45);
    buttonsPanel.add(helpButton, gridBagConstraints);

    cancelButton.setMnemonic(java.awt.event.KeyEvent.VK_C);
    cancelButton.setText("Cancel");
    cancelButton.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED));
    cancelButton.setMaximumSize(new java.awt.Dimension(80, 21));
    cancelButton.setMinimumSize(new java.awt.Dimension(80, 21));
    cancelButton.setPreferredSize(new java.awt.Dimension(80, 21));
    cancelButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        cancelActionPerformed(evt);
      }
    });
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
    gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 0);
    buttonsPanel.add(cancelButton, gridBagConstraints);

    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 4;
    getContentPane().add(buttonsPanel, gridBagConstraints);
  }// </editor-fold>//GEN-END:initComponents

  private void cancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelActionPerformed
    try
    {
      jniFiomeths.closeInputFile();
    }
    catch(Exception e)
    {
      stringHandler.displayErrorMsg(this, e.getMessage());
    }
    finally
    {
      setVisible(false);
      dispose();    
    }
  }//GEN-LAST:event_cancelActionPerformed

  private void helpActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_helpActionPerformed
   java.io.File helpFile = new java.io.File ("..");
   try
   {
       if (StartBrowser.isWindowsPlatform())
           StartBrowser.displayURL(this, "file:" + helpFile.getCanonicalPath() + "\\help\\fileproc.htm");
       else
           StartBrowser.displayURL(this, "file:" + helpFile.getCanonicalPath() + "/help/fileproc.htm");
   }
   catch(Exception e) 
   {
        stringHandler.displayErrorMsg(this, "Could not invoke browser");
   }   
  }//GEN-LAST:event_helpActionPerformed

  private void okActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okActionPerformed
    try
    {
      // if no ccs errors
      if(!lowerFilePanel.getError())
      {
          setVisible( false );
          javax.swing.JFileChooser jChooser1 = new javax.swing.JFileChooser(currentDir.getDirectory());
          jChooser1.setDialogTitle("Save As");
          jChooser1.addChoosableFileFilter(new DATFileFilter());
          jChooser1.setSelectedFile(new java.io.File("*.dat"));
          int state = jChooser1.showSaveDialog(parentFrame);
          if( state == javax.swing.JFileChooser.APPROVE_OPTION )
          {
            java.io.File file = jChooser1.getSelectedFile();
            currentDir.setDirectory(file.getAbsolutePath());
            if( file != null )
            {
              // Set Formats
              jniFiomeths.setUseNSEW(options.getUseNSEW());
              jniFiomeths.setUseMinutes(options.getUseMinutes());
              jniFiomeths.setUseSeconds(options.getUseSeconds());
              jniFiomeths.setLatLongPrecision(options.getPrecision());
              // BAEts29174 - Set output format for file operation
              jniFiomeths.setLeadingZeros (options.getLeadingZeros());
              jniFiomeths.setSeparator (options.getSeparator());
              jniFiomeths.setLonRange (options.getRange());

              if (lowerFilePanel.getProjectionType() == CoordinateType.GEODETIC)
                jniFiomeths.setGeodeticCoordinateOrder(lowerFilePanel.getCoordinateOrder());

              jniFiomeths.setOutputFilename(file.getPath(), lowerFilePanel.getDatumCode(), lowerFilePanel.getParameters());
             
              ProgressDlg progressDlg = new ProgressDlg(this, true, jniFiomeths);
              progressDlg.show();
            }
          }
      }
      else
      {
        lowerFilePanel.showErrors(this);
        dispose();
      }
    }
    catch(Exception e)
    {
        stringHandler.displayErrorMsg(this, e.getMessage());
    }
    finally
    {
      try
      {
        jniFiomeths.closeInputFile();
      }
      catch(Exception e)
      {
        stringHandler.displayErrorMsg(this, e.getMessage());
      }

      dispose();
    }
  }//GEN-LAST:event_okActionPerformed

  private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
    setVisible(false);
    dispose();
    try
    {
      jniFiomeths.closeInputFile();
    }
    catch(Exception e)
    {
      stringHandler.displayErrorMsg(this, e.getMessage());
    }
  }//GEN-LAST:event_closeDialog

    
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JPanel buttonsPanel;
  private javax.swing.JButton cancelButton;
  private javax.swing.JButton helpButton;
  private javax.swing.JPanel inputFilePanel;
  private javax.swing.JLabel inputLabel;
  private javax.swing.JButton okButton;
  private javax.swing.JPanel outputFilePanel;
  private javax.swing.JLabel outputLabel;
  // End of variables declaration//GEN-END:variables

}

// CLASSIFICATION: UNCLASSIFIED
