;; Pipeline description for Freescale PowerPC e500mc64 core.
;;   Copyright (C) 2009-2016 Free Software Foundation, Inc.
;;   Contributed by Edmar Wienskoski (edmar@freescale.com)
;;
;; This file is part of GCC.
;;
;; GCC is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 3, or (at your
;; option) any later version.
;;
;; GCC is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.
;;
;; e500mc64 64-bit SU(2), LSU, FPU, BPU
;; Max issue 3 insns/clock cycle (includes 1 branch)

(define_automaton "e500mc64_most,e500mc64_long,e500mc64_retire")
(define_cpu_unit "e500mc64_decode_0,e500mc64_decode_1" "e500mc64_most")
(define_cpu_unit "e500mc64_issue_0,e500mc64_issue_1"   "e500mc64_most")
(define_cpu_unit "e500mc64_retire_0,e500mc64_retire_1" "e500mc64_retire")

;; SU.
(define_cpu_unit "e500mc64_su0_stage0,e500mc64_su1_stage0" "e500mc64_most")

;; MU.
(define_cpu_unit "e500mc64_mu_stage0,e500mc64_mu_stage1" "e500mc64_most")
(define_cpu_unit "e500mc64_mu_stage2,e500mc64_mu_stage3" "e500mc64_most")

;; Non-pipelined division.
(define_cpu_unit "e500mc64_mu_div" "e500mc64_long")

;; LSU.
(define_cpu_unit "e500mc64_lsu" "e500mc64_most")

;; FPU.
(define_cpu_unit "e500mc64_fpu" "e500mc64_most")

;; Branch unit.
(define_cpu_unit "e500mc64_bu" "e500mc64_most")

;; The following units are used to make the automata deterministic.
(define_cpu_unit "present_e500mc64_decode_0" "e500mc64_most")
(define_cpu_unit "present_e500mc64_issue_0" "e500mc64_most")
(define_cpu_unit "present_e500mc64_retire_0" "e500mc64_retire")
(define_cpu_unit "present_e500mc64_su0_stage0" "e500mc64_most")

;; The following sets to make automata deterministic when option ndfa is used.
(presence_set "present_e500mc64_decode_0" "e500mc64_decode_0")
(presence_set "present_e500mc64_issue_0" "e500mc64_issue_0")
(presence_set "present_e500mc64_retire_0" "e500mc64_retire_0")
(presence_set "present_e500mc64_su0_stage0" "e500mc64_su0_stage0")

;; Some useful abbreviations.
(define_reservation "e500mc64_decode"
    "e500mc64_decode_0|e500mc64_decode_1+present_e500mc64_decode_0")
(define_reservation "e500mc64_issue"
    "e500mc64_issue_0|e500mc64_issue_1+present_e500mc64_issue_0")
(define_reservation "e500mc64_retire"
   "e500mc64_retire_0|e500mc64_retire_1+present_e500mc64_retire_0")
(define_reservation "e500mc64_su_stage0"
   "e500mc64_su0_stage0|e500mc64_su1_stage0+present_e500mc64_su0_stage0")

;; Simple SU insns.
(define_insn_reservation "e500mc64_su" 1
  (and (ior (eq_attr "type" "integer,insert,cntlz")
	    (and (eq_attr "type" "add,logical,exts")
		 (eq_attr "dot" "no"))
	    (and (eq_attr "type" "shift")
		 (eq_attr "dot" "no")
		 (eq_attr "var_shift" "no")))
       (eq_attr "cpu" "ppce500mc64"))
  "e500mc64_decode,e500mc64_issue+e500mc64_su_stage0+e500mc64_retire")

(define_insn_reservation "e500mc64_su2" 2
  (and (ior (eq_attr "type" "cmp,trap")
	    (and (eq_attr "type" "add,logical,exts")
		 (eq_attr "dot" "yes"))
	    (and (eq_attr "type" "shift")
		 (eq_attr "dot" "yes")
		 (eq_attr "var_shift" "no")))
       (eq_attr "cpu" "ppce500mc64"))
  "e500mc64_decode,e500mc64_issue+e500mc64_su_stage0,e500mc64_retire")

(define_insn_reservation "e500mc64_delayed" 2
  (and (eq_attr "type" "shift")
       (eq_attr "var_shift" "yes")
       (eq_attr "cpu" "ppce500mc64"))
  "e500mc64_decode,e500mc64_issue+e500mc64_su_stage0,e500mc64_retire")

(define_insn_reservation "e500mc64_two" 2
  (and (eq_attr "type" "two")
       (eq_attr "cpu" "ppce500mc64"))
  "e500mc64_decode,e500mc64_issue+e500mc64_su_stage0+e500mc64_retire,\
   e500mc64_issue+e500mc64_su_stage0+e500mc64_retire")

(define_insn_reservation "e500mc64_three" 3
  (and (eq_attr "type" "three")
       (eq_attr "cpu" "ppce500mc64"))
  "e500mc64_decode,e500mc64_issue+e500mc64_su_stage0+e500mc64_retire,\
   e500mc64_issue+e500mc64_su_stage0+e500mc64_retire,\
   e500mc64_issue+e500mc64_su_stage0+e500mc64_retire")

;; Multiply.
(define_insn_reservation "e500mc64_multiply" 4
  (and (eq_attr "type" "mul")
       (eq_attr "cpu" "ppce500mc64"))
  "e500mc64_decode,e500mc64_issue+e500mc64_mu_stage0,e500mc64_mu_stage1,\
   e500mc64_mu_stage2,e500mc64_mu_stage3+e500mc64_retire")

;; Divide. We use the average latency time here.
(define_insn_reservation "e500mc64_divide" 14
  (and (eq_attr "type" "div")
       (eq_attr "cpu" "ppce500mc64"))
  "e500mc64_decode,e500mc64_issue+e500mc64_mu_stage0+e500mc64_mu_div,\
   e500mc64_mu_div*13")

;; Branch.
(define_insn_reservation "e500mc64_branch" 1
  (and (eq_attr "type" "jmpreg,branch,isync")
       (eq_attr "cpu" "ppce500mc64"))
  "e500mc64_decode,e500mc64_bu,e500mc64_retire")

;; CR logical.
(define_insn_reservation "e500mc64_cr_logical" 1
  (and (eq_attr "type" "cr_logical,delayed_cr")
       (eq_attr "cpu" "ppce500mc64"))
  "e500mc64_decode,e500mc64_bu,e500mc64_retire")

;; Mfcr.
(define_insn_reservation "e500mc64_mfcr" 4
  (and (eq_attr "type" "mfcr")
       (eq_attr "cpu" "ppce500mc64"))
  "e500mc64_decode,e500mc64_issue+e500mc64_su1_stage0,e500mc64_su1_stage0*3+e500mc64_retire")

;; Mtcrf.
(define_insn_reservation "e500mc64_mtcrf" 1
  (and (eq_attr "type" "mtcr")
       (eq_attr "cpu" "ppce500mc64"))
  "e500mc64_decode,e500mc64_issue+e500mc64_su1_stage0+e500mc64_retire")

;; Mtjmpr.
(define_insn_reservation "e500mc64_mtjmpr" 1
  (and (eq_attr "type" "mtjmpr,mfjmpr")
       (eq_attr "cpu" "ppce500mc64"))
  "e500mc64_decode,e500mc64_issue+e500mc64_su_stage0+e500mc64_retire")

;; Brinc.
(define_insn_reservation "e500mc64_brinc" 1
  (and (eq_attr "type" "brinc")
       (eq_attr "cpu" "ppce500mc64"))
  "e500mc64_decode,e500mc64_issue+e500mc64_su_stage0+e500mc64_retire")

;; Loads.
(define_insn_reservation "e500mc64_load" 3
  (and (eq_attr "type" "load,load_l,sync")
       (eq_attr "cpu" "ppce500mc64"))
  "e500mc64_decode,e500mc64_issue+e500mc64_lsu,nothing,e500mc64_retire")

(define_insn_reservation "e500mc64_fpload" 4
  (and (eq_attr "type" "fpload")
       (eq_attr "cpu" "ppce500mc64"))
  "e500mc64_decode,e500mc64_issue+e500mc64_lsu,nothing*2,e500mc64_retire")

;; Stores.
(define_insn_reservation "e500mc64_store" 3
  (and (eq_attr "type" "store,store_c")
       (eq_attr "cpu" "ppce500mc64"))
  "e500mc64_decode,e500mc64_issue+e500mc64_lsu,nothing,e500mc64_retire")

(define_insn_reservation "e500mc64_fpstore" 3
  (and (eq_attr "type" "fpstore")
       (eq_attr "cpu" "ppce500mc64"))
  "e500mc64_decode,e500mc64_issue+e500mc64_lsu,nothing,e500mc64_retire")

;; The following ignores the retire unit to avoid a large automata.

;; FP.
(define_insn_reservation "e500mc64_float" 7
  (and (eq_attr "type" "fpsimple,fp,fpcompare,dmul")
       (eq_attr "cpu" "ppce500mc64"))
  "e500mc64_decode,e500mc64_issue+e500mc64_fpu")
; "e500mc64_decode,e500mc64_issue+e500mc64_fpu,nothing*5,e500mc64_retire")

;; FP divides are not pipelined.
(define_insn_reservation "e500mc64_sdiv" 20
  (and (eq_attr "type" "sdiv")
       (eq_attr "cpu" "ppce500mc64"))
  "e500mc64_decode,e500mc64_issue+e500mc64_fpu,e500mc64_fpu*19")

(define_insn_reservation "e500mc64_ddiv" 35
  (and (eq_attr "type" "ddiv")
       (eq_attr "cpu" "ppce500mc64"))
  "e500mc64_decode,e500mc64_issue+e500mc64_fpu,e500mc64_fpu*34")
