/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.format.FormatUtils;

public abstract class AbstractDuration
implements ReadableDuration {
    protected AbstractDuration() {
    }

    public Duration toDuration() {
        return new Duration(this.getMillis());
    }

    public Period toPeriod() {
        return new Period(this.getMillis());
    }

    public int compareTo(Object object) {
        long l;
        AbstractDuration abstractDuration = this;
        ReadableDuration readableDuration = (ReadableDuration)object;
        long l2 = abstractDuration.getMillis();
        if (l2 < (l = readableDuration.getMillis())) {
            return -1;
        }
        if (l2 > l) {
            return 1;
        }
        return 0;
    }

    public boolean isEqual(ReadableDuration readableDuration) {
        if (readableDuration == null) {
            readableDuration = Duration.ZERO;
        }
        return this.compareTo(readableDuration) == 0;
    }

    public boolean isLongerThan(ReadableDuration readableDuration) {
        if (readableDuration == null) {
            readableDuration = Duration.ZERO;
        }
        return this.compareTo(readableDuration) > 0;
    }

    public boolean isShorterThan(ReadableDuration readableDuration) {
        if (readableDuration == null) {
            readableDuration = Duration.ZERO;
        }
        return this.compareTo(readableDuration) < 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ReadableDuration)) {
            return false;
        }
        ReadableDuration readableDuration = (ReadableDuration)object;
        return this.getMillis() == readableDuration.getMillis();
    }

    public int hashCode() {
        long l = this.getMillis();
        return (int)(l ^ l >>> 32);
    }

    public String toString() {
        long l = this.getMillis();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PT");
        FormatUtils.appendUnpaddedInteger(stringBuffer, l / 1000L);
        long l2 = Math.abs(l % 1000L);
        if (l2 > 0L) {
            stringBuffer.append('.');
            FormatUtils.appendPaddedInteger(stringBuffer, l2, 3);
        }
        stringBuffer.append('S');
        return stringBuffer.toString();
    }
}

