﻿// <auto-generated />

using System;
using System.Collections.Generic;
using Microsoft.AspNetCore.Razor.Language.Legacy;

namespace Microsoft.AspNetCore.Razor.Language.Syntax;

internal partial class SyntaxVisitor<TResult>
{
    /// <summary>Called when the visitor visits a RazorDocumentSyntax node.</summary>
    public virtual TResult VisitRazorDocument(RazorDocumentSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a RazorCommentBlockSyntax node.</summary>
    public virtual TResult VisitRazorCommentBlock(RazorCommentBlockSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a RazorMetaCodeSyntax node.</summary>
    public virtual TResult VisitRazorMetaCode(RazorMetaCodeSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a GenericBlockSyntax node.</summary>
    public virtual TResult VisitGenericBlock(GenericBlockSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a UnclassifiedTextLiteralSyntax node.</summary>
    public virtual TResult VisitUnclassifiedTextLiteral(UnclassifiedTextLiteralSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupBlockSyntax node.</summary>
    public virtual TResult VisitMarkupBlock(MarkupBlockSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupTransitionSyntax node.</summary>
    public virtual TResult VisitMarkupTransition(MarkupTransitionSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupTextLiteralSyntax node.</summary>
    public virtual TResult VisitMarkupTextLiteral(MarkupTextLiteralSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupEphemeralTextLiteralSyntax node.</summary>
    public virtual TResult VisitMarkupEphemeralTextLiteral(MarkupEphemeralTextLiteralSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupCommentBlockSyntax node.</summary>
    public virtual TResult VisitMarkupCommentBlock(MarkupCommentBlockSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupMinimizedAttributeBlockSyntax node.</summary>
    public virtual TResult VisitMarkupMinimizedAttributeBlock(MarkupMinimizedAttributeBlockSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupAttributeBlockSyntax node.</summary>
    public virtual TResult VisitMarkupAttributeBlock(MarkupAttributeBlockSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupMiscAttributeContentSyntax node.</summary>
    public virtual TResult VisitMarkupMiscAttributeContent(MarkupMiscAttributeContentSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupLiteralAttributeValueSyntax node.</summary>
    public virtual TResult VisitMarkupLiteralAttributeValue(MarkupLiteralAttributeValueSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupDynamicAttributeValueSyntax node.</summary>
    public virtual TResult VisitMarkupDynamicAttributeValue(MarkupDynamicAttributeValueSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupElementSyntax node.</summary>
    public virtual TResult VisitMarkupElement(MarkupElementSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupStartTagSyntax node.</summary>
    public virtual TResult VisitMarkupStartTag(MarkupStartTagSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupEndTagSyntax node.</summary>
    public virtual TResult VisitMarkupEndTag(MarkupEndTagSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupTagHelperElementSyntax node.</summary>
    public virtual TResult VisitMarkupTagHelperElement(MarkupTagHelperElementSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupTagHelperStartTagSyntax node.</summary>
    public virtual TResult VisitMarkupTagHelperStartTag(MarkupTagHelperStartTagSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupTagHelperEndTagSyntax node.</summary>
    public virtual TResult VisitMarkupTagHelperEndTag(MarkupTagHelperEndTagSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupTagHelperAttributeSyntax node.</summary>
    public virtual TResult VisitMarkupTagHelperAttribute(MarkupTagHelperAttributeSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupMinimizedTagHelperAttributeSyntax node.</summary>
    public virtual TResult VisitMarkupMinimizedTagHelperAttribute(MarkupMinimizedTagHelperAttributeSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupTagHelperAttributeValueSyntax node.</summary>
    public virtual TResult VisitMarkupTagHelperAttributeValue(MarkupTagHelperAttributeValueSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupTagHelperDirectiveAttributeSyntax node.</summary>
    public virtual TResult VisitMarkupTagHelperDirectiveAttribute(MarkupTagHelperDirectiveAttributeSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupMinimizedTagHelperDirectiveAttributeSyntax node.</summary>
    public virtual TResult VisitMarkupMinimizedTagHelperDirectiveAttribute(MarkupMinimizedTagHelperDirectiveAttributeSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a CSharpCodeBlockSyntax node.</summary>
    public virtual TResult VisitCSharpCodeBlock(CSharpCodeBlockSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a CSharpTransitionSyntax node.</summary>
    public virtual TResult VisitCSharpTransition(CSharpTransitionSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a CSharpStatementLiteralSyntax node.</summary>
    public virtual TResult VisitCSharpStatementLiteral(CSharpStatementLiteralSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a CSharpExpressionLiteralSyntax node.</summary>
    public virtual TResult VisitCSharpExpressionLiteral(CSharpExpressionLiteralSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a CSharpEphemeralTextLiteralSyntax node.</summary>
    public virtual TResult VisitCSharpEphemeralTextLiteral(CSharpEphemeralTextLiteralSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a CSharpTemplateBlockSyntax node.</summary>
    public virtual TResult VisitCSharpTemplateBlock(CSharpTemplateBlockSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a CSharpStatementSyntax node.</summary>
    public virtual TResult VisitCSharpStatement(CSharpStatementSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a CSharpStatementBodySyntax node.</summary>
    public virtual TResult VisitCSharpStatementBody(CSharpStatementBodySyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a CSharpExplicitExpressionSyntax node.</summary>
    public virtual TResult VisitCSharpExplicitExpression(CSharpExplicitExpressionSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a CSharpExplicitExpressionBodySyntax node.</summary>
    public virtual TResult VisitCSharpExplicitExpressionBody(CSharpExplicitExpressionBodySyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a CSharpImplicitExpressionSyntax node.</summary>
    public virtual TResult VisitCSharpImplicitExpression(CSharpImplicitExpressionSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a CSharpImplicitExpressionBodySyntax node.</summary>
    public virtual TResult VisitCSharpImplicitExpressionBody(CSharpImplicitExpressionBodySyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a RazorDirectiveSyntax node.</summary>
    public virtual TResult VisitRazorDirective(RazorDirectiveSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a RazorDirectiveBodySyntax node.</summary>
    public virtual TResult VisitRazorDirectiveBody(RazorDirectiveBodySyntax node) => DefaultVisit(node);
}

internal partial class SyntaxVisitor
{
    /// <summary>Called when the visitor visits a RazorDocumentSyntax node.</summary>
    public virtual void VisitRazorDocument(RazorDocumentSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a RazorCommentBlockSyntax node.</summary>
    public virtual void VisitRazorCommentBlock(RazorCommentBlockSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a RazorMetaCodeSyntax node.</summary>
    public virtual void VisitRazorMetaCode(RazorMetaCodeSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a GenericBlockSyntax node.</summary>
    public virtual void VisitGenericBlock(GenericBlockSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a UnclassifiedTextLiteralSyntax node.</summary>
    public virtual void VisitUnclassifiedTextLiteral(UnclassifiedTextLiteralSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupBlockSyntax node.</summary>
    public virtual void VisitMarkupBlock(MarkupBlockSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupTransitionSyntax node.</summary>
    public virtual void VisitMarkupTransition(MarkupTransitionSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupTextLiteralSyntax node.</summary>
    public virtual void VisitMarkupTextLiteral(MarkupTextLiteralSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupEphemeralTextLiteralSyntax node.</summary>
    public virtual void VisitMarkupEphemeralTextLiteral(MarkupEphemeralTextLiteralSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupCommentBlockSyntax node.</summary>
    public virtual void VisitMarkupCommentBlock(MarkupCommentBlockSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupMinimizedAttributeBlockSyntax node.</summary>
    public virtual void VisitMarkupMinimizedAttributeBlock(MarkupMinimizedAttributeBlockSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupAttributeBlockSyntax node.</summary>
    public virtual void VisitMarkupAttributeBlock(MarkupAttributeBlockSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupMiscAttributeContentSyntax node.</summary>
    public virtual void VisitMarkupMiscAttributeContent(MarkupMiscAttributeContentSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupLiteralAttributeValueSyntax node.</summary>
    public virtual void VisitMarkupLiteralAttributeValue(MarkupLiteralAttributeValueSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupDynamicAttributeValueSyntax node.</summary>
    public virtual void VisitMarkupDynamicAttributeValue(MarkupDynamicAttributeValueSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupElementSyntax node.</summary>
    public virtual void VisitMarkupElement(MarkupElementSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupStartTagSyntax node.</summary>
    public virtual void VisitMarkupStartTag(MarkupStartTagSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupEndTagSyntax node.</summary>
    public virtual void VisitMarkupEndTag(MarkupEndTagSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupTagHelperElementSyntax node.</summary>
    public virtual void VisitMarkupTagHelperElement(MarkupTagHelperElementSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupTagHelperStartTagSyntax node.</summary>
    public virtual void VisitMarkupTagHelperStartTag(MarkupTagHelperStartTagSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupTagHelperEndTagSyntax node.</summary>
    public virtual void VisitMarkupTagHelperEndTag(MarkupTagHelperEndTagSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupTagHelperAttributeSyntax node.</summary>
    public virtual void VisitMarkupTagHelperAttribute(MarkupTagHelperAttributeSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupMinimizedTagHelperAttributeSyntax node.</summary>
    public virtual void VisitMarkupMinimizedTagHelperAttribute(MarkupMinimizedTagHelperAttributeSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupTagHelperAttributeValueSyntax node.</summary>
    public virtual void VisitMarkupTagHelperAttributeValue(MarkupTagHelperAttributeValueSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupTagHelperDirectiveAttributeSyntax node.</summary>
    public virtual void VisitMarkupTagHelperDirectiveAttribute(MarkupTagHelperDirectiveAttributeSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a MarkupMinimizedTagHelperDirectiveAttributeSyntax node.</summary>
    public virtual void VisitMarkupMinimizedTagHelperDirectiveAttribute(MarkupMinimizedTagHelperDirectiveAttributeSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a CSharpCodeBlockSyntax node.</summary>
    public virtual void VisitCSharpCodeBlock(CSharpCodeBlockSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a CSharpTransitionSyntax node.</summary>
    public virtual void VisitCSharpTransition(CSharpTransitionSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a CSharpStatementLiteralSyntax node.</summary>
    public virtual void VisitCSharpStatementLiteral(CSharpStatementLiteralSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a CSharpExpressionLiteralSyntax node.</summary>
    public virtual void VisitCSharpExpressionLiteral(CSharpExpressionLiteralSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a CSharpEphemeralTextLiteralSyntax node.</summary>
    public virtual void VisitCSharpEphemeralTextLiteral(CSharpEphemeralTextLiteralSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a CSharpTemplateBlockSyntax node.</summary>
    public virtual void VisitCSharpTemplateBlock(CSharpTemplateBlockSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a CSharpStatementSyntax node.</summary>
    public virtual void VisitCSharpStatement(CSharpStatementSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a CSharpStatementBodySyntax node.</summary>
    public virtual void VisitCSharpStatementBody(CSharpStatementBodySyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a CSharpExplicitExpressionSyntax node.</summary>
    public virtual void VisitCSharpExplicitExpression(CSharpExplicitExpressionSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a CSharpExplicitExpressionBodySyntax node.</summary>
    public virtual void VisitCSharpExplicitExpressionBody(CSharpExplicitExpressionBodySyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a CSharpImplicitExpressionSyntax node.</summary>
    public virtual void VisitCSharpImplicitExpression(CSharpImplicitExpressionSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a CSharpImplicitExpressionBodySyntax node.</summary>
    public virtual void VisitCSharpImplicitExpressionBody(CSharpImplicitExpressionBodySyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a RazorDirectiveSyntax node.</summary>
    public virtual void VisitRazorDirective(RazorDirectiveSyntax node) => DefaultVisit(node);

    /// <summary>Called when the visitor visits a RazorDirectiveBodySyntax node.</summary>
    public virtual void VisitRazorDirectiveBody(RazorDirectiveBodySyntax node) => DefaultVisit(node);
}

internal partial class SyntaxRewriter : SyntaxVisitor<SyntaxNode>
{
    public override SyntaxNode VisitRazorDocument(RazorDocumentSyntax node)
        => node.Update((RazorBlockSyntax)Visit(node.Document), (SyntaxToken)VisitToken(node.EndOfFile));

    public override SyntaxNode VisitRazorCommentBlock(RazorCommentBlockSyntax node)
        => node.Update((SyntaxToken)VisitToken(node.StartCommentTransition), (SyntaxToken)VisitToken(node.StartCommentStar), (SyntaxToken)VisitToken(node.Comment), (SyntaxToken)VisitToken(node.EndCommentStar), (SyntaxToken)VisitToken(node.EndCommentTransition));

    public override SyntaxNode VisitRazorMetaCode(RazorMetaCodeSyntax node)
        => node.Update(VisitList(node.MetaCode), node.ChunkGenerator);

    public override SyntaxNode VisitGenericBlock(GenericBlockSyntax node)
        => node.Update(VisitList(node.Children));

    public override SyntaxNode VisitUnclassifiedTextLiteral(UnclassifiedTextLiteralSyntax node)
        => node.Update(VisitList(node.LiteralTokens), node.ChunkGenerator);

    public override SyntaxNode VisitMarkupBlock(MarkupBlockSyntax node)
        => node.Update(VisitList(node.Children));

    public override SyntaxNode VisitMarkupTransition(MarkupTransitionSyntax node)
        => node.Update(VisitList(node.TransitionTokens), node.ChunkGenerator);

    public override SyntaxNode VisitMarkupTextLiteral(MarkupTextLiteralSyntax node)
        => node.Update(VisitList(node.LiteralTokens), node.ChunkGenerator);

    public override SyntaxNode VisitMarkupEphemeralTextLiteral(MarkupEphemeralTextLiteralSyntax node)
        => node.Update(VisitList(node.LiteralTokens), node.ChunkGenerator);

    public override SyntaxNode VisitMarkupCommentBlock(MarkupCommentBlockSyntax node)
        => node.Update(VisitList(node.Children));

    public override SyntaxNode VisitMarkupMinimizedAttributeBlock(MarkupMinimizedAttributeBlockSyntax node)
        => node.Update((MarkupTextLiteralSyntax)Visit(node.NamePrefix), (MarkupTextLiteralSyntax)Visit(node.Name));

    public override SyntaxNode VisitMarkupAttributeBlock(MarkupAttributeBlockSyntax node)
        => node.Update((MarkupTextLiteralSyntax)Visit(node.NamePrefix), (MarkupTextLiteralSyntax)Visit(node.Name), (MarkupTextLiteralSyntax)Visit(node.NameSuffix), (SyntaxToken)VisitToken(node.EqualsToken), (MarkupTextLiteralSyntax)Visit(node.ValuePrefix), (RazorBlockSyntax)Visit(node.Value), (MarkupTextLiteralSyntax)Visit(node.ValueSuffix));

    public override SyntaxNode VisitMarkupMiscAttributeContent(MarkupMiscAttributeContentSyntax node)
        => node.Update(VisitList(node.Children));

    public override SyntaxNode VisitMarkupLiteralAttributeValue(MarkupLiteralAttributeValueSyntax node)
        => node.Update((MarkupTextLiteralSyntax)Visit(node.Prefix), (MarkupTextLiteralSyntax)Visit(node.Value));

    public override SyntaxNode VisitMarkupDynamicAttributeValue(MarkupDynamicAttributeValueSyntax node)
        => node.Update((MarkupTextLiteralSyntax)Visit(node.Prefix), (RazorBlockSyntax)Visit(node.Value));

    public override SyntaxNode VisitMarkupElement(MarkupElementSyntax node)
        => node.Update((MarkupStartTagSyntax)Visit(node.StartTag), VisitList(node.Body), (MarkupEndTagSyntax)Visit(node.EndTag));

    public override SyntaxNode VisitMarkupStartTag(MarkupStartTagSyntax node)
        => node.Update((SyntaxToken)VisitToken(node.OpenAngle), (SyntaxToken)VisitToken(node.Bang), (SyntaxToken)VisitToken(node.Name), VisitList(node.Attributes), (SyntaxToken)VisitToken(node.ForwardSlash), (SyntaxToken)VisitToken(node.CloseAngle), node.ChunkGenerator);

    public override SyntaxNode VisitMarkupEndTag(MarkupEndTagSyntax node)
        => node.Update((SyntaxToken)VisitToken(node.OpenAngle), (SyntaxToken)VisitToken(node.ForwardSlash), (SyntaxToken)VisitToken(node.Bang), (SyntaxToken)VisitToken(node.Name), (MarkupMiscAttributeContentSyntax)Visit(node.MiscAttributeContent), (SyntaxToken)VisitToken(node.CloseAngle), node.ChunkGenerator);

    public override SyntaxNode VisitMarkupTagHelperElement(MarkupTagHelperElementSyntax node)
        => node.Update((MarkupTagHelperStartTagSyntax)Visit(node.StartTag), VisitList(node.Body), (MarkupTagHelperEndTagSyntax)Visit(node.EndTag));

    public override SyntaxNode VisitMarkupTagHelperStartTag(MarkupTagHelperStartTagSyntax node)
        => node.Update((SyntaxToken)VisitToken(node.OpenAngle), (SyntaxToken)VisitToken(node.Bang), (SyntaxToken)VisitToken(node.Name), VisitList(node.Attributes), (SyntaxToken)VisitToken(node.ForwardSlash), (SyntaxToken)VisitToken(node.CloseAngle), node.ChunkGenerator);

    public override SyntaxNode VisitMarkupTagHelperEndTag(MarkupTagHelperEndTagSyntax node)
        => node.Update((SyntaxToken)VisitToken(node.OpenAngle), (SyntaxToken)VisitToken(node.ForwardSlash), (SyntaxToken)VisitToken(node.Bang), (SyntaxToken)VisitToken(node.Name), (MarkupMiscAttributeContentSyntax)Visit(node.MiscAttributeContent), (SyntaxToken)VisitToken(node.CloseAngle), node.ChunkGenerator);

    public override SyntaxNode VisitMarkupTagHelperAttribute(MarkupTagHelperAttributeSyntax node)
        => node.Update((MarkupTextLiteralSyntax)Visit(node.NamePrefix), (MarkupTextLiteralSyntax)Visit(node.Name), (MarkupTextLiteralSyntax)Visit(node.NameSuffix), (SyntaxToken)VisitToken(node.EqualsToken), (MarkupTextLiteralSyntax)Visit(node.ValuePrefix), (MarkupTagHelperAttributeValueSyntax)Visit(node.Value), (MarkupTextLiteralSyntax)Visit(node.ValueSuffix));

    public override SyntaxNode VisitMarkupMinimizedTagHelperAttribute(MarkupMinimizedTagHelperAttributeSyntax node)
        => node.Update((MarkupTextLiteralSyntax)Visit(node.NamePrefix), (MarkupTextLiteralSyntax)Visit(node.Name));

    public override SyntaxNode VisitMarkupTagHelperAttributeValue(MarkupTagHelperAttributeValueSyntax node)
        => node.Update(VisitList(node.Children));

    public override SyntaxNode VisitMarkupTagHelperDirectiveAttribute(MarkupTagHelperDirectiveAttributeSyntax node)
        => node.Update((MarkupTextLiteralSyntax)Visit(node.NamePrefix), (RazorMetaCodeSyntax)Visit(node.Transition), (MarkupTextLiteralSyntax)Visit(node.Name), (RazorMetaCodeSyntax)Visit(node.Colon), (MarkupTextLiteralSyntax)Visit(node.ParameterName), (MarkupTextLiteralSyntax)Visit(node.NameSuffix), (SyntaxToken)VisitToken(node.EqualsToken), (MarkupTextLiteralSyntax)Visit(node.ValuePrefix), (MarkupTagHelperAttributeValueSyntax)Visit(node.Value), (MarkupTextLiteralSyntax)Visit(node.ValueSuffix));

    public override SyntaxNode VisitMarkupMinimizedTagHelperDirectiveAttribute(MarkupMinimizedTagHelperDirectiveAttributeSyntax node)
        => node.Update((MarkupTextLiteralSyntax)Visit(node.NamePrefix), (RazorMetaCodeSyntax)Visit(node.Transition), (MarkupTextLiteralSyntax)Visit(node.Name), (RazorMetaCodeSyntax)Visit(node.Colon), (MarkupTextLiteralSyntax)Visit(node.ParameterName));

    public override SyntaxNode VisitCSharpCodeBlock(CSharpCodeBlockSyntax node)
        => node.Update(VisitList(node.Children));

    public override SyntaxNode VisitCSharpTransition(CSharpTransitionSyntax node)
        => node.Update((SyntaxToken)VisitToken(node.Transition), node.ChunkGenerator);

    public override SyntaxNode VisitCSharpStatementLiteral(CSharpStatementLiteralSyntax node)
        => node.Update(VisitList(node.LiteralTokens), node.ChunkGenerator);

    public override SyntaxNode VisitCSharpExpressionLiteral(CSharpExpressionLiteralSyntax node)
        => node.Update(VisitList(node.LiteralTokens), node.ChunkGenerator);

    public override SyntaxNode VisitCSharpEphemeralTextLiteral(CSharpEphemeralTextLiteralSyntax node)
        => node.Update(VisitList(node.LiteralTokens), node.ChunkGenerator);

    public override SyntaxNode VisitCSharpTemplateBlock(CSharpTemplateBlockSyntax node)
        => node.Update(VisitList(node.Children));

    public override SyntaxNode VisitCSharpStatement(CSharpStatementSyntax node)
        => node.Update((CSharpTransitionSyntax)Visit(node.Transition), (CSharpSyntaxNode)Visit(node.Body));

    public override SyntaxNode VisitCSharpStatementBody(CSharpStatementBodySyntax node)
        => node.Update((RazorMetaCodeSyntax)Visit(node.OpenBrace), (CSharpCodeBlockSyntax)Visit(node.CSharpCode), (RazorMetaCodeSyntax)Visit(node.CloseBrace));

    public override SyntaxNode VisitCSharpExplicitExpression(CSharpExplicitExpressionSyntax node)
        => node.Update((CSharpTransitionSyntax)Visit(node.Transition), (CSharpSyntaxNode)Visit(node.Body));

    public override SyntaxNode VisitCSharpExplicitExpressionBody(CSharpExplicitExpressionBodySyntax node)
        => node.Update((RazorMetaCodeSyntax)Visit(node.OpenParen), (CSharpCodeBlockSyntax)Visit(node.CSharpCode), (RazorMetaCodeSyntax)Visit(node.CloseParen));

    public override SyntaxNode VisitCSharpImplicitExpression(CSharpImplicitExpressionSyntax node)
        => node.Update((CSharpTransitionSyntax)Visit(node.Transition), (CSharpSyntaxNode)Visit(node.Body));

    public override SyntaxNode VisitCSharpImplicitExpressionBody(CSharpImplicitExpressionBodySyntax node)
        => node.Update((CSharpCodeBlockSyntax)Visit(node.CSharpCode));

    public override SyntaxNode VisitRazorDirective(RazorDirectiveSyntax node)
        => node.Update((CSharpTransitionSyntax)Visit(node.Transition), (CSharpSyntaxNode)Visit(node.Body));

    public override SyntaxNode VisitRazorDirectiveBody(RazorDirectiveBodySyntax node)
        => node.Update((RazorSyntaxNode)Visit(node.Keyword), (CSharpCodeBlockSyntax)Visit(node.CSharpCode));
}

internal static partial class SyntaxFactory
{
    /// <summary>Creates a new RazorDocumentSyntax instance.</summary>
    public static RazorDocumentSyntax RazorDocument(RazorBlockSyntax document, SyntaxToken endOfFile)
    {
        ArgHelper.ThrowIfNull(document);
        if (endOfFile.Kind is not (SyntaxKind.EndOfFile)) return ThrowHelper.ThrowArgumentException<RazorDocumentSyntax>(nameof(endOfFile), $"Invalid SyntaxKind. Expected 'SyntaxKind.EndOfFile', but it was {endOfFile.Kind}");
        return (RazorDocumentSyntax)InternalSyntax.SyntaxFactory.RazorDocument(document == null ? null : (InternalSyntax.RazorBlockSyntax)document.Green, (Syntax.InternalSyntax.SyntaxToken)endOfFile.Node).CreateRed();
    }

    /// <summary>Creates a new RazorDocumentSyntax instance.</summary>
    public static RazorDocumentSyntax RazorDocument(RazorBlockSyntax document)
        => SyntaxFactory.RazorDocument(document, SyntaxFactory.Token(SyntaxKind.EndOfFile));

    /// <summary>Creates a new RazorCommentBlockSyntax instance.</summary>
    public static RazorCommentBlockSyntax RazorCommentBlock(SyntaxToken startCommentTransition, SyntaxToken startCommentStar, SyntaxToken comment, SyntaxToken endCommentStar, SyntaxToken endCommentTransition)
    {
        if (startCommentTransition.Kind is not (SyntaxKind.RazorCommentTransition)) return ThrowHelper.ThrowArgumentException<RazorCommentBlockSyntax>(nameof(startCommentTransition), $"Invalid SyntaxKind. Expected 'SyntaxKind.RazorCommentTransition', but it was {startCommentTransition.Kind}");
        if (startCommentStar.Kind is not (SyntaxKind.RazorCommentStar)) return ThrowHelper.ThrowArgumentException<RazorCommentBlockSyntax>(nameof(startCommentStar), $"Invalid SyntaxKind. Expected 'SyntaxKind.RazorCommentStar', but it was {startCommentStar.Kind}");
        if (comment.Kind is not (SyntaxKind.RazorCommentLiteral)) return ThrowHelper.ThrowArgumentException<RazorCommentBlockSyntax>(nameof(comment), $"Invalid SyntaxKind. Expected 'SyntaxKind.RazorCommentLiteral', but it was {comment.Kind}");
        if (endCommentStar.Kind is not (SyntaxKind.RazorCommentStar)) return ThrowHelper.ThrowArgumentException<RazorCommentBlockSyntax>(nameof(endCommentStar), $"Invalid SyntaxKind. Expected 'SyntaxKind.RazorCommentStar', but it was {endCommentStar.Kind}");
        if (endCommentTransition.Kind is not (SyntaxKind.RazorCommentTransition)) return ThrowHelper.ThrowArgumentException<RazorCommentBlockSyntax>(nameof(endCommentTransition), $"Invalid SyntaxKind. Expected 'SyntaxKind.RazorCommentTransition', but it was {endCommentTransition.Kind}");
        return (RazorCommentBlockSyntax)InternalSyntax.SyntaxFactory.RazorCommentBlock((Syntax.InternalSyntax.SyntaxToken)startCommentTransition.Node, (Syntax.InternalSyntax.SyntaxToken)startCommentStar.Node, (Syntax.InternalSyntax.SyntaxToken)comment.Node, (Syntax.InternalSyntax.SyntaxToken)endCommentStar.Node, (Syntax.InternalSyntax.SyntaxToken)endCommentTransition.Node).CreateRed();
    }

    /// <summary>Creates a new RazorCommentBlockSyntax instance.</summary>
    public static RazorCommentBlockSyntax RazorCommentBlock()
        => SyntaxFactory.RazorCommentBlock(SyntaxFactory.Token(SyntaxKind.RazorCommentTransition), SyntaxFactory.Token(SyntaxKind.RazorCommentStar), SyntaxFactory.Token(SyntaxKind.RazorCommentLiteral), SyntaxFactory.Token(SyntaxKind.RazorCommentStar), SyntaxFactory.Token(SyntaxKind.RazorCommentTransition));

    /// <summary>Creates a new RazorMetaCodeSyntax instance.</summary>
    public static RazorMetaCodeSyntax RazorMetaCode(SyntaxTokenList metaCode, ISpanChunkGenerator chunkGenerator)
        => (RazorMetaCodeSyntax)InternalSyntax.SyntaxFactory.RazorMetaCode(metaCode.Node.ToGreenList<InternalSyntax.SyntaxToken>(), chunkGenerator).CreateRed();

    /// <summary>Creates a new RazorMetaCodeSyntax instance.</summary>
    public static RazorMetaCodeSyntax RazorMetaCode(ISpanChunkGenerator chunkGenerator)
        => SyntaxFactory.RazorMetaCode(default(SyntaxTokenList), chunkGenerator);

    /// <summary>Creates a new GenericBlockSyntax instance.</summary>
    public static GenericBlockSyntax GenericBlock(SyntaxList<RazorSyntaxNode> children)
        => (GenericBlockSyntax)InternalSyntax.SyntaxFactory.GenericBlock(children.Node.ToGreenList<InternalSyntax.RazorSyntaxNode>()).CreateRed();

    /// <summary>Creates a new GenericBlockSyntax instance.</summary>
    public static GenericBlockSyntax GenericBlock()
        => SyntaxFactory.GenericBlock(default(SyntaxList<RazorSyntaxNode>));

    /// <summary>Creates a new UnclassifiedTextLiteralSyntax instance.</summary>
    public static UnclassifiedTextLiteralSyntax UnclassifiedTextLiteral(SyntaxTokenList literalTokens, ISpanChunkGenerator chunkGenerator)
        => (UnclassifiedTextLiteralSyntax)InternalSyntax.SyntaxFactory.UnclassifiedTextLiteral(literalTokens.Node.ToGreenList<InternalSyntax.SyntaxToken>(), chunkGenerator).CreateRed();

    /// <summary>Creates a new UnclassifiedTextLiteralSyntax instance.</summary>
    public static UnclassifiedTextLiteralSyntax UnclassifiedTextLiteral(ISpanChunkGenerator chunkGenerator)
        => SyntaxFactory.UnclassifiedTextLiteral(default(SyntaxTokenList), chunkGenerator);

    /// <summary>Creates a new MarkupBlockSyntax instance.</summary>
    public static MarkupBlockSyntax MarkupBlock(SyntaxList<RazorSyntaxNode> children)
        => (MarkupBlockSyntax)InternalSyntax.SyntaxFactory.MarkupBlock(children.Node.ToGreenList<InternalSyntax.RazorSyntaxNode>()).CreateRed();

    /// <summary>Creates a new MarkupBlockSyntax instance.</summary>
    public static MarkupBlockSyntax MarkupBlock()
        => SyntaxFactory.MarkupBlock(default(SyntaxList<RazorSyntaxNode>));

    /// <summary>Creates a new MarkupTransitionSyntax instance.</summary>
    public static MarkupTransitionSyntax MarkupTransition(SyntaxTokenList transitionTokens, ISpanChunkGenerator chunkGenerator)
        => (MarkupTransitionSyntax)InternalSyntax.SyntaxFactory.MarkupTransition(transitionTokens.Node.ToGreenList<InternalSyntax.SyntaxToken>(), chunkGenerator).CreateRed();

    /// <summary>Creates a new MarkupTransitionSyntax instance.</summary>
    public static MarkupTransitionSyntax MarkupTransition(ISpanChunkGenerator chunkGenerator)
        => SyntaxFactory.MarkupTransition(default(SyntaxTokenList), chunkGenerator);

    /// <summary>Creates a new MarkupTextLiteralSyntax instance.</summary>
    public static MarkupTextLiteralSyntax MarkupTextLiteral(SyntaxTokenList literalTokens, ISpanChunkGenerator chunkGenerator)
        => (MarkupTextLiteralSyntax)InternalSyntax.SyntaxFactory.MarkupTextLiteral(literalTokens.Node.ToGreenList<InternalSyntax.SyntaxToken>(), chunkGenerator).CreateRed();

    /// <summary>Creates a new MarkupTextLiteralSyntax instance.</summary>
    public static MarkupTextLiteralSyntax MarkupTextLiteral(ISpanChunkGenerator chunkGenerator)
        => SyntaxFactory.MarkupTextLiteral(default(SyntaxTokenList), chunkGenerator);

    /// <summary>Creates a new MarkupEphemeralTextLiteralSyntax instance.</summary>
    public static MarkupEphemeralTextLiteralSyntax MarkupEphemeralTextLiteral(SyntaxTokenList literalTokens, ISpanChunkGenerator chunkGenerator)
        => (MarkupEphemeralTextLiteralSyntax)InternalSyntax.SyntaxFactory.MarkupEphemeralTextLiteral(literalTokens.Node.ToGreenList<InternalSyntax.SyntaxToken>(), chunkGenerator).CreateRed();

    /// <summary>Creates a new MarkupEphemeralTextLiteralSyntax instance.</summary>
    public static MarkupEphemeralTextLiteralSyntax MarkupEphemeralTextLiteral(ISpanChunkGenerator chunkGenerator)
        => SyntaxFactory.MarkupEphemeralTextLiteral(default(SyntaxTokenList), chunkGenerator);

    /// <summary>Creates a new MarkupCommentBlockSyntax instance.</summary>
    public static MarkupCommentBlockSyntax MarkupCommentBlock(SyntaxList<RazorSyntaxNode> children)
        => (MarkupCommentBlockSyntax)InternalSyntax.SyntaxFactory.MarkupCommentBlock(children.Node.ToGreenList<InternalSyntax.RazorSyntaxNode>()).CreateRed();

    /// <summary>Creates a new MarkupCommentBlockSyntax instance.</summary>
    public static MarkupCommentBlockSyntax MarkupCommentBlock()
        => SyntaxFactory.MarkupCommentBlock(default(SyntaxList<RazorSyntaxNode>));

    /// <summary>Creates a new MarkupMinimizedAttributeBlockSyntax instance.</summary>
    public static MarkupMinimizedAttributeBlockSyntax MarkupMinimizedAttributeBlock(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name)
    {
        ArgHelper.ThrowIfNull(name);
        return (MarkupMinimizedAttributeBlockSyntax)InternalSyntax.SyntaxFactory.MarkupMinimizedAttributeBlock(namePrefix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)namePrefix.Green, name == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)name.Green).CreateRed();
    }

    /// <summary>Creates a new MarkupMinimizedAttributeBlockSyntax instance.</summary>
    public static MarkupMinimizedAttributeBlockSyntax MarkupMinimizedAttributeBlock(MarkupTextLiteralSyntax name)
        => SyntaxFactory.MarkupMinimizedAttributeBlock(default(MarkupTextLiteralSyntax), name);

    /// <summary>Creates a new MarkupAttributeBlockSyntax instance.</summary>
    public static MarkupAttributeBlockSyntax MarkupAttributeBlock(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, RazorBlockSyntax value, MarkupTextLiteralSyntax valueSuffix)
    {
        ArgHelper.ThrowIfNull(name);
        if (equalsToken.Kind is not (SyntaxKind.Equals)) return ThrowHelper.ThrowArgumentException<MarkupAttributeBlockSyntax>(nameof(equalsToken), $"Invalid SyntaxKind. Expected 'SyntaxKind.Equals', but it was {equalsToken.Kind}");
        return (MarkupAttributeBlockSyntax)InternalSyntax.SyntaxFactory.MarkupAttributeBlock(namePrefix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)namePrefix.Green, name == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)name.Green, nameSuffix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)nameSuffix.Green, (Syntax.InternalSyntax.SyntaxToken)equalsToken.Node, valuePrefix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)valuePrefix.Green, value == null ? null : (InternalSyntax.RazorBlockSyntax)value.Green, valueSuffix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)valueSuffix.Green).CreateRed();
    }

    /// <summary>Creates a new MarkupAttributeBlockSyntax instance.</summary>
    public static MarkupAttributeBlockSyntax MarkupAttributeBlock(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name, MarkupTextLiteralSyntax nameSuffix, MarkupTextLiteralSyntax valuePrefix, RazorBlockSyntax value, MarkupTextLiteralSyntax valueSuffix)
        => SyntaxFactory.MarkupAttributeBlock(namePrefix, name, nameSuffix, SyntaxFactory.Token(SyntaxKind.Equals), valuePrefix, value, valueSuffix);

    /// <summary>Creates a new MarkupAttributeBlockSyntax instance.</summary>
    public static MarkupAttributeBlockSyntax MarkupAttributeBlock(MarkupTextLiteralSyntax name)
        => SyntaxFactory.MarkupAttributeBlock(default(MarkupTextLiteralSyntax), name, default(MarkupTextLiteralSyntax), SyntaxFactory.Token(SyntaxKind.Equals), default(MarkupTextLiteralSyntax), default(RazorBlockSyntax), default(MarkupTextLiteralSyntax));

    /// <summary>Creates a new MarkupMiscAttributeContentSyntax instance.</summary>
    public static MarkupMiscAttributeContentSyntax MarkupMiscAttributeContent(SyntaxList<RazorSyntaxNode> children)
        => (MarkupMiscAttributeContentSyntax)InternalSyntax.SyntaxFactory.MarkupMiscAttributeContent(children.Node.ToGreenList<InternalSyntax.RazorSyntaxNode>()).CreateRed();

    /// <summary>Creates a new MarkupMiscAttributeContentSyntax instance.</summary>
    public static MarkupMiscAttributeContentSyntax MarkupMiscAttributeContent()
        => SyntaxFactory.MarkupMiscAttributeContent(default(SyntaxList<RazorSyntaxNode>));

    /// <summary>Creates a new MarkupLiteralAttributeValueSyntax instance.</summary>
    public static MarkupLiteralAttributeValueSyntax MarkupLiteralAttributeValue(MarkupTextLiteralSyntax prefix, MarkupTextLiteralSyntax value)
        => (MarkupLiteralAttributeValueSyntax)InternalSyntax.SyntaxFactory.MarkupLiteralAttributeValue(prefix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)prefix.Green, value == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)value.Green).CreateRed();

    /// <summary>Creates a new MarkupLiteralAttributeValueSyntax instance.</summary>
    public static MarkupLiteralAttributeValueSyntax MarkupLiteralAttributeValue()
        => SyntaxFactory.MarkupLiteralAttributeValue(default(MarkupTextLiteralSyntax), default(MarkupTextLiteralSyntax));

    /// <summary>Creates a new MarkupDynamicAttributeValueSyntax instance.</summary>
    public static MarkupDynamicAttributeValueSyntax MarkupDynamicAttributeValue(MarkupTextLiteralSyntax prefix, RazorBlockSyntax value)
    {
        ArgHelper.ThrowIfNull(value);
        return (MarkupDynamicAttributeValueSyntax)InternalSyntax.SyntaxFactory.MarkupDynamicAttributeValue(prefix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)prefix.Green, value == null ? null : (InternalSyntax.RazorBlockSyntax)value.Green).CreateRed();
    }

    /// <summary>Creates a new MarkupDynamicAttributeValueSyntax instance.</summary>
    public static MarkupDynamicAttributeValueSyntax MarkupDynamicAttributeValue(RazorBlockSyntax value)
        => SyntaxFactory.MarkupDynamicAttributeValue(default(MarkupTextLiteralSyntax), value);

    /// <summary>Creates a new MarkupElementSyntax instance.</summary>
    public static MarkupElementSyntax MarkupElement(MarkupStartTagSyntax startTag, SyntaxList<RazorSyntaxNode> body, MarkupEndTagSyntax endTag)
        => (MarkupElementSyntax)InternalSyntax.SyntaxFactory.MarkupElement(startTag == null ? null : (InternalSyntax.MarkupStartTagSyntax)startTag.Green, body.Node.ToGreenList<InternalSyntax.RazorSyntaxNode>(), endTag == null ? null : (InternalSyntax.MarkupEndTagSyntax)endTag.Green).CreateRed();

    /// <summary>Creates a new MarkupElementSyntax instance.</summary>
    public static MarkupElementSyntax MarkupElement(SyntaxList<RazorSyntaxNode> body = default(SyntaxList<RazorSyntaxNode>))
        => SyntaxFactory.MarkupElement(default(MarkupStartTagSyntax), body, default(MarkupEndTagSyntax));

    /// <summary>Creates a new MarkupStartTagSyntax instance.</summary>
    public static MarkupStartTagSyntax MarkupStartTag(SyntaxToken openAngle, SyntaxToken bang, SyntaxToken name, SyntaxList<RazorSyntaxNode> attributes, SyntaxToken forwardSlash, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
    {
        if (openAngle.Kind is not (SyntaxKind.OpenAngle)) return ThrowHelper.ThrowArgumentException<MarkupStartTagSyntax>(nameof(openAngle), $"Invalid SyntaxKind. Expected 'SyntaxKind.OpenAngle', but it was {openAngle.Kind}");
        if (bang.Kind is not (SyntaxKind.Bang or SyntaxKind.None)) return ThrowHelper.ThrowArgumentException<MarkupStartTagSyntax>(nameof(bang), $"Invalid SyntaxKind. Expected 'SyntaxKind.Bang or SyntaxKind.None', but it was {bang.Kind}");
        if (name.Kind is not (SyntaxKind.Text)) return ThrowHelper.ThrowArgumentException<MarkupStartTagSyntax>(nameof(name), $"Invalid SyntaxKind. Expected 'SyntaxKind.Text', but it was {name.Kind}");
        if (forwardSlash.Kind is not (SyntaxKind.ForwardSlash or SyntaxKind.None)) return ThrowHelper.ThrowArgumentException<MarkupStartTagSyntax>(nameof(forwardSlash), $"Invalid SyntaxKind. Expected 'SyntaxKind.ForwardSlash or SyntaxKind.None', but it was {forwardSlash.Kind}");
        if (closeAngle.Kind is not (SyntaxKind.CloseAngle)) return ThrowHelper.ThrowArgumentException<MarkupStartTagSyntax>(nameof(closeAngle), $"Invalid SyntaxKind. Expected 'SyntaxKind.CloseAngle', but it was {closeAngle.Kind}");
        return (MarkupStartTagSyntax)InternalSyntax.SyntaxFactory.MarkupStartTag((Syntax.InternalSyntax.SyntaxToken)openAngle.Node, (Syntax.InternalSyntax.SyntaxToken)bang.Node, (Syntax.InternalSyntax.SyntaxToken)name.Node, attributes.Node.ToGreenList<InternalSyntax.RazorSyntaxNode>(), (Syntax.InternalSyntax.SyntaxToken)forwardSlash.Node, (Syntax.InternalSyntax.SyntaxToken)closeAngle.Node, chunkGenerator).CreateRed();
    }

    /// <summary>Creates a new MarkupStartTagSyntax instance.</summary>
    public static MarkupStartTagSyntax MarkupStartTag(SyntaxList<RazorSyntaxNode> attributes, ISpanChunkGenerator chunkGenerator)
        => SyntaxFactory.MarkupStartTag(SyntaxFactory.Token(SyntaxKind.OpenAngle), default(SyntaxToken), SyntaxFactory.Token(SyntaxKind.Text), attributes, default(SyntaxToken), SyntaxFactory.Token(SyntaxKind.CloseAngle), chunkGenerator);

    /// <summary>Creates a new MarkupStartTagSyntax instance.</summary>
    public static MarkupStartTagSyntax MarkupStartTag(ISpanChunkGenerator chunkGenerator)
        => SyntaxFactory.MarkupStartTag(SyntaxFactory.Token(SyntaxKind.OpenAngle), default(SyntaxToken), SyntaxFactory.Token(SyntaxKind.Text), default(SyntaxList<RazorSyntaxNode>), default(SyntaxToken), SyntaxFactory.Token(SyntaxKind.CloseAngle), chunkGenerator);

    /// <summary>Creates a new MarkupEndTagSyntax instance.</summary>
    public static MarkupEndTagSyntax MarkupEndTag(SyntaxToken openAngle, SyntaxToken forwardSlash, SyntaxToken bang, SyntaxToken name, MarkupMiscAttributeContentSyntax miscAttributeContent, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
    {
        if (openAngle.Kind is not (SyntaxKind.OpenAngle)) return ThrowHelper.ThrowArgumentException<MarkupEndTagSyntax>(nameof(openAngle), $"Invalid SyntaxKind. Expected 'SyntaxKind.OpenAngle', but it was {openAngle.Kind}");
        if (forwardSlash.Kind is not (SyntaxKind.ForwardSlash)) return ThrowHelper.ThrowArgumentException<MarkupEndTagSyntax>(nameof(forwardSlash), $"Invalid SyntaxKind. Expected 'SyntaxKind.ForwardSlash', but it was {forwardSlash.Kind}");
        if (bang.Kind is not (SyntaxKind.Bang or SyntaxKind.None)) return ThrowHelper.ThrowArgumentException<MarkupEndTagSyntax>(nameof(bang), $"Invalid SyntaxKind. Expected 'SyntaxKind.Bang or SyntaxKind.None', but it was {bang.Kind}");
        if (name.Kind is not (SyntaxKind.Text)) return ThrowHelper.ThrowArgumentException<MarkupEndTagSyntax>(nameof(name), $"Invalid SyntaxKind. Expected 'SyntaxKind.Text', but it was {name.Kind}");
        if (closeAngle.Kind is not (SyntaxKind.CloseAngle)) return ThrowHelper.ThrowArgumentException<MarkupEndTagSyntax>(nameof(closeAngle), $"Invalid SyntaxKind. Expected 'SyntaxKind.CloseAngle', but it was {closeAngle.Kind}");
        return (MarkupEndTagSyntax)InternalSyntax.SyntaxFactory.MarkupEndTag((Syntax.InternalSyntax.SyntaxToken)openAngle.Node, (Syntax.InternalSyntax.SyntaxToken)forwardSlash.Node, (Syntax.InternalSyntax.SyntaxToken)bang.Node, (Syntax.InternalSyntax.SyntaxToken)name.Node, miscAttributeContent == null ? null : (InternalSyntax.MarkupMiscAttributeContentSyntax)miscAttributeContent.Green, (Syntax.InternalSyntax.SyntaxToken)closeAngle.Node, chunkGenerator).CreateRed();
    }

    /// <summary>Creates a new MarkupEndTagSyntax instance.</summary>
    public static MarkupEndTagSyntax MarkupEndTag(MarkupMiscAttributeContentSyntax miscAttributeContent, ISpanChunkGenerator chunkGenerator)
        => SyntaxFactory.MarkupEndTag(SyntaxFactory.Token(SyntaxKind.OpenAngle), SyntaxFactory.Token(SyntaxKind.ForwardSlash), default(SyntaxToken), SyntaxFactory.Token(SyntaxKind.Text), miscAttributeContent, SyntaxFactory.Token(SyntaxKind.CloseAngle), chunkGenerator);

    /// <summary>Creates a new MarkupEndTagSyntax instance.</summary>
    public static MarkupEndTagSyntax MarkupEndTag(ISpanChunkGenerator chunkGenerator)
        => SyntaxFactory.MarkupEndTag(SyntaxFactory.Token(SyntaxKind.OpenAngle), SyntaxFactory.Token(SyntaxKind.ForwardSlash), default(SyntaxToken), SyntaxFactory.Token(SyntaxKind.Text), default(MarkupMiscAttributeContentSyntax), SyntaxFactory.Token(SyntaxKind.CloseAngle), chunkGenerator);

    /// <summary>Creates a new MarkupTagHelperElementSyntax instance.</summary>
    public static MarkupTagHelperElementSyntax MarkupTagHelperElement(MarkupTagHelperStartTagSyntax startTag, SyntaxList<RazorSyntaxNode> body, MarkupTagHelperEndTagSyntax endTag)
    {
        ArgHelper.ThrowIfNull(startTag);
        return (MarkupTagHelperElementSyntax)InternalSyntax.SyntaxFactory.MarkupTagHelperElement(startTag == null ? null : (InternalSyntax.MarkupTagHelperStartTagSyntax)startTag.Green, body.Node.ToGreenList<InternalSyntax.RazorSyntaxNode>(), endTag == null ? null : (InternalSyntax.MarkupTagHelperEndTagSyntax)endTag.Green).CreateRed();
    }

    /// <summary>Creates a new MarkupTagHelperElementSyntax instance.</summary>
    public static MarkupTagHelperElementSyntax MarkupTagHelperElement(MarkupTagHelperStartTagSyntax startTag)
        => SyntaxFactory.MarkupTagHelperElement(startTag, default(SyntaxList<RazorSyntaxNode>), default(MarkupTagHelperEndTagSyntax));

    /// <summary>Creates a new MarkupTagHelperStartTagSyntax instance.</summary>
    public static MarkupTagHelperStartTagSyntax MarkupTagHelperStartTag(SyntaxToken openAngle, SyntaxToken bang, SyntaxToken name, SyntaxList<RazorSyntaxNode> attributes, SyntaxToken forwardSlash, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
    {
        if (openAngle.Kind is not (SyntaxKind.OpenAngle)) return ThrowHelper.ThrowArgumentException<MarkupTagHelperStartTagSyntax>(nameof(openAngle), $"Invalid SyntaxKind. Expected 'SyntaxKind.OpenAngle', but it was {openAngle.Kind}");
        if (bang.Kind is not (SyntaxKind.Bang or SyntaxKind.None)) return ThrowHelper.ThrowArgumentException<MarkupTagHelperStartTagSyntax>(nameof(bang), $"Invalid SyntaxKind. Expected 'SyntaxKind.Bang or SyntaxKind.None', but it was {bang.Kind}");
        if (name.Kind is not (SyntaxKind.Text)) return ThrowHelper.ThrowArgumentException<MarkupTagHelperStartTagSyntax>(nameof(name), $"Invalid SyntaxKind. Expected 'SyntaxKind.Text', but it was {name.Kind}");
        if (forwardSlash.Kind is not (SyntaxKind.ForwardSlash or SyntaxKind.None)) return ThrowHelper.ThrowArgumentException<MarkupTagHelperStartTagSyntax>(nameof(forwardSlash), $"Invalid SyntaxKind. Expected 'SyntaxKind.ForwardSlash or SyntaxKind.None', but it was {forwardSlash.Kind}");
        if (closeAngle.Kind is not (SyntaxKind.CloseAngle)) return ThrowHelper.ThrowArgumentException<MarkupTagHelperStartTagSyntax>(nameof(closeAngle), $"Invalid SyntaxKind. Expected 'SyntaxKind.CloseAngle', but it was {closeAngle.Kind}");
        return (MarkupTagHelperStartTagSyntax)InternalSyntax.SyntaxFactory.MarkupTagHelperStartTag((Syntax.InternalSyntax.SyntaxToken)openAngle.Node, (Syntax.InternalSyntax.SyntaxToken)bang.Node, (Syntax.InternalSyntax.SyntaxToken)name.Node, attributes.Node.ToGreenList<InternalSyntax.RazorSyntaxNode>(), (Syntax.InternalSyntax.SyntaxToken)forwardSlash.Node, (Syntax.InternalSyntax.SyntaxToken)closeAngle.Node, chunkGenerator).CreateRed();
    }

    /// <summary>Creates a new MarkupTagHelperStartTagSyntax instance.</summary>
    public static MarkupTagHelperStartTagSyntax MarkupTagHelperStartTag(SyntaxList<RazorSyntaxNode> attributes, ISpanChunkGenerator chunkGenerator)
        => SyntaxFactory.MarkupTagHelperStartTag(SyntaxFactory.Token(SyntaxKind.OpenAngle), default(SyntaxToken), SyntaxFactory.Token(SyntaxKind.Text), attributes, default(SyntaxToken), SyntaxFactory.Token(SyntaxKind.CloseAngle), chunkGenerator);

    /// <summary>Creates a new MarkupTagHelperStartTagSyntax instance.</summary>
    public static MarkupTagHelperStartTagSyntax MarkupTagHelperStartTag(ISpanChunkGenerator chunkGenerator)
        => SyntaxFactory.MarkupTagHelperStartTag(SyntaxFactory.Token(SyntaxKind.OpenAngle), default(SyntaxToken), SyntaxFactory.Token(SyntaxKind.Text), default(SyntaxList<RazorSyntaxNode>), default(SyntaxToken), SyntaxFactory.Token(SyntaxKind.CloseAngle), chunkGenerator);

    /// <summary>Creates a new MarkupTagHelperEndTagSyntax instance.</summary>
    public static MarkupTagHelperEndTagSyntax MarkupTagHelperEndTag(SyntaxToken openAngle, SyntaxToken forwardSlash, SyntaxToken bang, SyntaxToken name, MarkupMiscAttributeContentSyntax miscAttributeContent, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
    {
        if (openAngle.Kind is not (SyntaxKind.OpenAngle)) return ThrowHelper.ThrowArgumentException<MarkupTagHelperEndTagSyntax>(nameof(openAngle), $"Invalid SyntaxKind. Expected 'SyntaxKind.OpenAngle', but it was {openAngle.Kind}");
        if (forwardSlash.Kind is not (SyntaxKind.ForwardSlash)) return ThrowHelper.ThrowArgumentException<MarkupTagHelperEndTagSyntax>(nameof(forwardSlash), $"Invalid SyntaxKind. Expected 'SyntaxKind.ForwardSlash', but it was {forwardSlash.Kind}");
        if (bang.Kind is not (SyntaxKind.Bang or SyntaxKind.None)) return ThrowHelper.ThrowArgumentException<MarkupTagHelperEndTagSyntax>(nameof(bang), $"Invalid SyntaxKind. Expected 'SyntaxKind.Bang or SyntaxKind.None', but it was {bang.Kind}");
        if (name.Kind is not (SyntaxKind.Text)) return ThrowHelper.ThrowArgumentException<MarkupTagHelperEndTagSyntax>(nameof(name), $"Invalid SyntaxKind. Expected 'SyntaxKind.Text', but it was {name.Kind}");
        if (closeAngle.Kind is not (SyntaxKind.CloseAngle)) return ThrowHelper.ThrowArgumentException<MarkupTagHelperEndTagSyntax>(nameof(closeAngle), $"Invalid SyntaxKind. Expected 'SyntaxKind.CloseAngle', but it was {closeAngle.Kind}");
        return (MarkupTagHelperEndTagSyntax)InternalSyntax.SyntaxFactory.MarkupTagHelperEndTag((Syntax.InternalSyntax.SyntaxToken)openAngle.Node, (Syntax.InternalSyntax.SyntaxToken)forwardSlash.Node, (Syntax.InternalSyntax.SyntaxToken)bang.Node, (Syntax.InternalSyntax.SyntaxToken)name.Node, miscAttributeContent == null ? null : (InternalSyntax.MarkupMiscAttributeContentSyntax)miscAttributeContent.Green, (Syntax.InternalSyntax.SyntaxToken)closeAngle.Node, chunkGenerator).CreateRed();
    }

    /// <summary>Creates a new MarkupTagHelperEndTagSyntax instance.</summary>
    public static MarkupTagHelperEndTagSyntax MarkupTagHelperEndTag(MarkupMiscAttributeContentSyntax miscAttributeContent, ISpanChunkGenerator chunkGenerator)
        => SyntaxFactory.MarkupTagHelperEndTag(SyntaxFactory.Token(SyntaxKind.OpenAngle), SyntaxFactory.Token(SyntaxKind.ForwardSlash), default(SyntaxToken), SyntaxFactory.Token(SyntaxKind.Text), miscAttributeContent, SyntaxFactory.Token(SyntaxKind.CloseAngle), chunkGenerator);

    /// <summary>Creates a new MarkupTagHelperEndTagSyntax instance.</summary>
    public static MarkupTagHelperEndTagSyntax MarkupTagHelperEndTag(ISpanChunkGenerator chunkGenerator)
        => SyntaxFactory.MarkupTagHelperEndTag(SyntaxFactory.Token(SyntaxKind.OpenAngle), SyntaxFactory.Token(SyntaxKind.ForwardSlash), default(SyntaxToken), SyntaxFactory.Token(SyntaxKind.Text), default(MarkupMiscAttributeContentSyntax), SyntaxFactory.Token(SyntaxKind.CloseAngle), chunkGenerator);

    /// <summary>Creates a new MarkupTagHelperAttributeSyntax instance.</summary>
    public static MarkupTagHelperAttributeSyntax MarkupTagHelperAttribute(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, MarkupTagHelperAttributeValueSyntax value, MarkupTextLiteralSyntax valueSuffix)
    {
        ArgHelper.ThrowIfNull(name);
        if (equalsToken.Kind is not (SyntaxKind.Equals)) return ThrowHelper.ThrowArgumentException<MarkupTagHelperAttributeSyntax>(nameof(equalsToken), $"Invalid SyntaxKind. Expected 'SyntaxKind.Equals', but it was {equalsToken.Kind}");
        ArgHelper.ThrowIfNull(value);
        return (MarkupTagHelperAttributeSyntax)InternalSyntax.SyntaxFactory.MarkupTagHelperAttribute(namePrefix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)namePrefix.Green, name == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)name.Green, nameSuffix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)nameSuffix.Green, (Syntax.InternalSyntax.SyntaxToken)equalsToken.Node, valuePrefix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)valuePrefix.Green, value == null ? null : (InternalSyntax.MarkupTagHelperAttributeValueSyntax)value.Green, valueSuffix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)valueSuffix.Green).CreateRed();
    }

    /// <summary>Creates a new MarkupTagHelperAttributeSyntax instance.</summary>
    public static MarkupTagHelperAttributeSyntax MarkupTagHelperAttribute(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name, MarkupTextLiteralSyntax nameSuffix, MarkupTextLiteralSyntax valuePrefix, MarkupTagHelperAttributeValueSyntax value, MarkupTextLiteralSyntax valueSuffix)
        => SyntaxFactory.MarkupTagHelperAttribute(namePrefix, name, nameSuffix, SyntaxFactory.Token(SyntaxKind.Equals), valuePrefix, value, valueSuffix);

    /// <summary>Creates a new MarkupTagHelperAttributeSyntax instance.</summary>
    public static MarkupTagHelperAttributeSyntax MarkupTagHelperAttribute(MarkupTextLiteralSyntax name)
        => SyntaxFactory.MarkupTagHelperAttribute(default(MarkupTextLiteralSyntax), name, default(MarkupTextLiteralSyntax), SyntaxFactory.Token(SyntaxKind.Equals), default(MarkupTextLiteralSyntax), SyntaxFactory.MarkupTagHelperAttributeValue(), default(MarkupTextLiteralSyntax));

    /// <summary>Creates a new MarkupMinimizedTagHelperAttributeSyntax instance.</summary>
    public static MarkupMinimizedTagHelperAttributeSyntax MarkupMinimizedTagHelperAttribute(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name)
    {
        ArgHelper.ThrowIfNull(name);
        return (MarkupMinimizedTagHelperAttributeSyntax)InternalSyntax.SyntaxFactory.MarkupMinimizedTagHelperAttribute(namePrefix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)namePrefix.Green, name == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)name.Green).CreateRed();
    }

    /// <summary>Creates a new MarkupMinimizedTagHelperAttributeSyntax instance.</summary>
    public static MarkupMinimizedTagHelperAttributeSyntax MarkupMinimizedTagHelperAttribute(MarkupTextLiteralSyntax name)
        => SyntaxFactory.MarkupMinimizedTagHelperAttribute(default(MarkupTextLiteralSyntax), name);

    /// <summary>Creates a new MarkupTagHelperAttributeValueSyntax instance.</summary>
    public static MarkupTagHelperAttributeValueSyntax MarkupTagHelperAttributeValue(SyntaxList<RazorSyntaxNode> children)
        => (MarkupTagHelperAttributeValueSyntax)InternalSyntax.SyntaxFactory.MarkupTagHelperAttributeValue(children.Node.ToGreenList<InternalSyntax.RazorSyntaxNode>()).CreateRed();

    /// <summary>Creates a new MarkupTagHelperAttributeValueSyntax instance.</summary>
    public static MarkupTagHelperAttributeValueSyntax MarkupTagHelperAttributeValue()
        => SyntaxFactory.MarkupTagHelperAttributeValue(default(SyntaxList<RazorSyntaxNode>));

    /// <summary>Creates a new MarkupTagHelperDirectiveAttributeSyntax instance.</summary>
    public static MarkupTagHelperDirectiveAttributeSyntax MarkupTagHelperDirectiveAttribute(MarkupTextLiteralSyntax namePrefix, RazorMetaCodeSyntax transition, MarkupTextLiteralSyntax name, RazorMetaCodeSyntax colon, MarkupTextLiteralSyntax parameterName, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, MarkupTagHelperAttributeValueSyntax value, MarkupTextLiteralSyntax valueSuffix)
    {
        ArgHelper.ThrowIfNull(transition);
        ArgHelper.ThrowIfNull(name);
        if (equalsToken.Kind is not (SyntaxKind.Equals)) return ThrowHelper.ThrowArgumentException<MarkupTagHelperDirectiveAttributeSyntax>(nameof(equalsToken), $"Invalid SyntaxKind. Expected 'SyntaxKind.Equals', but it was {equalsToken.Kind}");
        ArgHelper.ThrowIfNull(value);
        return (MarkupTagHelperDirectiveAttributeSyntax)InternalSyntax.SyntaxFactory.MarkupTagHelperDirectiveAttribute(namePrefix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)namePrefix.Green, transition == null ? null : (InternalSyntax.RazorMetaCodeSyntax)transition.Green, name == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)name.Green, colon == null ? null : (InternalSyntax.RazorMetaCodeSyntax)colon.Green, parameterName == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)parameterName.Green, nameSuffix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)nameSuffix.Green, (Syntax.InternalSyntax.SyntaxToken)equalsToken.Node, valuePrefix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)valuePrefix.Green, value == null ? null : (InternalSyntax.MarkupTagHelperAttributeValueSyntax)value.Green, valueSuffix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)valueSuffix.Green).CreateRed();
    }

    /// <summary>Creates a new MarkupTagHelperDirectiveAttributeSyntax instance.</summary>
    public static MarkupTagHelperDirectiveAttributeSyntax MarkupTagHelperDirectiveAttribute(MarkupTextLiteralSyntax namePrefix, RazorMetaCodeSyntax transition, MarkupTextLiteralSyntax name, RazorMetaCodeSyntax colon, MarkupTextLiteralSyntax parameterName, MarkupTextLiteralSyntax nameSuffix, MarkupTextLiteralSyntax valuePrefix, MarkupTagHelperAttributeValueSyntax value, MarkupTextLiteralSyntax valueSuffix)
        => SyntaxFactory.MarkupTagHelperDirectiveAttribute(namePrefix, transition, name, colon, parameterName, nameSuffix, SyntaxFactory.Token(SyntaxKind.Equals), valuePrefix, value, valueSuffix);

    /// <summary>Creates a new MarkupTagHelperDirectiveAttributeSyntax instance.</summary>
    public static MarkupTagHelperDirectiveAttributeSyntax MarkupTagHelperDirectiveAttribute(RazorMetaCodeSyntax transition, MarkupTextLiteralSyntax name)
        => SyntaxFactory.MarkupTagHelperDirectiveAttribute(default(MarkupTextLiteralSyntax), transition, name, default(RazorMetaCodeSyntax), default(MarkupTextLiteralSyntax), default(MarkupTextLiteralSyntax), SyntaxFactory.Token(SyntaxKind.Equals), default(MarkupTextLiteralSyntax), SyntaxFactory.MarkupTagHelperAttributeValue(), default(MarkupTextLiteralSyntax));

    /// <summary>Creates a new MarkupMinimizedTagHelperDirectiveAttributeSyntax instance.</summary>
    public static MarkupMinimizedTagHelperDirectiveAttributeSyntax MarkupMinimizedTagHelperDirectiveAttribute(MarkupTextLiteralSyntax namePrefix, RazorMetaCodeSyntax transition, MarkupTextLiteralSyntax name, RazorMetaCodeSyntax colon, MarkupTextLiteralSyntax parameterName)
    {
        ArgHelper.ThrowIfNull(transition);
        ArgHelper.ThrowIfNull(name);
        return (MarkupMinimizedTagHelperDirectiveAttributeSyntax)InternalSyntax.SyntaxFactory.MarkupMinimizedTagHelperDirectiveAttribute(namePrefix == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)namePrefix.Green, transition == null ? null : (InternalSyntax.RazorMetaCodeSyntax)transition.Green, name == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)name.Green, colon == null ? null : (InternalSyntax.RazorMetaCodeSyntax)colon.Green, parameterName == null ? null : (InternalSyntax.MarkupTextLiteralSyntax)parameterName.Green).CreateRed();
    }

    /// <summary>Creates a new MarkupMinimizedTagHelperDirectiveAttributeSyntax instance.</summary>
    public static MarkupMinimizedTagHelperDirectiveAttributeSyntax MarkupMinimizedTagHelperDirectiveAttribute(RazorMetaCodeSyntax transition, MarkupTextLiteralSyntax name)
        => SyntaxFactory.MarkupMinimizedTagHelperDirectiveAttribute(default(MarkupTextLiteralSyntax), transition, name, default(RazorMetaCodeSyntax), default(MarkupTextLiteralSyntax));

    /// <summary>Creates a new CSharpCodeBlockSyntax instance.</summary>
    public static CSharpCodeBlockSyntax CSharpCodeBlock(SyntaxList<RazorSyntaxNode> children)
        => (CSharpCodeBlockSyntax)InternalSyntax.SyntaxFactory.CSharpCodeBlock(children.Node.ToGreenList<InternalSyntax.RazorSyntaxNode>()).CreateRed();

    /// <summary>Creates a new CSharpCodeBlockSyntax instance.</summary>
    public static CSharpCodeBlockSyntax CSharpCodeBlock()
        => SyntaxFactory.CSharpCodeBlock(default(SyntaxList<RazorSyntaxNode>));

    /// <summary>Creates a new CSharpTransitionSyntax instance.</summary>
    public static CSharpTransitionSyntax CSharpTransition(SyntaxToken transition, ISpanChunkGenerator chunkGenerator)
    {
        if (transition.Kind is not (SyntaxKind.Transition)) return ThrowHelper.ThrowArgumentException<CSharpTransitionSyntax>(nameof(transition), $"Invalid SyntaxKind. Expected 'SyntaxKind.Transition', but it was {transition.Kind}");
        return (CSharpTransitionSyntax)InternalSyntax.SyntaxFactory.CSharpTransition((Syntax.InternalSyntax.SyntaxToken)transition.Node, chunkGenerator).CreateRed();
    }

    /// <summary>Creates a new CSharpTransitionSyntax instance.</summary>
    public static CSharpTransitionSyntax CSharpTransition(ISpanChunkGenerator chunkGenerator)
        => SyntaxFactory.CSharpTransition(SyntaxFactory.Token(SyntaxKind.Transition), chunkGenerator);

    /// <summary>Creates a new CSharpStatementLiteralSyntax instance.</summary>
    public static CSharpStatementLiteralSyntax CSharpStatementLiteral(SyntaxTokenList literalTokens, ISpanChunkGenerator chunkGenerator)
        => (CSharpStatementLiteralSyntax)InternalSyntax.SyntaxFactory.CSharpStatementLiteral(literalTokens.Node.ToGreenList<InternalSyntax.SyntaxToken>(), chunkGenerator).CreateRed();

    /// <summary>Creates a new CSharpStatementLiteralSyntax instance.</summary>
    public static CSharpStatementLiteralSyntax CSharpStatementLiteral(ISpanChunkGenerator chunkGenerator)
        => SyntaxFactory.CSharpStatementLiteral(default(SyntaxTokenList), chunkGenerator);

    /// <summary>Creates a new CSharpExpressionLiteralSyntax instance.</summary>
    public static CSharpExpressionLiteralSyntax CSharpExpressionLiteral(SyntaxTokenList literalTokens, ISpanChunkGenerator chunkGenerator)
        => (CSharpExpressionLiteralSyntax)InternalSyntax.SyntaxFactory.CSharpExpressionLiteral(literalTokens.Node.ToGreenList<InternalSyntax.SyntaxToken>(), chunkGenerator).CreateRed();

    /// <summary>Creates a new CSharpExpressionLiteralSyntax instance.</summary>
    public static CSharpExpressionLiteralSyntax CSharpExpressionLiteral(ISpanChunkGenerator chunkGenerator)
        => SyntaxFactory.CSharpExpressionLiteral(default(SyntaxTokenList), chunkGenerator);

    /// <summary>Creates a new CSharpEphemeralTextLiteralSyntax instance.</summary>
    public static CSharpEphemeralTextLiteralSyntax CSharpEphemeralTextLiteral(SyntaxTokenList literalTokens, ISpanChunkGenerator chunkGenerator)
        => (CSharpEphemeralTextLiteralSyntax)InternalSyntax.SyntaxFactory.CSharpEphemeralTextLiteral(literalTokens.Node.ToGreenList<InternalSyntax.SyntaxToken>(), chunkGenerator).CreateRed();

    /// <summary>Creates a new CSharpEphemeralTextLiteralSyntax instance.</summary>
    public static CSharpEphemeralTextLiteralSyntax CSharpEphemeralTextLiteral(ISpanChunkGenerator chunkGenerator)
        => SyntaxFactory.CSharpEphemeralTextLiteral(default(SyntaxTokenList), chunkGenerator);

    /// <summary>Creates a new CSharpTemplateBlockSyntax instance.</summary>
    public static CSharpTemplateBlockSyntax CSharpTemplateBlock(SyntaxList<RazorSyntaxNode> children)
        => (CSharpTemplateBlockSyntax)InternalSyntax.SyntaxFactory.CSharpTemplateBlock(children.Node.ToGreenList<InternalSyntax.RazorSyntaxNode>()).CreateRed();

    /// <summary>Creates a new CSharpTemplateBlockSyntax instance.</summary>
    public static CSharpTemplateBlockSyntax CSharpTemplateBlock()
        => SyntaxFactory.CSharpTemplateBlock(default(SyntaxList<RazorSyntaxNode>));

    /// <summary>Creates a new CSharpStatementSyntax instance.</summary>
    public static CSharpStatementSyntax CSharpStatement(CSharpTransitionSyntax transition, CSharpSyntaxNode body)
    {
        ArgHelper.ThrowIfNull(transition);
        ArgHelper.ThrowIfNull(body);
        return (CSharpStatementSyntax)InternalSyntax.SyntaxFactory.CSharpStatement(transition == null ? null : (InternalSyntax.CSharpTransitionSyntax)transition.Green, body == null ? null : (InternalSyntax.CSharpSyntaxNode)body.Green).CreateRed();
    }

    /// <summary>Creates a new CSharpStatementBodySyntax instance.</summary>
    public static CSharpStatementBodySyntax CSharpStatementBody(RazorMetaCodeSyntax openBrace, CSharpCodeBlockSyntax csharpCode, RazorMetaCodeSyntax closeBrace)
    {
        ArgHelper.ThrowIfNull(openBrace);
        ArgHelper.ThrowIfNull(csharpCode);
        ArgHelper.ThrowIfNull(closeBrace);
        return (CSharpStatementBodySyntax)InternalSyntax.SyntaxFactory.CSharpStatementBody(openBrace == null ? null : (InternalSyntax.RazorMetaCodeSyntax)openBrace.Green, csharpCode == null ? null : (InternalSyntax.CSharpCodeBlockSyntax)csharpCode.Green, closeBrace == null ? null : (InternalSyntax.RazorMetaCodeSyntax)closeBrace.Green).CreateRed();
    }

    /// <summary>Creates a new CSharpStatementBodySyntax instance.</summary>
    public static CSharpStatementBodySyntax CSharpStatementBody(RazorMetaCodeSyntax openBrace, RazorMetaCodeSyntax closeBrace)
        => SyntaxFactory.CSharpStatementBody(openBrace, SyntaxFactory.CSharpCodeBlock(), closeBrace);

    /// <summary>Creates a new CSharpExplicitExpressionSyntax instance.</summary>
    public static CSharpExplicitExpressionSyntax CSharpExplicitExpression(CSharpTransitionSyntax transition, CSharpSyntaxNode body)
    {
        ArgHelper.ThrowIfNull(transition);
        ArgHelper.ThrowIfNull(body);
        return (CSharpExplicitExpressionSyntax)InternalSyntax.SyntaxFactory.CSharpExplicitExpression(transition == null ? null : (InternalSyntax.CSharpTransitionSyntax)transition.Green, body == null ? null : (InternalSyntax.CSharpSyntaxNode)body.Green).CreateRed();
    }

    /// <summary>Creates a new CSharpExplicitExpressionBodySyntax instance.</summary>
    public static CSharpExplicitExpressionBodySyntax CSharpExplicitExpressionBody(RazorMetaCodeSyntax openParen, CSharpCodeBlockSyntax csharpCode, RazorMetaCodeSyntax closeParen)
    {
        ArgHelper.ThrowIfNull(openParen);
        ArgHelper.ThrowIfNull(csharpCode);
        ArgHelper.ThrowIfNull(closeParen);
        return (CSharpExplicitExpressionBodySyntax)InternalSyntax.SyntaxFactory.CSharpExplicitExpressionBody(openParen == null ? null : (InternalSyntax.RazorMetaCodeSyntax)openParen.Green, csharpCode == null ? null : (InternalSyntax.CSharpCodeBlockSyntax)csharpCode.Green, closeParen == null ? null : (InternalSyntax.RazorMetaCodeSyntax)closeParen.Green).CreateRed();
    }

    /// <summary>Creates a new CSharpExplicitExpressionBodySyntax instance.</summary>
    public static CSharpExplicitExpressionBodySyntax CSharpExplicitExpressionBody(RazorMetaCodeSyntax openParen, RazorMetaCodeSyntax closeParen)
        => SyntaxFactory.CSharpExplicitExpressionBody(openParen, SyntaxFactory.CSharpCodeBlock(), closeParen);

    /// <summary>Creates a new CSharpImplicitExpressionSyntax instance.</summary>
    public static CSharpImplicitExpressionSyntax CSharpImplicitExpression(CSharpTransitionSyntax transition, CSharpSyntaxNode body)
    {
        ArgHelper.ThrowIfNull(transition);
        ArgHelper.ThrowIfNull(body);
        return (CSharpImplicitExpressionSyntax)InternalSyntax.SyntaxFactory.CSharpImplicitExpression(transition == null ? null : (InternalSyntax.CSharpTransitionSyntax)transition.Green, body == null ? null : (InternalSyntax.CSharpSyntaxNode)body.Green).CreateRed();
    }

    /// <summary>Creates a new CSharpImplicitExpressionBodySyntax instance.</summary>
    public static CSharpImplicitExpressionBodySyntax CSharpImplicitExpressionBody(CSharpCodeBlockSyntax csharpCode)
    {
        ArgHelper.ThrowIfNull(csharpCode);
        return (CSharpImplicitExpressionBodySyntax)InternalSyntax.SyntaxFactory.CSharpImplicitExpressionBody(csharpCode == null ? null : (InternalSyntax.CSharpCodeBlockSyntax)csharpCode.Green).CreateRed();
    }

    /// <summary>Creates a new CSharpImplicitExpressionBodySyntax instance.</summary>
    public static CSharpImplicitExpressionBodySyntax CSharpImplicitExpressionBody()
        => SyntaxFactory.CSharpImplicitExpressionBody(SyntaxFactory.CSharpCodeBlock());

    /// <summary>Creates a new RazorDirectiveSyntax instance.</summary>
    public static RazorDirectiveSyntax RazorDirective(CSharpTransitionSyntax transition, CSharpSyntaxNode body)
    {
        ArgHelper.ThrowIfNull(transition);
        ArgHelper.ThrowIfNull(body);
        return (RazorDirectiveSyntax)InternalSyntax.SyntaxFactory.RazorDirective(transition == null ? null : (InternalSyntax.CSharpTransitionSyntax)transition.Green, body == null ? null : (InternalSyntax.CSharpSyntaxNode)body.Green).CreateRed();
    }

    /// <summary>Creates a new RazorDirectiveBodySyntax instance.</summary>
    public static RazorDirectiveBodySyntax RazorDirectiveBody(RazorSyntaxNode keyword, CSharpCodeBlockSyntax csharpCode)
    {
        ArgHelper.ThrowIfNull(keyword);
        return (RazorDirectiveBodySyntax)InternalSyntax.SyntaxFactory.RazorDirectiveBody(keyword == null ? null : (InternalSyntax.RazorSyntaxNode)keyword.Green, csharpCode == null ? null : (InternalSyntax.CSharpCodeBlockSyntax)csharpCode.Green).CreateRed();
    }

    /// <summary>Creates a new RazorDirectiveBodySyntax instance.</summary>
    public static RazorDirectiveBodySyntax RazorDirectiveBody(RazorSyntaxNode keyword)
        => SyntaxFactory.RazorDirectiveBody(keyword, default(CSharpCodeBlockSyntax));
}
