#include "ipstore"

unsigned IPStore::anticipated(unsigned b) {
    if (!onoff || b >= balancer.nbackends())
	return 0;

    // Weed store for decisions later
    weed();

    // Get number of anticipated clients for given back end
    unsigned ret = 0;

    Mutex::lock(&store);
    for (StoreMap::iterator iter = store.begin();
	 iter != store.end();
	 iter++)
	if ((*iter).second.targetbackend == (int)b)
	    ret++;
    Mutex::unlock(&store);

    debugmsg(Mstr("Anticipated connections for back end ") + Mstr(b) + ": " +
	     Mstr(ret) + "\n");
    return ret;
}
   
	
