/*
 *  Copyright 2011  Integrated Computer Solutions - http://www.ics.com
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

function Acceleration(p_x,p_y,p_z,p_ts) {
    this.x = p_x || 0;
    this.y = p_y || 0;
    this.z = p_z || 0;
    this.timestamp = p_ts || 0;
    return this;
};

Acceleration.prototype.x = null;
Acceleration.prototype.y = null;
Acceleration.prototype.z = null;
Acceleration.prototype.timestamp = null;

Acceleration.cast = function (p_acceleration) {
    var acceleration = new Acceleration(p_acceleration.x,
                                        p_acceleration.y,
                                        p_acceleration.z,
                                        p_acceleration.timestamp);
    return acceleration;
};

function Accelerometer() {
};

Accelerometer.prototype.watchIds = [];

Accelerometer.prototype.getCurrentAcceleration = function (successCallback, errorCallback) {
    if (typeof successCallback !== "function") return;
    if (typeof errorCallback !== "function") errorCallback = function() {};

    Cordova.exec(successCallback, errorCallback, "com.cordova.Accelerometer", "getCurrentAcceleration", [ {} ]);
};

Accelerometer.prototype.watchAcceleration = function (successCallback, errorCallback, options) {
    if (typeof successCallback !== "function") return;
    if (typeof errorCallback !== "function") errorCallback = function() {};

    var watchId = this.watchIds.length + 1; // +1 in order to avoid 0 as watchId
    this.watchIds[watchId] = true;

    var frequency=10000;
    if (options && typeof(options.frequency) === "number") {
        frequency=options.frequency;
    }

    var self = this;
    function doWatch() {
        self.getCurrentAcceleration(function (p_acceleration) {
            if (!self.watchIds[watchId]) return;
            successCallback(p_acceleration);

            setTimeout(doWatch, frequency);
        }, function () {
            if (!self.watchIds[watchId]) return;

            errorCallback(p_accelerationError);
        });
    }

    setTimeout(doWatch, frequency);
    return watchId;
};

Accelerometer.prototype.clearWatch = function(watchId) {
    this.watchIds[watchId] = false;
};

Cordova.addConstructor("com.cordova.Accelerometer", function () {
    window.Acceleration = Acceleration;
    navigator.accelerometer = new Accelerometer();
});
