{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetNormalizeVelocity: Boolean;
    procedure SetNormalizeVelocity(const Value: Boolean);
  public
    { Set X3D field "keyValue". } { }
    procedure SetKeyValue(const Value: array of TVector4);
    { Set X3D field "keyValue". } { }
    procedure SetKeyValue(const Value: TVector4List);
    { X3D field "normalizeVelocity". } { }
    property NormalizeVelocity: Boolean read GetNormalizeVelocity write SetNormalizeVelocity;

{$endif read_interface}

{$ifdef read_implementation}

{ TSquadOrientationInterpolatorNode ----------------------------------------------- }

procedure TSquadOrientationInterpolatorNode.SetKeyValue(const Value: array of TVector4);
begin
  FdKeyValue.Send(Value);
end;

procedure TSquadOrientationInterpolatorNode.SetKeyValue(const Value: TVector4List);
begin
  FdKeyValue.Send(Value);
end;

function TSquadOrientationInterpolatorNode.GetNormalizeVelocity: Boolean;
begin
  Result := FdNormalizeVelocity.Value;
end;

procedure TSquadOrientationInterpolatorNode.SetNormalizeVelocity(const Value: Boolean);
begin
  FdNormalizeVelocity.Send(Value);
end;

{$endif read_implementation}
