{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetApplied: Boolean;
    procedure SetApplied(const Value: Boolean);
    function GetLinewidthScaleFactor: Single;
    procedure SetLinewidthScaleFactor(const Value: Single);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdApplied: TSFBool;
    { X3D field "applied". } { }
    public property FdApplied: TSFBool read FFdApplied;
    { X3D field "applied". } { }
    property Applied: Boolean read GetApplied write SetApplied;

    strict private FFdLinetype: TSFInt32;
    { X3D field "linetype". } { }
    public property FdLinetype: TSFInt32 read FFdLinetype;

    strict private FFdLinewidthScaleFactor: TSFFloat;
    { X3D field "linewidthScaleFactor". } { }
    public property FdLinewidthScaleFactor: TSFFloat read FFdLinewidthScaleFactor;
    { X3D field "linewidthScaleFactor". } { }
    property LinewidthScaleFactor: Single read GetLinewidthScaleFactor write SetLinewidthScaleFactor;

{$endif read_interface}

{$ifdef read_implementation}

{ TLinePropertiesNode ----------------------------------------------- }

function TLinePropertiesNode.GetApplied: Boolean;
begin
  Result := FdApplied.Value;
end;

procedure TLinePropertiesNode.SetApplied(const Value: Boolean);
begin
  FdApplied.Send(Value);
end;

function TLinePropertiesNode.GetLinewidthScaleFactor: Single;
begin
  Result := FdLinewidthScaleFactor.Value;
end;

procedure TLinePropertiesNode.SetLinewidthScaleFactor(const Value: Single);
begin
  FdLinewidthScaleFactor.Send(Value);
end;

class function TLinePropertiesNode.ClassX3DType: String;
begin
  Result := 'LineProperties';
end;

procedure TLinePropertiesNode.CreateNode;
begin
  inherited;

  FFdApplied := TSFBool.Create(Self, True, 'applied', true);
   FdApplied.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdApplied);

  FFdLinetype := TSFInt32.Create(Self, True, 'linetype', 1);
   FdLinetype.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdLinetype);
  { X3D specification comment: [1,Inf) }

  FFdLinewidthScaleFactor := TSFFloat.Create(Self, True, 'linewidthScaleFactor', 0);
   FdLinewidthScaleFactor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdLinewidthScaleFactor);
  { X3D specification comment: (-Inf,Inf) }

  DefaultContainerField := 'lineProperties';
end;

{$endif read_implementation}
