{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetAmbientIntensity: Single;
    procedure SetAmbientIntensity(const Value: Single);
    function GetAttenuation: TVector3;
    procedure SetAttenuation(const Value: TVector3);
    function GetColor: TCastleColorRGB;
    procedure SetColor(const Value: TCastleColorRGB);
    function GetIntensity: Single;
    procedure SetIntensity(const Value: Single);
    function GetSpot: Boolean;
    procedure SetSpot(const Value: Boolean);
    function GetSpotDropOffRate: Single;
    procedure SetSpotDropOffRate(const Value: Single);
    function GetSpotCutOffAngle: Single;
    procedure SetSpotCutOffAngle(const Value: Single);
  public
    { X3D field "ambientIntensity". } { }
    property AmbientIntensity: Single read GetAmbientIntensity write SetAmbientIntensity;
    { X3D field "attenuation". } { }
    property Attenuation: TVector3 read GetAttenuation write SetAttenuation;
    { X3D field "color". } { }
    property Color: TCastleColorRGB read GetColor write SetColor;
    { X3D field "intensity". } { }
    property Intensity: Single read GetIntensity write SetIntensity;
    { X3D field "spot". } { }
    property Spot: Boolean read GetSpot write SetSpot;
    { X3D field "spotDropOffRate". } { }
    property SpotDropOffRate: Single read GetSpotDropOffRate write SetSpotDropOffRate;
    { X3D field "spotCutOffAngle". } { }
    property SpotCutOffAngle: Single read GetSpotCutOffAngle write SetSpotCutOffAngle;

{$endif read_interface}

{$ifdef read_implementation}

{ TKambiHeadLightNode ----------------------------------------------- }

function TKambiHeadLightNode.GetAmbientIntensity: Single;
begin
  Result := FdAmbientIntensity.Value;
end;

procedure TKambiHeadLightNode.SetAmbientIntensity(const Value: Single);
begin
  FdAmbientIntensity.Send(Value);
end;

function TKambiHeadLightNode.GetAttenuation: TVector3;
begin
  Result := FdAttenuation.Value;
end;

procedure TKambiHeadLightNode.SetAttenuation(const Value: TVector3);
begin
  FdAttenuation.Send(Value);
end;

function TKambiHeadLightNode.GetColor: TCastleColorRGB;
begin
  Result := FdColor.Value;
end;

procedure TKambiHeadLightNode.SetColor(const Value: TCastleColorRGB);
begin
  FdColor.Send(Value);
end;

function TKambiHeadLightNode.GetIntensity: Single;
begin
  Result := FdIntensity.Value;
end;

procedure TKambiHeadLightNode.SetIntensity(const Value: Single);
begin
  FdIntensity.Send(Value);
end;

function TKambiHeadLightNode.GetSpot: Boolean;
begin
  Result := FdSpot.Value;
end;

procedure TKambiHeadLightNode.SetSpot(const Value: Boolean);
begin
  FdSpot.Send(Value);
end;

function TKambiHeadLightNode.GetSpotDropOffRate: Single;
begin
  Result := FdSpotDropOffRate.Value;
end;

procedure TKambiHeadLightNode.SetSpotDropOffRate(const Value: Single);
begin
  FdSpotDropOffRate.Send(Value);
end;

function TKambiHeadLightNode.GetSpotCutOffAngle: Single;
begin
  Result := FdSpotCutOffAngle.Value;
end;

procedure TKambiHeadLightNode.SetSpotCutOffAngle(const Value: Single);
begin
  FdSpotCutOffAngle.Send(Value);
end;

{$endif read_implementation}
