{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetCenter: TVector3;
    procedure SetCenter(const Value: TVector3);
    function GetNameField: String;
    procedure SetNameField(const Value: String);
    function GetRotation: TVector4;
    procedure SetRotation(const Value: TVector4);
    function GetScale: TVector3;
    procedure SetScale(const Value: TVector3);
    function GetScaleOrientation: TVector4;
    procedure SetScaleOrientation(const Value: TVector4);
    function GetTranslation: TVector3;
    procedure SetTranslation(const Value: TVector3);
  public
    { X3D field "center". } { }
    property Center: TVector3 read GetCenter write SetCenter;
    { X3D field "name". } { }
    property NameField: String read GetNameField write SetNameField;
    { X3D field "rotation". } { }
    property Rotation: TVector4 read GetRotation write SetRotation;
    { X3D field "scale". } { }
    property Scale: TVector3 read GetScale write SetScale;
    { X3D field "scaleOrientation". } { }
    property ScaleOrientation: TVector4 read GetScaleOrientation write SetScaleOrientation;
    { X3D field "translation". } { }
    property Translation: TVector3 read GetTranslation write SetTranslation;

{$endif read_interface}

{$ifdef read_implementation}

{ THAnimSiteNode ----------------------------------------------- }

function THAnimSiteNode.GetCenter: TVector3;
begin
  Result := FdCenter.Value;
end;

procedure THAnimSiteNode.SetCenter(const Value: TVector3);
begin
  FdCenter.Send(Value);
end;

function THAnimSiteNode.GetNameField: String;
begin
  Result := FdName.Value;
end;

procedure THAnimSiteNode.SetNameField(const Value: String);
begin
  FdName.Send(Value);
end;

function THAnimSiteNode.GetRotation: TVector4;
begin
  Result := FdRotation.Value;
end;

procedure THAnimSiteNode.SetRotation(const Value: TVector4);
begin
  FdRotation.Send(Value);
end;

function THAnimSiteNode.GetScale: TVector3;
begin
  Result := FdScale.Value;
end;

procedure THAnimSiteNode.SetScale(const Value: TVector3);
begin
  FdScale.Send(Value);
end;

function THAnimSiteNode.GetScaleOrientation: TVector4;
begin
  Result := FdScaleOrientation.Value;
end;

procedure THAnimSiteNode.SetScaleOrientation(const Value: TVector4);
begin
  FdScaleOrientation.Send(Value);
end;

function THAnimSiteNode.GetTranslation: TVector3;
begin
  Result := FdTranslation.Value;
end;

procedure THAnimSiteNode.SetTranslation(const Value: TVector3);
begin
  FdTranslation.Send(Value);
end;

{$endif read_implementation}
