#ifndef ATL_ctGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,240,320,400,480,560,880,1040,1200
 * N : 25,240,320,400,480,560,880,1040,1200
 * NB : 4,12,40,20,96,64,40,80,96
 */
#define ATL_ctGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 132) (nb_) = 4; \
   else if ((n_) < 280) (nb_) = 12; \
   else if ((n_) < 360) (nb_) = 40; \
   else if ((n_) < 440) (nb_) = 20; \
   else if ((n_) < 520) (nb_) = 96; \
   else if ((n_) < 720) (nb_) = 64; \
   else if ((n_) < 960) (nb_) = 40; \
   else if ((n_) < 1120) (nb_) = 80; \
   else (nb_) = 96; \
}


#endif    /* end ifndef ATL_ctGetNB_geqrf */
