#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2019 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# AI War 2
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220322.6

# Set game-specific variables

GAME_ID='ai-war-2'
GAME_NAME='AI War 2'

ARCHIVE_BASE_0='ai_war_2_4_006_54416.sh'
ARCHIVE_BASE_0_MD5='3bbcfa00ea5014d5d6f1258d780c97b0'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='3400000'
ARCHIVE_BASE_0_VERSION='4.006-gog54416'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/ai_war_2'

UNITY3D_NAME='AIWar2Linux'

CONTENT_PATH_DEFAULT='data/noarch/game'
ARCHIVE_GAME_BIN_FILES="
${UNITY3D_NAME}.x86_64
${UNITY3D_NAME}_Data/MonoBleedingEdge
${UNITY3D_NAME}_Data/Plugins
UnityPlayer.so
MonoBleedingEdge
ArcenNetworkLib
CodeExternal
PlayerData
ReliableDLLStorage"
ARCHIVE_GAME_DATA_FILES="
${UNITY3D_NAME}_Data
AIW2ModdingAndGUI
AssetBundles_Linux
GameData
GlobalBundles
XMLMods"

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID libc.so.6 libstdc++.so.6 libGL.so.1"

# Use persistent storage for user data

DATA_DIRS='./PlayerData'

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Get game icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
