/*
 * Decompiled with CFR 0.152.
 */
package org.bson.io;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.bson.io.OutputBuffer;

public class BasicOutputBuffer
extends OutputBuffer {
    private int _cur;
    private int _size;
    private byte[] _buffer = new byte[512];

    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) {
        this._ensure(len);
        System.arraycopy(b, off, this._buffer, this._cur, len);
        this._cur += len;
        this._size = Math.max(this._cur, this._size);
    }

    public void write(int b) {
        this._ensure(1);
        this._buffer[this._cur++] = (byte)(0xFF & b);
        this._size = Math.max(this._cur, this._size);
    }

    public int getPosition() {
        return this._cur;
    }

    public void setPosition(int position) {
        this._cur = position;
    }

    public void seekEnd() {
        this._cur = this._size;
    }

    public void seekStart() {
        this._cur = 0;
    }

    public int size() {
        return this._size;
    }

    public int pipe(OutputStream out) throws IOException {
        out.write(this._buffer, 0, this._size);
        return this._size;
    }

    public int pipe(DataOutput out) throws IOException {
        out.write(this._buffer, 0, this._size);
        return this._size;
    }

    void _ensure(int more) {
        int need = this._cur + more;
        if (need < this._buffer.length) {
            return;
        }
        int newSize = this._buffer.length * 2;
        if (newSize <= need) {
            newSize = need + 128;
        }
        byte[] n = new byte[newSize];
        System.arraycopy(this._buffer, 0, n, 0, this._size);
        this._buffer = n;
    }

    public String asString() {
        return new String(this._buffer, 0, this._size);
    }

    public String asString(String encoding) throws UnsupportedEncodingException {
        return new String(this._buffer, 0, this._size, encoding);
    }
}

