/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.services.ec2.model.InstancePrivateIpAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InstanceNetworkInterfaceResponse {
    private String networkInterfaceId;
    private Integer deviceIndex;
    private String subnetId;
    private String description;
    private String privateIpAddress;
    private List<String> groups;
    private Boolean deleteOnTermination;
    private List<InstancePrivateIpAddress> privateIpAddresses;

    public String getNetworkInterfaceId() {
        return this.networkInterfaceId;
    }

    public void setNetworkInterfaceId(String networkInterfaceId) {
        this.networkInterfaceId = networkInterfaceId;
    }

    public InstanceNetworkInterfaceResponse withNetworkInterfaceId(String networkInterfaceId) {
        this.networkInterfaceId = networkInterfaceId;
        return this;
    }

    public Integer getDeviceIndex() {
        return this.deviceIndex;
    }

    public void setDeviceIndex(Integer deviceIndex) {
        this.deviceIndex = deviceIndex;
    }

    public InstanceNetworkInterfaceResponse withDeviceIndex(Integer deviceIndex) {
        this.deviceIndex = deviceIndex;
        return this;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public InstanceNetworkInterfaceResponse withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public InstanceNetworkInterfaceResponse withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    public void setPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
    }

    public InstanceNetworkInterfaceResponse withPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
        return this;
    }

    public List<String> getGroups() {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        return this.groups;
    }

    public void setGroups(Collection<String> groups) {
        if (groups == null) {
            this.groups = null;
            return;
        }
        ArrayList<String> groupsCopy = new ArrayList<String>(groups.size());
        groupsCopy.addAll(groups);
        this.groups = groupsCopy;
    }

    public InstanceNetworkInterfaceResponse withGroups(String ... groups) {
        if (this.getGroups() == null) {
            this.setGroups(new ArrayList<String>(groups.length));
        }
        for (String value : groups) {
            this.getGroups().add(value);
        }
        return this;
    }

    public InstanceNetworkInterfaceResponse withGroups(Collection<String> groups) {
        if (groups == null) {
            this.groups = null;
        } else {
            ArrayList<String> groupsCopy = new ArrayList<String>(groups.size());
            groupsCopy.addAll(groups);
            this.groups = groupsCopy;
        }
        return this;
    }

    public Boolean isDeleteOnTermination() {
        return this.deleteOnTermination;
    }

    public void setDeleteOnTermination(Boolean deleteOnTermination) {
        this.deleteOnTermination = deleteOnTermination;
    }

    public InstanceNetworkInterfaceResponse withDeleteOnTermination(Boolean deleteOnTermination) {
        this.deleteOnTermination = deleteOnTermination;
        return this;
    }

    public Boolean getDeleteOnTermination() {
        return this.deleteOnTermination;
    }

    public List<InstancePrivateIpAddress> getPrivateIpAddresses() {
        if (this.privateIpAddresses == null) {
            this.privateIpAddresses = new ArrayList<InstancePrivateIpAddress>();
        }
        return this.privateIpAddresses;
    }

    public void setPrivateIpAddresses(Collection<InstancePrivateIpAddress> privateIpAddresses) {
        if (privateIpAddresses == null) {
            this.privateIpAddresses = null;
            return;
        }
        ArrayList<InstancePrivateIpAddress> privateIpAddressesCopy = new ArrayList<InstancePrivateIpAddress>(privateIpAddresses.size());
        privateIpAddressesCopy.addAll(privateIpAddresses);
        this.privateIpAddresses = privateIpAddressesCopy;
    }

    public InstanceNetworkInterfaceResponse withPrivateIpAddresses(InstancePrivateIpAddress ... privateIpAddresses) {
        if (this.getPrivateIpAddresses() == null) {
            this.setPrivateIpAddresses(new ArrayList<InstancePrivateIpAddress>(privateIpAddresses.length));
        }
        for (InstancePrivateIpAddress value : privateIpAddresses) {
            this.getPrivateIpAddresses().add(value);
        }
        return this;
    }

    public InstanceNetworkInterfaceResponse withPrivateIpAddresses(Collection<InstancePrivateIpAddress> privateIpAddresses) {
        if (privateIpAddresses == null) {
            this.privateIpAddresses = null;
        } else {
            ArrayList<InstancePrivateIpAddress> privateIpAddressesCopy = new ArrayList<InstancePrivateIpAddress>(privateIpAddresses.size());
            privateIpAddressesCopy.addAll(privateIpAddresses);
            this.privateIpAddresses = privateIpAddressesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.networkInterfaceId != null) {
            sb.append("NetworkInterfaceId: " + this.networkInterfaceId + ", ");
        }
        if (this.deviceIndex != null) {
            sb.append("DeviceIndex: " + this.deviceIndex + ", ");
        }
        if (this.subnetId != null) {
            sb.append("SubnetId: " + this.subnetId + ", ");
        }
        if (this.description != null) {
            sb.append("Description: " + this.description + ", ");
        }
        if (this.privateIpAddress != null) {
            sb.append("PrivateIpAddress: " + this.privateIpAddress + ", ");
        }
        if (this.groups != null) {
            sb.append("Groups: " + this.groups + ", ");
        }
        if (this.deleteOnTermination != null) {
            sb.append("DeleteOnTermination: " + this.deleteOnTermination + ", ");
        }
        if (this.privateIpAddresses != null) {
            sb.append("PrivateIpAddresses: " + this.privateIpAddresses + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNetworkInterfaceId() == null ? 0 : this.getNetworkInterfaceId().hashCode());
        hashCode = 31 * hashCode + (this.getDeviceIndex() == null ? 0 : this.getDeviceIndex().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetId() == null ? 0 : this.getSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIpAddress() == null ? 0 : this.getPrivateIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getGroups() == null ? 0 : this.getGroups().hashCode());
        hashCode = 31 * hashCode + (this.isDeleteOnTermination() == null ? 0 : this.isDeleteOnTermination().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIpAddresses() == null ? 0 : this.getPrivateIpAddresses().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceNetworkInterfaceResponse)) {
            return false;
        }
        InstanceNetworkInterfaceResponse other = (InstanceNetworkInterfaceResponse)obj;
        if (other.getNetworkInterfaceId() == null ^ this.getNetworkInterfaceId() == null) {
            return false;
        }
        if (other.getNetworkInterfaceId() != null && !other.getNetworkInterfaceId().equals(this.getNetworkInterfaceId())) {
            return false;
        }
        if (other.getDeviceIndex() == null ^ this.getDeviceIndex() == null) {
            return false;
        }
        if (other.getDeviceIndex() != null && !other.getDeviceIndex().equals(this.getDeviceIndex())) {
            return false;
        }
        if (other.getSubnetId() == null ^ this.getSubnetId() == null) {
            return false;
        }
        if (other.getSubnetId() != null && !other.getSubnetId().equals(this.getSubnetId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getPrivateIpAddress() == null ^ this.getPrivateIpAddress() == null) {
            return false;
        }
        if (other.getPrivateIpAddress() != null && !other.getPrivateIpAddress().equals(this.getPrivateIpAddress())) {
            return false;
        }
        if (other.getGroups() == null ^ this.getGroups() == null) {
            return false;
        }
        if (other.getGroups() != null && !other.getGroups().equals(this.getGroups())) {
            return false;
        }
        if (other.isDeleteOnTermination() == null ^ this.isDeleteOnTermination() == null) {
            return false;
        }
        if (other.isDeleteOnTermination() != null && !other.isDeleteOnTermination().equals(this.isDeleteOnTermination())) {
            return false;
        }
        if (other.getPrivateIpAddresses() == null ^ this.getPrivateIpAddresses() == null) {
            return false;
        }
        return other.getPrivateIpAddresses() == null || other.getPrivateIpAddresses().equals(this.getPrivateIpAddresses());
    }
}

