/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.view.client.HasRows;
import com.google.gwt.view.client.Range;
import com.google.gwt.view.client.RangeChangeEvent;
import com.google.gwt.view.client.RowCountChangeEvent;

public abstract class AbstractPager
extends Composite {
    private HasRows display;
    private boolean isRangeLimited = true;
    private int lastRowCount;
    private HandlerRegistration rangeChangeHandler;
    private HandlerRegistration rowCountChangeHandler;

    public HasRows getDisplay() {
        return this.display;
    }

    public int getPageSize() {
        return this.display == null ? -1 : this.display.getVisibleRange().getLength();
    }

    public int getPageStart() {
        return this.display == null ? -1 : this.display.getVisibleRange().getStart();
    }

    public boolean isRangeLimited() {
        return this.isRangeLimited;
    }

    public void setRangeLimited(boolean isRangeLimited) {
        this.isRangeLimited = isRangeLimited;
    }

    public void setDisplay(HasRows display) {
        if (this.rangeChangeHandler != null) {
            this.rangeChangeHandler.removeHandler();
            this.rangeChangeHandler = null;
        }
        if (this.rowCountChangeHandler != null) {
            this.rowCountChangeHandler.removeHandler();
            this.rangeChangeHandler = null;
        }
        this.display = display;
        if (display != null) {
            this.rangeChangeHandler = display.addRangeChangeHandler(new RangeChangeEvent.Handler(){

                public void onRangeChange(RangeChangeEvent event) {
                    if (AbstractPager.this.display != null) {
                        AbstractPager.this.onRangeOrRowCountChanged();
                    }
                }
            });
            this.rowCountChangeHandler = display.addRowCountChangeHandler(new RowCountChangeEvent.Handler(){

                public void onRowCountChange(RowCountChangeEvent event) {
                    if (AbstractPager.this.display != null) {
                        AbstractPager.this.handleRowCountChange(event.getNewRowCount(), event.isNewRowCountExact());
                    }
                }
            });
            this.onRangeOrRowCountChanged();
        }
    }

    protected void firstPage() {
        this.setPage(0);
    }

    protected int getPage() {
        if (this.display == null) {
            return -1;
        }
        Range range = this.display.getVisibleRange();
        int pageSize = range.getLength();
        return (range.getStart() + pageSize - 1) / pageSize;
    }

    protected int getPageCount() {
        if (this.display == null) {
            return -1;
        }
        int pageSize = this.getPageSize();
        return (this.display.getRowCount() + pageSize - 1) / pageSize;
    }

    protected boolean hasNextPage() {
        if (this.display == null) {
            return false;
        }
        if (!this.display.isRowCountExact()) {
            return true;
        }
        Range range = this.display.getVisibleRange();
        return range.getStart() + range.getLength() < this.display.getRowCount();
    }

    protected boolean hasNextPages(int pages) {
        if (this.display == null) {
            return false;
        }
        Range range = this.display.getVisibleRange();
        return range.getStart() + pages * range.getLength() < this.display.getRowCount();
    }

    protected boolean hasPage(int index) {
        return this.display == null ? false : this.getPageSize() * index < this.display.getRowCount();
    }

    protected boolean hasPreviousPage() {
        return this.display == null ? false : this.getPageStart() > 0 && this.display.getRowCount() > 0;
    }

    protected boolean hasPreviousPages(int pages) {
        if (this.display == null) {
            return false;
        }
        Range range = this.display.getVisibleRange();
        return (pages - 1) * range.getLength() < range.getStart();
    }

    protected void lastPage() {
        this.setPage(this.getPageCount() - 1);
    }

    protected void lastPageStart() {
        if (this.display != null) {
            this.setPageStart(this.display.getRowCount() - this.getPageSize());
        }
    }

    protected void nextPage() {
        if (this.display != null) {
            Range range = this.display.getVisibleRange();
            this.setPageStart(range.getStart() + range.getLength());
        }
    }

    protected abstract void onRangeOrRowCountChanged();

    protected void previousPage() {
        if (this.display != null) {
            Range range = this.display.getVisibleRange();
            this.setPageStart(range.getStart() - range.getLength());
        }
    }

    protected void setPage(int index) {
        if (!(this.display == null || this.isRangeLimited && this.display.isRowCountExact() && !this.hasPage(index))) {
            int pageSize = this.getPageSize();
            this.display.setVisibleRange(pageSize * index, pageSize);
        }
    }

    protected void setPageSize(int pageSize) {
        if (this.display != null) {
            Range range = this.display.getVisibleRange();
            int pageStart = range.getStart();
            if (this.isRangeLimited && this.display.isRowCountExact()) {
                pageStart = Math.min(pageStart, this.display.getRowCount() - pageSize);
            }
            pageStart = Math.max(0, pageStart);
            this.display.setVisibleRange(pageStart, pageSize);
        }
    }

    protected void setPageStart(int index) {
        if (this.display != null) {
            Range range = this.display.getVisibleRange();
            int pageSize = range.getLength();
            if (this.isRangeLimited && this.display.isRowCountExact()) {
                index = Math.min(index, this.display.getRowCount() - pageSize);
            }
            if ((index = Math.max(0, index)) != range.getStart()) {
                this.display.setVisibleRange(index, pageSize);
            }
        }
    }

    private void handleRowCountChange(int rowCount, boolean isExact) {
        int oldRowCount = this.lastRowCount;
        this.lastRowCount = this.display.getRowCount();
        if (this.isRangeLimited && oldRowCount != this.lastRowCount) {
            this.setPageStart(this.getPageStart());
        }
        this.onRangeOrRowCountChanged();
    }
}

