/*
 * Copyright (C) The MX4J Contributors.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package javax.management;

/**
 * Defines a series of callbacks that allow the MBean to interact with the process of MBean
 * registration and unregistration performed by the MBeanServer.
 * Implementing this interface is an easy way for an MBean to get the reference to the
 * MBeanServer that manages it.
 *
 * @version $Revision: 1.6 $
 */
public interface MBeanRegistration
{
   /**
    * Callback called just before MBean registration in the MBeanServer.
    * Any exception thrown by this method will cause the MBean registration to abort.
    *
    * @param server The MBeanServer on which the MBean will be registered.
    * @param name   The <code>ObjectName</code> of the MBean.
    * @return The <code>ObjectName</code> of the registered MBean, must not be null
    * @throws Exception Any possible exception generated by this method will be caught
    *                   by the <code>MBeanServer</code> and re-thrown as an <code>MBeanRegistrationException</code>
    *                   to the client.
    */
   public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception;

   /**
    * Callback called just after the MBean has been registered (successfully or not).
    *
    * @param registrationDone True if the registration was successful, false otherwise.
    */
   public void postRegister(Boolean registrationDone);

   /**
    * Callback called just before MBean unregistration from the MBeanServer.
    * Any exception thrown by this method will cause the MBean unregistration to abort.
    *
    * @throws Exception Any possible exception generated by this method will be caught
    *                   by the <code>MBeanServer</code> and re-thrown as an <code>MBeanRegistrationException</code>
    *                   to the client.
    */
   public void preDeregister() throws Exception;

   /**
    * Callback called just after the MBean has been successfully unregistered.
    */
   public void postDeregister();
}
