; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=gvn-hoist -S < %s | FileCheck %s

target datalayout = "e-m:x-p:32:32-i64:64-f80:32-n8:16:32-a:0:32-S32"
target triple = "i686-pc-windows-msvc18.0.0"

%struct.S = type { ptr, ptr }

declare void @f(ptr inalloca(<{ %struct.S }>))


; Check that we don't clone the %x alloca and insert it in the live range of
; %argmem, which would break the inalloca contract.
define void @test(i1 %b) {
; CHECK-LABEL: @test(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[X:%.*]] = alloca i8, align 1
; CHECK-NEXT:    [[INALLOCA_SAVE:%.*]] = call ptr @llvm.stacksave()
; CHECK-NEXT:    [[ARGMEM:%.*]] = alloca inalloca <{ [[STRUCT_S:%.*]] }>, align 4
; CHECK-NEXT:    [[TMP1:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARGMEM]], i32 0, i32 1
; CHECK-NEXT:    store ptr [[X]], ptr [[TMP1]], align 4
; CHECK-NEXT:    br i1 [[B:%.*]], label [[TRUE:%.*]], label [[FALSE:%.*]]
; CHECK:       true:
; CHECK-NEXT:    [[P:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARGMEM]], i32 0, i32 1
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       false:
; CHECK-NEXT:    [[P2:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARGMEM]], i32 0, i32 1
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    call void @f(ptr inalloca(<{ [[STRUCT_S]] }>) [[ARGMEM]])
; CHECK-NEXT:    call void @llvm.stackrestore(ptr [[INALLOCA_SAVE]])
; CHECK-NEXT:    ret void
;
entry:
  %x = alloca i8
  %inalloca.save = call ptr @llvm.stacksave()
  %argmem = alloca inalloca <{ %struct.S }>, align 4
  br i1 %b, label %true, label %false

true:
  %p = getelementptr inbounds %struct.S, ptr %argmem, i32 0, i32 1
  store ptr %x, ptr %p, align 4
  br label %exit

false:
  %p2 = getelementptr inbounds %struct.S, ptr %argmem, i32 0, i32 1
  store ptr %x, ptr %p2, align 4
  br label %exit

exit:
  call void @f(ptr inalloca(<{ %struct.S }>) %argmem)
  call void @llvm.stackrestore(ptr %inalloca.save)
  ret void
}

declare ptr @llvm.stacksave()
declare void @llvm.stackrestore(ptr)
