; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=-popcnt,+sse2 | FileCheck %s --check-prefix=NOPOPCNT
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+popcnt,+sse2 | FileCheck %s --check-prefix=POPCNT

define i1 @noncanonical_parity(<16 x i1> %x) {
; NOPOPCNT-LABEL: noncanonical_parity:
; NOPOPCNT:       # %bb.0:
; NOPOPCNT-NEXT:    psllw $7, %xmm0
; NOPOPCNT-NEXT:    pmovmskb %xmm0, %eax
; NOPOPCNT-NEXT:    xorb %ah, %al
; NOPOPCNT-NEXT:    setnp %al
; NOPOPCNT-NEXT:    retq
;
; POPCNT-LABEL: noncanonical_parity:
; POPCNT:       # %bb.0:
; POPCNT-NEXT:    psllw $7, %xmm0
; POPCNT-NEXT:    pmovmskb %xmm0, %eax
; POPCNT-NEXT:    popcntl %eax, %eax
; POPCNT-NEXT:    andl $1, %eax
; POPCNT-NEXT:    # kill: def $al killed $al killed $eax
; POPCNT-NEXT:    retq
  %r = call i1 @llvm.vector.reduce.xor.v16i1(<16 x i1> %x)
  ret i1 %r
}
define i1 @canonical_parity(<16 x i1> %x) {
; NOPOPCNT-LABEL: canonical_parity:
; NOPOPCNT:       # %bb.0:
; NOPOPCNT-NEXT:    psllw $7, %xmm0
; NOPOPCNT-NEXT:    pmovmskb %xmm0, %eax
; NOPOPCNT-NEXT:    xorb %ah, %al
; NOPOPCNT-NEXT:    setnp %al
; NOPOPCNT-NEXT:    retq
;
; POPCNT-LABEL: canonical_parity:
; POPCNT:       # %bb.0:
; POPCNT-NEXT:    psllw $7, %xmm0
; POPCNT-NEXT:    pmovmskb %xmm0, %eax
; POPCNT-NEXT:    popcntl %eax, %eax
; POPCNT-NEXT:    andl $1, %eax
; POPCNT-NEXT:    # kill: def $al killed $al killed $eax
; POPCNT-NEXT:    retq
  %i1 = bitcast <16 x i1> %x to i16
  %i2 = call i16 @llvm.ctpop.i16(i16 %i1)
  %i3 = and i16 %i2, 1
  %i4 = icmp ne i16 %i3, 0
  ret i1 %i4
}
define i1 @canonical_parity_noncanonical_pred(<16 x i1> %x) {
; NOPOPCNT-LABEL: canonical_parity_noncanonical_pred:
; NOPOPCNT:       # %bb.0:
; NOPOPCNT-NEXT:    psllw $7, %xmm0
; NOPOPCNT-NEXT:    pmovmskb %xmm0, %eax
; NOPOPCNT-NEXT:    movl %eax, %ecx
; NOPOPCNT-NEXT:    shrl %ecx
; NOPOPCNT-NEXT:    andl $21845, %ecx # imm = 0x5555
; NOPOPCNT-NEXT:    subl %ecx, %eax
; NOPOPCNT-NEXT:    movl %eax, %ecx
; NOPOPCNT-NEXT:    andl $13107, %ecx # imm = 0x3333
; NOPOPCNT-NEXT:    shrl $2, %eax
; NOPOPCNT-NEXT:    andl $13107, %eax # imm = 0x3333
; NOPOPCNT-NEXT:    addl %ecx, %eax
; NOPOPCNT-NEXT:    movl %eax, %ecx
; NOPOPCNT-NEXT:    shrl $4, %ecx
; NOPOPCNT-NEXT:    addl %eax, %ecx
; NOPOPCNT-NEXT:    andl $3855, %ecx # imm = 0xF0F
; NOPOPCNT-NEXT:    movl %ecx, %eax
; NOPOPCNT-NEXT:    shll $8, %eax
; NOPOPCNT-NEXT:    addl %ecx, %eax
; NOPOPCNT-NEXT:    shrl $8, %eax
; NOPOPCNT-NEXT:    # kill: def $al killed $al killed $eax
; NOPOPCNT-NEXT:    retq
;
; POPCNT-LABEL: canonical_parity_noncanonical_pred:
; POPCNT:       # %bb.0:
; POPCNT-NEXT:    psllw $7, %xmm0
; POPCNT-NEXT:    pmovmskb %xmm0, %eax
; POPCNT-NEXT:    popcntl %eax, %eax
; POPCNT-NEXT:    # kill: def $al killed $al killed $eax
; POPCNT-NEXT:    retq
  %i1 = bitcast <16 x i1> %x to i16
  %i2 = call i16 @llvm.ctpop.i16(i16 %i1)
  %i3 = and i16 %i2, 1
  %i4 = icmp eq i16 %i3, 1
  ret i1 %i4
}

define i1 @noncanonical_nonparity(<16 x i1> %x) {
; NOPOPCNT-LABEL: noncanonical_nonparity:
; NOPOPCNT:       # %bb.0:
; NOPOPCNT-NEXT:    psllw $7, %xmm0
; NOPOPCNT-NEXT:    pmovmskb %xmm0, %eax
; NOPOPCNT-NEXT:    xorb %ah, %al
; NOPOPCNT-NEXT:    setp %al
; NOPOPCNT-NEXT:    retq
;
; POPCNT-LABEL: noncanonical_nonparity:
; POPCNT:       # %bb.0:
; POPCNT-NEXT:    psllw $7, %xmm0
; POPCNT-NEXT:    pmovmskb %xmm0, %eax
; POPCNT-NEXT:    popcntl %eax, %eax
; POPCNT-NEXT:    andl $1, %eax
; POPCNT-NEXT:    xorb $1, %al
; POPCNT-NEXT:    # kill: def $al killed $al killed $eax
; POPCNT-NEXT:    retq
  %r.inv = call i1 @llvm.vector.reduce.xor.v16i1(<16 x i1> %x)
  %r = xor i1 %r.inv, -1
  ret i1 %r
}
define i1 @canonical_nonparity(<16 x i1> %x) {
; NOPOPCNT-LABEL: canonical_nonparity:
; NOPOPCNT:       # %bb.0:
; NOPOPCNT-NEXT:    psllw $7, %xmm0
; NOPOPCNT-NEXT:    pmovmskb %xmm0, %eax
; NOPOPCNT-NEXT:    xorb %ah, %al
; NOPOPCNT-NEXT:    setp %al
; NOPOPCNT-NEXT:    retq
;
; POPCNT-LABEL: canonical_nonparity:
; POPCNT:       # %bb.0:
; POPCNT-NEXT:    psllw $7, %xmm0
; POPCNT-NEXT:    pmovmskb %xmm0, %eax
; POPCNT-NEXT:    popcntl %eax, %eax
; POPCNT-NEXT:    testb $1, %al
; POPCNT-NEXT:    sete %al
; POPCNT-NEXT:    retq
  %i1 = bitcast <16 x i1> %x to i16
  %i2 = call i16 @llvm.ctpop.i16(i16 %i1)
  %i3 = and i16 %i2, 1
  %i4 = icmp eq i16 %i3, 0
  ret i1 %i4
}
define i1 @canonical_nonparity_noncanonical_pred(<16 x i1> %x) {
; NOPOPCNT-LABEL: canonical_nonparity_noncanonical_pred:
; NOPOPCNT:       # %bb.0:
; NOPOPCNT-NEXT:    psllw $7, %xmm0
; NOPOPCNT-NEXT:    pmovmskb %xmm0, %eax
; NOPOPCNT-NEXT:    xorb %ah, %al
; NOPOPCNT-NEXT:    setp %al
; NOPOPCNT-NEXT:    retq
;
; POPCNT-LABEL: canonical_nonparity_noncanonical_pred:
; POPCNT:       # %bb.0:
; POPCNT-NEXT:    psllw $7, %xmm0
; POPCNT-NEXT:    pmovmskb %xmm0, %eax
; POPCNT-NEXT:    popcntl %eax, %eax
; POPCNT-NEXT:    andl $1, %eax
; POPCNT-NEXT:    xorb $1, %al
; POPCNT-NEXT:    # kill: def $al killed $al killed $eax
; POPCNT-NEXT:    retq
  %i1 = bitcast <16 x i1> %x to i16
  %i2 = call i16 @llvm.ctpop.i16(i16 %i1)
  %i3 = and i16 %i2, 1
  %i4 = icmp ne i16 %i3, 1
  ret i1 %i4
}

declare i1 @llvm.vector.reduce.xor.v16i1(<16 x i1>)
declare i16 @llvm.ctpop.i16(i16)
