#! /usr/bin/env python

# Genetic
# Copyright (C) 2001 Jean-Baptiste LAMY
#
# This program is free software. See README or LICENSE for the license terms.

import random, string, math
from genetic import organism, lifecycle

# Set the function to minimize.
#
# Here we compute the smallest sphere that contains all the points in the following list.
# FUNC return the sphere radius, and genes are the center coordinates (x, y, z).

points = [
  [ 1.0, 0.0, 0.0],
  [-1.0, 0.0, 0.0],
  [0.0,  1.0, 0.0],
  [0.0, -1.0, 0.0],
  [0.0, 0.0,  1.0],
  [0.0, 0.0, -1.0],
  ]

def radius_func(x, y, z):
  radius = 0.0
  for point in points:
    distance = math.sqrt((point[0] - x) ** 2 + (point[1] - y) ** 2 + (point[2] - z) ** 2)
    if distance > radius: radius = distance
  return radius

class SphereMinimizer(organism.Organism):
  characteristics = [
    organism.Characteristic("radius", radius_func)
    ]
  
  def __cmp__(self, other):
    # Say how we compare 2 organisms. Here, the lower the sphere radius is the better the organism is.
    return cmp(self.radius, other.radius)


# Initial set of organisms
organismA = SphereMinimizer([
  organism.Chromosom(x = -0.5, y = 9.8, z = 0.9, __mutampl__ = 2.0, __mutation__ = 0.8),
  ])

organismB = SphereMinimizer([
  organism.Chromosom(x = -5.5, y = 0.2, z = -1.0, __mutampl__ = 2.0, __mutation__ = 0.8),
  ])

organisms = [organismA, organismB]

# True for elitism (= always keep the best organism)
ELITISM = 1

# Number of generation to run
NB_GENERATION = 10

# Number of children they made
NB_CHILDREN  = 50

# Number of organisms kept per set
NB_ORGANISMS = 10


lifecycle.run(organisms, ELITISM, NB_GENERATION, NB_CHILDREN, NB_ORGANISMS)
