      SUBROUTINE LOCPT ( N,P, M,S,K,KS, EPS, LOC)
C
C     DETERMINES POSITION OF EACH OF N POINTS (P) RELATIVE TO SURFACE
C        BOUNDED BY M POINTS (S)
C        ALL POINTS IN THE SAME COORDINATE SYSTEM
C     KS IS THE (UNIT) VECTOR NORMAL TO THE SURFACE
C     LOC(I) IS FLAG INDICATING POSITION OF POINT I RELATIVE TO SURFACE:
C        LOC= 1    WHEN POINT WITHIN SURFACE BOUNDRY
C        LOC= 0    WHEN POINT IS ON SURFACE BOUNDRY
C        LOC= -1   WHEN POINT OUTSIDE SURFACE BOUNDRY
C
C     MAXIMUM OF 4 POINTS MAY BE LOCATED RELATIVE
C        TO SURFACE WITH MAXIMUM OF 4 SIDES
C        WHOSE ENDPOINTS ARE IN K(2,M)
C
      DOUBLE PRECISION P(3,4), S(3,4), KS(3)
      DOUBLE PRECISION VE(3,4), VP(3), V(3),VEMAG(4)
      DOUBLE PRECISION VMAG, VPMAG, VDOTK, EDOTP
      DOUBLE PRECISION DVMAG, DADOTB, EPS(2)
C
      INTEGER LOC(1), K(2,1)
C
C
C     EPS ARRAY FOR SIGNIFICANCE TESTING
C        EPS(1) IS AREA, ANGLE LIMIT
C        EPS(2) IS LENGTH LIMIT
C
C
C
C     SET UP VECTORS ALONG EACH SURFACE EDGE
C
      DO 20 NE=1,M
      K1= K(1,NE)
      K2= K(2,NE)
C
      DO 15 I=1,2
C     VE IS VECTOR ALONG SURFACE EDGE
   15 VE(I,NE)= S(I,K2) -S(I,K1)
      VE(3,NE)=0.D0
      VEMAG(NE)= DVMAG( VE(1,NE), EPS(2) )
   20 CONTINUE
C
C      DETERMINE LOCATION OF POINT RELATIVE TO SURFACE
C
      DO 40 NP= 1,N
C        (PRESET POINT FLAG TO INTERIOR CODE)
      LOC(NP)= 1
C
      DO 30 NE= 1,M
      K1= K(1,NE)
C
      DO 24  I=1,2
C     VP IS VECTOR FROM FIRST END OF EDGE VECTOR TO POINT
   24 VP(I)= P(I,NP) -S(I,K1)
      VP(3)= 0.D0
      VPMAG= DVMAG(VP,EPS(2))
C
C     V= VE CROSS VP
      CALL DAXB(VE(1,NE), VP,V)
      VMAG= DVMAG(V,EPS(1))
C     VDOTK= (VE CROSS VP) DOT K,  K NORMAL TO PLANE OF SURFACE
      VDOTK= DADOTB(V, KS)
C     EDOTP IS VE DOT VP
      EDOTP= DADOTB( VE(1,NE), VP)
      IF (VPMAG .LE. EPS(2) )    GO TO 37
      IF (VDOTK .GT. EPS(1))           GO TO 30
C                                      INSIDE THIS EDGE
      IF (         (VDOTK .LT. -EPS(1) )         .OR.
     1             (EDOTP .LE. EPS(1))           .OR.
     2             (VEMAG(NE) +EPS(2) .LT. VPMAG) )        GO TO 35
C                                                          OUTSIDE
                   GO TO 37
C                  ON THIS EDGE
   30 CONTINUE
C     POINT IS WITHIN SURFACE BOUNDRY IF NOT OUTSIDE ANY EDGE
C        AND NOT ON SURFACE BOUNDRY
      GO TO 40
C
C     POINT IS OUTSIDE SURFACE BOUNDRY IF OUTSIDE ANY EDGE
   35 LOC(NP)= -1
      GO TO 40
C
C
C     POINT IS ON BOUNDRY WHEN ANGLE IS EFFECTIVELY ZERO
C        OR (EFFECTIVELY) COINCIDENT WITH EDGE POINT
   37 LOC(NP)= 0
C
   40 CONTINUE
      RETURN
      END
